/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.OracleTimeoutPollingThread;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleConnection;

class OracleTimeoutThreadPerVM
extends OracleTimeout
implements Monitor,
Diagnosable {
    private static final String CLASS_NAME = OracleTimeoutThreadPerVM.class.getName();
    private static final OracleTimeoutPollingThread watchdog = new OracleTimeoutPollingThread();
    private OracleStatement statement;
    private long interruptAfter;
    private String name;
    private final Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();

    OracleTimeoutThreadPerVM(String name) {
        this.name = name;
        this.interruptAfter = Long.MAX_VALUE;
        watchdog.addTimeout(this);
    }

    static void stopWatchdog() {
        try {
            watchdog.interrupt();
        }
        catch (SecurityException e) {
            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "stopWatchdog", "stopWatchdog: {0}", (String)null, (Throwable)null, (Object)e.getMessage());
        }
    }

    @Override
    void close() {
        watchdog.removeTimeout(this);
    }

    @Override
    void setTimeout(long milliseconds, OracleStatement stmt) throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.interruptAfter != Long.MAX_VALUE) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 131).fillInStackTrace();
            }
            this.statement = stmt;
            this.interruptAfter = System.currentTimeMillis() + milliseconds;
        }
    }

    @Override
    void cancelTimeout() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.statement = null;
            this.interruptAfter = Long.MAX_VALUE;
        }
    }

    void interruptIfAppropriate(long now) {
        OracleStatement s2;
        block10: {
            if (now < this.interruptAfter) {
                return;
            }
            try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
                s2 = this.statement;
                if (now >= this.interruptAfter) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "interruptIfAppropriate", "CANCELING thread: {0}", (String)null, (Throwable)null, (Object)this.name);
                    this.statement = null;
                    this.interruptAfter = Long.MAX_VALUE;
                    break block10;
                }
                return;
            }
        }
        try {
            s2.cancel();
        }
        catch (Throwable e) {
            this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "interruptIfAppropriate", "statement cancel failed\n{0}\n", (String)null, e, (Object)e.getMessage());
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

