/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.internal;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Flow;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.Monitor;

public final class CompletionStageUtil {
    private static final Flow.Subscription NO_OP_SUBSCRIPTION = new Flow.Subscription(){

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    };
    public static final CompletableFuture<Void> VOID_COMPLETED_FUTURE = CompletableFuture.completedFuture(null);

    private CompletionStageUtil() {
    }

    public static void acceptCompletion(CompletionHandler handler) {
        try {
            handler.handle();
        }
        catch (Exception unhandledException) {
            throw new CompletionException(unhandledException);
        }
    }

    public static <T> T handleCompletion(T result, Throwable throwable, CompletionHandler handler) {
        CompletionStageUtil.acceptCompletion(handler);
        if (throwable == null) {
            return result;
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T> BiFunction<T, Throwable, T> completionHandler(CompletionHandler handler) {
        return (r, e) -> CompletionStageUtil.handleCompletion(r, e, handler);
    }

    public static <T, U> U handleNormalCompletion(T result, NormalCompletionHandler<T, U> handler) {
        try {
            return handler.handle(result);
        }
        catch (Exception unhandledException) {
            throw new CompletionException(unhandledException);
        }
    }

    public static <T, U> U handleNormalCompletion(T result, Throwable throwable, NormalCompletionHandler<T, U> handler) {
        if (throwable == null) {
            return CompletionStageUtil.handleNormalCompletion(result, handler);
        }
        if (throwable instanceof CompletionException) {
            throw (CompletionException)throwable;
        }
        throw new CompletionException(throwable);
    }

    public static <T, U> Function<T, U> normalCompletionHandler(NormalCompletionHandler<T, U> handler) {
        return r -> CompletionStageUtil.handleNormalCompletion(r, handler);
    }

    public static <E extends Throwable, T> T handleExceptionalCompletion(Throwable throwable, Class<E> handledType, ExceptionalCompletionHandler<? super E, ? extends T> handler) {
        if (throwable == null) {
            return null;
        }
        Throwable unwrappedThrowable = CompletionStageUtil.unwrapCompletionException(throwable);
        if (handledType.isInstance(unwrappedThrowable)) {
            try {
                return handler.handle(unwrappedThrowable);
            }
            catch (Exception unhandledException) {
                throw new CompletionException(unhandledException);
            }
        }
        throw new CompletionException(unwrappedThrowable);
    }

    public static <E extends Throwable, T> Function<Throwable, T> exceptionalCompletionHandler(Class<E> handledType, ExceptionalCompletionHandler<? super E, T> handler) {
        return e -> CompletionStageUtil.handleExceptionalCompletion(e, handledType, handler);
    }

    public static <T, E extends Throwable, U> U handleCompletion(T result, NormalCompletionHandler<? super T, U> normalHandler, Throwable throwable, Class<E> handledErrorType, ExceptionalCompletionHandler<? super E, ? extends U> errorHandler) {
        return throwable == null ? CompletionStageUtil.handleNormalCompletion(result, normalHandler) : CompletionStageUtil.handleExceptionalCompletion(throwable, handledErrorType, errorHandler);
    }

    public static <T, E extends Throwable, U> BiFunction<T, Throwable, U> completionHandler(NormalCompletionHandler<T, U> normalHandler, Class<E> handledErrorType, ExceptionalCompletionHandler<? super E, U> errorHandler) {
        return (t2, e) -> CompletionStageUtil.handleCompletion(t2, normalHandler, e, handledErrorType, errorHandler);
    }

    public static Throwable unwrapCompletionException(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return throwable.getCause();
        }
        return throwable;
    }

    public static <T> CompletionStage<T> completedStage(T value) {
        return CompletableFuture.completedStage(value);
    }

    public static <T> CompletionStage<T> failedStage(Throwable failure) {
        return CompletableFuture.failedStage(failure);
    }

    public static Flow.Publisher<Void> newNoItemPublisher(CompletionStage<Void> itemStage, Phaser joinPhaser) {
        return CompletionStageUtil.newBatchItemPublisher(itemStage, nil -> NoItemIterator.INSTANCE, joinPhaser);
    }

    public static <T> Flow.Publisher<T> newSingleItemPublisher(CompletionStage<T> itemStage, Phaser joinPhaser) {
        return CompletionStageUtil.newBatchItemPublisher(itemStage, x$0 -> new SingleItemIterator<Object>(x$0), joinPhaser);
    }

    public static <T, U> Flow.Publisher<U> newBatchItemPublisher(CompletionStage<T> batchItemStage, Function<T, Iterator<U>> iteratorFunction, Phaser joinPhaser) {
        return new BatchItemPublisher<T, U>(batchItemStage, iteratorFunction, joinPhaser);
    }

    public static <T> Flow.Subscriber<T> newFutureSubscriber(CompletionStage<Flow.Subscriber<T>> subscriberStage) {
        return new FutureSubscriber<T>(subscriberStage);
    }

    public static <T> CompletionStage<T> subscribeForSingleItem(Flow.Publisher<T> publisher) {
        final CompletableFuture nextSignalFuture = new CompletableFuture();
        publisher.subscribe(new Flow.Subscriber<T>(){
            Flow.Subscription subscription;

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                this.subscription = subscription;
                this.subscription.request(1L);
            }

            @Override
            public void onNext(T nextItem) {
                this.subscription.cancel();
                nextSignalFuture.complete(nextItem);
            }

            @Override
            public void onComplete() {
                nextSignalFuture.complete(null);
            }

            @Override
            public void onError(Throwable error) {
                nextSignalFuture.completeExceptionally(error);
            }
        });
        return nextSignalFuture;
    }

    public static void callOnComplete(CompletionStage<Void> completionStage, Consumer<Throwable> callback) {
        CompletionStageUtil.callOnComplete(completionStage, (T nil, Throwable error) -> callback.accept((Throwable)error));
    }

    public static <T> void callOnComplete(CompletionStage<T> completionStage, BiConsumer<T, Throwable> callback) {
        CompletableFuture<T> future = completionStage.toCompletableFuture();
        if (future.isDone() && !future.isCompletedExceptionally()) {
            callback.accept(future.join(), null);
        } else {
            future.whenComplete((BiConsumer)callback);
        }
    }

    public static <T extends Throwable> T suppress(T throwable, Throwable suppressed) {
        if (suppressed != null) {
            throwable.addSuppressed(suppressed);
        }
        return throwable;
    }

    private static final class IteratorSubscription<T>
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private final Iterator<T> itemIterator;
        private final Monitor signalMonitor = Monitor.newInstance();
        private final AtomicLong demand = new AtomicLong(0L);
        private final Consumer<IteratorSubscription> onCancel;
        private AtomicBoolean isCancelled = new AtomicBoolean(false);

        private IteratorSubscription(Flow.Subscriber<? super T> subscriber, Iterator<T> itemIterator, Consumer<IteratorSubscription> onCancel) {
            this.subscriber = subscriber;
            this.itemIterator = itemIterator;
            this.onCancel = onCancel;
        }

        @Override
        public void request(long n) {
            if (this.isCancelled.get()) {
                return;
            }
            if (n < 1L) {
                this.emitError(new IllegalArgumentException("Received a negative subscription request. Argument to request(long) was: " + n));
            } else {
                boolean demandIncreasedFromZero;
                boolean bl = demandIncreasedFromZero = 0L == this.demand.getAndUpdate(existingDemand -> {
                    long newDemand = existingDemand + n;
                    return newDemand > 0L ? newDemand : Long.MAX_VALUE;
                });
                if (demandIncreasedFromZero) {
                    this.emitItems();
                }
            }
        }

        @Override
        public void cancel() {
            if (this.isCancelled.compareAndSet(false, true)) {
                this.onCancel.accept(this);
            }
        }

        public boolean equals(Object object) {
            return object instanceof IteratorSubscription && ((IteratorSubscription)object).subscriber.equals(this.subscriber);
        }

        public int hashCode() {
            return this.subscriber.hashCode();
        }

        private void emitItems() {
            long unfilledDemand = this.demand.get();
            while (unfilledDemand > 0L) {
                int i = 0;
                while ((long)i < unfilledDemand && this.itemIterator.hasNext()) {
                    this.emitItem(this.itemIterator.next());
                    ++i;
                }
                if (!this.itemIterator.hasNext()) {
                    this.emitComplete();
                    return;
                }
                long itemsEmitted = unfilledDemand;
                unfilledDemand = this.demand.updateAndGet(existingDemand -> {
                    if (existingDemand == Long.MAX_VALUE) {
                        return Long.MAX_VALUE;
                    }
                    return existingDemand - itemsEmitted;
                });
            }
        }

        private void emitItem(T item) {
            try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
                if (this.isCancelled.get()) {
                    return;
                }
                try {
                    this.subscriber.onNext(item);
                }
                catch (Throwable onNextFailure) {
                    CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/internal/CompletionStageUtil", "emitItem", "Subscriber.onNext(Object) threw an exception", null, onNextFailure);
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void emitError(Throwable error) {
            try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
                if (!this.isCancelled.compareAndSet(false, true)) {
                    return;
                }
                try {
                    this.subscriber.onError(error);
                    this.onCancel.accept(this);
                }
                catch (Throwable onErrorFailure) {
                    try {
                        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/internal/CompletionStageUtil", "emitError", "Subscriber.onError(Throwable) threw an exception", null, onErrorFailure);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.onCancel.accept(this);
                    }
                }
            }
        }

        private void emitComplete() {
            try (Monitor.CloseableLock lock = this.signalMonitor.acquireCloseableLock();){
                if (!this.isCancelled.compareAndSet(false, true)) {
                    return;
                }
                try {
                    this.subscriber.onComplete();
                    this.onCancel.accept(this);
                }
                catch (Throwable onCompleteFailure) {
                    try {
                        CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/internal/CompletionStageUtil", "emitComplete", "Subscriber.onComplete() threw an exception", null, onCompleteFailure);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.onCancel.accept(this);
                    }
                }
            }
        }
    }

    private static final class BatchItemPublisher<U, T>
    implements Flow.Publisher<T> {
        private final CompletionStage<U> batchItemStage;
        private final Function<U, Iterator<T>> iteratorFunction;
        private final Phaser joinPhaser;
        private final int creationPhase;
        private final AtomicBoolean isSubscribed = new AtomicBoolean(false);
        private final CopyOnWriteArraySet<IteratorSubscription> subscriptions = new CopyOnWriteArraySet();

        private BatchItemPublisher(CompletionStage<U> batchItemStage, Function<U, Iterator<T>> iteratorFunction, Phaser joinPhaser) {
            this.batchItemStage = batchItemStage;
            this.iteratorFunction = iteratorFunction;
            this.joinPhaser = joinPhaser;
            this.creationPhase = joinPhaser.register();
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            Objects.requireNonNull(subscriber);
            boolean isAfterJoin = !this.isSubscribed.compareAndSet(false, true) && this.creationPhase != this.joinPhaser.register();
            try {
                CompletionStageUtil.callOnComplete(this.batchItemStage, (batchItem, failure) -> {
                    if (isAfterJoin) {
                        failure = new IllegalStateException("This Publisher is invalid after joinOracle returns");
                    }
                    if (failure != null) {
                        this.subscribeToFailedBatch(subscriber, (Throwable)failure);
                    } else {
                        this.subscribeToBatch(subscriber, batchItem);
                    }
                });
            }
            catch (Throwable throwable) {
                this.subscribeToFailedBatch(subscriber, throwable);
            }
        }

        private void subscribeToBatch(Flow.Subscriber<? super T> subscriber, U batchItem) {
            Iterator<T> itemIterator = this.iteratorFunction.apply(batchItem);
            IteratorSubscription<T> newSubscription = new IteratorSubscription<T>(subscriber, itemIterator, subscription -> {
                try {
                    this.subscriptions.remove(subscription);
                }
                finally {
                    this.joinPhaser.arriveAndDeregister();
                }
            });
            if (!this.subscriptions.add(newSubscription)) {
                this.subscriptions.stream().filter(newSubscription::equals).findFirst().ifPresent(subscription -> subscription.emitError(new IllegalStateException("Subscriber argument to subscribe(Subscriber) is already subscribed")));
            } else {
                try (Monitor.CloseableLock lock = newSubscription.signalMonitor.acquireCloseableLock();){
                    subscriber.onSubscribe(newSubscription);
                    if (batchItem == null) {
                        newSubscription.emitComplete();
                    }
                }
                catch (Throwable onSubscribeFailure) {
                    CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/internal/CompletionStageUtil", "subscribeToBatch", "Subscriber.onSubscribe() threw an exception", null, onSubscribeFailure);
                    newSubscription.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void subscribeToFailedBatch(Flow.Subscriber<? super T> subscriber, Throwable failure) {
            try {
                subscriber.onSubscribe(NO_OP_SUBSCRIPTION);
                subscriber.onError(CompletionStageUtil.unwrapCompletionException(failure));
            }
            catch (Throwable subscriberFailure) {
                CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, "oracle/jdbc/internal/CompletionStageUtil", "subscribeToFailedBatch", "Subscriber threw an exception", null, subscriberFailure);
            }
            finally {
                this.joinPhaser.arriveAndDeregister();
            }
        }
    }

    private static final class FutureSubscriber<T>
    implements Flow.Subscriber<T> {
        private final CompletionStage<Flow.Subscriber<T>> subscriberStage;
        private final CompletableFuture<Void> onSubscribeFuture = new CompletableFuture();

        FutureSubscriber(CompletionStage<Flow.Subscriber<T>> subscriberStage) {
            this.subscriberStage = subscriberStage;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            CompletionStageUtil.callOnComplete(this.subscriberStage, (subscriber, error) -> {
                if (error == null) {
                    subscriber.onSubscribe(subscription);
                    this.onSubscribeFuture.complete(null);
                } else {
                    subscription.cancel();
                }
            });
        }

        @Override
        public void onNext(T value) {
            this.subscriberStage.toCompletableFuture().join().onNext(value);
        }

        @Override
        public void onError(Throwable error) {
            CompletionStageUtil.callOnComplete(this.onSubscribeFuture, ignored -> this.subscriberStage.toCompletableFuture().join().onError(error));
        }

        @Override
        public void onComplete() {
            CompletionStageUtil.callOnComplete(this.onSubscribeFuture, ignored -> this.subscriberStage.toCompletableFuture().join().onComplete());
        }
    }

    private static final class SingleItemIterator<T>
    implements Iterator<T> {
        private final T item;
        boolean hasNext = true;

        private SingleItemIterator(T item) {
            this.item = item;
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public T next() {
            this.hasNext = false;
            return this.item;
        }
    }

    private static final class NoItemIterator
    implements Iterator<Void> {
        private static final NoItemIterator INSTANCE = new NoItemIterator();

        private NoItemIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Void next() {
            throw new NoSuchElementException();
        }
    }

    @FunctionalInterface
    public static interface ExceptionalCompletionHandler<E extends Throwable, T>
    extends Function<E, T> {
        public T handle(E var1) throws Exception;

        @Override
        default public T apply(E input) {
            try {
                return this.handle(input);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface NormalCompletionHandler<T, U>
    extends Function<T, U> {
        public U handle(T var1) throws Exception;

        @Override
        default public U apply(T input) {
            try {
                return this.handle(input);
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }

    @FunctionalInterface
    public static interface CompletionHandler
    extends Runnable {
        public void handle() throws Exception;

        @Override
        default public void run() {
            try {
                this.handle();
            }
            catch (Exception exception) {
                throw new CompletionException(exception);
            }
        }
    }
}

