/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.converter.CharacterSetMetaData;

public class OracleTypeCHAR
extends OracleType
implements Serializable {
    private static final String CLASS_NAME = OracleTypeCHAR.class.getName();
    static final long serialVersionUID = -6899444518695804629L;
    int form;
    int charset;
    int length;
    int characterSemantic;
    private transient OracleConnection connection;
    private short pickleCharaterSetId;
    private transient CharacterSet pickleCharacterSet;
    private short pickleNcharCharacterSet;

    protected OracleTypeCHAR() {
    }

    public OracleTypeCHAR(OracleConnection conn) {
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.connection = conn;
        this.pickleCharaterSetId = 0;
        this.pickleNcharCharacterSet = 0;
        this.pickleCharacterSet = null;
        try {
            this.pickleCharaterSetId = this.connection.getStructAttrCsId();
        }
        catch (SQLException sqlException) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "OracleTypeCHAR", sqlException.getMessage(), null, sqlException, new Object[0]);
            this.pickleCharaterSetId = (short)-1;
        }
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    protected OracleTypeCHAR(OracleConnection conn, int typecode) {
        super(typecode);
        this.form = 0;
        this.charset = 0;
        this.length = 0;
        this.connection = conn;
        this.pickleCharaterSetId = 0;
        this.pickleNcharCharacterSet = 0;
        this.pickleCharacterSet = null;
        try {
            this.pickleCharaterSetId = this.connection.getStructAttrCsId();
        }
        catch (SQLException sqlException) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "OracleTypeCHAR", sqlException.getMessage(), null, sqlException, new Object[0]);
            this.pickleCharaterSetId = (short)-1;
        }
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    private int getLengthInCharacter() {
        short characterSet;
        int ratio = 0;
        short s2 = characterSet = this.form == 2 ? this.pickleNcharCharacterSet : this.pickleCharaterSetId;
        if (characterSet != 0) {
            ratio = CharacterSetMetaData.getRatio(characterSet, 1);
            return this.length / ratio;
        }
        return this.length;
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        CHAR datum;
        if (value == null) {
            return null;
        }
        if (value instanceof CHAR) {
            datum = (CHAR)value;
        } else if (this.typeCode == 1 && value instanceof String) {
            if (this.characterSemantic != 0) {
                int ratio = CharacterSetMetaData.getRatio(this.pickleCharaterSetId, 1);
                Object s2 = (String)value;
                for (int i = ((String)s2).length(); i < this.length / ratio; ++i) {
                    s2 = (String)s2 + " ";
                }
                value = s2;
                datum = new CHAR(value, this.pickleCharacterSet);
            } else {
                datum = new CHAR((String)value, this.pickleCharacterSet, this.length);
            }
        } else {
            datum = new CHAR(value, this.pickleCharacterSet);
        }
        if (this.typeCode == 12 || this.typeCode == -9) {
            datum.setVariableLength(true);
        }
        return datum;
    }

    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof Object[] && !(obj instanceof char[][])) {
                return super.toDatumArray(obj, conn, beginIdx, count);
            }
            datumArray = this.cArrayToDatumArray(obj, conn, beginIdx, count);
        }
        return datumArray;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        super.parseTDSrec(tdsReader);
        try {
            this.length = tdsReader.readUB2();
            this.form = tdsReader.readByte();
            this.characterSemantic = this.form & 0x80;
            this.form &= 0x7F;
            this.charset = tdsReader.readUB2();
            if (this.form == 2) {
                switch (this.typeCode) {
                    case 12: {
                        this.typeCode = -9;
                        break;
                    }
                    case 1: {
                        this.typeCode = -15;
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS").fillInStackTrace();
        }
        if (this.form != 2 || this.pickleNcharCharacterSet != 0) {
            return;
        }
        try {
            this.pickleNcharCharacterSet = this.connection.getStructAttrNCsId();
        }
        catch (SQLException sqlException) {
            this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "parseTDSrec", sqlException.getMessage(), null, sqlException, new Object[0]);
            this.pickleNcharCharacterSet = (short)2000;
        }
        this.pickleCharaterSetId = this.pickleNcharCharacterSet;
        this.pickleCharacterSet = CharacterSet.make(this.pickleCharaterSetId);
    }

    @Override
    protected int pickle81(PickleContext context, Datum data) throws SQLException {
        CHAR dbchar = this.getDbCHAR(data);
        if (this.characterSemantic != 0 && this.form != 2 ? dbchar.getStringWithReplacement().length() > this.length : dbchar.getLength() > (long)this.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 72, "\"" + dbchar.getStringWithReplacement() + "\"").fillInStackTrace();
        }
        return super.pickle81(context, dbchar);
    }

    @Override
    protected Object toObject(byte[] bytes, int type, Map map) throws SQLException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        CHAR result = null;
        switch (this.form) {
            case 1: 
            case 2: {
                result = new CHAR(bytes, this.pickleCharacterSet);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                result = new CHAR(bytes, null);
            }
        }
        if ((this.typeCode == 12 || this.typeCode == -9) && result != null) {
            result.setVariableLength(true);
        }
        if (type == 1) {
            return result;
        }
        if (type == 2) {
            return result != null ? result.stringValue() : result;
        }
        if (type == 3) {
            return bytes;
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, bytes).fillInStackTrace();
    }

    private CHAR getDbCHAR(Datum data) {
        CHAR in_char_obj = (CHAR)data;
        CHAR db_char_obj = null;
        if (in_char_obj.getCharacterSet().getOracleId() == this.pickleCharaterSetId) {
            db_char_obj = in_char_obj;
        } else {
            try {
                db_char_obj = new CHAR(in_char_obj.toString(), this.pickleCharacterSet);
            }
            catch (SQLException sqlException) {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "getDbCHAR", sqlException.getMessage(), null, sqlException, new Object[0]);
                db_char_obj = in_char_obj;
            }
        }
        return db_char_obj;
    }

    private Datum[] cArrayToDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof char[][]) {
                char[][] parray = (char[][])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new CHAR(new String(parray[(int)beginIdx + i - 1]), this.pickleCharacterSet);
                }
            } else if (obj instanceof boolean[]) {
                boolean[] parray = (boolean[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new CHAR(parray[(int)beginIdx + i - 1], this.pickleCharacterSet);
                }
            } else if (obj instanceof short[]) {
                short[] parray = (short[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new CHAR(parray[(int)beginIdx + i - 1], this.pickleCharacterSet);
                }
            } else if (obj instanceof int[]) {
                int[] parray = (int[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new CHAR(parray[(int)beginIdx + i - 1], this.pickleCharacterSet);
                }
            } else if (obj instanceof long[]) {
                long[] parray = (long[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new CHAR(new Long(parray[(int)beginIdx + i - 1]), this.pickleCharacterSet);
                }
            } else if (obj instanceof float[]) {
                float[] parray = (float[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new CHAR(new Float(parray[(int)beginIdx + i - 1]), this.pickleCharacterSet);
                }
            } else if (obj instanceof double[]) {
                double[] parray = (double[])obj;
                int len = (int)(count == -1 ? (long)parray.length : Math.min((long)parray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[len];
                for (int i = 0; i < len; ++i) {
                    datumArray[i] = new CHAR(new Double(parray[(int)beginIdx + i - 1]), this.pickleCharacterSet);
                }
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, obj).fillInStackTrace();
            }
        }
        return datumArray;
    }

    public int getLength() {
        if (this.characterSemantic != 0) {
            return this.getLengthInCharacter();
        }
        return this.length;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.form);
        out.writeInt(this.charset);
        out.writeInt(this.length);
        out.writeInt(this.characterSemantic);
        out.writeShort(this.pickleCharaterSetId);
        out.writeShort(this.pickleNcharCharacterSet);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.form = in.readInt();
        this.charset = in.readInt();
        this.length = in.readInt();
        this.characterSemantic = in.readInt();
        this.pickleCharaterSetId = in.readShort();
        this.pickleNcharCharacterSet = in.readShort();
        this.pickleCharacterSet = this.pickleNcharCharacterSet != 0 ? CharacterSet.make(this.pickleNcharCharacterSet) : CharacterSet.make(this.pickleCharaterSetId);
    }

    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        this.connection = conn;
    }

    @Override
    public boolean isNCHAR() throws SQLException {
        return this.form == 2;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }
}

