/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.OracleClob;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={Clob.class, OracleClob.class, oracle.jdbc.internal.OracleClob.class})
public abstract class NonTxnReplayableClob
extends NonTxnReplayableBase
implements Replayable {
    private static final Method GETASCIISTREAM_METHOD = NonTxnReplayableClob.getGetAsciiStreamMethod();
    private static final Method GETASCIISTREAM_LONG_METHOD = NonTxnReplayableClob.getGetAsciiStreamLongMethod();
    private static final Method GETCHARSTREAM_METHOD = NonTxnReplayableClob.getGetCharacterStreamMethod();
    private static final Method GETCHARSTREAM_LONG_METHOD = NonTxnReplayableClob.getGetCharacterStreamLongMethod();
    private static final Method GETCHARSTREAM_LONG_LONG_METHOD = NonTxnReplayableClob.getGetCharacterStreamLongLongMethod();
    private static final Method SETASCIISTREAM_LONG_METHOD = NonTxnReplayableClob.getSetAsciiStreamLongMethod();
    private static final Method SETCHARSTREAM_LONG_METHOD = NonTxnReplayableClob.getSetCharacterStreamLongMethod();
    protected boolean isFreed = false;

    private static final Method getGetAsciiStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getAsciiStream", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetAsciiStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getAsciiStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetCharacterStreamLongLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("getCharacterStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getSetAsciiStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("setAsciiStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getSetCharacterStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleClob.class.getMethod("setCharacterStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method m4, Object receiver, Object ... args) {
        super.preForAll(m4, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="free", args={})})
    protected void preForFree(Method m4, Object receiver, Object ... args) {
        this.isFreed = true;
        super.preForAll(m4, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="setString", args={long.class, String.class}), @Signature(name="setString", args={long.class, String.class, int.class, int.class}), @Signature(name="truncate", args={long.class})})
    protected void preForClobWrites(Method m4, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableClob", "preForClobWrites", "On clob {0}, entering preForClobWrites({1})", (String)null, (Throwable)null, new Object[]{this, m4.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m4, 371, "Replay disabled because of active transaction", null);
        } else {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableClob", "preForClobWrites", "On clob {0}, failover manager not set", (String)null, (Throwable)null, (Object)this);
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableClob", "preForClobWrites", "On clob {0}, exiting preForClobWrites()", (String)null, (Throwable)null, (Object)this);
    }

    @Override
    @Post
    protected Object postForAll(Method m4, Object result) {
        if (result instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m4, result);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m4, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m4, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m4, SQLException error) throws SQLException {
        return super.onErrorForAll(m4, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getAsciiStream() throws SQLException {
        if (GETASCIISTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method m4 = GETASCIISTREAM_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob delegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            InputStream delegateReturn = delegate.canReadBasicLobDataInLocator() ? delegate.getAsciiStream() : delegate.getDBAccess().newInputStream((oracle.jdbc.internal.OracleClob)((Object)this), delegate.getBufferSize(), 0L);
            return (InputStream)this.postForAll(m4, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    public InputStream getAsciiStream(long pos) throws SQLException {
        if (GETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get ascii stream");
        }
        Method m4 = GETASCIISTREAM_LONG_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob delegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            InputStream delegateReturn = delegate.canReadBasicLobDataInLocator() ? delegate.getAsciiStream(pos) : delegate.getDBAccess().newInputStream((oracle.jdbc.internal.OracleClob)((Object)this), delegate.getBufferSize(), pos);
            return (InputStream)this.postForAll(m4, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    public Reader getCharacterStream() throws SQLException {
        if (GETCHARSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method m4 = GETCHARSTREAM_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob delegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            Reader delegateReturn = delegate.canReadBasicLobDataInLocator() ? delegate.getCharacterStream() : delegate.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), delegate.getBufferSize(), 0L);
            return (Reader)this.postForAll(m4, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (Reader)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    public Reader getCharacterStream(long pos) throws SQLException {
        if (GETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method m4 = GETCHARSTREAM_LONG_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob delegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            Reader delegateReturn = delegate.canReadBasicLobDataInLocator() ? delegate.getCharacterStream(pos) : delegate.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), delegate.getBufferSize(), pos);
            return (Reader)this.postForAll(m4, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (Reader)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    public Reader getCharacterStream(long pos, long length) throws SQLException {
        if (GETCHARSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get character stream");
        }
        Method m4 = GETCHARSTREAM_LONG_LONG_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            Reader delegateReturn;
            oracle.jdbc.internal.OracleClob delegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            if (delegate.canReadBasicLobDataInLocator()) {
                delegateReturn = delegate.getCharacterStream(pos, length);
            } else {
                long lobLen = delegate.length();
                if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
                    SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 68);
                    sqlexc.fillInStackTrace();
                    throw sqlexc;
                }
                delegateReturn = delegate.getDBAccess().newReader((oracle.jdbc.internal.OracleClob)((Object)this), delegate.getBufferSize(), pos, length);
            }
            return (Reader)this.postForAll(m4, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (Reader)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        if (SETASCIISTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set ascii stream");
        }
        Method m4 = SETASCIISTREAM_LONG_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob delegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            OutputStream delegateReturn = delegate.getDBAccess().newOutputStream((oracle.jdbc.internal.OracleClob)((Object)this), delegate.getBufferSize(), pos, true);
            return (OutputStream)this.postForAll(m4, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (OutputStream)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        if (SETCHARSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set character stream");
        }
        Method m4 = SETCHARSTREAM_LONG_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleClob delegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            Writer delegateReturn = delegate.getDBAccess().newWriter((oracle.jdbc.internal.OracleClob)((Object)this), delegate.getBufferSize(), pos, true);
            return (Writer)this.postForAll(m4, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (Writer)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    public OutputStream getAsciiOutputStream() throws SQLException {
        return this.setAsciiStream(1L);
    }

    public OutputStream getAsciiOutputStream(long pos) throws SQLException {
        return this.setAsciiStream(pos);
    }

    public Writer getCharacterOutputStream() throws SQLException {
        return this.setCharacterStream(1L);
    }

    public Writer getCharacterOutputStream(long pos) throws SQLException {
        return this.setCharacterStream(pos);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleClob delegate = (oracle.jdbc.internal.OracleClob)this.getDelegate();
        return delegate.getInternalConnection();
    }
}

