/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.NClob;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.OracleNClob;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableClob;
import oracle.jdbc.replay.driver.Replayable;

@ProxyFor(value={NClob.class, OracleNClob.class, oracle.jdbc.internal.OracleNClob.class})
public abstract class NonTxnReplayableNClob
extends NonTxnReplayableClob
implements Replayable {
    @Override
    @Pre
    protected void preForAll(Method m4, Object receiver, Object ... args) {
        super.preForAll(m4, receiver, args);
    }

    @Override
    @Pre
    @Methods(signatures={@Signature(name="setString", args={long.class, String.class}), @Signature(name="setString", args={long.class, String.class, int.class, int.class}), @Signature(name="truncate", args={long.class})})
    protected void preForClobWrites(Method m4, Object receiver, Object ... args) {
        FailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableNClob", "preForClobWrites", "On nclob {0}, entering preForClobWrites({1})", (String)null, (Throwable)null, new Object[]{this, m4.getName()});
        super.preForClobWrites(m4, receiver, args);
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, "oracle/jdbc/replay/driver/NonTxnReplayableNClob", "preForClobWrites", "On nclob {0}, exiting preForClobWrites()", (String)null, (Throwable)null, (Object)this);
    }

    @Override
    @Post
    protected Object postForAll(Method m4, Object result) {
        if (result instanceof NonTxnReplayableBase) {
            NonTxnReplayableBase jdbcProxy = (NonTxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m4, result);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m4, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m4, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m4, SQLException error) throws SQLException {
        return super.onErrorForAll(m4, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleNClob delegate = (oracle.jdbc.internal.OracleNClob)this.getDelegate();
        return delegate.getInternalConnection();
    }
}

