/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jdbc.nl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;

public class NLParamParser {
    private String filename;
    private Hashtable ht;
    private Vector linebuffer;
    private int filePermissions = 0;
    private int Commentcnt = 0;
    private int nvStringcnt = 0;
    private int Groupcnt = 0;
    private boolean hasComments = false;
    private boolean hasGroups = false;
    private String[] errstr;
    private int errstrcnt;
    private static final int MAX_ERRORS = 50;
    public static final byte IGNORE_NONE = 0;
    public static final byte IGNORE_NL_EXCEPTION = 1;
    public static final byte IGNORE_FILE_EXCEPTION = 2;
    public static final byte NLPASUCC = 1;
    public static final byte NLPAOVWR = 2;
    public static final byte NLPAFAIL = -1;
    private static boolean DEBUG = false;

    public static NLParamParser createEmptyParamParser() {
        return new NLParamParser();
    }

    private NLParamParser() {
        this.filename = null;
        this.ht = new Hashtable(128);
    }

    public NLParamParser(String filename) throws IOException, NLException {
        this(filename, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NLParamParser(String filename, byte ignore_exception) throws NLException, IOException {
        this.filename = filename;
        this.ht = new Hashtable(128);
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(filename);
            br = new BufferedReader(fr);
            this.initializeNlpa(br, ignore_exception);
        }
        catch (FileNotFoundException e) {
            if ((ignore_exception & 2) == 0) {
                throw new FileNotFoundException(filename);
            }
        }
        finally {
            if (fr != null) {
                fr.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    public NLParamParser(Reader dataStream) throws IOException, NLException {
        this(dataStream, 0);
    }

    public NLParamParser(Reader dataStream, byte ignore_exception) throws IOException, NLException {
        BufferedReader br = new BufferedReader(dataStream);
        this.filename = null;
        this.ht = new Hashtable(128);
        this.initializeNlpa(br, ignore_exception);
    }

    private void initializeNlpa(BufferedReader br, byte ignore_exception) throws IOException, NLException {
        block28: {
            this.linebuffer = new Vector(100, 50);
            this.errstr = new String[50];
            try {
                String newline;
                while ((newline = br.readLine()) != null) {
                    this.linebuffer.addElement(newline);
                }
            }
            catch (IOException e) {
                if ((ignore_exception & 2) != 0) break block28;
                throw new IOException("Unable to read a line from : " + this.filename);
            }
        }
        Object nvElem = "";
        String linesep = NVPair.LINE_SEPARATOR;
        Object commentKey = "";
        Object commentValue = "";
        for (int i = 0; i < this.linebuffer.size(); ++i) {
            block32: {
                String line;
                block31: {
                    line = (String)this.linebuffer.elementAt(i);
                    if (line.length() == 0) continue;
                    if (line.charAt(0) == '#') {
                        if (line.indexOf(".ORA Configuration ") != -1 || line.indexOf(" Network Configuration File: ") != -1 || line.indexOf("Generated by") != -1) {
                            if (!DEBUG) continue;
                            System.out.println(line + ": this comment ignored");
                            continue;
                        }
                        if (((String)commentKey).length() != 0) {
                            commentValue = (String)commentValue + line + linesep;
                            continue;
                        }
                        commentKey = "COMMENT#" + this.Commentcnt;
                        commentValue = line + linesep;
                        if (this.hasComments) continue;
                        this.hasComments = true;
                        continue;
                    }
                    if (line.charAt(0) == ' ' || line.charAt(0) == '\t' || line.charAt(0) == ')' || line.charAt(0) == '(') {
                        if (((String)commentValue).length() == 0) {
                            if (((String)nvElem).length() == 0) {
                                line = this.eatNLPWS(line);
                            }
                            if ((line = this.checkNLPforComments(line)).length() == 0) continue;
                            nvElem = (String)nvElem + line + linesep;
                            continue;
                        }
                        if (((String)nvElem).length() == 0 && ((String)commentValue).length() != 0) {
                            line = this.eatNLPWS(line);
                            if ((line = this.checkNLPforComments(line)).length() == 0 || (ignore_exception & 1) != 0) continue;
                            throw new NLException("InvalidChar-04611", "");
                        }
                        if (((String)nvElem).length() == 0 || ((String)commentValue).length() == 0) continue;
                        commentKey = "";
                        commentValue = "";
                        line = this.checkNLPforComments(line);
                        nvElem = (String)nvElem + line + linesep;
                        continue;
                    }
                    if (((String)nvElem).length() == 0 && ((String)commentValue).length() == 0) {
                        line = this.checkNLPforComments(line);
                        nvElem = (String)nvElem + line + linesep;
                        continue;
                    }
                    if (((String)nvElem).length() == 0 && ((String)commentValue).length() != 0) {
                        block29: {
                            commentValue = this.modifyCommentString((String)commentValue);
                            try {
                                this.addNLPListElement((String)commentKey + "=" + (String)commentValue);
                            }
                            catch (NLException e) {
                                this.storeError((String)nvElem, ignore_exception);
                                if ((ignore_exception & 1) != 0) break block29;
                                throw e;
                            }
                        }
                        commentKey = "";
                        commentValue = "";
                        ++this.Commentcnt;
                        line = this.checkNLPforComments(line);
                        nvElem = (String)nvElem + line + linesep;
                        continue;
                    }
                    if (((String)nvElem).length() != 0 && ((String)commentValue).length() == 0) {
                        block30: {
                            try {
                                this.addNLPListElement((String)nvElem);
                            }
                            catch (NLException e) {
                                this.storeError((String)nvElem, ignore_exception);
                                if ((ignore_exception & 1) != 0) break block30;
                                throw e;
                            }
                        }
                        nvElem = "";
                        line = this.checkNLPforComments(line);
                        nvElem = (String)nvElem + line + linesep;
                        continue;
                    }
                    if (((String)nvElem).length() == 0 || ((String)commentValue).length() == 0) continue;
                    try {
                        this.addNLPListElement((String)nvElem);
                    }
                    catch (NLException e) {
                        this.storeError((String)nvElem, ignore_exception);
                        if ((ignore_exception & 1) != 0) break block31;
                        throw e;
                    }
                }
                nvElem = "";
                line = this.checkNLPforComments(line);
                nvElem = (String)nvElem + line + linesep;
                commentValue = this.modifyCommentString((String)commentValue);
                try {
                    this.addNLPListElement((String)commentKey + "=" + (String)commentValue);
                }
                catch (NLException e) {
                    this.storeError((String)nvElem, ignore_exception);
                    if ((ignore_exception & 1) != 0) break block32;
                    throw e;
                }
            }
            commentKey = "";
            commentValue = "";
            ++this.Commentcnt;
        }
        if (((String)nvElem).length() != 0) {
            block33: {
                try {
                    this.addNLPListElement((String)nvElem);
                }
                catch (NLException e) {
                    this.storeError((String)nvElem, ignore_exception);
                    if ((ignore_exception & 1) != 0) break block33;
                    throw e;
                }
            }
            nvElem = "";
        }
        if (((String)commentValue).length() != 0) {
            block34: {
                commentValue = this.modifyCommentString((String)commentValue);
                try {
                    this.addNLPListElement((String)commentKey + "=" + (String)commentValue);
                }
                catch (NLException e) {
                    this.storeError((String)nvElem, ignore_exception);
                    if ((ignore_exception & 1) != 0) break block34;
                    throw e;
                }
            }
            commentKey = "";
            commentValue = "";
            ++this.Commentcnt;
        }
    }

    private String modifyCommentString(String str) {
        Object str1 = "";
        boolean offset = false;
        block7: for (int i = 0; i < str.length(); ++i) {
            char current_char = str.charAt(i);
            switch (current_char) {
                case '(': {
                    str1 = (String)str1 + "\\(";
                    continue block7;
                }
                case '=': {
                    str1 = (String)str1 + "\\=";
                    continue block7;
                }
                case ')': {
                    str1 = (String)str1 + "\\)";
                    continue block7;
                }
                case ',': {
                    str1 = (String)str1 + "\\,";
                    continue block7;
                }
                case '\\': {
                    str1 = (String)str1 + "\\\\";
                    continue block7;
                }
                default: {
                    str1 = (String)str1 + str.charAt(i);
                }
            }
        }
        return str1;
    }

    private String checkNLPforComments(String str) {
        StringBuffer str1 = new StringBuffer(str.length());
        boolean offset = false;
        for (int i = 0; i < str.length(); ++i) {
            char current_char = str.charAt(i);
            if (current_char == '#') {
                if (i != 0) {
                    if (str.charAt(i - 1) != '\\') break;
                    str1.append(current_char);
                    continue;
                }
                return "";
            }
            str1.append(current_char);
        }
        return str1.toString();
    }

    private String eatNLPWS(String str) {
        StringBuffer str1 = new StringBuffer(str.length());
        int offset = 0;
        boolean NWScharfound = false;
        while (!NWScharfound) {
            char current_char;
            if ((current_char = str.charAt(offset++)) != ' ' || current_char != '\t') {
                NWScharfound = true;
                int i = offset - 1;
                while (str.charAt(i) == '\n') {
                    str1.append(str.charAt(i));
                    ++i;
                }
                continue;
            }
            if (current_char != '\n') continue;
            return "";
        }
        return str1.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveNLParams() throws IOException {
        if (this.filename == null) {
            return;
        }
        try (FileWriter fw = null;){
            fw = new FileWriter(this.filename);
            String orafileType = "unknown";
            StringTokenizer st = new StringTokenizer(this.filename, File.separator);
            while (st.hasMoreTokens()) {
                orafileType = st.nextToken();
            }
            this.writeToStream(fw, orafileType, this.filename);
        }
    }

    public void writeToStream(Writer out, String headerFileType, String headerFileName) {
        PrintWriter pw = null;
        pw = new PrintWriter(new BufferedWriter(out));
        pw.println("# " + headerFileType + " Network Configuration File: " + headerFileName);
        pw.println("# Generated by Oracle configuration tools.");
        pw.println("");
        if (this.hasGroups) {
            this.saveNLPGroups(pw);
        }
        Enumeration e = this.ht.elements();
        while (e.hasMoreElements()) {
            NVPair nvp = (NVPair)e.nextElement();
            String Value2 = nvp.toString(0, true);
            if (DEBUG) {
                System.out.println("The initial stringified NVPair is:\n" + Value2);
            }
            if (Value2.equals("")) continue;
            char[] chkstr = new char[Value2.length() - 2];
            Value2.getChars(1, Value2.length() - 1, chkstr, 0);
            String newValue = new String(chkstr);
            if (DEBUG) {
                System.out.println("The modified NV String is:\n" + newValue);
            }
            pw.println(newValue);
            pw.println("");
            chkstr = null;
        }
        pw.close();
    }

    public void saveNLParams(String filename) throws FileNotFoundException, IOException {
        String oldFilenameOrNullIfStream = this.filename;
        this.filename = filename;
        this.saveNLParams();
        this.filename = oldFilenameOrNullIfStream;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean configuredInFile() {
        return this.filename != null;
    }

    public int getNLPListSize() {
        this.nvStringcnt = 0;
        Enumeration e = this.ht.keys();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (paramName.indexOf("COMMENT") != -1) continue;
            ++this.nvStringcnt;
        }
        return this.nvStringcnt;
    }

    public boolean inErrorList(String name) {
        boolean exists = false;
        if (DEBUG) {
            System.out.println("Entering inErrorList():");
        }
        for (int i = 0; !(exists && i >= this.errstrcnt || this.errstrcnt == 0); ++i) {
            if (this.errstr[i].indexOf(name) == -1) continue;
            exists = true;
        }
        return exists;
    }

    public NVPair getNLPListElement(String Name4) {
        String UName = Name4.toUpperCase();
        return (NVPair)this.ht.get(UName);
    }

    public String[] getNLPAllNames() {
        int size = this.getNLPListSize();
        String[] Names = new String[size];
        int count = 0;
        Enumeration e = this.ht.keys();
        while (e.hasMoreElements()) {
            String paramName = (String)e.nextElement();
            if (paramName.indexOf("COMMENT") != -1) continue;
            Names[count++] = paramName;
        }
        return Names;
    }

    public String[] getNLPAllElements() {
        int size = this.getNLPListSize();
        String[] nvstrings = new String[size];
        int count = 0;
        Enumeration e = this.ht.elements();
        while (e.hasMoreElements()) {
            NVPair nvp = (NVPair)e.nextElement();
            if (nvp.getName().indexOf("COMMENT") != -1) continue;
            String nvelem = nvp.toString();
            nvstrings[count++] = nvelem;
        }
        return nvstrings;
    }

    public byte addNLPListElement(String Name4, Object Value2) {
        try {
            Object retobj = this.ht.put(Name4, Value2);
            return retobj != null ? (byte)2 : 1;
        }
        catch (NullPointerException e) {
            if (DEBUG) {
                System.out.println(e.getMessage());
            }
            return -1;
        }
    }

    public void addNLPGroupProfile(String[] Names) {
        String GroupName = new String("GROUP#" + this.Groupcnt++);
        String[] GroupValue = Names;
        if (!this.hasGroups) {
            this.hasGroups = true;
        }
        this.addNLPListElement(GroupName, GroupValue);
    }

    private String[] getNLPGroupProfile(String Name4) {
        String UName = Name4.toUpperCase();
        return (String[])this.ht.get(UName);
    }

    private void saveNLPGroups(PrintWriter pw) {
        for (int i = 0; i < this.Groupcnt; ++i) {
            String GroupName = new String("GROUP#" + i);
            String[] Value2 = this.getNLPGroupProfile(GroupName);
            for (int j = 0; j < Value2.length; ++j) {
                String paramValue = null;
                String newValue = null;
                NVPair nvp = null;
                if (DEBUG) {
                    System.out.println("Current Value in Group Profile: " + Value2[j]);
                }
                if (Value2[j] == null) continue;
                nvp = this.getNLPListElement(Value2[j]);
                if (nvp != null) {
                    paramValue = nvp.toString(0, true);
                    if (DEBUG) {
                        System.out.println("Parameter Value = " + paramValue);
                    }
                    char[] chkstr = new char[paramValue.length() - 2];
                    paramValue.getChars(1, paramValue.length() - 1, chkstr, 0);
                    newValue = new String(chkstr);
                    pw.println(newValue);
                    pw.println("");
                    NVPair nvp_gone = this.removeNLPListElement(Value2[j]);
                    if (nvp_gone == null && DEBUG) {
                        System.out.println("saveNLPGroups(): Could notremove param from Hashtable");
                    }
                    chkstr = null;
                    newValue = null;
                    continue;
                }
                if (!DEBUG) continue;
                System.out.println("No such Parameter in the Table");
            }
            this.removeNLPGroupProfile(GroupName);
        }
    }

    public void addNLPListElement(String nvString) throws NLException {
        String[] unames;
        char[] chkstr = new char[nvString.length() + 2];
        String newstr = "";
        if (DEBUG) {
            System.out.println("Entering Method addNLPListElement\n");
            System.out.println("String to add is: " + nvString);
        }
        nvString.getChars(0, nvString.length(), chkstr, 1);
        if (chkstr[1] == '(') {
            newstr = nvString;
        } else {
            chkstr[0] = 40;
            String os = System.getProperty("os.name");
            if (os != null && (os.equals("Windows NT") || os.equals("Windows 95"))) {
                if (chkstr[chkstr.length - 2] == '/' || chkstr[chkstr.length - 2] == '\\') {
                    chkstr[chkstr.length - 2] = 41;
                } else {
                    chkstr[chkstr.length - 1] = 41;
                }
            } else if (chkstr[chkstr.length - 2] == '\\') {
                chkstr[chkstr.length - 2] = 41;
            } else {
                chkstr[chkstr.length - 1] = 41;
            }
            newstr = new String(chkstr);
            if (DEBUG) {
                System.out.println("The modified NV String is: " + newstr);
            }
        }
        NVFactory nvf = new NVFactory();
        NVPair nvp = nvf.createNVPair(newstr);
        if (nvp.getRHSType() == NVPair.RHS_NONE) {
            throw new NLException("NullRHS-04612", nvp.getName());
        }
        String name = nvp.getName();
        String uname = name.toUpperCase();
        nvp.setName(uname);
        block4: for (String aliasUname : unames = uname.split(",")) {
            if (DEBUG) {
                System.out.println("The final NV String is: " + nvp.toString());
            }
            byte retcode = this.addNLPListElement(aliasUname, nvp);
            switch (retcode) {
                case 2: {
                    if (!DEBUG) continue block4;
                    System.out.println("The value for the Name: " + aliasUname + " was overwritten\n");
                    continue block4;
                }
                case -1: {
                    if (!DEBUG) continue block4;
                    System.out.println("The value for the Name: " + aliasUname + " could not be inserted\n");
                }
            }
        }
    }

    public NVPair removeNLPListElement(String Name4) {
        Object retobj;
        String UName = Name4.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + UName + " from Table");
        }
        return (retobj = this.ht.remove(UName)) != null ? (NVPair)retobj : null;
    }

    public void removeNLPGroupProfile(String Name4) {
        String UName = Name4.toUpperCase();
        if (DEBUG) {
            System.out.println("Trying to remove: " + UName + " GroupName from Table");
        }
        Object retobj = this.ht.remove(UName);
    }

    public void removeNLPAllElements() {
        this.ht.clear();
    }

    public String toString() {
        Object out = "";
        Enumeration e = this.ht.elements();
        while (e.hasMoreElements()) {
            NVPair nvp = (NVPair)e.nextElement();
            String Value2 = nvp.toString();
            out = (String)out + Value2 + "\n";
        }
        return out;
    }

    public boolean fileHasComments() {
        return this.hasComments;
    }

    public void println() {
        System.out.println(this.toString());
    }

    public void setFilePermissions(int filePermissions) {
        this.filePermissions = filePermissions;
    }

    private void storeError(String nvElem, byte ignore_exception) throws NLException {
        if (this.errstrcnt < 50) {
            this.errstr[this.errstrcnt++] = nvElem;
        } else if ((ignore_exception & 1) == 0) {
            throw new NLException("Too many errors", "");
        }
    }
}

