/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.resolver;

import java.util.ArrayList;
import java.util.Vector;
import oracle.net.jdbc.TNSAddress.AddressList;
import oracle.net.jdbc.TNSAddress.SchemaObjectFactoryInterface;
import oracle.net.ns.NetException;
import oracle.net.nt.ConnOption;
import oracle.net.nt.ConnStrategy;
import oracle.net.resolver.NavAddress;
import oracle.net.resolver.NavDescriptionList;
import oracle.net.resolver.NavSchemaObject;

public class NavAddressList
extends AddressList
implements NavSchemaObject {
    private Vector activeChildren = new Vector(1, 10);
    private int sBuflength;
    private NetException stashedException = null;

    public NavAddressList(SchemaObjectFactoryInterface fac) {
        super(fac);
    }

    @Override
    public void navigate(ConnStrategy cs, StringBuffer sBuf) throws NetException {
        this.navigate2(cs, sBuf, 0);
    }

    private void navigate2(ConnStrategy cs, StringBuffer sBuf, int reCurCnt) throws NetException {
        int i;
        boolean nested = false;
        ++reCurCnt;
        this.sBuflength = sBuf.length();
        sBuf.append("(ADDRESS_LIST=");
        if (this.sourceRoute) {
            this.activeChildren = this.children;
            try {
                ((NavSchemaObject)this.activeChildren.elementAt(0)).navigate(cs, sBuf);
            }
            catch (NetException e) {
                this.stashedException = e;
                throw e;
            }
            for (i = 1; i < this.activeChildren.size(); ++i) {
                ((NavSchemaObject)this.activeChildren.elementAt(i)).addToString(cs);
            }
        } else {
            this.activeChildren = NavDescriptionList.setActiveChildren(this.children, this.failover, this.loadBalance);
            for (i = 0; i < this.activeChildren.size(); ++i) {
                if (this.getChildrenType(i) == 1) {
                    nested = true;
                    ((NavAddressList)this.activeChildren.elementAt(i)).navigate2(cs, sBuf, reCurCnt);
                    continue;
                }
                try {
                    ((NavSchemaObject)this.activeChildren.elementAt(i)).navigate(cs, sBuf);
                    continue;
                }
                catch (NetException e) {
                    this.stashedException = e;
                }
            }
            if (cs.currentDescription().getConnectOptions().size() == 0) {
                sBuf.replace(sBuf.length() - "(ADDRESS_LIST=".length(), sBuf.length(), "");
                throw this.stashedException;
            }
        }
        if (!(--reCurCnt == 0 && nested || this.sourceRoute)) {
            this.closeNVPair(cs, false);
        } else {
            this.closeNVPair(cs, true);
        }
        sBuf.setLength(this.sBuflength);
        if (this.loadBalance) {
            cs.addSocketOptions_FORCE_DNS_LOAD_BALANCING_OFF();
        }
    }

    @Override
    public void addToString(ConnStrategy cs) {
        String NVString = this.toString();
        ArrayList<ConnOption> cOpts = cs.currentDescription().getConnectOptions();
        for (ConnOption co : cOpts) {
            if (co.done) continue;
            co.conn_data.append(NVString);
        }
    }

    @Override
    public String toString() {
        Object s2 = "";
        s2 = (String)s2 + "(ADDRESS_LIST=";
        for (int i = 0; i < this.children.size(); ++i) {
            s2 = (String)s2 + ((NavSchemaObject)this.children.elementAt(i)).toString();
        }
        if (this.sourceRoute) {
            s2 = (String)s2 + "(SOURCE_ROUTE=yes)";
        }
        if (this.loadBalance) {
            s2 = (String)s2 + "(LOAD_BALANCE=yes)";
        }
        if (!this.failover) {
            s2 = (String)s2 + "(FAILOVER=false)";
        }
        s2 = (String)s2 + ")";
        return s2;
    }

    public int getChildrenSize() {
        return this.children.size();
    }

    public int getChildrenType(int childNum) {
        return ((NavSchemaObject)this.children.elementAt(childNum)).isA();
    }

    public NavAddress getChild(int childNum) {
        return (NavAddress)this.children.elementAt(childNum);
    }

    private void closeNVPair(ConnStrategy cs, boolean mode) {
        ArrayList<ConnOption> cOpts = cs.currentDescription().getConnectOptions();
        for (int i = cOpts.size() - 1; i >= 0 && !cOpts.get((int)i).done && (mode || cOpts.size() - 1 - i < this.getChildrenSize()); --i) {
            if (this.sourceRoute) {
                cOpts.get((int)i).conn_data.append("(SOURCE_ROUTE=yes)");
                cOpts.get((int)i).done = true;
            }
            cOpts.get((int)i).conn_data.append(")");
        }
    }
}

