/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.sql.Datum;

public class RAW
extends Datum {
    static final long serialVersionUID = -3298750557928937840L;

    static int hexDigit2Nibble(char hex) throws SQLException {
        int result = Character.digit(hex, 16);
        if (result == -1) {
            throw (SQLException)DatabaseError.createSqlException(59, "Invalid hex digit: " + hex).fillInStackTrace();
        }
        return result;
    }

    public static byte[] hexString2Bytes(String hexString) throws SQLException {
        byte[] bytes;
        int len = hexString.length();
        char[] hexChars = new char[len];
        hexString.getChars(0, len, hexChars, 0);
        int i = 0;
        int j = 0;
        if (len == 0) {
            return new byte[0];
        }
        if (len % 2 > 0) {
            bytes = new byte[(len + 1) / 2];
            bytes[i++] = (byte)RAW.hexDigit2Nibble(hexChars[j++]);
        } else {
            bytes = new byte[len / 2];
        }
        while (i < bytes.length) {
            bytes[i] = (byte)(RAW.hexDigit2Nibble(hexChars[j++]) << 4 | RAW.hexDigit2Nibble(hexChars[j++]));
            ++i;
        }
        return bytes;
    }

    public static RAW newRAW(Object obj) throws SQLException {
        RAW result = new RAW(obj);
        return result;
    }

    public static RAW oldRAW(Object obj) throws SQLException {
        RAW result;
        if (obj instanceof String) {
            String s2 = (String)obj;
            byte[] bytes = null;
            try {
                bytes = s2.getBytes("ISO8859_1");
            }
            catch (UnsupportedEncodingException e) {
                throw DatabaseError.createSqlException(109, "ISO8859_1 character encoding not found");
            }
            result = new RAW(bytes);
        } else {
            result = new RAW(obj);
        }
        return result;
    }

    public RAW() {
    }

    public RAW(byte[] raw_bytes) {
        super(raw_bytes);
    }

    public RAW(Object val) throws SQLException {
        this();
        if (val instanceof byte[]) {
            this.setShareBytes((byte[])val);
        } else if (val instanceof String) {
            this.setShareBytes(RAW.hexString2Bytes((String)val));
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, val).fillInStackTrace();
        }
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.getBytes();
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        return class_name.compareTo("java.lang.String") == 0 || class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    @Override
    public String stringValue() {
        String ret = RepConversion.bArray2String(this.getBytes());
        return ret;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        int nbytes = (int)this.getLength();
        char[] chars = new char[nbytes * 2];
        byte[] bytes = this.shareBytes();
        DBConversion.RAWBytesToHexChars(bytes, nbytes, chars);
        CharArrayReader ret = new CharArrayReader(chars);
        return ret;
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        int nbytes = (int)this.getLength();
        char[] chars = new char[nbytes * 2];
        byte[] bytes = this.shareBytes();
        DBConversion.RAWBytesToHexChars(bytes, nbytes, chars);
        byte[] buf = new byte[nbytes * 2];
        DBConversion.javaCharsToAsciiBytes(chars, nbytes * 2, buf);
        ByteArrayInputStream ret = new ByteArrayInputStream(buf);
        return ret;
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getStream();
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new byte[arraySize][];
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

