/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.PrintDriver;
import oracle.xml.parser.v2.ScalableDOMPrintDriver;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLCDATA;
import oracle.xml.parser.v2.XMLComment;
import oracle.xml.parser.v2.XMLDeclPI;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLDocumentFragment;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLEntityReference;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSSerializerFilter;

public class XMLPrintDriver
implements PrintDriver {
    protected XMLOutputStream out;
    protected Vector prefixVector;
    protected Vector nsVector;
    protected int prevSize;
    protected int prefixCount;
    protected Hashtable nsDeclToPrint;
    protected Hashtable inheritedNS;
    private boolean formatPrettyPrint = false;
    private boolean xmlDeclaration = true;
    private LSSerializerFilter filter = null;
    boolean printAllAttrs = false;
    boolean lsSerializer = false;
    boolean printInheritedNS = false;
    String serializerEncoding = null;
    private String schemaLocation = null;
    static final int NSDECL_CONFLICT = 2;
    static final int NSDECL_FOUND = 1;
    static final int NSDECL_MISMATCH = 0;
    static final int NSDECL_NOTFOUND = -1;
    static final String FORMAT_PRETTY_PRINT = "format-pretty-print";
    static final String XML_DECLARATION = "xml-declaration";
    private static final String xpdName = XMLPrintDriver.class.getCanonicalName().intern();
    private static final String sdpdName = ScalableDOMPrintDriver.class.getCanonicalName().intern();
    private final String className = this.getClass().getCanonicalName().intern();
    private final boolean isExtending = !this.className.equals(xpdName) && !this.className.equals(sdpdName);

    XMLPrintDriver(XMLOutputStream xMLOutputStream) {
        this.out = xMLOutputStream;
        this.init();
    }

    public XMLPrintDriver(Writer writer) {
        this.out = new XMLOutputStream(writer);
        this.init();
    }

    public XMLPrintDriver(PrintWriter printWriter) {
        this.out = new XMLOutputStream(printWriter);
        this.init();
    }

    public XMLPrintDriver(OutputStream outputStream) {
        this.out = new XMLOutputStream(outputStream);
        this.init();
    }

    @Override
    public void setEncoding(String string) throws IOException {
        if (this.serializerEncoding == null) {
            this.serializerEncoding = string;
        }
        this.out.setEncoding(string, true, true);
    }

    public void setEOLChars(String string) {
        this.out.setEOLChars(string);
    }

    public void setFormatPrettyPrint(boolean bl) {
        if (bl) {
            this.out.setOutputStyle(1);
        } else {
            this.out.setOutputStyle(0);
        }
    }

    public void setPrintInheritedNamespaces(boolean bl) {
        this.printInheritedNS = bl;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public void setConfig(DOMConfiguration dOMConfiguration) throws IOException {
        this.lsSerializer = true;
        this.formatPrettyPrint = (Boolean)dOMConfiguration.getParameter(FORMAT_PRETTY_PRINT);
        this.xmlDeclaration = (Boolean)dOMConfiguration.getParameter(XML_DECLARATION);
        if (this.formatPrettyPrint) {
            this.out.setOutputStyle(1);
        } else {
            this.out.setOutputStyle(0);
        }
    }

    void setFilter(LSSerializerFilter lSSerializerFilter) {
        this.filter = lSSerializerFilter;
    }

    public void printNode(XMLNode xMLNode) throws IOException {
        xMLNode.print(this.out, false);
        this.out.flush();
    }

    @Override
    public void printDoctype(DTD dTD) throws IOException {
        dTD.print(this.out, false);
        this.out.flush();
    }

    @Override
    public void printDocument(XMLDocument xMLDocument) throws IOException {
        this.setEncoding(xMLDocument.getEncoding());
        this.printXMLDecl(xMLDocument);
        this.printChildNodes(xMLDocument);
        this.out.flush();
    }

    @Override
    public void printElement(XMLElement xMLElement) throws IOException {
        XMLNode xMLNode;
        boolean bl = false;
        if (this.printInheritedNS && this.inheritedNS == null && (xMLNode = (XMLNode)xMLElement.getParentNode()).getNodeType() == 1) {
            this.inheritedNS = xMLElement.getAllNamespaceAttrs();
            bl = true;
        }
        this.internalPrintElement(xMLElement, false);
        if (bl) {
            this.inheritedNS = null;
        }
        this.out.flush();
    }

    public void printElement(XMLElement xMLElement, boolean bl) throws IOException {
        XMLNode xMLNode;
        boolean bl2 = false;
        if (this.printInheritedNS && this.inheritedNS == null && (xMLNode = (XMLNode)xMLElement.getParentNode()).getNodeType() == 1) {
            this.inheritedNS = xMLElement.getAllNamespaceAttrs();
            bl2 = true;
        }
        this.internalPrintElement(xMLElement, bl);
        if (bl2) {
            this.inheritedNS = null;
        }
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalPrintElement(XMLElement xMLElement, boolean bl) throws IOException {
        String string;
        if (this.schemaLocation != null) {
            string = this.schemaLocation;
            this.schemaLocation = null;
            xMLElement = (XMLElement)xMLElement.cloneNode(true);
            xMLElement.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", string);
        } else {
            string = null;
        }
        this.printAllAttrs = bl;
        boolean bl2 = true;
        boolean bl3 = this.out.mixed;
        int n = this.out.getOutputStyle();
        int n2 = this.nsVector.size();
        int n3 = this.prefixCount;
        this.prevSize = n2;
        this.nsDeclToPrint.clear();
        try {
            this.out.writeIndent();
            this.out.writeChars("<");
            this.scanNSDecls(xMLElement);
            String string2 = xMLElement.getNodePrefix();
            String string3 = xMLElement.getNamespace();
            string2 = this.checkConflicts(string2, string3, true);
            if (string2 == null) {
                this.out.writeChars(xMLElement.getNodeName());
            } else {
                if (!string2.equals("")) {
                    this.out.writeChars(string2);
                    this.out.write(58);
                }
                this.out.writeChars(xMLElement.getNodeLocalName());
            }
            if (xMLElement.hasAttributes()) {
                this.internalPrintAttributeNodes(xMLElement);
            }
            this.printNsDecls(xMLElement);
            if (xMLElement.hasChildNodes()) {
                this.out.writeChars(">");
                bl2 = false;
                if (xMLElement.isNodeFlag(65536)) {
                    this.out.mixed = true;
                } else if (!xMLElement.isNodeFlag(131072)) {
                    for (Node node = xMLElement.getFirstChild(); node != null; node = node.getNextSibling()) {
                        short s2 = node.getNodeType();
                        if (s2 != 3 && s2 != 5) continue;
                        this.out.mixed = true;
                        break;
                    }
                }
                this.out.writeNewLine();
                this.out.addIndent(1);
                if (this.isExtending) {
                    this.externalPrintChildNodes(xMLElement);
                } else {
                    this.internalPrintChildNodes(xMLElement);
                }
                this.out.addIndent(-1);
                this.out.writeIndent();
                this.out.mixed = bl3;
            }
            if (bl2) {
                this.out.writeChars("/>");
            } else {
                this.out.writeChars("</");
                if (string2 == null) {
                    this.out.writeChars(xMLElement.getNodeName());
                } else {
                    if (!string2.equals("")) {
                        this.out.writeChars(string2);
                        this.out.write(58);
                    }
                    this.out.writeChars(xMLElement.getNodeLocalName());
                }
                this.out.writeChars(">");
            }
            this.out.writeNewLine();
            this.out.setOutputStyle(n);
            this.prefixCount = n3;
            this.nsVector.setSize(n2);
            this.prefixVector.setSize(n2);
        }
        finally {
            this.schemaLocation = string;
        }
    }

    @Override
    public void printDocumentFragment(XMLDocumentFragment xMLDocumentFragment) throws IOException {
        this.printChildNodes(xMLDocumentFragment);
        this.out.flush();
    }

    @Override
    public void printTextNode(XMLText xMLText) throws IOException {
        xMLText.print(this.out, false);
        this.out.flush();
    }

    @Override
    public void printComment(XMLComment xMLComment) throws IOException {
        xMLComment.print(this.out, false);
        this.out.flush();
    }

    @Override
    public void printCDATASection(XMLCDATA xMLCDATA) throws IOException {
        xMLCDATA.print(this.out, false);
        this.out.flush();
    }

    @Override
    public void printProcessingInstruction(XMLPI xMLPI) throws IOException {
        xMLPI.print(this.out, false);
        this.out.flush();
    }

    @Override
    public void printAttribute(XMLAttr xMLAttr) throws IOException {
        this.internalPrintAttribute(xMLAttr);
        this.out.flush();
    }

    private void internalPrintAttribute(XMLAttr xMLAttr) throws IOException {
        if (!xMLAttr.getSpecified() && !this.printAllAttrs) {
            return;
        }
        String string = null;
        if (!xMLAttr.isNodeFlag(262144)) {
            String string2 = xMLAttr.getNamespace();
            string = string2 == null || string2.equals("") ? null : this.checkConflicts(xMLAttr.getNodePrefix(), string2, false);
        }
        this.out.write(32);
        if (string == null) {
            this.out.writeChars(xMLAttr.getNodeName());
        } else {
            if (!string.equals("")) {
                this.out.writeChars(string);
                this.out.write(58);
            }
            this.out.writeChars(xMLAttr.getNodeLocalName());
        }
        XMLAttr.print1(this.out, xMLAttr.getNodeValue());
    }

    @Override
    public void printEntityReference(XMLEntityReference xMLEntityReference) throws IOException {
        xMLEntityReference.print(this.out, false);
        this.out.flush();
    }

    @Override
    public final void printChildNodes(XMLNode xMLNode) throws IOException {
        if (this.isExtending) {
            this.externalPrintChildNodes(xMLNode);
        } else {
            this.internalPrintChildNodes(xMLNode);
        }
        this.out.flush();
    }

    final void internalPrintChildNodes(XMLNode xMLNode) throws IOException {
        block7: for (XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild(); xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getNextSibling()) {
            switch (xMLNode2.getNodeType()) {
                case 10: {
                    if (!this.xmlDeclaration) continue block7;
                    xMLNode2.print(this.out, false);
                    continue block7;
                }
                case 1: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block7;
                    this.internalPrintElement((XMLElement)xMLNode2, this.printAllAttrs);
                    continue block7;
                }
                case 11: {
                    this.internalPrintChildNodes(xMLNode2);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block7;
                    xMLNode2.print(this.out, false);
                    continue block7;
                }
                case 7: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1 || !this.xmlDeclaration) continue block7;
                    xMLNode2.print(this.out, false);
                    continue block7;
                }
            }
        }
    }

    final void externalPrintChildNodes(XMLNode xMLNode) throws IOException {
        block10: for (XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild(); xMLNode2 != null; xMLNode2 = (XMLNode)xMLNode2.getNextSibling()) {
            switch (xMLNode2.getNodeType()) {
                case 10: {
                    if (!this.xmlDeclaration) continue block10;
                    this.printDoctype((DTD)xMLNode2);
                    continue block10;
                }
                case 1: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printElement((XMLElement)xMLNode2, this.printAllAttrs);
                    continue block10;
                }
                case 11: {
                    this.printDocumentFragment((XMLDocumentFragment)xMLNode2);
                    continue block10;
                }
                case 3: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printTextNode((XMLText)xMLNode2);
                    continue block10;
                }
                case 8: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printComment((XMLComment)xMLNode2);
                    continue block10;
                }
                case 4: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printCDATASection((XMLCDATA)xMLNode2);
                    continue block10;
                }
                case 7: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1 || !this.xmlDeclaration) continue block10;
                    this.printProcessingInstruction((XMLPI)xMLNode2);
                    continue block10;
                }
                case 5: {
                    if (!this.callPrinterFilter(xMLNode2) || this.filter != null && this.filter.acceptNode(xMLNode2) != 1) continue block10;
                    this.printEntityReference((XMLEntityReference)xMLNode2);
                    continue block10;
                }
            }
        }
    }

    private boolean callPrinterFilter(XMLNode xMLNode) {
        if (this.filter == null) {
            return true;
        }
        return (1 << xMLNode.getNodeType() - 1 & this.filter.getWhatToShow()) != 0;
    }

    private void scanNSDecls(XMLElement xMLElement) throws IOException {
        String string;
        for (XMLAttr xMLAttr = (XMLAttr)xMLElement.getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
            if (!xMLAttr.isNodeFlag(262144)) continue;
            string = xMLAttr.getNodePrefix();
            String string2 = xMLAttr.getLocalName();
            if ("xmlns".equals(string)) {
                this.addNsDeclPrinted(string2, xMLAttr.getNodeValue());
                continue;
            }
            this.addNsDeclPrinted("", xMLAttr.getNodeValue());
        }
        if (this.inheritedNS != null && !this.inheritedNS.isEmpty()) {
            Enumeration enumeration = this.inheritedNS.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                String string3 = (String)this.inheritedNS.get(string);
                if (this.nsDeclToPrint.get(string) != null) continue;
                this.addNsDeclPrinted(string, string3);
            }
            this.inheritedNS.clear();
        }
    }

    @Override
    public final void printAttributeNodes(XMLElement xMLElement) throws IOException {
        this.internalPrintAttributeNodes(xMLElement);
        this.out.flush();
    }

    private final void internalPrintAttributeNodes(XMLElement xMLElement) throws IOException {
        for (XMLAttr xMLAttr = (XMLAttr)xMLElement.getFirstAttribute(); xMLAttr != null; xMLAttr = xMLAttr.getNextAttribute()) {
            if (xMLAttr.isNodeFlag(262144)) {
                if ("xmlns".equals(xMLAttr.getNodePrefix())) {
                    this.nsDeclToPrint.remove(xMLAttr.getNodeLocalName());
                } else {
                    this.nsDeclToPrint.remove("");
                }
            }
            if (!this.isExtending) {
                this.internalPrintAttribute(xMLAttr);
                continue;
            }
            this.printAttribute(xMLAttr);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
        this.out.finalFlush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void close(int n) throws IOException {
        this.out.close(n);
    }

    public void printXMLDecl(XMLDocument xMLDocument) throws IOException {
        if (!this.lsSerializer) {
            if (xMLDocument.version != null) {
                XMLDeclPI.printXMLDecl(this.out, xMLDocument.version, xMLDocument.encoding, xMLDocument.standalone);
            }
        } else if (this.xmlDeclaration) {
            if (xMLDocument.version != null) {
                XMLDeclPI.printXMLDecl(this.out, xMLDocument.version, xMLDocument.encoding, xMLDocument.standalone);
            } else {
                XMLDeclPI.printXMLDecl(this.out, "1.0", this.serializerEncoding, xMLDocument.standalone);
            }
        }
        this.out.flush();
    }

    protected String checkConflicts(String string, String string2, boolean bl) throws IOException {
        if (string == null) {
            string = "";
        }
        if ("xml".equals(string)) {
            return null;
        }
        if (!string.equals("") || bl) {
            int n = this.lookupNsDecl(string, string2);
            if (n != 1) {
                if (n == 2) {
                    string = this.resolvePrefix(string2);
                }
                this.addNsDeclPrinted(string, string2);
            }
            if (n == 2) {
                return string;
            }
        } else if (!string2.equals("")) {
            string = this.lookupPrefix(string2);
            if (string == null || string == "" && !bl) {
                string = this.resolvePrefix(string2);
                this.addNsDeclPrinted(string, string2);
            }
            return string;
        }
        return null;
    }

    protected void addNsDeclPrinted(String string, String string2) throws IOException {
        String string3 = (String)this.nsDeclToPrint.get(string);
        if (string3 == null) {
            this.prefixVector.addElement(string);
            this.nsVector.addElement(string2);
            this.nsDeclToPrint.put(string, string2);
        } else if (!string3.equals(string2)) {
            String string4 = XMLDocument.defErr.getMessage3(21018, (String)this.nsDeclToPrint.get(string), string2, string);
            throw new IOException(string4);
        }
    }

    protected int lookupNsDecl(String string, String string2) throws IOException {
        int n = this.prefixVector.size();
        return this.lookupNsDecl(string, string2, n);
    }

    protected int lookupNsDecl(String string, String string2, int n) {
        int n2;
        int n3 = -1;
        for (n2 = n - 1; n2 >= 0; --n2) {
            if (!string.equals(this.prefixVector.elementAt(n2))) continue;
            if (string2.equals(this.nsVector.elementAt(n2))) {
                n3 = 1;
                break;
            }
            n3 = 0;
            break;
        }
        if (n3 == 0 && n2 >= this.prevSize) {
            n3 = 2;
        }
        return n3;
    }

    private String lookupPrefix(String string) {
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml";
        }
        int n = this.prefixVector.size();
        for (int i = n - 1; i >= 0; --i) {
            if (!string.equals(this.nsVector.elementAt(i))) continue;
            return (String)this.prefixVector.elementAt(i);
        }
        return null;
    }

    private String resolvePrefix(String string) throws IOException {
        String string2 = "ns" + this.prefixCount++;
        while (this.lookupNsDecl(string2, string) == 2) {
            string2 = "ns" + this.prefixCount++;
        }
        return string2;
    }

    protected void printNsDecls(XMLElement xMLElement) throws IOException {
        Enumeration enumeration = this.nsDeclToPrint.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)this.nsDeclToPrint.get(string);
            XMLAttr xMLAttr = null;
            XMLDocument xMLDocument = (XMLDocument)xMLElement.getOwnerDocument();
            if (this.lookupNsDecl(string, string2, this.prevSize) == 1) continue;
            xMLAttr = string == null || string.equals("") ? (XMLAttr)xMLDocument.createAttribute("http://www.w3.org/2000/xmlns/", "xmlns", string2) : (XMLAttr)xMLDocument.createAttribute("http://www.w3.org/2000/xmlns/", "xmlns:" + string, string2);
            xMLAttr.setNodeFlag(65536);
            if (!this.isExtending) {
                this.internalPrintAttribute(xMLAttr);
                continue;
            }
            this.printAttribute(xMLAttr);
        }
    }

    private void init() {
        this.prefixVector = new Vector(10);
        this.nsVector = new Vector(10);
        this.nsDeclToPrint = new Hashtable(20);
        this.prefixVector.addElement("");
        this.nsVector.addElement("");
    }
}

