/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.scalable;

import oracle.xml.comp.CXMLReader;
import oracle.xml.scalable.BinaryIndex;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.IntArrayIndex;

class ShortArrayIndex
extends BinaryIndex {
    short[][] index = new short[64][];
    short[][] children = new short[64][];
    int[] length = new int[64];
    boolean[] child = new boolean[64];
    int depth = 0;
    int level = 0;
    static final short EMPTY_FLAG = Short.MIN_VALUE;

    ShortArrayIndex() {
    }

    @Override
    public BinaryIndex enlargeIndex() {
        IntArrayIndex intArrayIndex = new IntArrayIndex();
        intArrayIndex.depth = this.depth;
        intArrayIndex.level = this.level;
        for (int i = 0; i < 64 && this.index[i] != null; ++i) {
            short[] sArray = this.index[i];
            short[] sArray2 = this.children[i];
            int n = this.length[i];
            int[] nArray = new int[sArray.length];
            int[] nArray2 = new int[sArray.length];
            for (int j = 0; j < n; ++j) {
                nArray[j] = sArray[j];
                int n2 = sArray2[j];
                if (n2 < 0) {
                    n2 = n2 & Short.MAX_VALUE | Integer.MIN_VALUE;
                }
                nArray2[j] = n2;
            }
            intArrayIndex.index[i] = nArray;
            intArrayIndex.children[i] = nArray2;
        }
        System.arraycopy(this.child, 0, intArrayIndex.child, 0, 64);
        System.arraycopy(this.length, 0, intArrayIndex.length, 0, 64);
        return intArrayIndex;
    }

    @Override
    public boolean startElement(long l) {
        if (l >= 32767L) {
            return false;
        }
        this.write(l, this.level, false);
        this.child[this.level] = false;
        if (this.level > 0 && !this.child[this.level - 1]) {
            int n = this.length[this.level];
            this.write(n, this.level - 1, true);
            this.child[this.level - 1] = true;
        }
        int n = this.level++;
        this.length[n] = this.length[n] + 1;
        return true;
    }

    @Override
    public void endElement() {
        int n = this.length[this.level] | Short.MIN_VALUE;
        if (n == 0) {
            n = -1;
        }
        --this.level;
        if (this.level >= 0 && !this.child[this.level]) {
            this.write(n, this.level, true);
            this.child[this.level] = true;
        }
    }

    @Override
    public final void buildIndex(InfosetReader infosetReader) throws Exception {
        this.level = 0;
        ((CXMLReader)infosetReader).init();
        this.index[0] = new short[1];
        this.children[0] = new short[1];
        while (infosetReader.hasNext()) {
            infosetReader.next();
            int n = infosetReader.getEventType();
            switch (n) {
                case 1: {
                    int n2;
                    this.write(infosetReader.offsetToLong(), this.level, false);
                    this.child[this.level] = false;
                    if (this.level > 0 && !this.child[this.level - 1]) {
                        n2 = this.length[this.level];
                        this.write(n2, this.level - 1, true);
                        this.child[this.level - 1] = true;
                    }
                    int n3 = this.level++;
                    this.length[n3] = this.length[n3] + 1;
                    break;
                }
                case 2: {
                    int n2 = this.length[this.level] | Short.MIN_VALUE;
                    if (n2 == 0) {
                        n2 = -1;
                    }
                    --this.level;
                    if (this.level < 0 || this.child[this.level]) break;
                    this.write(n2, this.level, true);
                    this.child[this.level] = true;
                    break;
                }
            }
        }
        long l = 0L;
        for (int i = 1; i < 64; ++i) {
            short[] sArray;
            short[] sArray2 = this.index[i];
            if (sArray2 == null) {
                this.depth = i;
                break;
            }
            int n = this.length[i];
            l += (long)this.length[i];
            if (sArray2.length - n > 1024) {
                sArray = new short[n];
                System.arraycopy(sArray2, 0, sArray, 0, n);
                this.index[i] = sArray;
            }
            if ((sArray2 = this.children[i]) == null || sArray2.length - n <= 1024) continue;
            sArray = new short[n];
            System.arraycopy(sArray2, 0, sArray, 0, n);
            this.children[i] = sArray;
        }
    }

    private void write(long l, int n, boolean bl) {
        short[][] sArray = bl ? this.children : this.index;
        short[] sArray2 = sArray[n];
        if (sArray2 == null) {
            sArray2 = n == 0 ? new short[1] : new short[1024];
            sArray[n] = sArray2;
            if (!bl) {
                ++this.depth;
            }
        }
        int n2 = this.length[n];
        if (bl) {
            --n2;
        }
        if (n2 >= sArray2.length) {
            short[] sArray3 = sArray2;
            sArray2 = new short[n2 * 2];
            System.arraycopy(sArray3, 0, sArray2, 0, sArray3.length);
            sArray[n] = sArray2;
        }
        sArray2[n2] = (short)l;
    }

    @Override
    long getLocator(int n, int n2) {
        return this.index[n][n2];
    }

    @Override
    int getChildStart(int n, int n2) {
        short s2 = this.children[n][n2];
        if (s2 < 0) {
            return -1;
        }
        return s2 & 0xFFFF;
    }

    @Override
    int getChildEnd(int n, int n2) {
        if (++n2 >= this.length[n]) {
            return this.length[n + 1];
        }
        int n3 = this.children[n][n2] & Short.MAX_VALUE;
        return n3;
    }

    @Override
    int getIndexDepth() {
        return this.depth;
    }
}

