/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.security;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.Securable;

public class JCEEncryptor
implements Securable {
    private static final String DES_ECB = "DES/ECB/PKCS5Padding";
    private final Cipher decryptCipherDES_ECB = Cipher.getInstance("DES/ECB/PKCS5Padding");
    private static final String AES_ECB = "AES/ECB/PKCS5Padding";
    private final Cipher decryptCipherAES_ECB;
    private static final String AES_CBC = "AES/CBC/PKCS5Padding";
    private final Cipher encryptCipherAES_CBC;
    private final Cipher decryptCipherAES_CBC;

    public JCEEncryptor() throws Exception {
        this.decryptCipherDES_ECB.init(2, Synergizer.getDESMultitasker());
        this.decryptCipherAES_ECB = Cipher.getInstance(AES_ECB);
        this.decryptCipherAES_ECB.init(2, Synergizer.getAESMultitasker());
        SecretKey sk = Synergizer.getAESCBCMultitasker();
        IvParameterSpec iv = Synergizer.getIvSpec();
        this.encryptCipherAES_CBC = Cipher.getInstance(AES_CBC);
        this.encryptCipherAES_CBC.init(1, (Key)sk, iv);
        this.decryptCipherAES_CBC = Cipher.getInstance(AES_CBC);
        this.decryptCipherAES_CBC.init(2, (Key)sk, iv);
    }

    @Override
    public synchronized String encryptPassword(String password) {
        try {
            return Helper.buildHexStringFromBytes(this.encryptCipherAES_CBC.doFinal(password.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw ValidationException.errorEncryptingPassword(e);
        }
    }

    @Override
    public synchronized String decryptPassword(String encryptedPswd) {
        String password;
        block35: {
            if (encryptedPswd == null) {
                return null;
            }
            password = null;
            byte[] bytePassword = new byte[]{};
            try {
                bytePassword = Helper.buildBytesFromHexString(encryptedPswd);
                password = new String(this.decryptCipherAES_CBC.doFinal(bytePassword), "UTF-8");
            }
            catch (IllegalBlockSizeException | ConversionException ce) {
                password = encryptedPswd;
            }
            catch (Exception e) {
                ObjectInputStream oisAes = null;
                try {
                    try {
                        oisAes = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(bytePassword), this.decryptCipherAES_ECB));
                        password = (String)oisAes.readObject();
                    }
                    catch (Exception f) {
                        block34: {
                            ObjectInputStream oisDes = null;
                            try {
                                oisDes = new ObjectInputStream(new CipherInputStream(new ByteArrayInputStream(bytePassword), this.decryptCipherDES_ECB));
                                password = (String)oisDes.readObject();
                            }
                            catch (ArrayIndexOutOfBoundsException g2) {
                                password = encryptedPswd;
                                if (oisDes != null) {
                                    try {
                                        oisDes.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block34;
                            }
                            catch (Exception h2) {
                                try {
                                    if (h2.getCause() instanceof IllegalBlockSizeException) {
                                        password = encryptedPswd;
                                        break block34;
                                    }
                                    throw ValidationException.errorDecryptingPassword(h2);
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    if (oisDes != null) {
                                        try {
                                            oisDes.close();
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                            }
                            if (oisDes == null) break block34;
                            try {
                                oisDes.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (oisAes == null) break block35;
                        try {
                            oisAes.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (oisAes != null) {
                        try {
                            oisAes.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        return password;
    }

    private static class Synergizer {
        private Synergizer() {
        }

        private static SecretKey getDESMultitasker() throws Exception {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("DES");
            return factory.generateSecret(new DESKeySpec(Helper.buildBytesFromHexString("E60B80C7AEC78038")));
        }

        private static SecretKey getAESMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("3E7CFEF156E712906E1F603B59463C67"), "AES");
        }

        private static SecretKey getAESCBCMultitasker() throws Exception {
            return new SecretKeySpec(Helper.buildBytesFromHexString("2DB7354A48F1CA7B48ACA247540FC923"), "AES");
        }

        private static IvParameterSpec getIvSpec() {
            byte[] b = new byte[]{-26, 124, -99, 32, -37, -58, -93, 100, 126, -55, -21, 48, -86, 97, 12, 113};
            return new IvParameterSpec(b);
        }
    }
}

