/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.rs;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.RollbackException;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.dynamic.DynamicEntity;
import org.eclipse.persistence.dynamic.DynamicType;
import org.eclipse.persistence.eis.mappings.EISCompositeCollectionMapping;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.jaxb.SessionEventListener;
import org.eclipse.persistence.internal.jpa.EJBQueryImpl;
import org.eclipse.persistence.internal.jpa.EntityManagerFactoryImpl;
import org.eclipse.persistence.internal.jpa.weaving.RestAdapterClassWriter;
import org.eclipse.persistence.internal.jpa.weaving.RestCollectionAdapterClassWriter;
import org.eclipse.persistence.internal.jpa.weaving.RestReferenceAdapterV2ClassWriter;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredFields;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.internal.weaving.RelationshipInfo;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBMarshaller;
import org.eclipse.persistence.jaxb.JAXBUnmarshaller;
import org.eclipse.persistence.jaxb.ObjectGraph;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContext;
import org.eclipse.persistence.jaxb.dynamic.DynamicJAXBContextFactory;
import org.eclipse.persistence.jaxb.metadata.MetadataSource;
import org.eclipse.persistence.jpa.JpaHelper;
import org.eclipse.persistence.jpa.PersistenceProvider;
import org.eclipse.persistence.jpa.dynamic.JPADynamicHelper;
import org.eclipse.persistence.jpa.rs.annotations.RestPageableQueries;
import org.eclipse.persistence.jpa.rs.annotations.RestPageableQuery;
import org.eclipse.persistence.jpa.rs.exceptions.JPARSException;
import org.eclipse.persistence.jpa.rs.features.FeatureSet;
import org.eclipse.persistence.jpa.rs.features.ServiceVersion;
import org.eclipse.persistence.jpa.rs.features.fieldsfiltering.FieldsFilter;
import org.eclipse.persistence.jpa.rs.util.CollectionWrapperBuilder;
import org.eclipse.persistence.jpa.rs.util.IdHelper;
import org.eclipse.persistence.jpa.rs.util.JPARSLogger;
import org.eclipse.persistence.jpa.rs.util.JTATransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.ObjectGraphBuilder;
import org.eclipse.persistence.jpa.rs.util.ResourceLocalTransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.TransactionWrapper;
import org.eclipse.persistence.jpa.rs.util.list.ReadAllQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultCollection;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultList;
import org.eclipse.persistence.jpa.rs.util.list.ReportQueryResultListItem;
import org.eclipse.persistence.jpa.rs.util.list.SingleResultQueryList;
import org.eclipse.persistence.jpa.rs.util.xmladapters.LinkAdapter;
import org.eclipse.persistence.jpa.rs.util.xmladapters.RelationshipLinkAdapter;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLInverseReferenceMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.Session;
import org.eclipse.persistence.sessions.UnitOfWork;

public class PersistenceContext {
    public static final String JPARS_CONTEXT = "eclipselink.jpars.context";
    public static final String CLASS_NAME = PersistenceContext.class.getName();
    public static final String SESSION_VERSION_PROPERTY = "jaxb.context.version";
    protected List<XmlAdapter> adapters = null;
    protected String name = null;
    protected EntityManagerFactory emf;
    protected JAXBContext jaxbContext = null;
    protected URI baseURI = null;
    private SessionLog sessionLog = null;
    protected TransactionWrapper transaction = null;
    private Boolean weavingEnabled = null;
    private ServiceVersion version = ServiceVersion.NO_VERSION;
    private CollectionWrapperBuilder collectionWrapperBuilder;
    private Map<String, RestPageableQuery> pageableQueries;

    protected PersistenceContext() {
    }

    public PersistenceContext(String emfName, EntityManagerFactoryImpl emf, URI defaultURI) {
        this.init(emfName, emf, defaultURI, ServiceVersion.NO_VERSION);
    }

    public PersistenceContext(String emfName, EntityManagerFactoryImpl emf, URI defaultURI, ServiceVersion version) {
        this.init(emfName, emf, defaultURI, version);
    }

    private void init(String emfName, EntityManagerFactoryImpl emf, URI defaultURI, ServiceVersion version) {
        this.emf = emf;
        this.name = emfName;
        this.baseURI = defaultURI;
        this.sessionLog = emf.getServerSession().getSessionLog();
        this.version = version != null ? version : ServiceVersion.NO_VERSION;
        this.transaction = this.getServerSession().hasExternalTransactionController() ? new JTATransactionWrapper() : new ResourceLocalTransactionWrapper();
        try {
            this.jaxbContext = this.createDynamicJAXBContext(emf.getDatabaseSession());
        }
        catch (JAXBException jaxbe) {
            JPARSLogger.exception(this.getSessionLog(), "exception_creating_jaxb_context", new Object[]{emfName, jaxbe.toString()}, jaxbe);
            emf.close();
        }
        catch (IOException e) {
            JPARSLogger.exception(this.getSessionLog(), "exception_creating_jaxb_context", new Object[]{emfName, e.toString()}, e);
            emf.close();
        }
    }

    public boolean isWeavingEnabled() {
        if (this.weavingEnabled == null) {
            this.weavingEnabled = this.getWeavingProperty();
        }
        return this.weavingEnabled;
    }

    public String getVersion() {
        return this.version.getCode();
    }

    public ServiceVersion getServiceVersion() {
        return this.version;
    }

    protected void addDynamicXMLMetadataSources(List<Object> metadataSources, AbstractSession session) {
        HashSet<String> packages = new HashSet<String>();
        for (Class descriptorClass : session.getDescriptors().keySet()) {
            String packageName = "";
            int lastDotIndex = descriptorClass.getName().lastIndexOf(46);
            if (lastDotIndex > 0) {
                packageName = descriptorClass.getName().substring(0, lastDotIndex);
            }
            if (packages.contains(packageName)) continue;
            packages.add(packageName);
        }
        for (String packageName : packages) {
            metadataSources.add(this.getSupportedFeatureSet().getDynamicMetadataSource(session, packageName));
        }
    }

    public void create(Map<String, String> tenantId, Object entity) throws Exception {
        try (EntityManager em = this.getEmf().createEntityManager(tenantId);){
            try {
                this.transaction.beginTransaction(em);
                em.persist(entity);
                this.transaction.commitTransaction(em);
            }
            catch (RollbackException ex) {
                throw ex;
            }
            catch (Exception ex) {
                this.transaction.rollbackTransaction(em);
                throw ex;
            }
        }
    }

    protected JAXBContext createDynamicJAXBContext(AbstractSession session) throws JAXBException, IOException {
        ServiceVersion cachedContextVersion = (ServiceVersion)((Object)session.getProperty(SESSION_VERSION_PROPERTY));
        JAXBContext cachedContext = (JAXBContext)((Object)session.getProperty(JAXBContext.class.getName()));
        if (cachedContext != null && cachedContextVersion != null && cachedContextVersion == this.version) {
            return cachedContext;
        }
        Map<String, Object> properties = this.createJAXBProperties(session);
        ClassLoader cl = session.getDatasourcePlatform().getConversionManager().getLoader();
        DynamicJAXBContext jaxbContext = DynamicJAXBContextFactory.createContextFromOXM(cl, properties);
        session.setProperty(SESSION_VERSION_PROPERTY, (Object)this.version);
        session.setProperty(JAXBContext.class.getName(), (Object)jaxbContext);
        return jaxbContext;
    }

    protected EntityManagerFactoryImpl createEntityManagerFactory(PersistenceUnitInfo info, Map<String, ?> properties) {
        PersistenceProvider provider = new PersistenceProvider();
        EntityManagerFactory emf = provider.createContainerEntityManagerFactory(info, properties);
        return (EntityManagerFactoryImpl)emf;
    }

    protected EntityManager createEntityManager(String tenantId) {
        return this.getEmf().createEntityManager();
    }

    protected Map<String, Object> createJAXBProperties(AbstractSession session) throws IOException {
        Object passedOXMLocations;
        HashMap<String, Object> properties = new HashMap<String, Object>(1);
        ArrayList<Object> metadataLocations = new ArrayList<Object>();
        this.addDynamicXMLMetadataSources(metadataLocations, session);
        String oxmLocation = (String)this.emf.getProperties().get("eclipselink.jpa-rs.oxm");
        if (oxmLocation != null) {
            metadataLocations.add(oxmLocation);
        }
        if ((passedOXMLocations = this.emf.getProperties().get("eclipselink.oxm.metadata-source")) != null) {
            if (passedOXMLocations instanceof Collection) {
                metadataLocations.addAll((Collection)passedOXMLocations);
            } else {
                metadataLocations.add(passedOXMLocations);
            }
        }
        for (MetadataSource metadataSource : this.getSupportedFeatureSet().getMetadataSources()) {
            metadataLocations.add(metadataSource);
        }
        properties.put("eclipselink.oxm.metadata-source", metadataLocations);
        SessionEventListener sessionEventListener = this.getSupportedFeatureSet().getSessionEventListener(session);
        if (sessionEventListener != null) {
            properties.put("eclipselink.session-event-listener", sessionEventListener);
        }
        return properties;
    }

    public void delete(Map<String, String> tenantId, String type, Object id) {
        try (EntityManager em = this.getEmf().createEntityManager(tenantId);){
            try {
                this.transaction.beginTransaction(em);
                Object entity = em.find(this.getClass(type), id);
                if (entity != null) {
                    em.remove(entity);
                }
                this.transaction.commitTransaction(em);
            }
            catch (RollbackException ex) {
                throw JPARSException.exceptionOccurred(ex);
            }
            catch (Exception ex) {
                this.transaction.rollbackTransaction(em);
                throw JPARSException.exceptionOccurred(ex);
            }
        }
    }

    public boolean doesExist(Map<String, String> tenantId, Object entity) {
        DatabaseSession session = JpaHelper.getDatabaseSession(this.getEmf());
        return session.doesObjectExist(entity);
    }

    protected void finalize() throws Throwable {
        this.emf.close();
        super.finalize();
    }

    public Object find(String entityName, Object id) {
        return this.find(null, entityName, id);
    }

    public Object find(Map<String, String> tenantId, String entityName, Object id) {
        return this.find(tenantId, entityName, id, null);
    }

    public Object find(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties) {
        try (EntityManager em = this.getEmf().createEntityManager(tenantId);){
            Object obj = em.find(this.getClass(entityName), id, properties);
            return obj;
        }
    }

    /*
     * Loose catch block
     */
    public Object updateOrAddAttribute(Map<String, String> tenantId, String entityName, Object id, Map<String, Object> properties, String attribute, Object attributeValue, String partner) {
        try (EntityManager em = this.getEmf().createEntityManager(tenantId);){
            Object object;
            ClassDescriptor descriptor = this.getServerSession().getClassDescriptor(this.getClass(entityName));
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (mapping == null) {
                return null;
            }
            if (mapping.isObjectReferenceMapping() || mapping.isCollectionMapping()) {
                DatabaseMapping partnerMapping;
                block15: {
                    ClassDescriptor referenceDescriptor;
                    partnerMapping = null;
                    if (partner != null && (partnerMapping = (referenceDescriptor = mapping.getReferenceDescriptor()).getMappingForAttributeName(partner)) == null) {
                        return null;
                    }
                    this.transaction.beginTransaction(em);
                    object = em.find(this.getClass(entityName), id, properties);
                    if (object != null) break block15;
                    return null;
                }
                try {
                    attributeValue = em.merge(attributeValue);
                    this.setMappingValueInObject(object, attributeValue, mapping, partnerMapping);
                    this.transaction.commitTransaction(em);
                }
                catch (RollbackException e) {
                    JPARSLogger.exception(this.getSessionLog(), "exception_while_updating_attribute", new Object[]{entityName, this.getName()}, e);
                    em.close();
                    return null;
                }
                catch (Exception e) {
                    JPARSLogger.exception(this.getSessionLog(), "exception_while_updating_attribute", new Object[]{entityName, this.getName()}, e);
                    this.transaction.rollbackTransaction(em);
                    em.close();
                    return null;
                }
            }
            return null;
            Object obj = object;
            return obj;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public Object removeAttribute(Map<String, String> tenantId, String entityName, Object id, String attribute, String listItemId, Object entity, String partner) {
        String fieldName = null;
        try (EntityManager em = this.getEmf().createEntityManager(tenantId);){
            Class<?> clazz = this.getClass(entityName);
            ClassDescriptor descriptor = this.getServerSession().getClassDescriptor(clazz);
            DatabaseMapping mapping = descriptor.getMappingForAttributeName(attribute);
            if (mapping == null) {
                return null;
            }
            if (mapping.isObjectReferenceMapping() || mapping.isCollectionMapping()) {
                DatabaseMapping partnerMapping = null;
                Object originalAttributeValue = null;
                ClassDescriptor referenceDescriptor = mapping.getReferenceDescriptor();
                if (partner != null && (partnerMapping = referenceDescriptor.getMappingForAttributeName(partner)) == null) {
                    return null;
                }
                Field[] fields = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedGetDeclaredFields(clazz)) : PrivilegedAccessHelper.getDeclaredFields(clazz);
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    fieldName = field.getName();
                    if (fieldName.equals(attribute)) {
                        try {
                            Object attributeValue;
                            originalAttributeValue = attributeValue = this.getAttribute(entity, attribute);
                            if (!(attributeValue instanceof Collection)) break;
                            if (listItemId == null) {
                                ((Collection)attributeValue).clear();
                                break;
                            }
                            Object realListItemId = IdHelper.buildId(this, referenceDescriptor.getAlias(), listItemId);
                            Object member = this.find(referenceDescriptor.getAlias(), realListItemId);
                            ((Collection)attributeValue).remove(member);
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            em.close();
                            return null;
                        }
                    }
                    ++n2;
                }
                this.transaction.beginTransaction(em);
                entity = em.merge(entity);
                this.removeMappingValueFromObject(entity, originalAttributeValue, mapping, partnerMapping);
                this.transaction.commitTransaction(em);
                Object object = entity;
                return object;
            }
            return null;
        }
    }

    private Object getAttribute(Object entity, String propertyName) {
        try {
            PropertyDescriptor[] props;
            BeanInfo info = Introspector.getBeanInfo(entity.getClass(), Object.class);
            PropertyDescriptor[] propertyDescriptorArray = props = info.getPropertyDescriptors();
            int n = props.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String name = pd.getName();
                if (propertyName.equals(name)) {
                    Method getter = pd.getReadMethod();
                    Object value = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedMethodInvoker(getter, entity)) : PrivilegedAccessHelper.invokeMethod(getter, entity);
                    return value;
                }
                ++n2;
            }
        }
        catch (IntrospectionException | IllegalAccessException | InvocationTargetException | PrivilegedActionException ex) {
            return null;
        }
        return null;
    }

    protected void removeMappingValueFromObject(Object object, Object attributeValue, DatabaseMapping mapping, DatabaseMapping partner) {
        boolean removed;
        if (mapping.isObjectReferenceMapping()) {
            Object currentValue = mapping.getRealAttributeValueFromObject(object, (AbstractSession)((Object)this.getServerSession()));
            if (currentValue.equals(attributeValue)) {
                ((ObjectReferenceMapping)mapping).getIndirectionPolicy().setRealAttributeValueInObject(object, null, true);
                if (partner != null) {
                    this.removeMappingValueFromObject(attributeValue, object, partner, null);
                }
            }
        } else if (mapping.isCollectionMapping() && (removed = ((Collection)mapping.getRealAttributeValueFromObject(object, (AbstractSession)((Object)this.getServerSession()))).remove(attributeValue)) && partner != null) {
            this.removeMappingValueFromObject(attributeValue, object, partner, null);
        }
    }

    public URI getBaseURI() {
        return this.baseURI;
    }

    public Class<?> getClass(String entityName) {
        ClassDescriptor descriptor = this.getDescriptor(entityName);
        if (descriptor == null) {
            return null;
        }
        return descriptor.getJavaClass();
    }

    public DatabaseSession getServerSession() {
        return JpaHelper.getDatabaseSession(this.emf);
    }

    public AbstractSession getClientSession(EntityManager em) {
        UnitOfWork uow = JpaHelper.getEntityManager(em).getUnitOfWork();
        return (AbstractSession)((Object)uow);
    }

    public ClassDescriptor getDescriptor(String entityName) {
        DatabaseSession session = this.getServerSession();
        ClassDescriptor descriptor = session.getDescriptorForAlias(entityName);
        if (descriptor == null) {
            for (Object ajaxBSession : this.getJAXBContext().getXMLContext().getSessions()) {
                descriptor = ((Session)ajaxBSession).getClassDescriptorForAlias(entityName);
                if (descriptor != null) break;
            }
        }
        return descriptor;
    }

    public ClassDescriptor getDescriptorForClass(Class clazz) {
        DatabaseSession session = this.getServerSession();
        ClassDescriptor descriptor = session.getDescriptor(clazz);
        if (descriptor == null) {
            return this.getJAXBDescriptorForClass(clazz);
        }
        return descriptor;
    }

    public ClassDescriptor getJAXBDescriptorForClass(Class clazz) {
        ClassDescriptor descriptor = null;
        for (Object ajaxBSession : this.getJAXBContext().getXMLContext().getSessions()) {
            descriptor = ((Session)ajaxBSession).getClassDescriptor(clazz);
            if (descriptor != null) break;
        }
        return descriptor;
    }

    public EntityManagerFactory getEmf() {
        return this.emf;
    }

    public JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    public String getName() {
        return this.name;
    }

    public SessionLog getSessionLog() {
        return this.sessionLog;
    }

    public Object merge(Map<String, String> tenantId, Object entity) {
        try (EntityManager em = this.getEmf().createEntityManager(tenantId);){
            ArrayList mergedEntity;
            this.transaction.beginTransaction(em);
            if (entity instanceof List) {
                ArrayList mergeList = new ArrayList();
                for (Object o : (List)entity) {
                    mergeList.add(em.merge(o));
                }
                mergedEntity = mergeList;
            } else {
                mergedEntity = em.merge(entity);
            }
            this.transaction.commitTransaction(em);
            ArrayList arrayList = mergedEntity;
            return arrayList;
        }
    }

    public DynamicEntity newEntity(String type) {
        return this.newEntity(null, type);
    }

    public DynamicEntity newEntity(Map<String, String> tenantId, String type) {
        DynamicEntity entity;
        JPADynamicHelper helper = new JPADynamicHelper(this.getEmf());
        try {
            entity = helper.newDynamicEntity(type);
        }
        catch (IllegalArgumentException e) {
            DynamicType jaxbType;
            ClassDescriptor descriptor = this.getDescriptor(type);
            if (descriptor != null && (jaxbType = (DynamicType)descriptor.getProperty("ENTITY_TYPE")) != null) {
                return jaxbType.newDynamicEntity();
            }
            JPARSLogger.exception(this.getSessionLog(), "exception_thrown_while_creating_dynamic_entity", new Object[]{type}, e);
            throw e;
        }
        return entity;
    }

    public int queryExecuteUpdate(Map<String, String> tenantId, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        try (EntityManager em = this.getEmf().createEntityManager(tenantId);){
            Query query = this.constructQuery(em, name, parameters, hints);
            this.transaction.beginTransaction(em);
            int result = query.executeUpdate();
            this.transaction.commitTransaction(em);
            int n = result;
            return n;
        }
    }

    public List queryMultipleResults(Map<String, String> tenantId, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        try (EntityManager em = this.getEmf().createEntityManager(tenantId);){
            Query query = this.constructQuery(em, name, parameters, hints);
            List list = query.getResultList();
            return list;
        }
    }

    protected Query constructQuery(EntityManager em, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        Query query = em.createNamedQuery(name);
        DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
        if (parameters != null) {
            for (Map.Entry<?, ?> entry : parameters.entrySet()) {
                String key = (String)entry.getKey();
                Class parameterClass = null;
                int index = dbQuery.getArguments().indexOf(key);
                if (index >= 0) {
                    parameterClass = dbQuery.getArgumentTypes().get(index);
                }
                Object parameter = entry.getValue();
                if (parameterClass != null) {
                    parameter = ConversionManager.getDefaultManager().convertObject(parameter, parameterClass);
                }
                query.setParameter(key, parameter);
            }
        }
        if (hints != null) {
            for (Map.Entry<String, ?> entry : hints.entrySet()) {
                query.setHint(entry.getKey(), entry.getValue());
            }
        }
        return query;
    }

    public Query buildQuery(Map<String, String> tenantId, String name, Map<?, ?> parameters, Map<String, ?> hints) {
        EntityManager em = this.getEmf().createEntityManager(tenantId);
        Query query = em.createNamedQuery(name);
        DatabaseQuery dbQuery = ((EJBQueryImpl)query).getDatabaseQuery();
        if (parameters != null) {
            for (Map.Entry<?, ?> entry : parameters.entrySet()) {
                String key = (String)entry.getKey();
                Class parameterClass = null;
                int index = dbQuery.getArguments().indexOf(key);
                if (index >= 0) {
                    parameterClass = dbQuery.getArgumentTypes().get(index);
                }
                Object parameter = entry.getValue();
                if (parameterClass != null) {
                    parameter = ConversionManager.getDefaultManager().convertObject(parameter, parameterClass);
                }
                query.setParameter(key, parameter);
            }
        }
        if (hints != null) {
            for (Map.Entry<String, ?> entry : hints.entrySet()) {
                query.setHint(entry.getKey(), entry.getValue());
            }
        }
        return query;
    }

    protected void setMappingValueInObject(Object object, Object attributeValue, DatabaseMapping mapping, DatabaseMapping partner) {
        if (mapping.isObjectReferenceMapping()) {
            ((ObjectReferenceMapping)mapping).getIndirectionPolicy().setRealAttributeValueInObject(object, attributeValue, true);
            if (partner != null) {
                this.setMappingValueInObject(attributeValue, object, partner, null);
            }
        } else if (mapping.isCollectionMapping()) {
            ((Collection)mapping.getAttributeValueFromObject(object)).add(attributeValue);
            if (partner != null) {
                this.setMappingValueInObject(attributeValue, object, partner, null);
            }
        }
    }

    public void stop() {
        if (this.emf != null && this.emf.isOpen()) {
            this.emf.close();
        }
        this.emf = null;
        this.jaxbContext = null;
    }

    public String toString() {
        return "PersistenceContext(name:" + this.getName() + ", version:" + this.getVersion() + ", identityHashCode:" + System.identityHashCode(this) + ")";
    }

    public Object unmarshalEntity(String type, MediaType acceptedMediaType, InputStream in) throws JAXBException {
        if (JPARSLogger.isLoggableFinest(this.getSessionLog())) {
            in = in.markSupported() ? in : new BufferedInputStream(in);
            in.mark(0x3200000);
            JPARSLogger.entering(this.getSessionLog(), CLASS_NAME, "unmarshalEntity", in);
        }
        Object unmarshalled = this.unmarshal(this.getClass(type), acceptedMediaType, in);
        JPARSLogger.exiting(this.getSessionLog(), CLASS_NAME, "unmarshalEntity", new Object[]{unmarshalled.getClass().getName(), unmarshalled});
        return unmarshalled;
    }

    public Object unmarshal(Class type, MediaType acceptedMediaType, InputStream in) throws JAXBException {
        JAXBUnmarshaller unmarshaller = this.getJAXBContext().createUnmarshaller();
        unmarshaller.setProperty("eclipselink.json.include-root", Boolean.FALSE);
        unmarshaller.setProperty("eclipselink.media-type", acceptedMediaType.toString());
        unmarshaller.setAdapter(new LinkAdapter(this.getBaseURI().toString(), this));
        unmarshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent event) {
                return event.getSeverity() == 0;
            }
        });
        for (XmlAdapter adapter : this.getAdapters()) {
            unmarshaller.setAdapter(adapter);
        }
        if (acceptedMediaType == MediaType.APPLICATION_JSON_TYPE) {
            JAXBElement element = unmarshaller.unmarshal(new StreamSource(in), type);
            if (element.getValue() instanceof List) {
                for (Object object : (List)element.getValue()) {
                    this.wrap(object);
                }
                return element.getValue();
            }
            this.wrap(element.getValue());
            return element.getValue();
        }
        Object domainObject = unmarshaller.unmarshal(new StreamSource(in));
        if (domainObject instanceof List) {
            for (Object object : (List)domainObject) {
                this.wrap(object);
            }
            return domainObject;
        }
        this.wrap(domainObject);
        return domainObject;
    }

    protected Object wrap(Object entity) {
        if (entity != null && PersistenceWeavedRest.class.isAssignableFrom(entity.getClass())) {
            if (!this.doesExist(null, entity)) {
                return entity;
            }
            ClassDescriptor descriptor = this.getJAXBDescriptorForClass(entity.getClass());
            if (entity instanceof FetchGroupTracker) {
                FetchGroup fetchGroup = new FetchGroup();
                for (DatabaseMapping mapping : descriptor.getMappings()) {
                    if (mapping instanceof XMLInverseReferenceMapping) continue;
                    fetchGroup.addAttribute(mapping.getAttributeName());
                }
                new FetchGroupManager().setObjectFetchGroup(entity, fetchGroup, null);
                ((FetchGroupTracker)entity)._persistence_setSession(JpaHelper.getDatabaseSession(this.getEmf()));
            } else if (descriptor.hasRelationships()) {
                for (DatabaseMapping mapping : descriptor.getMappings()) {
                    if (!(mapping instanceof XMLInverseReferenceMapping)) continue;
                    JPARSLogger.error(this.getSessionLog(), "weaving_required_for_relationships", new Object[0]);
                    throw JPARSException.invalidConfiguration();
                }
            }
        }
        return entity;
    }

    public void marshallEntity(Object object, MediaType mediaType, OutputStream output) throws JAXBException {
        JPARSLogger.entering(this.getSessionLog(), CLASS_NAME, "marshallEntity", new Object[]{object, mediaType});
        this.marshall(object, mediaType, output, true);
        JPARSLogger.exiting(this.getSessionLog(), CLASS_NAME, "marshallEntity", this, object, mediaType);
    }

    public void marshallEntity(Object object, FieldsFilter filter, MediaType mediaType, OutputStream output) throws JAXBException {
        JPARSLogger.entering(this.getSessionLog(), CLASS_NAME, "marshallEntity", new Object[]{object, filter, mediaType});
        this.marshall(object, mediaType, output, true, filter);
        JPARSLogger.exiting(this.getSessionLog(), CLASS_NAME, "marshallEntity", this, object, mediaType);
    }

    public void marshall(Object object, MediaType mediaType, OutputStream output, boolean sendRelationships) throws JAXBException {
        this.marshall(object, mediaType, output, sendRelationships, null);
    }

    public void marshall(Object object, MediaType mediaType, OutputStream output, boolean sendRelationships, FieldsFilter fieldsFilter) throws JAXBException {
        if (this.version.compareTo(ServiceVersion.VERSION_2_0) < 0 && sendRelationships) {
            this.preMarshallEntity(object);
        }
        JAXBMarshaller marshaller = this.getJAXBContext().createMarshaller();
        marshaller.setProperty("eclipselink.media-type", mediaType.toString());
        marshaller.setProperty("eclipselink.json.include-root", false);
        marshaller.setProperty("eclipselink.json.reduce-any-arrays", true);
        marshaller.setProperty("eclipselink.json.wrapper-as-array-name", true);
        marshaller.setAdapter(new LinkAdapter(this.getBaseURI().toString(), this));
        marshaller.setAdapter(new RelationshipLinkAdapter(this.getBaseURI().toString(), this));
        for (XmlAdapter adapter : this.getAdapters()) {
            marshaller.setAdapter(adapter);
        }
        if (this.version.compareTo(ServiceVersion.VERSION_2_0) >= 0) {
            this.getCollectionWrapperBuilder().wrapCollections(object);
            ObjectGraphBuilder objectGraphBuilder = new ObjectGraphBuilder(this);
            ObjectGraph objectGraph = objectGraphBuilder.createObjectGraph(object, fieldsFilter);
            if (objectGraph != null) {
                marshaller.setProperty("eclipselink.object-graph", objectGraph);
            }
        }
        if (mediaType == MediaType.APPLICATION_XML_TYPE && object instanceof List) {
            marshaller.setProperty("jaxb.fragment", true);
            XMLOutputFactory outputFactory = XMLOutputFactory.newFactory();
            try {
                XMLStreamWriter writer = outputFactory.createXMLStreamWriter(output);
                writer.writeStartDocument();
                writer.writeStartElement("List");
                for (Object o : (List)object) {
                    marshaller.marshal(o, writer);
                }
                writer.writeEndDocument();
                writer.flush();
                this.postMarshallEntity(object);
            }
            catch (Exception ex) {
                throw JPARSException.exceptionOccurred(ex);
            }
        } else {
            marshaller.marshal(object, output);
            if (this.version.compareTo(ServiceVersion.VERSION_2_0) < 0) {
                this.postMarshallEntity(object);
            }
        }
    }

    protected void preMarshallEntity(Object object) {
        if (object instanceof List) {
            for (Object o : (List)object) {
                this.preMarshallIndividualEntity(o);
            }
        } else {
            this.preMarshallIndividualEntity(object);
        }
    }

    protected void preMarshallIndividualEntity(Object entity) {
        if (entity instanceof ReportQueryResultListItem) {
            ReportQueryResultListItem item = (ReportQueryResultListItem)entity;
            for (JAXBElement field : item.getFields()) {
                this.setRelationshipInfo(field.getValue());
            }
        } else if (entity instanceof SingleResultQueryList) {
            SingleResultQueryList item = (SingleResultQueryList)entity;
            for (JAXBElement field : item.getFields()) {
                this.setRelationshipInfo(field.getValue());
            }
        } else if (entity instanceof ReportQueryResultList) {
            ReportQueryResultList list = (ReportQueryResultList)entity;
            for (ReportQueryResultListItem item : list.getItems()) {
                for (JAXBElement field : item.getFields()) {
                    this.setRelationshipInfo(field.getValue());
                }
            }
        } else if (entity instanceof ReadAllQueryResultCollection) {
            ReadAllQueryResultCollection list = (ReadAllQueryResultCollection)entity;
            List<Object> items = list.getItems();
            if (items != null && !items.isEmpty()) {
                for (Object item : items) {
                    this.setRelationshipInfo(item);
                }
            }
        } else if (entity instanceof ReportQueryResultCollection) {
            ReportQueryResultCollection list = (ReportQueryResultCollection)entity;
            List<ReportQueryResultListItem> items = list.getItems();
            if (items != null && !items.isEmpty()) {
                for (ReportQueryResultListItem item : items) {
                    this.setRelationshipInfo(item);
                }
            }
        } else {
            this.setRelationshipInfo(entity);
        }
    }

    private void setRelationshipInfo(Object entity) {
        ClassDescriptor descriptor;
        if (entity != null && entity instanceof PersistenceWeavedRest && (descriptor = this.getServerSession().getClassDescriptor(entity.getClass())) != null) {
            ((PersistenceWeavedRest)entity)._persistence_setRelationships(new ArrayList<RelationshipInfo>());
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                RelationshipInfo info;
                if (mapping.isForeignReferenceMapping()) {
                    ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
                    info = new RelationshipInfo();
                    info.setAttributeName(frMapping.getAttributeName());
                    info.setOwningEntity(entity);
                    info.setOwningEntityAlias(descriptor.getAlias());
                    info.setPersistencePrimaryKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(entity, (AbstractSession)((Object)this.getServerSession())));
                    ((PersistenceWeavedRest)entity)._persistence_getRelationships().add(info);
                    continue;
                }
                if (!mapping.isEISMapping() || !(mapping instanceof EISCompositeCollectionMapping)) continue;
                EISCompositeCollectionMapping eisMapping = (EISCompositeCollectionMapping)mapping;
                info = new RelationshipInfo();
                info.setAttributeName(eisMapping.getAttributeName());
                info.setOwningEntity(entity);
                info.setOwningEntityAlias(descriptor.getAlias());
                info.setPersistencePrimaryKey(descriptor.getObjectBuilder().extractPrimaryKeyFromObject(entity, (AbstractSession)((Object)this.getServerSession())));
                ((PersistenceWeavedRest)entity)._persistence_getRelationships().add(info);
            }
        }
    }

    protected void postMarshallEntity(Object object) {
        if (object instanceof List) {
            for (Object entity : (List)object) {
                if (!(entity instanceof PersistenceWeavedRest)) continue;
                ((PersistenceWeavedRest)entity)._persistence_setRelationships(new ArrayList<RelationshipInfo>());
            }
        } else if (object instanceof PersistenceWeavedRest) {
            ((PersistenceWeavedRest)object)._persistence_setRelationships(new ArrayList<RelationshipInfo>());
        }
    }

    protected List<XmlAdapter> getAdapters() throws JPARSException {
        if (this.adapters != null) {
            return this.adapters;
        }
        this.adapters = new ArrayList<XmlAdapter>();
        try {
            ClassLoader cl = this.getServerSession().getDatasourcePlatform().getConversionManager().getLoader();
            for (ClassDescriptor desc : this.getServerSession().getDescriptors().values()) {
                if (this.version.compareTo(ServiceVersion.VERSION_2_0) >= 0) {
                    String collectionAdapterName = RestCollectionAdapterClassWriter.getClassName(desc.getJavaClass().getName());
                    Class<?> collectionAdaptorClass = Class.forName(collectionAdapterName, true, cl);
                    Class[] argTypes = new Class[]{PersistenceContext.class};
                    Constructor<?> collectionAdaptorConstructor = collectionAdaptorClass.getDeclaredConstructor(argTypes);
                    Object[] args = new Object[]{this};
                    this.adapters.add((XmlAdapter)collectionAdaptorConstructor.newInstance(args));
                    String refAdapterName = RestReferenceAdapterV2ClassWriter.getClassName(desc.getJavaClass().getName());
                    Class<?> refAdaptorClass = Class.forName(refAdapterName, true, cl);
                    Class[] refAdapterTypes = new Class[]{PersistenceContext.class};
                    Constructor<?> refAdaptorConstructor = refAdaptorClass.getDeclaredConstructor(refAdapterTypes);
                    Object[] refAdapterArgs = new Object[]{this};
                    this.adapters.add((XmlAdapter)refAdaptorConstructor.newInstance(refAdapterArgs));
                    continue;
                }
                if (desc.isAggregateCollectionDescriptor() || desc.isAggregateDescriptor()) continue;
                Class clz = desc.getJavaClass();
                String referenceAdapterName = RestAdapterClassWriter.constructClassNameForReferenceAdapter(clz.getName());
                Class<?> referenceAdaptorClass = Class.forName(referenceAdapterName, true, cl);
                Class[] argTypes1 = new Class[]{String.class, PersistenceContext.class};
                Constructor<?> referenceAdaptorConstructor = referenceAdaptorClass.getDeclaredConstructor(argTypes1);
                Object[] args1 = new Object[]{this.getBaseURI().toString(), this};
                this.adapters.add((XmlAdapter)referenceAdaptorConstructor.newInstance(args1));
            }
        }
        catch (ReflectiveOperationException | RuntimeException ex) {
            ex.printStackTrace();
            throw JPARSException.exceptionOccurred(ex);
        }
        return this.adapters;
    }

    private boolean getWeavingProperty() {
        boolean restWeavingEnabled = true;
        boolean fetchGroupWeavingEnabled = true;
        boolean weavingEnabled = true;
        Map<String, Object> properties = this.emf.getProperties();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (key.equals("eclipselink.weaving") && !"true".equalsIgnoreCase((String)value) && !"static".equalsIgnoreCase((String)value)) {
                weavingEnabled = false;
            }
            if (key.equals("eclipselink.weaving.rest") && !"true".equalsIgnoreCase((String)value)) {
                restWeavingEnabled = false;
            }
            if (!key.equals("eclipselink.weaving.fetchgroups") || "true".equalsIgnoreCase((String)value)) continue;
            fetchGroupWeavingEnabled = false;
        }
        return weavingEnabled && restWeavingEnabled && fetchGroupWeavingEnabled;
    }

    public FeatureSet getSupportedFeatureSet() {
        return this.version.getFeatureSet();
    }

    public boolean isQueryPageable(String queryName) {
        return this.getPageableQueries().get(queryName) != null;
    }

    public RestPageableQuery getPageableQuery(String queryName) {
        return this.getPageableQueries().get(queryName);
    }

    public void setVersion(String version) {
        this.version = ServiceVersion.fromCode(version);
    }

    public void setBaseURI(URI baseURI) {
        this.baseURI = baseURI;
    }

    private Map<String, RestPageableQuery> getPageableQueries() {
        if (this.pageableQueries == null) {
            this.initPageableQueries();
        }
        return this.pageableQueries;
    }

    private void initPageableQueries() {
        this.pageableQueries = new HashMap<String, RestPageableQuery>();
        for (Class clazz : this.getServerSession().getProject().getDescriptors().keySet()) {
            if (!clazz.isAnnotationPresent(RestPageableQueries.class)) continue;
            RestPageableQueries restPageableQueries = clazz.getAnnotation(RestPageableQueries.class);
            RestPageableQuery[] restPageableQueryArray = restPageableQueries.value();
            int n = restPageableQueryArray.length;
            int n2 = 0;
            while (n2 < n) {
                RestPageableQuery restPageableQuery = restPageableQueryArray[n2];
                this.pageableQueries.put(restPageableQuery.queryName(), restPageableQuery);
                ++n2;
            }
        }
    }

    public CollectionWrapperBuilder getCollectionWrapperBuilder() {
        if (this.collectionWrapperBuilder == null) {
            this.collectionWrapperBuilder = new CollectionWrapperBuilder(this);
        }
        return this.collectionWrapperBuilder;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        PersistenceContext otherContext = (PersistenceContext)other;
        if (this.name == null ? otherContext.name != null : !this.name.equals(otherContext.name)) {
            return false;
        }
        return !(this.version == null ? otherContext.version != null : !this.version.equals((Object)otherContext.version));
    }
}

