/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.painter.AbstractAreaPainter;
import org.jdesktop.swingx.painter.PainterUtils;
import org.jdesktop.swingx.painter.effects.AreaEffect;

public class TextPainter
extends AbstractAreaPainter<Object> {
    private String text = "";
    private Font font = null;

    public TextPainter() {
        this("");
    }

    public TextPainter(String text) {
        this(text, null, null);
    }

    public TextPainter(String text, Font font) {
        this(text, font, null);
    }

    public TextPainter(String text, Paint paint) {
        this(text, null, paint);
    }

    public TextPainter(String text, Font font, Paint paint) {
        this.text = text;
        this.font = font;
        this.setFillPaint(paint);
    }

    public void setFont(Font f) {
        Font old = this.getFont();
        this.font = f;
        this.setDirty(true);
        this.firePropertyChange("font", old, this.getFont());
    }

    public Font getFont() {
        return this.font;
    }

    public void setText(String text) {
        String old = this.getText();
        this.text = text == null ? "" : text;
        this.setDirty(true);
        this.firePropertyChange("text", old, this.getText());
    }

    public String getText() {
        return this.text;
    }

    @Override
    protected void doPaint(Graphics2D g2, Object component, int width, int height) {
        Font f = this.calculateFont(component);
        if (f != null) {
            g2.setFont(f);
        }
        Paint paint = PainterUtils.getForegroundPaint(this.getFillPaint(), component);
        String t2 = this.calculateText(component);
        FontMetrics metrics = g2.getFontMetrics(g2.getFont());
        int tw = metrics.stringWidth(t2);
        int th = metrics.getHeight();
        Rectangle res = this.calculateLayout(tw, th, width, height);
        g2.translate(res.x, res.y);
        if (this.isPaintStretched()) {
            paint = this.calculateSnappedPaint(paint, res.width, res.height);
        }
        if (paint != null) {
            g2.setPaint(paint);
        }
        g2.drawString(t2, 0, 0 + metrics.getAscent());
        if (this.getAreaEffects() != null) {
            Shape shape = this.provideShape(g2, component, width, height);
            for (AreaEffect ef : this.getAreaEffects()) {
                ef.apply(g2, shape, width, height);
            }
        }
        g2.translate(-res.x, -res.y);
    }

    private String calculateText(Object component) {
        String t2 = this.getText();
        if (t2 != null && !t2.trim().equals("")) {
            return t2;
        }
        if (component instanceof JTextComponent) {
            t2 = ((JTextComponent)component).getText();
        }
        if (component instanceof JLabel) {
            t2 = ((JLabel)component).getText();
        }
        if (component instanceof AbstractButton) {
            t2 = ((AbstractButton)component).getText();
        }
        return t2;
    }

    private Font calculateFont(Object component) {
        Font f = PainterUtils.getComponentFont(this.getFont(), component);
        if (f == null) {
            f = new Font("Dialog", 0, 18);
        }
        return f;
    }

    @Override
    protected Shape provideShape(Graphics2D g2, Object comp, int width, int height) {
        Font f = this.calculateFont(comp);
        String t2 = this.calculateText(comp);
        FontMetrics metrics = g2.getFontMetrics(f);
        GlyphVector vect = f.createGlyphVector(g2.getFontRenderContext(), t2);
        return vect.getOutline(0.0f, 0.0f + (float)metrics.getAscent());
    }
}

