/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.awt;

import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Completions;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.tools.Diagnostic;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.awt.ActionReferences;
import org.openide.awt.ActionRegistration;
import org.openide.awt.ActionState;
import org.openide.awt.DynamicMenuContent;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public final class ActionProcessor
extends LayerGeneratingProcessor {
    private static final String IDENTIFIER = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
    private static final Pattern FQN = Pattern.compile("(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)(?:[.](?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*))*");
    private static final String[] DEFAULT_COMPLETIONS = new String[]{"Menu", "Toolbars", "Shortcuts", "Loaders"};
    private Processor COMPLETIONS;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> hash = new HashSet<String>();
        hash.add(ActionRegistration.class.getCanonicalName());
        hash.add(ActionID.class.getCanonicalName());
        hash.add(ActionReference.class.getCanonicalName());
        hash.add(ActionReferences.class.getCanonicalName());
        return hash;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        if (annotation.getAnnotationType().asElement().getSimpleName().toString().contains(ActionReference.class.getSimpleName()) && member.getSimpleName().contentEquals("path")) {
            if (userText == null) {
                userText = "";
            }
            if (userText.startsWith("\"")) {
                userText = userText.substring(1);
            }
            HashSet<Completion> res = new HashSet<Completion>();
            for (String c : DEFAULT_COMPLETIONS) {
                if (!c.startsWith(userText)) continue;
                res.add(Completions.of("\"" + c + '/', NbBundle.getMessage(ActionProcessor.class, "HINT_" + c)));
            }
            if (!res.isEmpty()) {
                return res;
            }
            if (this.COMPLETIONS == null) {
                String pathCompletions = System.getProperty(ActionReference.class.getName() + ".completion");
                if (pathCompletions != null) {
                    void var7_10;
                    ClassLoader classLoader = Lookup.getDefault().lookup(ClassLoader.class);
                    if (classLoader == null) {
                        ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                    }
                    if (var7_10 == null) {
                        ClassLoader classLoader3 = ActionProcessor.class.getClassLoader();
                    }
                    try {
                        void var7_12;
                        this.COMPLETIONS = (Processor)Class.forName(pathCompletions, true, (ClassLoader)var7_12).newInstance();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace(ex);
                        this.COMPLETIONS = this;
                    }
                } else {
                    return res;
                }
            }
            if (this.COMPLETIONS != null && this.COMPLETIONS != this) {
                this.COMPLETIONS.init(this.processingEnv);
                for (Completion completion : this.COMPLETIONS.getCompletions(element, annotation, member, userText)) {
                    res.add(completion);
                }
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        ActionID id;
        TypeMirror actionListener = this.type(ActionListener.class);
        TypeMirror p1 = this.type(Presenter.Menu.class);
        TypeMirror p2 = this.type(Presenter.Toolbar.class);
        TypeMirror p3 = this.type(Presenter.Popup.class);
        TypeMirror caa = this.type(ContextAwareAction.class);
        TypeMirror dmc = this.type(DynamicMenuContent.class);
        TypeMirror at = this.type(Action.class);
        TypeMirror ot = this.type(Object.class);
        TypeMirror lt = this.type(EventListener.class);
        TypeMirror vt = this.type(Void.class);
        for (Element element : roundEnv.getElementsAnnotatedWith(ActionRegistration.class)) {
            ActionReferences actionReferences;
            String key;
            String popupText;
            ActionRegistration ar = element.getAnnotation(ActionRegistration.class);
            if (ar == null) continue;
            ActionID aid = element.getAnnotation(ActionID.class);
            if (aid == null) {
                throw new LayerGenerationException("@ActionRegistration can only be used together with @ActionID annotation", element, this.processingEnv, ar);
            }
            if (aid.id() == null) continue;
            if (aid.category().startsWith("Actions/")) {
                throw new LayerGenerationException("@ActionID category() should not start with Actions/", element, this.processingEnv, aid, "category");
            }
            if (!FQN.matcher(aid.id()).matches()) {
                throw new LayerGenerationException("@ActionID id() must be valid fully qualified name", element, this.processingEnv, aid, "id");
            }
            String id2 = aid.id().replace('.', '-');
            LayerBuilder builder = this.layer(element);
            LayerBuilder.File f = builder.file("Actions/" + aid.category() + "/" + id2 + ".instance");
            f.bundlevalue("displayName", ar.displayName(), ar, "displayName");
            String menuText = ar.menuText();
            if (!menuText.isEmpty()) {
                f.bundlevalue("menuText", menuText, ar, "menuText");
            }
            if (!(popupText = ar.popupText()).isEmpty()) {
                f.bundlevalue("popupText", popupText, ar, "popupText");
            }
            boolean createDelegate = true;
            if (element.getKind() == ElementKind.FIELD) {
                VariableElement var = (VariableElement)element;
                TypeMirror stringType = this.type(String.class);
                if (!(element.asType() == stringType && element.getModifiers().contains((Object)Modifier.PUBLIC) && element.getModifiers().contains((Object)Modifier.STATIC) && element.getModifiers().contains((Object)Modifier.FINAL))) {
                    throw new LayerGenerationException("Only static string constant fields can be annotated", element, this.processingEnv, ar);
                }
                if (ar.key().length() != 0) {
                    throw new LayerGenerationException("When annotating field, one cannot define key()", element, this.processingEnv, ar, "key");
                }
                createDelegate = false;
                key = var.getConstantValue().toString();
            } else if (element.getKind() == ElementKind.CLASS) {
                if (!this.isAssignable(element.asType(), actionListener)) {
                    throw new LayerGenerationException("Class annotated with @ActionRegistration must implement java.awt.event.ActionListener!", element, this.processingEnv, ar);
                }
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException("Class has to be public", element, this.processingEnv, ar);
                }
                if (element.getEnclosingElement().getKind() == ElementKind.CLASS && !element.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException("Inner class annotated with @ActionRegistration has to be static", element);
                }
                key = ar.key();
            } else {
                assert (element.getKind() == ElementKind.METHOD) : element;
                builder.instanceFile("dummy", null, ActionListener.class, ar, null);
                key = ar.key();
            }
            Boolean direct = null;
            AnnotationMirror arMirror = null;
            block3: for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                if (!annotationMirror.getAnnotationType().toString().equals(ActionRegistration.class.getCanonicalName())) continue;
                arMirror = annotationMirror;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    if (!entry.getKey().getSimpleName().contentEquals("lazy")) continue;
                    direct = (Boolean)entry.getValue().getValue() == false;
                    assert (direct == !ar.lazy());
                    continue block3;
                }
            }
            if (direct == null) {
                if (element.getKind() == ElementKind.FIELD) {
                    direct = false;
                } else {
                    TypeMirror type = element.getKind() == ElementKind.CLASS ? element.asType() : ((ExecutableElement)element).getReturnType();
                    direct = this.isAssignable(type, p1) || this.isAssignable(type, p2) || this.isAssignable(type, p3) || this.isAssignable(type, caa) || this.isAssignable(type, dmc);
                    if (direct.booleanValue()) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Should explicitly specify lazy attribute", element);
                    }
                }
            }
            if (direct.booleanValue()) {
                if (key.length() != 0) {
                    throw new LayerGenerationException("Cannot specify key and use eager registration", element, this.processingEnv, ar, "key");
                }
                if (!ar.iconBase().isEmpty()) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "iconBase unused on eager registrations", element, arMirror);
                }
                f.instanceAttribute("instanceCreate", Action.class);
            } else {
                TypeMirror selectType = null;
                if (key.length() == 0) {
                    f.methodvalue("instanceCreate", "org.openide.awt.Actions", "alwaysEnabled");
                } else {
                    f.methodvalue("instanceCreate", "org.openide.awt.Actions", "callback");
                    if (createDelegate) {
                        f.methodvalue("fallback", "org.openide.awt.Actions", "alwaysEnabled");
                    }
                    f.stringvalue("key", key);
                }
                if (createDelegate) {
                    try {
                        f.instanceAttribute("delegate", ActionListener.class, ar, null);
                    }
                    catch (LayerGenerationException layerGenerationException) {
                        selectType = this.generateContext(element, f, ar);
                    }
                }
                if (ar.iconBase().length() > 0) {
                    builder.validateResource(ar.iconBase(), element, ar, "iconBase", true);
                    f.stringvalue("iconBase", ar.iconBase());
                }
                f.boolvalue("noIconInMenu", !ar.iconInMenu());
                if (ar.asynchronous()) {
                    f.boolvalue("asynchronous", true);
                }
                if (ar.surviveFocusChange()) {
                    f.boolvalue("surviveFocusChange", true);
                }
                this.processActionState(element, ar.enabledOn(), f, selectType, true, at, ot, lt, vt);
                this.processActionState(element, ar.checkedOn(), f, selectType, false, at, ot, lt, vt);
            }
            f.write();
            ActionReference aref = element.getAnnotation(ActionReference.class);
            if (aref != null) {
                this.processReferences(element, aref, aid);
            }
            if ((actionReferences = element.getAnnotation(ActionReferences.class)) == null) continue;
            for (ActionReference actionReference : actionReferences.value()) {
                this.processReferences(element, actionReference, aid);
            }
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ActionReference.class)) {
            ActionReference ref;
            if (element.getAnnotation(ActionRegistration.class) != null || (ref = element.getAnnotation(ActionReference.class)) == null) continue;
            id = element.getAnnotation(ActionID.class);
            if (id != null) {
                this.processReferences(element, ref, id);
                continue;
            }
            throw new LayerGenerationException("Don't use @ActionReference without @ActionID", element, this.processingEnv, ref);
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(ActionReferences.class)) {
            ActionReferences refs;
            if (element.getAnnotation(ActionRegistration.class) != null || (refs = element.getAnnotation(ActionReferences.class)) == null) continue;
            id = element.getAnnotation(ActionID.class);
            if (id != null) {
                for (ActionReference actionReference : refs.value()) {
                    if (!actionReference.id().id().isEmpty() || !actionReference.id().category().isEmpty()) {
                        throw new LayerGenerationException("Don't specify additional id=@ActionID(...) when using @ActionID on the element", element, this.processingEnv, actionReference.id());
                    }
                    this.processReferences(element, actionReference, id);
                }
                continue;
            }
            for (ActionReference actionReference : refs.value()) {
                if (actionReference.id().id().isEmpty() || actionReference.id().category().isEmpty()) {
                    throw new LayerGenerationException("Specify real id=@ActionID(...)", element, this.processingEnv, actionReference.id());
                }
                this.processReferences(element, actionReference, actionReference.id());
            }
        }
        return true;
    }

    private void processActionState(Element e, ActionState as, LayerBuilder.File f, TypeMirror selectType, boolean enable, TypeMirror actionType, TypeMirror objectType, TypeMirror eventListenerType, TypeMirror voidType) throws LayerGenerationException {
        String property = as.property();
        TypeMirror enabledType = null;
        try {
            as.type();
        }
        catch (MirroredTypeException mte) {
            enabledType = mte.getTypeMirror();
        }
        if (enabledType == null || enabledType.getKind() != TypeKind.DECLARED) {
            throw new LayerGenerationException("Invalid enabled-on type in @ActionState", e, this.processingEnv, as, "type");
        }
        if (this.processingEnv.getTypeUtils().isSameType(enabledType, voidType)) {
            return;
        }
        if (!as.useActionInstance() && this.processingEnv.getTypeUtils().isSameType(enabledType, objectType) && "".equals(as.property()) && !enable) {
            throw new LayerGenerationException("Property must be specified", e, this.processingEnv, as);
        }
        DeclaredType dt = (DeclaredType)enabledType;
        if (this.processingEnv.getTypeUtils().isSameType(dt, objectType)) {
            if (selectType == null) {
                throw new LayerGenerationException("Property owner type must be specified", e, this.processingEnv, as);
            }
            dt = (DeclaredType)selectType;
        }
        String dtName = this.processingEnv.getElementUtils().getBinaryName((TypeElement)dt.asElement()).toString();
        f.stringvalue(enable ? "enableOnType" : "checkedOnType", dtName);
        if (!enable) {
            f.boolvalue("openide.awt.actionToggle", true);
        }
        boolean isAction = this.processingEnv.getTypeUtils().isSameType(dt, actionType);
        switch (property) {
            case "": {
                if (as.useActionInstance()) {
                    property = null;
                    break;
                }
                property = enable ? "enabled" : "SwingSelectedKey";
                break;
            }
            case "#null": {
                property = null;
            }
        }
        TypeElement tel = (TypeElement)dt.asElement();
        if (property != null && !isAction) {
            Element getter = null;
            ExecutableElement invalidGetter = null;
            String capitalizedName = Character.toUpperCase(property.charAt(0)) + property.substring(1);
            String isGetter = "is" + capitalizedName;
            String getGetter = "get" + capitalizedName;
            for (ExecutableElement el : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers(tel))) {
                if (el.getSimpleName().contentEquals(isGetter)) {
                    if (!el.getParameters().isEmpty()) {
                        invalidGetter = el;
                    } else {
                        getter = el;
                        break;
                    }
                }
                if (!el.getSimpleName().contentEquals(getGetter)) continue;
                if (!el.getParameters().isEmpty()) {
                    if (invalidGetter != null) continue;
                    invalidGetter = el;
                    continue;
                }
                getter = el;
            }
            if (getter == null) {
                if (invalidGetter != null) {
                    throw new LayerGenerationException("Getter " + dtName + "." + invalidGetter.toString() + " must take no parameters", e, this.processingEnv, as, "property");
                }
                throw new LayerGenerationException("Property " + property + " not found in " + dtName + ".", e, this.processingEnv, as, "property");
            }
            Set<Modifier> mods = getter.getModifiers();
            if (!mods.contains((Object)Modifier.PUBLIC)) {
                throw new LayerGenerationException("Getter " + dtName + "." + getter.toString() + " must be public", e, this.processingEnv, as, "property");
            }
        }
        if (property != null) {
            f.stringvalue(enable ? "enableOnProperty" : "checkedOnProperty", property);
        }
        TypeMirror listenType = null;
        try {
            as.listenOn();
            return;
        }
        catch (MirroredTypeException ex) {
            boolean wantsListen;
            listenType = ex.getTypeMirror();
            boolean explicitListenerType = !this.processingEnv.getTypeUtils().isSameType(listenType, eventListenerType);
            TypeElement lfaceElement = (TypeElement)((DeclaredType)listenType).asElement();
            String lfaceName = lfaceElement.getSimpleName().toString();
            String lfaceFQN = this.processingEnv.getElementUtils().getBinaryName(lfaceElement).toString();
            String addName = "add" + lfaceName;
            String removeName = "remove" + lfaceName;
            if (explicitListenerType) {
                if (lfaceElement.getKind() != ElementKind.INTERFACE) {
                    throw new LayerGenerationException(lfaceFQN + " is not an interface", e, this.processingEnv, as, "listenOn");
                }
                if (!lfaceElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException(lfaceFQN + " is not public", e, this.processingEnv, as, "listenOn");
                }
            }
            ExecutableElement addMethod = null;
            ExecutableElement addCandidate = null;
            ExecutableElement removeMethod = null;
            ExecutableElement removeCandidate = null;
            for (ExecutableElement el : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers(tel))) {
                if (el.getSimpleName().contentEquals(addName)) {
                    addCandidate = el;
                    if (!el.getModifiers().contains((Object)Modifier.PUBLIC) || el.getModifiers().contains((Object)Modifier.STATIC) || el.getParameters().size() != 1 || !this.processingEnv.getTypeUtils().isSameType(listenType, el.getParameters().get(0).asType())) continue;
                    addMethod = el;
                    continue;
                }
                if (!el.getSimpleName().contentEquals(removeName)) continue;
                removeCandidate = el;
                if (!el.getModifiers().contains((Object)Modifier.PUBLIC) || el.getModifiers().contains((Object)Modifier.STATIC) || el.getParameters().size() != 1 || !this.processingEnv.getTypeUtils().isSameType(listenType, el.getParameters().get(0).asType())) continue;
                removeMethod = el;
            }
            if (addMethod == null) {
                if (addCandidate != null) {
                    throw new LayerGenerationException("Method add" + addCandidate.getSimpleName() + " must be public and take exactly one parameter of type " + lfaceName + ".", e, this.processingEnv, as, "listenOn");
                }
                if (explicitListenerType) {
                    throw new LayerGenerationException("Method add" + lfaceName + " not found on " + dtName, e, this.processingEnv, as, "listenOn");
                }
            }
            if (removeMethod == null) {
                if (removeCandidate != null) {
                    throw new LayerGenerationException("Method remove" + removeCandidate.getSimpleName() + " must be public and take exactly one parameter of type " + lfaceName + ".", e, this.processingEnv, as, "listenOn");
                }
                if (explicitListenerType) {
                    throw new LayerGenerationException("Method remove" + lfaceName + " not found on " + dtName, e, this.processingEnv, as, "listenOn");
                }
            }
            boolean bl = wantsListen = explicitListenerType || addMethod != null && removeMethod != null;
            if (wantsListen) {
                f.stringvalue(enable ? "enableOnChangeListener" : "checkedOnChangeListener", lfaceFQN);
            }
            if (!"".equals(as.listenOnMethod())) {
                if (!explicitListenerType) {
                    throw new LayerGenerationException("Cannot specify listenOnMethod() without listenOn().", e, this.processingEnv, as, "listenOnMethod");
                }
                String m4 = as.listenOnMethod();
                boolean found = false;
                for (ExecutableElement el : ElementFilter.methodsIn(this.processingEnv.getElementUtils().getAllMembers(lfaceElement))) {
                    if (!el.getSimpleName().contentEquals(m4)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new LayerGenerationException("Interface " + lfaceFQN + " does not contain method " + m4, e, this.processingEnv, as, "listenOnMethod");
                }
                f.stringvalue(enable ? "enableOnMethod" : "checkedOnMethod", m4);
            }
            if (!"".equals(as.checkedValue())) {
                switch (as.checkedValue()) {
                    case "#null": {
                        f.boolvalue(enable ? "enableOnNull" : "checkedOnNull", true);
                        break;
                    }
                    case "#non-null": {
                        f.boolvalue(enable ? "enableOnNull" : "checkedOnNull", false);
                        break;
                    }
                    default: {
                        f.stringvalue(enable ? "enableOnValue" : "checkedOnValue", as.checkedValue());
                    }
                }
            }
            if (as.useActionInstance()) {
                f.stringvalue(enable ? "enableOnActionProperty" : "checkedOnActionProperty", enable ? "enabled" : "SwingSelectedKey");
            }
            return;
        }
    }

    private TypeMirror type(Class<?> type) {
        TypeElement e = this.processingEnv.getElementUtils().getTypeElement(type.getCanonicalName());
        return e == null ? null : e.asType();
    }

    private TypeMirror generateContext(Element e, LayerBuilder.File f, ActionRegistration ar) throws LayerGenerationException {
        ExecutableElement ee = null;
        ExecutableElement candidate = null;
        for (ExecutableElement element : ElementFilter.constructorsIn(e.getEnclosedElements())) {
            if (element.getKind() != ElementKind.CONSTRUCTOR) continue;
            candidate = element;
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (ee != null) {
                throw new LayerGenerationException("Only one public constructor allowed", e, this.processingEnv, ar);
            }
            ee = element;
        }
        if (ee == null || ee.getParameters().size() != 1) {
            if (candidate != null) {
                throw new LayerGenerationException("Constructor has to be public with one argument", candidate);
            }
            throw new LayerGenerationException("Constructor must have one argument", ee);
        }
        VariableElement ve = ee.getParameters().get(0);
        TypeMirror ctorType = ve.asType();
        switch (ctorType.getKind()) {
            case ARRAY: {
                String elemType = ((ArrayType)ctorType).getComponentType().toString();
                throw new LayerGenerationException("Use List<" + elemType + "> rather than " + elemType + "[] in constructor", e, this.processingEnv, ar);
            }
            case DECLARED: {
                break;
            }
            default: {
                throw new LayerGenerationException("Must use SomeType (or List<SomeType>) in constructor, not " + (Object)((Object)ctorType.getKind()));
            }
        }
        DeclaredType dt = (DeclaredType)ctorType;
        String dtName = this.processingEnv.getElementUtils().getBinaryName((TypeElement)dt.asElement()).toString();
        if ("java.util.List".equals(dtName)) {
            if (dt.getTypeArguments().isEmpty()) {
                throw new LayerGenerationException("Use List<SomeType>", ee);
            }
            f.stringvalue("type", this.binaryName(dt.getTypeArguments().get(0)));
            f.methodvalue("delegate", "org.openide.awt.Actions", "inject");
            f.stringvalue("injectable", this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString());
            f.stringvalue("selectionType", "ANY");
            f.methodvalue("instanceCreate", "org.openide.awt.Actions", "context");
            return dt.getTypeArguments().get(0);
        }
        if (!dt.getTypeArguments().isEmpty()) {
            throw new LayerGenerationException("No type parameters allowed in ", ee);
        }
        f.stringvalue("type", this.binaryName(ctorType));
        f.methodvalue("delegate", "org.openide.awt.Actions", "inject");
        f.stringvalue("injectable", this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString());
        f.stringvalue("selectionType", "EXACTLY_ONE");
        f.methodvalue("instanceCreate", "org.openide.awt.Actions", "context");
        return ctorType;
    }

    private String binaryName(TypeMirror t2) {
        Element e = this.processingEnv.getTypeUtils().asElement(t2);
        if (e != null && (e.getKind().isClass() || e.getKind().isInterface())) {
            return this.processingEnv.getElementUtils().getBinaryName((TypeElement)e).toString();
        }
        return t2.toString();
    }

    private boolean isAssignable(TypeMirror first, TypeMirror snd) {
        if (snd == null) {
            return false;
        }
        return this.processingEnv.getTypeUtils().isAssignable(first, snd);
    }

    private void processReferences(Element e, ActionReference ref, ActionID aid) throws LayerGenerationException {
        KeyStroke[] stroke;
        if (!(ref.id().category().isEmpty() || ref.id().id().isEmpty() || aid.id().equals(ref.id().id()) && aid.category().equals(ref.id().category()))) {
            throw new LayerGenerationException("Can't specify id() attribute when @ActionID provided on the element", e, this.processingEnv, aid);
        }
        String name = ref.name();
        if (name.isEmpty()) {
            name = aid.id().replace('.', '-');
        }
        if (ref.path().startsWith("Shortcuts") && (stroke = Utilities.stringToKeys(name)) == null) {
            throw new LayerGenerationException("Registrations in Shortcuts folder need to represent a key. Specify value for 'name' attribute.\nSee org.openide.util.Utilities.stringToKeys for possible values. Current name=\"" + name + "\" is not valid.\n", e, this.processingEnv, ref, "path");
        }
        LayerBuilder.File f = this.layer(e).file(ref.path() + "/" + name + ".shadow");
        f.stringvalue("originalFile", "Actions/" + aid.category() + "/" + aid.id().replace('.', '-') + ".instance");
        f.position(ref.position());
        f.write();
        if (ref.separatorAfter() != Integer.MAX_VALUE) {
            if (ref.position() == Integer.MAX_VALUE || ref.position() >= ref.separatorAfter()) {
                throw new LayerGenerationException("separatorAfter() must be greater than position()", e, this.processingEnv, ref);
            }
            LayerBuilder.File after = this.layer(e).file(ref.path() + "/" + name + "-separatorAfter.instance");
            after.newvalue("instanceCreate", JSeparator.class.getName());
            after.position(ref.separatorAfter());
            after.write();
        }
        if (ref.separatorBefore() != Integer.MAX_VALUE) {
            if (ref.position() == Integer.MAX_VALUE || ref.position() <= ref.separatorBefore()) {
                throw new LayerGenerationException("separatorBefore() must be lower than position()", e, this.processingEnv, ref);
            }
            LayerBuilder.File before = this.layer(e).file(ref.path() + "/" + name + "-separatorBefore.instance");
            before.newvalue("instanceCreate", JSeparator.class.getName());
            before.position(ref.separatorBefore());
            before.write();
        }
    }
}

