/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackInputStream;
import java.lang.ref.SoftReference;
import java.rmi.MarshalledObject;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLMapAttr;
import org.openide.util.BaseUtilities;
import org.openide.util.Enumerations;
import org.openide.util.NbBundle;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.NbObjectInputStream;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultAttributes
implements AbstractFileSystem.Attr,
AbstractFileSystem.List {
    static final long serialVersionUID = -5801291358293736478L;
    @Deprecated
    public static final String ATTR_NAME = "filesystem";
    @Deprecated
    public static final String ATTR_EXT = "attributes";
    @Deprecated
    public static final String ATTR_NAME_EXT = "filesystem.attributes";
    private static final String ATTR_NAME_EXT_XML = System.getProperty("org.openide.filesystems.DefaultAttributes.ATTR_NAME_EXT_XML", ".nbattrs");
    private static final String READONLY_ATTRIBUTES = "readOnlyAttrs";
    private static final String PUBLIC_ID = "-//NetBeans//DTD DefaultAttributes 1.0//EN";
    private static final String DTD_PATH = "org/openide/filesystems/attributes.dtd";
    private AbstractFileSystem.Info info;
    private AbstractFileSystem.Change change;
    private AbstractFileSystem.List list;
    private String fileName;
    private transient Map<String, SoftReference<Table>> cache;

    public DefaultAttributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
        this.info = info;
        this.change = change;
        this.list = list;
        this.fileName = ATTR_NAME_EXT_XML;
    }

    protected DefaultAttributes(AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list, String fileName) {
        this(info, change, list);
        this.fileName = fileName;
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ObjectInputStream.GetField fields = ois.readFields();
        Object o1 = AbstractFileSystem.readImpl("change", fields);
        Object o2 = AbstractFileSystem.readImpl("info", fields);
        Object o3 = AbstractFileSystem.readImpl("list", fields);
        this.change = (AbstractFileSystem.Change)o1;
        this.info = (AbstractFileSystem.Info)o2;
        this.list = (AbstractFileSystem.List)o3;
    }

    @Override
    public String[] children(String f) {
        String[] arr = this.list.children(f);
        int lookUpIndex = 0;
        if (arr == null) {
            return null;
        }
        int size = arr.length;
        if (size == 1) {
            if (BaseUtilities.getOperatingSystem() == 16384 && arr[0] != null && f != null && arr[0].equalsIgnoreCase("_nbattrs.")) {
                try {
                    this.deleteFile(f + "/" + arr[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                arr[0] = this.getFileName();
            }
            if (this.getFileName().equals(arr[0]) || ATTR_NAME_EXT_XML.equals(arr[0]) || ATTR_NAME_EXT.equals(arr[0])) {
                try {
                    this.change.delete(f + "/" + arr[0]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return new String[0];
            }
        }
        for (int i = 0; i < size; ++i) {
            if (BaseUtilities.getOperatingSystem() == 16384 && arr[i] != null && f != null && arr[i].equalsIgnoreCase("_nbattrs.")) {
                try {
                    File fp = new File(f + "/.nbattrs");
                    if (!fp.exists()) {
                        this.cache = null;
                        this.copyVMSAttrFile(f);
                    }
                }
                catch (IOException fp) {
                    // empty catch block
                }
                arr[i] = this.getFileName();
            }
            String safeNbAttrsCopy = this.getFileName() + "~";
            if (!this.getFileName().equals(arr[i]) && !ATTR_NAME_EXT.equals(arr[i]) && !ATTR_NAME_EXT_XML.equals(arr[i]) && !safeNbAttrsCopy.equals(arr[i])) continue;
            arr[i] = null;
            if (++lookUpIndex >= 2) break;
        }
        return arr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyVMSAttrFile(String f) throws IOException {
        InputStream is = null;
        OutputStream os = null;
        try {
            int readi;
            this.change.createData(f + "/" + this.getFileName());
            is = this.info.inputStream(f + "/_nbattrs.");
            os = this.info.outputStream(f + "/" + this.getFileName());
            byte[] buf = new byte[256];
            while ((readi = is.read(buf, 0, 256)) >= 0) {
                os.write(buf, 0, readi);
            }
            is.close();
            is = null;
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readAttribute(String name, String attrName) {
        Table t2;
        String[] arr = new String[2];
        DefaultAttributes.split(name, arr);
        if (attrName.equals(READONLY_ATTRIBUTES)) {
            return this.info.readOnly(arr[0]) ? Boolean.TRUE : Boolean.FALSE;
        }
        DefaultAttributes defaultAttributes = this;
        synchronized (defaultAttributes) {
            t2 = this.loadTable(arr[0]);
        }
        return t2.getAttr(arr[1], attrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeAttribute(String name, String attrName, Object value) throws IOException {
        String[] arr = new String[2];
        DefaultAttributes.split(name, arr);
        while (true) {
            int version;
            Table t2;
            DefaultAttributes defaultAttributes = this;
            synchronized (defaultAttributes) {
                t2 = this.loadTable(arr[0]);
                version = t2.version;
            }
            Object prev = t2.getAttr(arr[1], attrName);
            if (prev == value) {
                return;
            }
            DefaultAttributes defaultAttributes2 = this;
            synchronized (defaultAttributes2) {
                Table t22 = this.loadTable(arr[0]);
                if (t2 == t22 && version == t22.version) {
                    if (value == null) {
                        t2.setAttr(arr[1], attrName, null);
                    } else {
                        int objType = XMLMapAttr.Attr.distinguishObject(value);
                        if (objType == XMLMapAttr.Attr.isValid("SERIALVALUE")) {
                            t2.setAttr(arr[1], attrName, value);
                        } else {
                            t2.setAttr(arr[1], attrName, XMLMapAttr.createAttribute(objType, value.toString()));
                        }
                    }
                    this.saveTable(arr[0], t2);
                    return;
                }
            }
        }
    }

    @Override
    public synchronized Enumeration<String> attributes(String name) {
        String[] arr = new String[2];
        DefaultAttributes.split(name, arr);
        Table t2 = this.loadTable(arr[0]);
        return t2.attrs(arr[1]);
    }

    @Override
    public synchronized void renameAttributes(String oldName, String newName) {
        try {
            String[] arr = new String[2];
            DefaultAttributes.split(oldName, arr);
            Table t2 = this.loadTable(arr[0]);
            Map v = (Map)t2.remove(arr[1]);
            if (v == null) {
                return;
            }
            DefaultAttributes.split(newName, arr);
            Iterator it = v.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry pair = it.next();
                if (!FileUtil.transientAttributes.contains(pair.getKey())) continue;
                it.remove();
            }
            t2.put(arr[1], v);
            this.saveTable(arr[0], t2);
        }
        catch (IOException e) {
            ExternalUtil.exception(e);
        }
    }

    @Override
    public synchronized void deleteAttributes(String name) {
        try {
            String[] arr = new String[2];
            DefaultAttributes.split(name, arr);
            Table t2 = this.loadTable(arr[0]);
            if (t2.remove(arr[1]) != null) {
                this.saveTable(arr[0], t2);
            }
        }
        catch (IOException e) {
            ExternalUtil.exception(e);
        }
    }

    private Map<String, SoftReference<Table>> getCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, SoftReference<Table>>(31);
        }
        return this.cache;
    }

    private static void split(String name, String[] arr) {
        int i = name.lastIndexOf(47);
        if (i == -1) {
            arr[0] = "";
            arr[1] = name;
            return;
        }
        arr[0] = name.substring(0, i);
        arr[1] = ++i == name.length() ? "" : name.substring(i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTable(String name, Table map) throws IOException {
        String fullName = (name.length() == 0 ? "" : name + '/') + this.getFileName();
        String safeName = fullName + "~";
        if (this.info.folder(fullName)) {
            if (map.size() == 0) {
                return;
            }
            this.change.createData(fullName);
        } else if (map.size() == 0) {
            this.deleteFile(fullName);
            return;
        }
        PrintWriter pw = null;
        IOException ioexc = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.info.outputStream(safeName)), "UTF8"));
            map.writeToXML(pw);
            pw.flush();
        }
        catch (IOException iex) {
            ioexc = iex;
        }
        finally {
            if (pw != null) {
                pw.close();
            }
            if (ioexc != null) {
                try {
                    this.deleteFile(safeName);
                }
                catch (IOException ioe) {
                    if (ioe.getCause() == null) {
                        ioe.initCause(ioexc);
                    }
                    throw ioe;
                }
                throw ioexc;
            }
            int counter = 0;
            while (true) {
                try {
                    this.deleteFile(fullName);
                }
                catch (IOException iex2) {
                    FileSystem.LOG.log(Level.INFO, "Cannot delete " + fullName, iex2);
                }
                try {
                    this.change.rename(safeName, fullName);
                }
                catch (IOException ex) {
                    FileSystem.LOG.log(Level.INFO, "Cannot rename " + fullName + " to " + safeName, ex);
                    if (counter > 10) {
                        throw ex;
                    }
                    ++counter;
                    continue;
                }
                break;
            }
        }
    }

    private Table loadTable(String name) {
        Table m4;
        SoftReference<Table> r = this.getCache().get(name);
        if (r != null && (m4 = r.get()) != null) {
            return m4;
        }
        Table t2 = this.load(name);
        t2.attach(name, this);
        this.getCache().put(name, new SoftReference<Table>(t2));
        return t2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Table load(String name) {
        String[] acceptNames = new String[]{(name.length() == 0 ? "" : name + '/') + this.getFileName(), (name.length() == 0 ? "" : name + '/') + ATTR_NAME_EXT};
        int i = 0;
        while (i < acceptNames.length) {
            if (this.info.size(acceptNames[i]) > 0L) {
                try {
                    InputStream fis = this.info.inputStream(acceptNames[i]);
                    try {
                        Table table = DefaultAttributes.loadTable(fis, acceptNames[i]);
                        return table;
                    }
                    finally {
                        try {
                            fis.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (FileNotFoundException ex) {
                    ExternalUtil.exception(ex);
                }
            }
            ++i;
        }
        return new Table();
    }

    static Table loadTable(InputStream is, String folderName) {
        block5: {
            Table retTable = new Table();
            PushbackInputStream pbStream = null;
            boolean isSerialized = false;
            try {
                if (folderName.endsWith(ATTR_NAME_EXT)) {
                    pbStream = new PushbackInputStream(is, 4);
                    isSerialized = DefaultAttributes.isSerialized(pbStream);
                }
                if (isSerialized && pbStream != null) {
                    BufferedInputStream fis = new BufferedInputStream(pbStream);
                    NbObjectInputStream ois = new NbObjectInputStream(fis);
                    Object o = ois.readObject();
                    if (o instanceof Table) {
                        return (Table)o;
                    }
                    break block5;
                }
                BufferedInputStream bis = pbStream != null ? new BufferedInputStream(pbStream) : new BufferedInputStream(is);
                retTable.readFromXML(bis, false);
                return retTable;
            }
            catch (Exception e) {
                IOException summaryEx = new IOException(NbBundle.getMessage(DefaultAttributes.class, "EXC_DefAttrReadErr") + ": " + folderName);
                ExternalUtil.copyAnnotation(summaryEx, e);
                ExternalUtil.exception(summaryEx);
            }
        }
        return new Table();
    }

    private static final boolean isSerialized(PushbackInputStream pbStream) throws IOException {
        int[] serialPattern = new int[]{172, 237, 0, 5};
        byte[] checkedArray = new byte[serialPattern.length];
        int unsignedConv = 0;
        pbStream.read(checkedArray, 0, checkedArray.length);
        pbStream.unread(checkedArray);
        for (int i = 0; i < checkedArray.length; ++i) {
            int n = unsignedConv = checkedArray[i] < 0 ? checkedArray[i] + 256 : checkedArray[i];
            if (serialPattern[i] == unsignedConv) continue;
            return false;
        }
        return true;
    }

    synchronized void removeTable(String name) {
        this.getCache().remove(name);
    }

    static boolean acceptName(String name) {
        return name.endsWith(ATTR_NAME_EXT) || name.endsWith(ATTR_NAME_EXT_XML);
    }

    private String getFileName() {
        if (this.fileName == null) {
            this.fileName = ATTR_NAME_EXT_XML;
        }
        return this.fileName;
    }

    private void deleteFile(String name) throws IOException {
        OutputStream os = null;
        this.info.lock(name);
        try {
            os = this.info.outputStream(name);
            os.close();
            os = null;
            this.change.delete(name);
        }
        finally {
            if (os != null) {
                os.close();
            }
            this.info.unlock(name);
        }
    }

    static class InnerParser
    extends DefaultHandler {
        private ElementHandler[] elmKeyService;
        private String tagInProcess = "";
        private String publicId;
        private String publicURL;

        InnerParser(String publicId, String publicURL, ElementHandler[] elmKeyService) {
            this.elmKeyService = elmKeyService;
            this.publicId = publicId;
            this.publicURL = publicURL;
        }

        public void parseXML(String uri, boolean validate) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
            XMLReader parser = this.getParser(validate);
            parser.parse(uri);
        }

        public void parseXML(InputStream is, boolean validate) throws IOException, SAXException, ParserConfigurationException, FactoryConfigurationError {
            InputSource iSource = new InputSource(is);
            XMLReader parser = this.getParser(validate);
            parser.parse(iSource);
        }

        private XMLReader getParser(boolean validate) throws SAXException, ParserConfigurationException, FactoryConfigurationError {
            XMLReader parser = XMLUtil.createXMLReader(validate);
            parser.setEntityResolver(this);
            parser.setContentHandler(this);
            parser.setErrorHandler(this);
            return parser;
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw exception;
        }

        @Override
        public void startElement(String uri, String lname, String name, Attributes attrs) throws SAXException {
            this.tagInProcess = name = name.trim();
            for (int i = 0; i < this.elmKeyService.length; ++i) {
                if (this.elmKeyService[i].isMyTag(name) == -1) continue;
                this.elmKeyService[i].startElement(name, attrs);
                return;
            }
            throw new SAXException(NbBundle.getMessage(DefaultAttributes.class, "XML_UnknownElement") + " " + name);
        }

        @Override
        public void endElement(String uri, String lname, String name) throws SAXException {
            for (int i = 0; i < this.elmKeyService.length; ++i) {
                if (this.elmKeyService[i].isMyTag(name.trim()) == -1) continue;
                this.elmKeyService[i].endElement(name.trim());
                return;
            }
            throw new SAXException(NbBundle.getMessage(DefaultAttributes.class, "XML_UnknownElement") + " " + name);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            for (int i = 0; i < this.elmKeyService.length; ++i) {
                if (this.elmKeyService[i].isMyTag(this.tagInProcess) == -1) continue;
                this.elmKeyService[i].characters(ch, start, length);
                return;
            }
            throw new SAXException(NbBundle.getMessage(DefaultAttributes.class, "XML_UnknownElement") + " " + this.tagInProcess);
        }

        @Override
        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (pid != null && pid.equals(this.publicId)) {
                return new InputSource(this.publicURL);
            }
            return new InputSource(sid);
        }
    }

    static abstract class ElementHandler {
        private static final String[] EMPTY = new String[0];
        private int mandatAttrCount;

        ElementHandler() {
        }

        public void startElement(String elemName, Attributes attrs) throws SAXException {
            HashMap<String, String> mapMandatory = new HashMap<String, String>();
            HashMap<String, String> mapAllowed = new HashMap<String, String>();
            if (!this.checkAttributes(attrs, mapMandatory, mapAllowed)) {
                throw new SAXException(NbBundle.getMessage(DefaultAttributes.class, "XML_InaccurateParam") + ": " + elemName);
            }
            this.internalStartElement(elemName, mapMandatory, mapAllowed);
        }

        protected void internalStartElement(String elemName, HashMap mapMandatory, HashMap mapAllowed) throws SAXException {
        }

        protected void characters(char[] ch, int start, int length) throws SAXException {
        }

        protected void endElement(String elemName) throws SAXException {
        }

        protected String[] getKeys() {
            return EMPTY;
        }

        protected String[] getMandatoryAttrs() {
            return this.getKeys();
        }

        protected String[] getAllowedAttrs() {
            return EMPTY;
        }

        private int isMyTag(String name) {
            return this.isInArray(name, this.getKeys());
        }

        private int isAllowedAttr(String name) {
            return this.isInArray(name, this.getAllowedAttrs());
        }

        private boolean isMandatOK() {
            return this.mandatAttrCount == this.getMandatoryAttrs().length;
        }

        private int isMandatoryAttr(String name) {
            int retValue = this.isInArray(name, this.getMandatoryAttrs());
            if (retValue != -1) {
                ++this.mandatAttrCount;
            }
            return retValue;
        }

        private int isInArray(String name, String[] arr) {
            if (arr == null || name == null) {
                return -1;
            }
            String correctStr = name.trim();
            for (int i = 0; i < arr.length; ++i) {
                if (!correctStr.equalsIgnoreCase(arr[i])) continue;
                return i;
            }
            return -1;
        }

        private boolean checkAttributes(Attributes attrList, HashMap<String, String> mapMandatory, HashMap<String, String> mapAllowed) {
            this.mandatAttrCount = 0;
            if (attrList == null) {
                return false;
            }
            for (int i = 0; i < attrList.getLength(); ++i) {
                String temp;
                if (this.isMandatoryAttr(attrList.getQName(i)) != -1) {
                    temp = attrList.getQName(i).toUpperCase(Locale.ENGLISH);
                    mapMandatory.put(temp, attrList.getValue(i));
                    continue;
                }
                if (this.isAllowedAttr(attrList.getQName(i)) == -1) continue;
                temp = attrList.getQName(i).toUpperCase(Locale.ENGLISH);
                mapAllowed.put(temp, attrList.getValue(i));
            }
            return this.isMandatOK();
        }
    }

    static final class Table
    extends HashMap
    implements Externalizable {
        static final long serialVersionUID = 2353458763249746934L;
        private transient String name;
        private transient DefaultAttributes attrs;
        private transient int version = 0;

        public Table() {
            super(11);
        }

        public void attach(String name, DefaultAttributes attrs) {
            this.name = name;
            this.attrs = attrs;
        }

        protected void finalize() {
            this.attrs.removeTable(this.name);
        }

        public Object getAttr(String fileName, String attrName) {
            XMLMapAttr m4 = (XMLMapAttr)this.get(fileName);
            if (m4 != null) {
                Object o = null;
                try {
                    o = m4.getAttribute(attrName);
                }
                catch (Exception e) {
                    ExternalUtil.annotate((Throwable)e, "fileName = " + fileName);
                    ExternalUtil.exception(e);
                }
                if (o == null) {
                    return null;
                }
                if (!(o instanceof NbMarshalledObject)) {
                    return o;
                }
                NbMarshalledObject mo = (NbMarshalledObject)o;
                try {
                    return mo == null ? null : mo.get();
                }
                catch (IOException e) {
                    ExternalUtil.log("Cannot load attribute " + attrName + " from " + fileName);
                    ExternalUtil.exception(e);
                }
                catch (ClassNotFoundException e) {
                    ExternalUtil.log("Cannot load attribute " + attrName + " from " + fileName);
                    ExternalUtil.exception(e);
                }
            }
            return null;
        }

        final void setMarshalledAttr(String fileName, String attrName, NbMarshalledObject obj) {
            this.setAttr(fileName, attrName, obj);
        }

        final void setAttr(String fileName, String attrName, Object obj) {
            XMLMapAttr m4 = (XMLMapAttr)this.get(fileName);
            if (m4 == null) {
                m4 = new XMLMapAttr();
                this.put(fileName, m4);
            }
            m4.put(attrName, obj, false);
            if (obj == null && m4.size() == 1) {
                this.remove(fileName);
            }
            ++this.version;
        }

        public Enumeration<String> attrs(String fileName) {
            Map m4 = (Map)this.get(fileName);
            if (m4 == null) {
                return Enumerations.empty();
            }
            HashSet s2 = new HashSet(m4.keySet());
            return Collections.enumeration(s2);
        }

        private ElementHandler parseFirstLevel() {
            ElementHandler elemService = new ElementHandler(){
                private final String[] ELM_KEYS = new String[]{"ATTRIBUTES"};
                private final String[] MANDAT_ATTR_KEYS = new String[]{"VERSION"};

                @Override
                public void internalStartElement(String elemName, HashMap mapMandatory, HashMap mapAllowed) throws SAXException {
                }

                @Override
                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                @Override
                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }
            };
            return elemService;
        }

        private ElementHandler parseSecondLevel(final StringBuffer fileName) {
            ElementHandler elemService = new ElementHandler(){
                private final String[] ELM_KEYS = new String[]{"FILEOBJECT"};
                private final String[] MANDAT_ATTR_KEYS = new String[]{"NAME"};

                @Override
                public void internalStartElement(String elemName, HashMap mapMandatory, HashMap mapAllowed) throws SAXException {
                    fileName.delete(0, fileName.length());
                    String temp = (String)mapMandatory.get("NAME");
                    if (temp == null) {
                        temp = (String)mapMandatory.get("name");
                    }
                    if (temp != null) {
                        fileName.append(temp);
                    }
                }

                @Override
                public void endElement(String elementName) throws SAXException {
                }

                @Override
                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                @Override
                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }
            };
            return elemService;
        }

        private ElementHandler parseThirdLevel(final StringBuffer fileName) {
            ElementHandler elemService = new ElementHandler(){
                private final String[] ELM_KEYS = new String[]{"ATTR"};
                private final String[] MANDAT_ATTR_KEYS = new String[]{"NAME"};

                @Override
                public void internalStartElement(String elemName, HashMap mapMandatory, HashMap mapAllowed) throws SAXException {
                    if (mapAllowed.isEmpty()) {
                        return;
                    }
                    String attrName = (String)mapMandatory.get("NAME");
                    if (attrName == null) {
                        attrName = (String)mapMandatory.get("name");
                    }
                    if (attrName == null) {
                        return;
                    }
                    for (Map.Entry pair : mapAllowed.entrySet()) {
                        if (XMLMapAttr.Attr.isValid((String)pair.getKey()) == -1) continue;
                        XMLMapAttr.Attr attr = XMLMapAttr.createAttributeAndDecode((String)pair.getKey(), (String)pair.getValue());
                        this.setAttr(fileName.toString(), attrName, attr);
                    }
                }

                @Override
                protected String[] getKeys() {
                    return this.ELM_KEYS;
                }

                @Override
                protected String[] getMandatoryAttrs() {
                    return this.MANDAT_ATTR_KEYS;
                }

                @Override
                protected String[] getAllowedAttrs() {
                    return XMLMapAttr.Attr.getAttrTypes();
                }
            };
            return elemService;
        }

        public void writeToXML(PrintWriter pw) {
            Iterator it = new TreeSet(this.keySet()).iterator();
            XMLMapAttr.writeHeading(pw);
            while (it.hasNext()) {
                String file = (String)it.next();
                XMLMapAttr attr = (XMLMapAttr)this.get(file);
                if (attr == null || attr.isEmpty()) continue;
                attr.write(pw, file, "    ");
            }
            XMLMapAttr.writeEnding(pw);
        }

        public void readFromXML(InputStream is, boolean validate) throws SAXException {
            StringBuffer fileName = new StringBuffer();
            ElementHandler[] elmKeyService = new ElementHandler[]{this.parseFirstLevel(), this.parseSecondLevel(fileName), this.parseThirdLevel(fileName)};
            String dtd = this.getClass().getClassLoader().getResource(DefaultAttributes.DTD_PATH).toExternalForm();
            InnerParser parser = new InnerParser(DefaultAttributes.PUBLIC_ID, dtd, elmKeyService);
            try {
                parser.parseXML(is, validate);
            }
            catch (Exception ioe) {
                throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(NbBundle.getMessage(DefaultAttributes.class, "EXC_DefAttrReadErr")), ioe);
            }
            catch (FactoryConfigurationError fce) {
                throw (SAXException)ExternalUtil.copyAnnotation(new SAXException(NbBundle.getMessage(DefaultAttributes.class, "EXC_DefAttrReadErr")), fce);
            }
        }

        @Override
        public void writeExternal(ObjectOutput oo) throws IOException {
            for (String file : this.keySet()) {
                Map attr = (Map)this.get(file);
                if (attr == null || attr.isEmpty()) continue;
                oo.writeObject(file);
                for (Map.Entry entry : attr.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (key == null || value == null) continue;
                    oo.writeObject(key);
                    oo.writeObject(value);
                }
                oo.writeObject(null);
            }
            oo.writeObject(null);
        }

        @Override
        public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
            String file;
            while ((file = (String)oi.readObject()) != null) {
                String attr;
                while ((attr = (String)oi.readObject()) != null) {
                    Object o = oi.readObject();
                    if (o instanceof MarshalledObject) {
                        o = ((MarshalledObject)o).get();
                        o = new NbMarshalledObject(o);
                    }
                    if (!(o instanceof NbMarshalledObject)) continue;
                    this.setAttr(file, attr, o);
                }
            }
        }
    }
}

