/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.AbstractFolder;
import org.openide.filesystems.FileObject;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;

final class RefreshRequest
implements Runnable {
    private static final int REFRESH_COUNT = 30;
    private static RequestProcessor REFRESHER = new RequestProcessor("FS refresher");
    private Reference<AbstractFileSystem> system;
    private Enumeration<AbstractFolder> en;
    private int refreshTime;
    private RequestProcessor.Task task;

    public RefreshRequest(AbstractFileSystem fs, int ms) {
        this.system = new WeakReference<AbstractFileSystem>(fs);
        this.refreshTime = ms;
        this.task = REFRESHER.post(this, ms, 1);
    }

    public int getRefreshTime() {
        return this.refreshTime;
    }

    public synchronized void stop() {
        this.refreshTime = 0;
        if (this.task == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        RequestProcessor.Task t2;
        int ms;
        RefreshRequest refreshRequest = this;
        synchronized (refreshRequest) {
            ms = this.refreshTime;
            if (ms <= 0) {
                return;
            }
            t2 = this.task;
            this.task = null;
        }
        try {
            this.doLoop(ms);
        }
        finally {
            refreshRequest = this;
            synchronized (refreshRequest) {
                this.task = t2;
                this.notifyAll();
            }
            if (this.system != null && this.system.get() != null) {
                t2.schedule(ms);
            } else {
                this.refreshTime = 0;
            }
        }
    }

    private void doLoop(int ms) {
        AbstractFileSystem system = this.system.get();
        if (system == null) {
            return;
        }
        if (this.en == null || !this.en.hasMoreElements()) {
            this.en = NbCollections.checkedEnumerationByFilter(RefreshRequest.existingFolders(system), AbstractFolder.class, true);
        }
        for (int i = 0; i < 30 && this.en.hasMoreElements(); ++i) {
            AbstractFolder fo = this.en.nextElement();
            if (fo != null && (!fo.isFolder() || fo.isInitialized())) {
                fo.refresh();
            }
            if (this.refreshTime > 0) continue;
            return;
        }
        if (!this.en.hasMoreElements()) {
            this.en = null;
        }
    }

    private static Enumeration<? extends FileObject> existingFolders(AbstractFileSystem fs) {
        return fs.existingFileObjects(fs.getAbstractRoot());
    }

    public String toString() {
        AbstractFileSystem fs = this.system.get();
        return "RefreshRequest for " + (fs == null ? "gone FS" : fs);
    }
}

