/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems.annotations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.openide.filesystems.annotations.LayerGenerationException;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class LayerBuilder {
    private final Document doc;
    private final javax.lang.model.element.Element originatingElement;
    private final ProcessingEnvironment processingEnv;
    private final List<File> unwrittenFiles = new LinkedList<File>();

    LayerBuilder(Document document, javax.lang.model.element.Element originatingElement, ProcessingEnvironment processingEnv) {
        this.doc = document;
        this.originatingElement = originatingElement;
        this.processingEnv = processingEnv;
    }

    public File file(String path) {
        if (!path.matches("[^/]+(/[^/]+)*")) {
            throw new IllegalArgumentException(path);
        }
        File f = new File(path, false);
        this.unwrittenFiles.add(f);
        return f;
    }

    public File folder(String path) {
        File f = new File(path, true);
        this.unwrittenFiles.add(f);
        return f;
    }

    void close() {
        for (File f : this.unwrittenFiles) {
            if (f.getPath().startsWith("dummy/")) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "layer file " + f.getPath() + " was never written");
        }
        this.unwrittenFiles.clear();
    }

    public File instanceFile(String path, String name, Class<?> type) throws IllegalArgumentException, LayerGenerationException {
        return this.instanceFile(path, name, type, null, null);
    }

    public File instanceFile(String path, String name, Class<?> type, Annotation annotation, String annotationMethod) throws IllegalArgumentException, LayerGenerationException {
        String basename;
        String[] clazzOrMethod = this.instantiableClassOrMethod(type, annotation, annotationMethod);
        String clazz = clazzOrMethod[0];
        String method = clazzOrMethod[1];
        if (name == null) {
            basename = clazz.replace('.', '-');
            if (method != null) {
                basename = basename + "-" + method;
            }
        } else {
            basename = name;
        }
        File f = this.file(path + "/" + basename + ".instance");
        if (method != null) {
            f.methodvalue("instanceCreate", clazz, method);
        } else if (name != null) {
            f.stringvalue("instanceClass", clazz);
        }
        return f;
    }

    public File instanceFile(String path, String name) throws IllegalArgumentException, LayerGenerationException {
        return this.instanceFile(path, name, null, null);
    }

    public File instanceFile(String path, String name, Annotation annotation, String annotationMethod) throws IllegalArgumentException, LayerGenerationException {
        String basename;
        String[] clazzOrMethod = this.instantiableClassOrMethod(null, annotation, annotationMethod);
        String clazz = clazzOrMethod[0];
        String method = clazzOrMethod[1];
        if (name == null) {
            basename = clazz.replace('.', '-');
            if (method != null) {
                basename = basename + "-" + method;
            }
        } else {
            basename = name;
        }
        return this.file(path + "/" + basename + ".instance");
    }

    private String[] instantiableClassOrMethod(Class<?> type, Annotation annotation, String annotationMethod) throws IllegalArgumentException, LayerGenerationException {
        if (this.originatingElement == null) {
            throw new IllegalArgumentException("Only applicable to builders with exactly one associated element");
        }
        DeclaredType typeMirror = type != null ? this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement(type.getName().replace('$', '.')), new TypeMirror[0]) : null;
        switch (this.originatingElement.getKind()) {
            case CLASS: {
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.originatingElement).toString();
                if (this.originatingElement.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                    throw new LayerGenerationException(clazz + " must not be abstract", this.originatingElement, this.processingEnv, annotation, annotationMethod);
                }
                boolean hasDefaultCtor = false;
                for (ExecutableElement constructor : ElementFilter.constructorsIn(this.originatingElement.getEnclosedElements())) {
                    if (!constructor.getParameters().isEmpty()) continue;
                    hasDefaultCtor = true;
                    break;
                }
                if (!hasDefaultCtor) {
                    throw new LayerGenerationException(clazz + " must have a no-argument constructor", this.originatingElement, this.processingEnv, annotation, annotationMethod);
                }
                if (typeMirror != null && !this.processingEnv.getTypeUtils().isAssignable(this.originatingElement.asType(), typeMirror)) {
                    throw new LayerGenerationException(clazz + " is not assignable to " + typeMirror, this.originatingElement, this.processingEnv, annotation, annotationMethod);
                }
                if (!this.originatingElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    throw new LayerGenerationException(clazz + " is not public", this.originatingElement, this.processingEnv, annotation, annotationMethod);
                }
                if (((TypeElement)this.originatingElement).getNestingKind().isNested() && !this.originatingElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(clazz + " is nested but not static", this.originatingElement, this.processingEnv, annotation, annotationMethod);
                }
                return new String[]{clazz, null};
            }
            case METHOD: {
                boolean mapParam;
                String clazz = this.processingEnv.getElementUtils().getBinaryName((TypeElement)this.originatingElement.getEnclosingElement()).toString();
                String method = this.originatingElement.getSimpleName().toString();
                if (!this.originatingElement.getModifiers().contains((Object)Modifier.STATIC)) {
                    throw new LayerGenerationException(clazz + "." + method + " must be static", this.originatingElement, this.processingEnv, annotation, annotationMethod);
                }
                List<? extends VariableElement> params = ((ExecutableElement)this.originatingElement).getParameters();
                DeclaredType utilMapType = this.processingEnv.getTypeUtils().getDeclaredType(this.processingEnv.getElementUtils().getTypeElement("java.util.Map"), new TypeMirror[0]);
                boolean bl = mapParam = params.size() == 1 && this.processingEnv.getTypeUtils().isAssignable(params.get(0).asType(), utilMapType);
                if (!params.isEmpty() && !mapParam) {
                    throw new LayerGenerationException(clazz + "." + method + " must not take arguments", this.originatingElement, this.processingEnv, annotation, annotationMethod);
                }
                if (typeMirror != null && !this.processingEnv.getTypeUtils().isAssignable(((ExecutableElement)this.originatingElement).getReturnType(), typeMirror)) {
                    throw new LayerGenerationException(clazz + "." + method + " is not assignable to " + typeMirror, this.originatingElement, this.processingEnv, annotation, annotationMethod);
                }
                return new String[]{clazz, method};
            }
        }
        throw new LayerGenerationException("Annotated element is not loadable as an instance", this.originatingElement, this.processingEnv, annotation, annotationMethod);
    }

    public File shadowFile(String target, String folder, String name) {
        if (name == null) {
            name = target.replaceFirst("^.+/", "").replaceFirst("\\.[^./]+$", "");
        }
        return this.file(folder + "/" + name + ".shadow").stringvalue("originalFile", target);
    }

    public FileObject validateResource(String resource, javax.lang.model.element.Element originatingElement, Annotation annotation, String annotationMethod, boolean searchClasspath) throws LayerGenerationException {
        if (resource.startsWith("/")) {
            throw new LayerGenerationException("do not use leading slashes on resource paths", originatingElement, this.processingEnv, annotation, annotationMethod);
        }
        if (searchClasspath) {
            for (JavaFileManager.Location loc : new JavaFileManager.Location[]{StandardLocation.SOURCE_PATH, StandardLocation.CLASS_OUTPUT, StandardLocation.CLASS_PATH, StandardLocation.PLATFORM_CLASS_PATH}) {
                try {
                    FileObject f = this.processingEnv.getFiler().getResource(loc, "", resource);
                    if (loc.isOutputLocation()) {
                        f.openInputStream().close();
                    }
                    return f;
                }
                catch (IOException ex) {
                }
            }
            throw new LayerGenerationException("Cannot find resource " + resource, originatingElement, this.processingEnv, annotation, annotationMethod);
        }
        try {
            try {
                FileObject f = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_PATH, "", resource);
                f.openInputStream().close();
                return f;
            }
            catch (FileNotFoundException x) {
                try {
                    FileObject f = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", resource);
                    f.openInputStream().close();
                    return f;
                }
                catch (IOException x2) {
                    throw x;
                }
            }
        }
        catch (IOException x) {
            throw new LayerGenerationException("Cannot find resource " + resource, originatingElement, this.processingEnv, annotation, annotationMethod);
        }
    }

    public static String absolutizeResource(javax.lang.model.element.Element originatingElement, String resource) throws LayerGenerationException {
        if (resource.startsWith("/")) {
            return resource.substring(1);
        }
        try {
            return new URI(null, LayerBuilder.findPackage(originatingElement).replace('.', '/') + "/", null).resolve(new URI(null, resource, null)).getPath();
        }
        catch (URISyntaxException x) {
            throw new LayerGenerationException(x.toString(), originatingElement);
        }
    }

    private static String findPackage(javax.lang.model.element.Element e) {
        switch (e.getKind()) {
            case PACKAGE: {
                return ((PackageElement)e).getQualifiedName().toString();
            }
        }
        return LayerBuilder.findPackage(e.getEnclosingElement());
    }

    public final class File {
        private final String path;
        private final boolean folder;
        private final Map<String, String[]> attrs = new LinkedHashMap<String, String[]>();
        private String contents;
        private String url;

        File(String path, boolean folder) {
            this.path = path;
            this.folder = folder;
        }

        public String getPath() {
            return this.path;
        }

        public File contents(String contents) {
            if (this.contents != null || this.url != null || contents == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.contents = contents;
            return this;
        }

        public File url(String url) {
            if (this.contents != null || this.url != null || url == null || this.folder) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            return this;
        }

        public File stringvalue(String attr, String value) {
            this.attrs.put(attr, new String[]{"stringvalue", value});
            return this;
        }

        public File bytevalue(String attr, byte value) {
            this.attrs.put(attr, new String[]{"bytevalue", Byte.toString(value)});
            return this;
        }

        public File shortvalue(String attr, short value) {
            this.attrs.put(attr, new String[]{"shortvalue", Short.toString(value)});
            return this;
        }

        public File intvalue(String attr, int value) {
            this.attrs.put(attr, new String[]{"intvalue", Integer.toString(value)});
            return this;
        }

        public File longvalue(String attr, long value) {
            this.attrs.put(attr, new String[]{"longvalue", Long.toString(value)});
            return this;
        }

        public File floatvalue(String attr, float value) {
            this.attrs.put(attr, new String[]{"floatvalue", Float.toString(value)});
            return this;
        }

        public File doublevalue(String attr, double value) {
            this.attrs.put(attr, new String[]{"doublevalue", Double.toString(value)});
            return this;
        }

        public File boolvalue(String attr, boolean value) {
            this.attrs.put(attr, new String[]{"boolvalue", Boolean.toString(value)});
            return this;
        }

        public File charvalue(String attr, char value) {
            this.attrs.put(attr, new String[]{"charvalue", Character.toString(value)});
            return this;
        }

        public File urlvalue(String attr, URI value) throws LayerGenerationException {
            if (value.isOpaque()) {
                throw new LayerGenerationException("Cannot use an opaque URI: " + value, LayerBuilder.this.originatingElement);
            }
            this.attrs.put(attr, new String[]{"urlvalue", value.toString()});
            return this;
        }

        public File urlvalue(String attr, String value) throws LayerGenerationException {
            try {
                return this.urlvalue(attr, URI.create(value));
            }
            catch (IllegalArgumentException x) {
                throw new LayerGenerationException(x.getLocalizedMessage(), LayerBuilder.this.originatingElement);
            }
        }

        public File methodvalue(String attr, String clazz, String method) {
            this.attrs.put(attr, new String[]{"methodvalue", clazz + "." + method});
            return this;
        }

        public File newvalue(String attr, String clazz) {
            this.attrs.put(attr, new String[]{"newvalue", clazz});
            return this;
        }

        public File instanceAttribute(String attr, Class<?> type) throws IllegalArgumentException, LayerGenerationException {
            return this.instanceAttribute(attr, type, null, null);
        }

        public File instanceAttribute(String attr, Class<?> type, Annotation annotation, String annotationMethod) throws IllegalArgumentException, LayerGenerationException {
            String[] clazzOrMethod = LayerBuilder.this.instantiableClassOrMethod(type, annotation, annotationMethod);
            if (clazzOrMethod[1] == null) {
                this.newvalue(attr, clazzOrMethod[0]);
            } else {
                this.methodvalue(attr, clazzOrMethod[0], clazzOrMethod[1]);
            }
            return this;
        }

        public File bundlevalue(String attr, String bundle, String key) {
            this.attrs.put(attr, new String[]{"bundlevalue", bundle + "#" + key});
            return this;
        }

        public File bundlevalue(String attr, String label) throws LayerGenerationException {
            return this.bundlevalue(attr, label, null, null);
        }

        public File bundlevalue(String attr, String label, Annotation annotation, String annotationMethod) throws LayerGenerationException {
            String javaIdentifier = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
            Matcher m4 = Pattern.compile("((?:" + javaIdentifier + "\\.)+[^\\s.#]+)?#(\\S*)").matcher(label);
            if (m4.matches()) {
                String bundle = m4.group(1);
                String key = m4.group(2);
                if (bundle == null) {
                    javax.lang.model.element.Element referenceElement;
                    for (referenceElement = LayerBuilder.this.originatingElement; referenceElement != null && referenceElement.getKind() != ElementKind.PACKAGE; referenceElement = referenceElement.getEnclosingElement()) {
                    }
                    if (referenceElement == null) {
                        throw new LayerGenerationException("No reference element to determine package in '" + label + "'", LayerBuilder.this.originatingElement);
                    }
                    bundle = ((PackageElement)referenceElement).getQualifiedName() + ".Bundle";
                }
                this.verifyBundleKey(bundle, key, m4.group(1) == null, annotation, annotationMethod);
                this.bundlevalue(attr, bundle, key);
            } else {
                this.stringvalue(attr, label);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyBundleKey(String bundle, String key, boolean samePackage, Annotation annotation, String annotationMethod) throws LayerGenerationException {
            if (LayerBuilder.this.processingEnv == null) {
                return;
            }
            if (samePackage) {
                for (javax.lang.model.element.Element e = LayerBuilder.this.originatingElement; e != null; e = e.getEnclosingElement()) {
                    NbBundle.Messages m4 = e.getAnnotation(NbBundle.Messages.class);
                    if (m4 == null) continue;
                    for (String kv : m4.value()) {
                        if (!kv.startsWith(key + "=")) continue;
                        return;
                    }
                }
            }
            try (InputStream is = LayerBuilder.this.validateResource(bundle.replace('.', '/') + ".properties", LayerBuilder.this.originatingElement, null, null, false).openInputStream();){
                Properties p = new Properties();
                p.load(is);
                if (p.getProperty(key) == null) {
                    throw new LayerGenerationException("No key '" + key + "' found in " + bundle, LayerBuilder.this.originatingElement, LayerBuilder.this.processingEnv, annotation, annotationMethod);
                }
            }
            catch (IOException x) {
                throw new LayerGenerationException("Could not open " + bundle + ": " + x, LayerBuilder.this.originatingElement, LayerBuilder.this.processingEnv, annotation, annotationMethod);
            }
        }

        public File serialvalue(String attr, byte[] data) {
            StringBuilder buf = new StringBuilder(data.length * 2);
            for (int n : data) {
                if (n >= 0 && n < 16) {
                    buf.append('0');
                }
                buf.append(Integer.toHexString(n < 0 ? n + 256 : n));
            }
            this.attrs.put(attr, new String[]{"serialvalue", buf.toString().toUpperCase(Locale.ENGLISH)});
            return this;
        }

        public File position(int position) {
            if (position != Integer.MAX_VALUE) {
                this.intvalue("position", position);
            }
            return this;
        }

        public LayerBuilder write() {
            LayerBuilder.this.unwrittenFiles.remove(this);
            Element e = LayerBuilder.this.doc.getDocumentElement();
            String[] pieces = this.path.split("/");
            for (String piece : Arrays.asList(pieces).subList(0, pieces.length - 1)) {
                Element kid = this.find(e, piece, "file|folder");
                if (kid != null) {
                    if (!kid.getNodeName().equals("folder")) {
                        throw new IllegalArgumentException(this.path);
                    }
                    e = kid;
                    continue;
                }
                e = (Element)e.appendChild(LayerBuilder.this.doc.createElement("folder"));
                e.setAttribute("name", piece);
            }
            String piece = pieces[pieces.length - 1];
            Element file = this.find(e, piece, "file|folder");
            if (file == null) {
                file = (Element)e.appendChild(LayerBuilder.this.doc.createElement(this.folder ? "folder" : "file"));
                file.setAttribute("name", piece);
            }
            if (LayerBuilder.this.originatingElement != null) {
                Object name;
                switch (LayerBuilder.this.originatingElement.getKind()) {
                    case METHOD: 
                    case CONSTRUCTOR: 
                    case ENUM_CONSTANT: 
                    case FIELD: 
                    case INSTANCE_INIT: 
                    case STATIC_INIT: {
                        name = LayerBuilder.this.originatingElement.getEnclosingElement() + "." + LayerBuilder.this.originatingElement;
                        break;
                    }
                    default: {
                        name = LayerBuilder.this.originatingElement.toString();
                    }
                }
                boolean addComment = true;
                NodeList oldComments = file.getChildNodes();
                for (int i = 0; i < oldComments.getLength(); ++i) {
                    Node node = oldComments.item(i);
                    if (node.getNodeType() != 8 || !node.getNodeValue().equals(name)) continue;
                    addComment = false;
                    break;
                }
                if (addComment) {
                    file.appendChild(LayerBuilder.this.doc.createComment((String)name));
                }
            }
            for (Map.Entry<String, String[]> entry : this.attrs.entrySet()) {
                Element former = this.find(file, entry.getKey(), "attr");
                if (former != null) {
                    file.removeChild(former);
                }
                Element attr = (Element)file.appendChild(LayerBuilder.this.doc.createElement("attr"));
                attr.setAttribute("name", entry.getKey());
                attr.setAttribute(entry.getValue()[0], entry.getValue()[1]);
            }
            if (this.url != null) {
                file.setAttribute("url", this.url);
            } else if (this.contents != null) {
                NodeList oldContents = file.getChildNodes();
                int i = 0;
                while (i < oldContents.getLength()) {
                    Node node = oldContents.item(i);
                    if (node.getNodeType() == 4) {
                        file.removeChild(node);
                        continue;
                    }
                    ++i;
                }
                file.appendChild(LayerBuilder.this.doc.createCDATASection(this.contents));
            }
            return LayerBuilder.this;
        }

        private Element find(Element parent, String name, String kindRx) {
            NodeList nl = parent.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element e;
                Node item = nl.item(i);
                if (item.getNodeType() != 1 || !(e = (Element)item).getAttribute("name").equals(name) || !e.getNodeName().matches(kindRx)) continue;
                return e;
            }
            return null;
        }
    }
}

