/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InvalidObjectException;
import java.lang.ref.ReferenceQueue;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.SourceVersion;
import org.openide.util.Lookup;
import org.openide.util.RE13;
import org.openide.util.TopologicalSortException;
import org.openide.util.lookup.implspi.ActiveQueue;

public abstract class BaseUtilities {
    private static final Logger LOG = Logger.getLogger(BaseUtilities.class.getName());
    public static final int OS_WINNT = 1;
    public static final int OS_WIN95 = 2;
    public static final int OS_WIN98 = 4;
    public static final int OS_SOLARIS = 8;
    public static final int OS_LINUX = 16;
    public static final int OS_HP = 32;
    public static final int OS_AIX = 64;
    public static final int OS_IRIX = 128;
    public static final int OS_SUNOS = 256;
    public static final int OS_TRU64 = 512;
    @Deprecated
    public static final int OS_DEC = 1024;
    public static final int OS_OS2 = 2048;
    public static final int OS_MAC = 4096;
    public static final int OS_WIN2000 = 8192;
    public static final int OS_VMS = 16384;
    public static final int OS_WIN_OTHER = 32768;
    public static final int OS_OTHER = 65536;
    public static final int OS_FREEBSD = 131072;
    public static final int OS_WINVISTA = 262144;
    public static final int OS_UNIX_OTHER = 524288;
    public static final int OS_OPENBSD = 0x100000;
    @Deprecated
    public static final int OS_WINDOWS_MASK = 303111;
    @Deprecated
    public static final int OS_UNIX_MASK = 1709048;
    private static int operatingSystem = -1;
    private static final Object TRANS_LOCK = new Object();
    private static Object transLoader;
    private static RE transExp;
    private static volatile Boolean pathURIConsistent;

    private BaseUtilities() {
    }

    public static ReferenceQueue<Object> activeReferenceQueue() {
        return ActiveQueue.queue();
    }

    public static int getOperatingSystem() {
        if (operatingSystem == -1) {
            String osName = System.getProperty("os.name");
            operatingSystem = "Windows NT".equals(osName) ? 1 : ("Windows 95".equals(osName) ? 2 : ("Windows 98".equals(osName) ? 4 : ("Windows 2000".equals(osName) ? 8192 : ("Windows Vista".equals(osName) ? 262144 : (osName.startsWith("Windows ") ? 32768 : ("Solaris".equals(osName) ? 8 : (osName.startsWith("SunOS") ? 8 : (osName.endsWith("Linux") ? 16 : ("HP-UX".equals(osName) ? 32 : ("AIX".equals(osName) ? 64 : ("Irix".equals(osName) ? 128 : ("SunOS".equals(osName) ? 256 : ("Digital UNIX".equals(osName) ? 512 : ("OS/2".equals(osName) ? 2048 : ("OpenVMS".equals(osName) ? 16384 : (osName.equals("Mac OS X") ? 4096 : (osName.startsWith("Darwin") ? 4096 : (osName.toLowerCase(Locale.US).startsWith("freebsd") ? 131072 : ("OpenBSD".equals(osName) ? 0x100000 : (File.pathSeparatorChar == ':' ? 524288 : 65536))))))))))))))))))));
        }
        return operatingSystem;
    }

    public static boolean isWindows() {
        return (BaseUtilities.getOperatingSystem() & 0x4A007) != 0;
    }

    public static boolean isMac() {
        return (BaseUtilities.getOperatingSystem() & 0x1000) != 0;
    }

    public static boolean isUnix() {
        return (BaseUtilities.getOperatingSystem() & 0x1A13F8) != 0;
    }

    static void resetOperatingSystem() {
        operatingSystem = -1;
    }

    public static boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        return SourceVersion.isIdentifier(id) && !SourceVersion.isKeyword(id);
    }

    public static String[] wrapStringToArray(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        int i;
        String[] workingSet;
        block14: {
            if (original.length() == 0) {
                return new String[]{original};
            }
            if (removeNewLines) {
                original = BaseUtilities.trimString(original);
                original = original.replace('\n', ' ');
                workingSet = new String[]{original};
            } else {
                StringTokenizer tokens = new StringTokenizer(original, "\n");
                int len = tokens.countTokens();
                workingSet = new String[len];
                for (i = 0; i < len; ++i) {
                    workingSet[i] = tokens.nextToken();
                }
            }
            if (width < 1) {
                width = 1;
            }
            if (original.length() <= width) {
                return workingSet;
            }
            boolean ok = true;
            for (int i2 = 0; i2 < workingSet.length; ++i2) {
                boolean bl = ok = ok && workingSet[i2].length() < width;
                if (ok) {
                    continue;
                }
                break block14;
            }
            return workingSet;
        }
        ArrayList<String> lines = new ArrayList<String>();
        int lineStart = 0;
        for (i = 0; i < workingSet.length; ++i) {
            if (workingSet[i].length() < width) {
                lines.add(workingSet[i]);
                continue;
            }
            breakIterator.setText(workingSet[i]);
            int nextStart = breakIterator.next();
            int prevStart = 0;
            while (true) {
                if (nextStart - lineStart < width && nextStart != -1) {
                    prevStart = nextStart;
                    nextStart = breakIterator.next();
                    continue;
                }
                if (nextStart == -1) {
                    nextStart = prevStart = workingSet[i].length();
                }
                if (prevStart == 0) {
                    prevStart = nextStart;
                }
                lines.add(workingSet[i].substring(lineStart, prevStart));
                lineStart = prevStart;
                prevStart = 0;
                if (lineStart >= workingSet[i].length()) break;
            }
            lineStart = 0;
        }
        String[] s2 = new String[lines.size()];
        return lines.toArray(s2);
    }

    private static String trimString(String s2) {
        char c;
        int idx = 0;
        int slen = s2.length();
        if (slen == 0) {
            return s2;
        }
        while (((c = s2.charAt(idx++)) == '\n' || c == '\r') && idx < slen) {
        }
        --idx;
        if ((idx = (s2 = s2.substring(idx)).length() - 1) < 0) {
            return s2;
        }
        while (((c = s2.charAt(idx--)) == '\n' || c == '\r') && idx >= 0) {
        }
        return s2.substring(0, idx + 2);
    }

    public static String wrapString(String original, int width, BreakIterator breakIterator, boolean removeNewLines) {
        String[] sarray = BaseUtilities.wrapStringToArray(original, width, breakIterator, removeNewLines);
        StringBuilder retBuf = new StringBuilder();
        for (int i = 0; i < sarray.length; ++i) {
            retBuf.append(sarray[i]);
            retBuf.append('\n');
        }
        return retBuf.toString();
    }

    public static String pureClassName(String fullName) {
        int index = fullName.indexOf(36);
        if (index >= 0 && index < fullName.length()) {
            return fullName.substring(index + 1, fullName.length());
        }
        return fullName;
    }

    public static boolean compareObjects(Object o1, Object o2) {
        return BaseUtilities.compareObjectsImpl(o1, o2, 1);
    }

    public static boolean compareObjectsImpl(Object o1, Object o2, int checkArraysDepth) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o2 == null) {
            return false;
        }
        if (checkArraysDepth > 0) {
            if (o1 instanceof Object[] && o2 instanceof Object[]) {
                Object[] o1a = (Object[])o1;
                int l1 = o1a.length;
                Object[] o2a = (Object[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (BaseUtilities.compareObjectsImpl(o1a[i], o2a[i], checkArraysDepth - 1)) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof byte[] && o2 instanceof byte[]) {
                byte[] o1a = (byte[])o1;
                int l1 = o1a.length;
                byte[] o2a = (byte[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof short[] && o2 instanceof short[]) {
                short[] o1a = (short[])o1;
                int l1 = o1a.length;
                short[] o2a = (short[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof int[] && o2 instanceof int[]) {
                int[] o1a = (int[])o1;
                int l1 = o1a.length;
                int[] o2a = (int[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof long[] && o2 instanceof long[]) {
                long[] o1a = (long[])o1;
                int l1 = o1a.length;
                long[] o2a = (long[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof float[] && o2 instanceof float[]) {
                float[] o1a = (float[])o1;
                int l1 = o1a.length;
                float[] o2a = (float[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof double[] && o2 instanceof double[]) {
                double[] o1a = (double[])o1;
                int l1 = o1a.length;
                double[] o2a = (double[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof char[] && o2 instanceof char[]) {
                char[] o1a = (char[])o1;
                int l1 = o1a.length;
                char[] o2a = (char[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
                boolean[] o1a = (boolean[])o1;
                int l1 = o1a.length;
                boolean[] o2a = (boolean[])o2;
                int l2 = o2a.length;
                if (l1 != l2) {
                    return false;
                }
                for (int i = 0; i < l1; ++i) {
                    if (o1a[i] == o2a[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return o1.equals(o2);
    }

    public static String getClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return BaseUtilities.getClassName(clazz.getComponentType()) + "[]";
        }
        return clazz.getName();
    }

    public static String getShortClassName(Class<?> clazz) {
        if (clazz.isArray()) {
            return BaseUtilities.getShortClassName(clazz.getComponentType()) + "[]";
        }
        String name = clazz.getName().replace('$', '.');
        return name.substring(name.lastIndexOf(46) + 1, name.length());
    }

    public static Object toPrimitiveArray(Object[] array) {
        if (array instanceof Integer[]) {
            int[] r = new int[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Integer)array[i] == null ? 0 : (Integer)array[i];
            }
            return r;
        }
        if (array instanceof Boolean[]) {
            boolean[] r = new boolean[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Boolean)array[i] == null ? false : (Boolean)array[i];
            }
            return r;
        }
        if (array instanceof Byte[]) {
            byte[] r = new byte[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Byte)array[i] == null ? (byte)0 : (Byte)array[i];
            }
            return r;
        }
        if (array instanceof Character[]) {
            char[] r = new char[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Character)array[i] == null ? (char)'\u0000' : ((Character)array[i]).charValue();
            }
            return r;
        }
        if (array instanceof Double[]) {
            double[] r = new double[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Double)array[i] == null ? 0.0 : (Double)array[i];
            }
            return r;
        }
        if (array instanceof Float[]) {
            float[] r = new float[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Float)array[i] == null ? 0.0f : ((Float)array[i]).floatValue();
            }
            return r;
        }
        if (array instanceof Long[]) {
            long[] r = new long[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Long)array[i] == null ? 0L : (Long)array[i];
            }
            return r;
        }
        if (array instanceof Short[]) {
            short[] r = new short[array.length];
            int k = array.length;
            for (int i = 0; i < k; ++i) {
                r[i] = (Short)array[i] == null ? (short)0 : (Short)array[i];
            }
            return r;
        }
        throw new IllegalArgumentException();
    }

    public static Object[] toObjectArray(Object array) {
        if (array instanceof Object[]) {
            return (Object[])array;
        }
        if (array instanceof int[]) {
            int k = ((int[])array).length;
            Object[] r = new Integer[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((int[])array)[i];
            }
            return r;
        }
        if (array instanceof boolean[]) {
            int k = ((boolean[])array).length;
            Object[] r = new Boolean[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((boolean[])array)[i];
            }
            return r;
        }
        if (array instanceof byte[]) {
            int k = ((byte[])array).length;
            Object[] r = new Byte[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((byte[])array)[i];
            }
            return r;
        }
        if (array instanceof char[]) {
            int k = ((char[])array).length;
            Object[] r = new Character[k];
            for (int i = 0; i < k; ++i) {
                r[i] = Character.valueOf(((char[])array)[i]);
            }
            return r;
        }
        if (array instanceof double[]) {
            int k = ((double[])array).length;
            Object[] r = new Double[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((double[])array)[i];
            }
            return r;
        }
        if (array instanceof float[]) {
            int k = ((float[])array).length;
            Object[] r = new Float[k];
            for (int i = 0; i < k; ++i) {
                r[i] = Float.valueOf(((float[])array)[i]);
            }
            return r;
        }
        if (array instanceof long[]) {
            int k = ((long[])array).length;
            Object[] r = new Long[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((long[])array)[i];
            }
            return r;
        }
        if (array instanceof short[]) {
            int k = ((short[])array).length;
            Object[] r = new Short[k];
            for (int i = 0; i < k; ++i) {
                r[i] = ((short[])array)[i];
            }
            return r;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getObjectType(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        throw new IllegalArgumentException();
    }

    public static Class<?> getPrimitiveType(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static String[] parseParameters(String s2) {
        boolean NULL2 = false;
        boolean IN_PARAM = true;
        int IN_DOUBLE_QUOTE = 2;
        int IN_SINGLE_QUOTE = 3;
        ArrayList<String> params = new ArrayList<String>(5);
        int state = 0;
        StringBuilder buff = new StringBuilder(20);
        int slength = s2.length();
        block18: for (int i = 0; i < slength; ++i) {
            char c = s2.charAt(i);
            switch (state) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            state = 3;
                            continue block18;
                        }
                        case '\"': {
                            state = 2;
                            continue block18;
                        }
                    }
                    if (Character.isWhitespace(c)) continue block18;
                    buff.append(c);
                    state = 1;
                    continue block18;
                }
                case 3: {
                    if (c != '\'') {
                        buff.append(c);
                        continue block18;
                    }
                    state = 1;
                    continue block18;
                }
                case 2: {
                    switch (c) {
                        case '\\': {
                            char peek;
                            char c2 = peek = i < slength - 1 ? s2.charAt(i + 1) : (char)'\u0000';
                            if (peek == '\"' || peek == '\\') {
                                buff.append(peek);
                                ++i;
                                continue block18;
                            }
                            buff.append(c);
                            continue block18;
                        }
                        case '\"': {
                            state = 1;
                            continue block18;
                        }
                    }
                    buff.append(c);
                    continue block18;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            state = 3;
                            continue block18;
                        }
                        case '\"': {
                            state = 2;
                            continue block18;
                        }
                    }
                    if (Character.isWhitespace(c)) {
                        params.add(buff.toString());
                        buff.setLength(0);
                        state = 0;
                        continue block18;
                    }
                    buff.append(c);
                }
            }
        }
        if (buff.length() > 0) {
            params.add(buff.toString());
        }
        return params.toArray(new String[params.size()]);
    }

    public static String escapeParameters(String[] params) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            BaseUtilities.escapeString(params[i], sb);
            sb.append(' ');
        }
        int len = sb.length();
        if (len > 0) {
            sb.setLength(len - 1);
        }
        return sb.toString().trim();
    }

    private static void escapeString(String s2, StringBuffer sb) {
        if (s2.length() == 0) {
            sb.append("\"\"");
            return;
        }
        boolean hasSpace = false;
        int sz = sb.length();
        int slen = s2.length();
        for (int i = 0; i < slen; ++i) {
            char c = s2.charAt(i);
            if (Character.isWhitespace(c)) {
                hasSpace = true;
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (c == '\"') {
                sb.append('\\').append('\"');
                continue;
            }
            sb.append(c);
        }
        if (hasSpace) {
            sb.insert(sz, '\"');
            sb.append('\"');
        }
    }

    public static <T> List<T> topologicalSort(Collection<? extends T> c, Map<? super T, ? extends Collection<? extends T>> edges) throws TopologicalSortException {
        HashMap finished = new HashMap();
        ArrayList r = new ArrayList(Math.max(c.size(), 1));
        ArrayList<T> cRev = new ArrayList<T>(c);
        Collections.reverse(cRev);
        Iterator it = cRev.iterator();
        while (it.hasNext()) {
            List<? super T> cycle = BaseUtilities.visit(it.next(), edges, finished, r);
            if (cycle == null) continue;
            throw new TopologicalSortException(cRev, edges);
        }
        Collections.reverse(r);
        if (r.size() != c.size()) {
            r.retainAll(c);
        }
        return r;
    }

    static <T> List<T> visit(T node, Map<? super T, ? extends Collection<? extends T>> edges, Map<T, Boolean> finished, List<T> r) {
        Boolean b = finished.get(node);
        if (b != null) {
            if (b.booleanValue()) {
                return null;
            }
            ArrayList<T> cycle = new ArrayList<T>();
            cycle.add(node);
            finished.put(node, null);
            return cycle;
        }
        Collection<T> e = edges.get(node);
        if (e != null) {
            finished.put(node, Boolean.FALSE);
            Iterator<T> it = e.iterator();
            while (it.hasNext()) {
                List<T> cycle = BaseUtilities.visit(it.next(), edges, finished, r);
                if (cycle == null) continue;
                if (cycle instanceof ArrayList) {
                    if (Boolean.FALSE == finished.get(node)) {
                        cycle.add(node);
                    } else {
                        Collections.reverse(cycle);
                        cycle = Collections.unmodifiableList(cycle);
                    }
                }
                finished.put(node, Boolean.TRUE);
                return cycle;
            }
        }
        finished.put(node, Boolean.TRUE);
        r.add(node);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String translate(String className) {
        RE exp;
        BaseUtilities.checkMapping();
        Object object = TRANS_LOCK;
        synchronized (object) {
            exp = transExp;
        }
        if (exp == null) {
            return className;
        }
        object = exp;
        synchronized (object) {
            return exp.convert(className);
        }
    }

    private static void checkMapping() {
        if (transLoader == TRANS_LOCK) {
            return;
        }
        ClassLoader current = Lookup.getDefault().lookup(ClassLoader.class);
        if (current == null) {
            current = ClassLoader.getSystemClassLoader();
        }
        if (transLoader == current) {
            return;
        }
        BaseUtilities.initForLoader(current, current);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initForLoader(ClassLoader current, Object set) {
        Enumeration<URL> en;
        if (set == null) {
            set = TRANS_LOCK;
        }
        try {
            en = current.getResources("META-INF/netbeans/translate.names");
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
            en = null;
        }
        if (en == null || !en.hasMoreElements()) {
            Object ex = TRANS_LOCK;
            synchronized (ex) {
                transLoader = set;
                transExp = null;
            }
            return;
        }
        RE13 re = null;
        re = new RE13();
        TreeSet<String[]> list = new TreeSet<String[]>(new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                int i2;
                String s1 = o1[0];
                String s2 = o2[0];
                int i1 = s1.length();
                if (i1 != (i2 = s2.length())) {
                    return i2 - i1;
                }
                return s2.compareTo(s1);
            }
        });
        while (en.hasMoreElements()) {
            URL u = en.nextElement();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(u.openStream(), "UTF8"));
                BaseUtilities.loadTranslationFile(re, reader, list);
                reader.close();
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, "Problematic file: {0}", u);
                LOG.log(Level.WARNING, null, ex);
            }
        }
        String[] arr = new String[list.size()];
        String[] pattern = new String[arr.length];
        int i = 0;
        for (String[] pair : list) {
            arr[i] = pair[1].intern();
            pattern[i] = pair[0];
            ++i;
        }
        Object object = TRANS_LOCK;
        synchronized (object) {
            if (arr.length == 0) {
                transExp = null;
            } else {
                transExp = re;
                transExp.init(pattern, arr);
            }
            transLoader = set;
        }
    }

    private static void loadTranslationFile(RE re, BufferedReader reader, Set<String[]> results) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0 || line.startsWith("#")) continue;
            String[] pair = re.readPair(line);
            if (pair == null) {
                throw new InvalidObjectException("Line is invalid: " + line);
            }
            results.add(pair);
        }
    }

    public static URI toURI(File f) {
        URI u;
        if (BaseUtilities.pathToURISupported()) {
            try {
                u = f.toPath().toUri();
            }
            catch (InvalidPathException ex) {
                u = f.toURI();
                LOG.log(Level.FINE, "can't convert " + f + " falling back to " + u, ex);
            }
        } else {
            u = f.toURI();
        }
        if (u.toString().startsWith("file:///")) {
            try {
                return new URI(u.getScheme(), u.getUserInfo(), u.getHost(), u.getPort(), u.getPath(), u.getQuery(), u.getFragment());
            }
            catch (URISyntaxException ex) {
                LOG.log(Level.FINE, "could not convert " + f + " to URI", ex);
            }
        }
        return u;
    }

    public static File toFile(URI u) throws IllegalArgumentException {
        try {
            return Paths.get(u).toFile();
        }
        catch (Exception x) {
            LOG.log(Level.FINE, "could not convert " + u + " to File", x);
            String host = u.getHost();
            if (host != null && !host.isEmpty() && "file".equals(u.getScheme())) {
                return new File("\\\\" + host + u.getPath().replace('/', '\\'));
            }
            return new File(u);
        }
    }

    public static URI normalizeURI(URI uri) {
        URI normalized = uri.normalize();
        if (uri.getAuthority() == null && "file".equals(uri.getScheme()) && uri.getPath().startsWith("//")) {
            try {
                normalized = new URI(normalized.getScheme(), null, "///" + normalized.getPath(), normalized.getQuery(), normalized.getFragment());
            }
            catch (URISyntaxException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return normalized;
    }

    private static boolean pathToURISupported() {
        Boolean res = pathURIConsistent;
        if (res == null) {
            boolean c;
            try {
                File f = new File("k\u00fc\u00f1");
                c = f.toPath().toUri().equals(f.toURI());
            }
            catch (InvalidPathException e) {
                c = false;
            }
            if (!c) {
                LOG.fine("The java.nio.file.Path.toUri is inconsistent with java.io.File.toURI");
            }
            res = pathURIConsistent = Boolean.valueOf(c);
        }
        return res;
    }

    static interface RE {
        public void init(String[] var1, String[] var2);

        public String convert(String var1);

        public String[] readPair(String var1);
    }
}

