/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openide.util.GlobalLookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public abstract class Lookup {
    private static final Logger LOG = Logger.getLogger("org.openide.util.lookup.init");
    public static final Lookup EMPTY = new Empty();
    private static Lookup defaultLookup;
    private static Provider defaultLookupProvider;

    public static synchronized Lookup getDefault() {
        Lookup gLpk = GlobalLookup.current();
        if (gLpk != null) {
            return gLpk;
        }
        if (defaultLookup != null || defaultLookupProvider != null) {
            Lookup lkp;
            if (defaultLookupProvider != null && (lkp = defaultLookupProvider.getLookup()) != null) {
                return lkp;
            }
            return defaultLookup;
        }
        LOG.log(Level.FINER, "About to initialize Lookup@{0}.getDefault() by {1}", new Object[]{Lookup.class.getClassLoader(), Thread.currentThread()});
        String className = System.getProperty("org.openide.util.Lookup");
        LOG.log(Level.FINER, "Specified by property? Value: {0}", className);
        if ("-".equals(className)) {
            return EMPTY;
        }
        ClassLoader l = Thread.currentThread().getContextClassLoader();
        LOG.log(Level.FINER, "Searching in classloader {0}", l);
        try {
            if (className != null) {
                Lookup lkp;
                Object o = Class.forName(className, true, l).newInstance();
                defaultLookup = (Lookup)o;
                GlobalLookup.setSystemLookup(defaultLookup);
                LOG.log(Level.FINE, "Default lookup initialized {0}", defaultLookup);
                if (o instanceof Provider && (lkp = (defaultLookupProvider = (Provider)o).getLookup()) != null) {
                    return lkp;
                }
                return defaultLookup;
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Constuction of " + className + " via " + l + " failed", e);
        }
        Lookup misl = Lookups.metaInfServices(l);
        defaultLookup = misl.lookup(Lookup.class);
        LOG.log(Level.FINER, "Searching for {0} in {1} yields {2}", new Object[]{Lookup.class, misl, defaultLookup});
        if (defaultLookup != null) {
            Lookup lkp;
            if (defaultLookup instanceof Provider && (lkp = (defaultLookupProvider = (Provider)((Object)defaultLookup)).getLookup()) != null) {
                return lkp;
            }
            LOG.log(Level.FINE, "Default lookup initialized {0}", defaultLookup);
            return defaultLookup;
        }
        Provider prov = misl.lookup(Provider.class);
        LOG.log(Level.FINER, "Searching for {0} in {1} yields {2}", new Object[]{Provider.class, misl, defaultLookup});
        if (prov != null) {
            defaultLookup = Lookups.proxy(prov);
            LOG.log(Level.FINE, "Default lookup initialized {0}", defaultLookup);
            return defaultLookup;
        }
        DefLookup def = new DefLookup();
        def.init(l, misl, false);
        defaultLookup = def;
        def.init(l, misl, true);
        LOG.log(Level.FINE, "Default lookup initialized {0}", defaultLookup);
        return defaultLookup;
    }

    private static synchronized void resetDefaultLookup() {
        if (defaultLookup == null || defaultLookup instanceof DefLookup) {
            DefLookup def = (DefLookup)defaultLookup;
            ClassLoader l = Thread.currentThread().getContextClassLoader();
            Lookup misl = Lookups.metaInfServices(l);
            if (def == null) {
                def = new DefLookup();
                def.init(l, misl, false);
                defaultLookup = def;
            }
            def.init(l, misl, true);
        }
    }

    public abstract <T> T lookup(Class<T> var1);

    public abstract <T> Result<T> lookup(Template<T> var1);

    public <T> Item<T> lookupItem(Template<T> template) {
        Result<T> res = this.lookup(template);
        Iterator<Item<T>> it = res.allItems().iterator();
        return it.hasNext() ? it.next() : null;
    }

    public <T> Result<T> lookupResult(Class<T> clazz) {
        return this.lookup(new Template<T>(clazz));
    }

    public <T> Collection<? extends T> lookupAll(Class<T> clazz) {
        return this.lookupResult(clazz).allInstances();
    }

    private static final class Empty
    extends Lookup {
        private static final Result NO_RESULT = new Result(){

            @Override
            public void addLookupListener(LookupListener l) {
            }

            @Override
            public void removeLookupListener(LookupListener l) {
            }

            public Collection allInstances() {
                return Collections.EMPTY_SET;
            }
        };

        Empty() {
        }

        @Override
        public <T> T lookup(Class<T> clazz) {
            return null;
        }

        @Override
        public <T> Result<T> lookup(Template<T> template) {
            return NO_RESULT;
        }
    }

    public static abstract class Item<T> {
        public abstract T getInstance();

        public abstract Class<? extends T> getType();

        public abstract String getId();

        public abstract String getDisplayName();

        public String toString() {
            return this.getId();
        }
    }

    public static abstract class Result<T> {
        public abstract void addLookupListener(LookupListener var1);

        public abstract void removeLookupListener(LookupListener var1);

        public abstract Collection<? extends T> allInstances();

        public Set<Class<? extends T>> allClasses() {
            return Collections.emptySet();
        }

        public Collection<? extends Item<T>> allItems() {
            return Collections.emptyList();
        }
    }

    public static final class Template<T> {
        private int hashCode;
        private Class<T> type;
        private String id;
        private T instance;

        @Deprecated
        public Template() {
            this(null);
        }

        public Template(Class<T> type) {
            this(type, null, null);
        }

        public Template(Class<T> type, String id, T instance) {
            this.type = this.extractType(type);
            this.id = id;
            this.instance = instance;
        }

        private Class<T> extractType(Class<T> type) {
            return type == null ? Object.class : type;
        }

        public Class<T> getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public T getInstance() {
            return this.instance;
        }

        public int hashCode() {
            if (this.hashCode != 0) {
                return this.hashCode;
            }
            this.hashCode = (this.type == null ? 1 : this.type.hashCode()) + (this.id == null ? 2 : this.id.hashCode()) + (this.instance == null ? 3 : 0);
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Template)) {
                return false;
            }
            Template t2 = (Template)obj;
            if (this.hashCode() != t2.hashCode()) {
                return false;
            }
            if (this.type != t2.type) {
                return false;
            }
            if (this.id == null ? t2.id != null : !this.id.equals(t2.id)) {
                return false;
            }
            if (this.instance == null) {
                return t2.instance == null;
            }
            return this.instance.equals(t2.instance);
        }

        public String toString() {
            return "Lookup.Template[type=" + this.type + ",id=" + this.id + ",instance=" + this.instance + "]";
        }
    }

    public static interface Provider {
        public Lookup getLookup();
    }

    private static final class DefLookup
    extends ProxyLookup {
        public DefLookup() {
            super(new Lookup[0]);
        }

        public void init(ClassLoader loader, Lookup metaInfLookup, boolean addPath) {
            Lookup clLookup = Lookups.singleton(loader);
            ArrayList<Lookup> arr = new ArrayList<Lookup>();
            arr.add(metaInfLookup);
            arr.add(clLookup);
            String paths = System.getProperty("org.openide.util.Lookup.paths");
            if (addPath && paths != null) {
                LOG.log(Level.FINE, "Adding search paths {0}", paths);
                for (String p : paths.split(":")) {
                    arr.add(Lookups.forPath(p));
                }
            }
            LOG.log(Level.FINER, "Setting DefLookup delegates {0}", arr);
            this.setLookups(arr.toArray(new Lookup[0]));
        }
    }
}

