/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.datatransfer;

import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import javax.swing.event.EventListenerList;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;

public abstract class ExClipboard
extends Clipboard {
    private EventListenerList listeners = new EventListenerList();

    public ExClipboard(String name) {
        super(name);
    }

    public final void addClipboardListener(ClipboardListener list) {
        this.listeners.add(ClipboardListener.class, list);
    }

    public final void removeClipboardListener(ClipboardListener list) {
        this.listeners.remove(ClipboardListener.class, list);
    }

    protected final void fireClipboardChange() {
        Object[] l = this.listeners.getListenerList();
        ClipboardEvent ev = null;
        for (int i = l.length - 2; i >= 0; i -= 2) {
            ClipboardListener list = (ClipboardListener)l[i + 1];
            if (ev == null) {
                ev = new ClipboardEvent(this);
            }
            list.clipboardChanged(ev);
        }
    }

    protected abstract Convertor[] getConvertors();

    public Transferable convert(Transferable t2) {
        Convertor[] convertors = this.getConvertors();
        for (int i = 0; i < convertors.length; ++i) {
            if (t2 == null) {
                return null;
            }
            t2 = convertors[i].convert(t2);
        }
        return t2;
    }

    public static void transferableAccepted(Transferable t2, int action) {
        if (t2 instanceof ExTransferable) {
            ((ExTransferable)t2).fireAccepted(action);
        } else if (t2.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t2.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                for (int i = 0; i < cnt; ++i) {
                    ExClipboard.transferableAccepted(mto.getTransferableAt(i), action);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void transferableRejected(Transferable t2) {
        if (t2 instanceof ExTransferable) {
            ((ExTransferable)t2).fireRejected();
        } else if (t2.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t2.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                for (int i = 0; i < cnt; ++i) {
                    ExClipboard.transferableRejected(mto.getTransferableAt(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContents(Transferable contents, ClipboardOwner owner) {
        ExClipboard exClipboard = this;
        synchronized (exClipboard) {
            if (this.contents != null) {
                ExClipboard.transferableOwnershipLost(this.contents);
            }
            final ClipboardOwner oldOwner = this.owner;
            final Transferable oldContents = this.contents;
            this.owner = owner;
            this.contents = contents;
            if (oldOwner != null && oldOwner != owner) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        oldOwner.lostOwnership(ExClipboard.this, oldContents);
                    }
                });
            }
        }
        FlavorEvent e = new FlavorEvent(this);
        this.fireClipboardChange();
        for (FlavorListener l : this.getFlavorListeners()) {
            l.flavorsChanged(e);
        }
    }

    public static void transferableOwnershipLost(Transferable t2) {
        if (t2 instanceof ExTransferable) {
            ((ExTransferable)t2).fireOwnershipLost();
        } else if (t2.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            try {
                MultiTransferObject mto = (MultiTransferObject)t2.getTransferData(ExTransferable.multiFlavor);
                int cnt = mto.getCount();
                for (int i = 0; i < cnt; ++i) {
                    ExClipboard.transferableOwnershipLost(mto.getTransferableAt(i));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface Convertor {
        public Transferable convert(Transferable var1);
    }
}

