/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes;

import com.github.weisj.jsvg.attributes.UnitType;
import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.geometry.util.GeometryUtil;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.Use;
import com.github.weisj.jsvg.nodes.container.ContainerNode;
import com.github.weisj.jsvg.nodes.prototype.ShapedContainer;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.nodes.text.Text;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.MaskedPaint;
import com.github.weisj.jsvg.renderer.Output;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.BlittableImage;
import com.github.weisj.jsvg.util.ImageUtil;
import com.github.weisj.jsvg.util.ShapeUtil;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={})
@PermittedContent(categories={Category.Animation, Category.Descriptive, Category.Shape}, anyOf={Use.class, Text.class})
public final class ClipPath
extends ContainerNode
implements ShapedContainer<SVGNode> {
    public static final String TAG = "clippath";
    private boolean isValid;
    private UnitType clipPathUnits;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.isValid = this.checkIsValid();
        this.clipPathUnits = attributeNode.getEnum("clipPathUnits", UnitType.UserSpaceOnUse);
    }

    private boolean checkIsValid() {
        for (SVGNode sVGNode : this.children()) {
            SVGNode referenced;
            if (!(sVGNode instanceof Use) || (referenced = ((Use)sVGNode).referencedNode()) == null || this.isAcceptableType(referenced)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Shape clipShape(@NotNull RenderContext context, @NotNull Rectangle2D elementBounds, boolean useSoftClip) {
        Area areaShape;
        Shape shape = ShapedContainer.super.elementShape(context);
        if (!useSoftClip && this.clipPathUnits == UnitType.ObjectBoundingBox) {
            shape = this.clipPathUnits.viewTransform(elementBounds).createTransformedShape(shape);
        }
        if ((areaShape = new Area(shape)).isRectangular()) {
            return areaShape.getBounds();
        }
        return areaShape;
    }

    @NotNull
    public Paint createPaintForSoftClipping(@NotNull Output output, @NotNull RenderContext context, @NotNull Rectangle2D objectBounds, @NotNull Shape clipShape) {
        Rectangle2D transformedClipBounds = GeometryUtil.containingBoundsAfterTransform(this.clipPathUnits.viewTransform(objectBounds), clipShape.getBounds());
        BlittableImage blitImage = BlittableImage.create(ImageUtil::createLuminosityBuffer, context, output.clipBounds(), transformedClipBounds, objectBounds, this.clipPathUnits);
        Rectangle2D clipBoundsInUserSpace = blitImage.boundsInUserSpace();
        if (ShapeUtil.isInvalidArea(clipBoundsInUserSpace)) {
            return PaintParser.DEFAULT_COLOR;
        }
        blitImage.render(output, g2 -> {
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, blitImage.image().getWidth(), blitImage.image().getHeight());
            g2.setColor(Color.WHITE);
            g2.fill(clipShape);
        });
        Point2D.Double offset = new Point2D.Double(clipBoundsInUserSpace.getX(), clipBoundsInUserSpace.getY());
        context.rootTransform().transform(offset, offset);
        return new MaskedPaint(PaintParser.DEFAULT_COLOR, blitImage.image().getRaster(), offset);
    }
}

