/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.swing.log;

import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Arrays;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.hironico.common.swing.SortedComboBoxModel;
import net.hironico.common.swing.log.SwingHandler;
import net.hironico.common.utils.StreamUtils;

public class LogPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(LogPanel.class.getName());
    private JPanel pnlTools = null;
    private JComboBox<String> cmbLogName = null;
    private JButton btnRefresh = null;
    private JComboBox<Level> cmbLogLevel = null;
    private JButton btnClear = null;
    private JScrollPane scrollLog = null;
    private JTextArea txtLog = null;
    private int maxRows = 5000;
    private SwingHandler swingHandler = null;

    public LogPanel() {
        this.initialize();
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
        this.getSwingHandler().setMaxRows(maxRows);
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.WHITE);
        this.add((Component)this.getPnlTools(), "North");
        this.add((Component)this.getScrollLog(), "Center");
    }

    private JPanel getPnlTools() {
        if (this.pnlTools == null) {
            this.pnlTools = new JPanel();
            this.pnlTools.setLayout(new FlowLayout(3));
            this.pnlTools.add(new JLabel("Logger name:"));
            this.pnlTools.add(this.getCmbLogName());
            this.pnlTools.add(this.getBtnRefresh());
            this.pnlTools.add(new JLabel("Log level:"));
            this.pnlTools.add(this.getCmbLogLevel());
            this.pnlTools.add(this.getBtnClear());
        }
        return this.pnlTools;
    }

    private JComboBox<String> getCmbLogName() {
        if (this.cmbLogName == null) {
            SortedComboBoxModel model = new SortedComboBoxModel();
            this.cmbLogName = new JComboBox(model);
            StreamUtils.stream(LogManager.getLogManager().getLoggerNames()).forEach(model::addElement);
            this.cmbLogName.addActionListener(actionEvent -> {
                String selectedLogName = (String)this.getCmbLogName().getSelectedItem();
                if (selectedLogName != null) {
                    Level level = Optional.ofNullable(Logger.getLogger(selectedLogName).getLevel()).orElse(LogManager.getLogManager().getLogger("").getLevel());
                    this.getCmbLogLevel().setSelectedItem(level);
                }
            });
        }
        return this.cmbLogName;
    }

    private JButton getBtnRefresh() {
        if (this.btnRefresh == null) {
            this.btnRefresh = new JButton("Refresh");
            this.btnRefresh.addActionListener(actionEvent -> {
                SortedComboBoxModel model = (SortedComboBoxModel)this.getCmbLogName().getModel();
                model.removeAllElements();
                StreamUtils.stream(LogManager.getLogManager().getLoggerNames()).forEach(model::addElement);
            });
        }
        return this.btnRefresh;
    }

    private JComboBox<Level> getCmbLogLevel() {
        if (this.cmbLogLevel == null) {
            this.cmbLogLevel = new JComboBox();
            Level[] standardLevels = new Level[]{Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
            Arrays.stream(standardLevels).forEach(level -> this.cmbLogLevel.addItem((Level)level));
            this.cmbLogLevel.addActionListener(actionEvent -> {
                String selectedLogName = (String)this.getCmbLogName().getSelectedItem();
                if (selectedLogName != null) {
                    Logger.getLogger(selectedLogName).setLevel((Level)this.getCmbLogLevel().getSelectedItem());
                }
            });
        }
        return this.cmbLogLevel;
    }

    private JButton getBtnClear() {
        if (this.btnClear == null) {
            this.btnClear = new JButton("Clear");
            this.btnClear.addActionListener(actionEvent -> this.getTxtLog().setText(""));
        }
        return this.btnClear;
    }

    protected JScrollPane getScrollLog() {
        if (this.scrollLog == null) {
            this.scrollLog = new JScrollPane(this.getTxtLog());
            this.scrollLog.setBorder(BorderFactory.createEmptyBorder());
        }
        return this.scrollLog;
    }

    protected JTextArea getTxtLog() {
        if (this.txtLog == null) {
            this.txtLog = new JTextArea();
            this.txtLog.setBorder(BorderFactory.createEmptyBorder());
            this.txtLog.setEditable(false);
            try {
                float fontSize = 11.0f;
                if (SystemInfo.isLinux) {
                    float f = fontSize = SystemInfo.isKDE ? 13.0f : 15.0f;
                }
                if (SystemInfo.isMacOS) {
                    fontSize = 13.0f;
                }
                float fontScaledSize = UIScale.scale(fontSize);
                Font font = new Font("Consolas", 0, (int)fontSize);
                Font scaledFont = font.deriveFont(fontScaledSize);
                this.txtLog.setFont(scaledFont);
            }
            catch (Exception ex) {
                LOGGER.severe("Cannot set font for Swing Logger !");
            }
            try {
                LogManager.getLogManager().getLogger("").addHandler(this.getSwingHandler());
            }
            catch (Exception ex) {
                LOGGER.severe("Cannot create LOG handler to swing!");
            }
        }
        return this.txtLog;
    }

    protected SwingHandler getSwingHandler() {
        if (this.swingHandler == null) {
            try {
                this.swingHandler = new SwingHandler(this.txtLog, this.maxRows);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return this.swingHandler;
    }
}

