/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.common.utils.log;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@JsonRootName(value="log")
public class LogConfig {
    @JsonProperty(value="filename")
    public String filename;
    @JsonProperty(value="level")
    public String level;
    @JsonProperty(value="pattern")
    public String pattern;

    public void apply() {
        LogConfig.setLogLevel(this.level);
        System.setProperty("java.util.logging.SimpleFormatter.format", this.pattern);
        ConsoleHandler logHandler = new ConsoleHandler();
        Logger.getAnonymousLogger().addHandler(logHandler);
        this.setFileHandler();
        LogConfig.setLogLevel(this.level);
    }

    private void setFileHandler() {
        if (this.filename != null) {
            return;
        }
        try {
            FileHandler fileHandler = new FileHandler(this.filename, 0xA00000, 10);
            Logger.getAnonymousLogger().addHandler(fileHandler);
            Logger.getAnonymousLogger().info("LOG file configured: " + this.filename);
        }
        catch (IOException | SecurityException ex) {
            Logger.getAnonymousLogger().log(Level.SEVERE, "Cannot create the log file handler.", ex);
        }
    }

    public static void setLogLevel(String logLevelArg) {
        try {
            Level level = Level.parse(logLevelArg.toUpperCase());
            if (level == null) {
                Logger.getAnonymousLogger().severe("Invalid log level: " + logLevelArg);
                return;
            }
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            rootLogger.setLevel(level);
            for (Handler h2 : rootLogger.getHandlers()) {
                h2.setLevel(level);
            }
        }
        catch (IllegalArgumentException iae) {
            Logger.getAnonymousLogger().severe("Invalid log level argument: " + logLevelArg);
        }
    }
}

