/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql;

import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.hironico.common.swing.ComponentMover;
import net.hironico.common.swing.ComponentResizer;
import net.hironico.common.utils.DynamicFileLoader;
import net.hironico.minisql.DbConfigFile;
import net.hironico.minisql.ui.MainWindow;

public class App {
    private static final Logger LOGGER = Logger.getLogger(App.class.getName());
    private static String version = null;
    public static MainWindow mainWindow;

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        version = "unknown!";
        try {
            Enumeration<URL> resources = App.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                Manifest manifest = new Manifest(resources.nextElement().openStream());
                LOGGER.fine(String.format("Manifest found: %s", manifest));
                manifest.getEntries().keySet().forEach(k -> LOGGER.fine(String.format("> %s", k)));
                Attributes attribs = manifest.getMainAttributes();
                if (attribs == null) continue;
                version = attribs.getValue("Hironico-Mini-SQL");
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Cannot read the version from the manifest.", ex);
        }
        return version;
    }

    private static void addDriversToClasspath() throws Exception {
        File dir = new File(".");
        LOGGER.info("Startup directory: " + dir.getAbsolutePath());
        FilenameFilter filter = (dir1, name) -> name.startsWith("ojdbc") && name.endsWith(".jar");
        for (String name2 : Objects.requireNonNull(dir.list(filter))) {
            File jarFile = new File(dir.getAbsolutePath() + File.separator + name2);
            LOGGER.info("Including file into classpath: " + jarFile.getAbsolutePath());
            DynamicFileLoader.addFile(jarFile);
        }
    }

    private static void loadConfig() {
        try {
            DbConfigFile.loadConfig();
        }
        catch (FileNotFoundException fne) {
            LOGGER.warning("Configuration file was not found. Never mind...");
        }
        catch (Throwable t2) {
            LOGGER.log(Level.SEVERE, "Error while loading config from file.", t2);
        }
    }

    private static void startGui() {
        SwingUtilities.invokeLater(() -> {
            try {
                UIManager.setLookAndFeel(new FlatLightLaf());
                if (SystemInfo.isLinux) {
                    JFrame.setDefaultLookAndFeelDecorated(false);
                    JDialog.setDefaultLookAndFeelDecorated(false);
                }
                if (SystemInfo.isMacOS) {
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                    System.setProperty("apple.awt.application.name", "My Application");
                    System.setProperty("apple.awt.application.appearance", "system");
                }
                UIManager.put("TabbedPane.selectedBackground", Color.white);
            }
            catch (Throwable t2) {
                LOGGER.log(Level.SEVERE, "Unable to set the windows look and feel...");
            }
            mainWindow = MainWindow.getInstance();
            mainWindow.setVisible(true);
            mainWindow.setPreferredSize(new Dimension(1024, 768));
            mainWindow.setSize(1024, 768);
            if (mainWindow.isUndecorated()) {
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                final Rectangle screenBounds = env.getMaximumWindowBounds();
                ComponentResizer cr = new ComponentResizer();
                cr.setMinimumSize(new Dimension(1024, 768));
                cr.setMaximumSize(new Dimension(screenBounds.width, screenBounds.height));
                cr.registerComponent(mainWindow);
                cr.setSnapSize(new Dimension(10, 10));
                ComponentMover cm = new ComponentMover(mainWindow, mainWindow.getRibbon());
                mainWindow.getRibbon().addMouseListener(new MouseAdapter(){
                    final Rectangle oldBounds = new Rectangle(0, 0, 1024, 768);

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() >= 2) {
                            int width = App.mainWindow.getSize().width;
                            int height = App.mainWindow.getSize().height;
                            int x = mainWindow.getX();
                            int y = mainWindow.getY();
                            if (width < screenBounds.width && height < screenBounds.height) {
                                this.oldBounds.x = x;
                                this.oldBounds.y = y;
                                this.oldBounds.width = width;
                                this.oldBounds.height = height;
                                mainWindow.setBounds(screenBounds);
                            } else {
                                mainWindow.setBounds(this.oldBounds);
                            }
                        }
                    }
                });
            }
        });
    }

    public static void main(String[] args) {
        String logFormat = "%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS %4$-7s %2$s %5$s%6$s%n";
        System.setProperty("java.util.logging.SimpleFormatter.format", logFormat);
        try {
            App.addDriversToClasspath();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Cannot add jar files to classpath.", ex);
        }
        System.setProperty("apple.awt.application.name", "Mini SQL");
        App.loadConfig();
        App.startGui();
    }
}

