/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ctrl;

import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hironico.minisql.DbConfig;
import net.hironico.minisql.model.SQLObject;
import net.hironico.minisql.model.SQLObjectTypeEnum;
import net.hironico.minisql.model.SQLResultSetTableModel;

public class MetadataResultCallable
implements Callable<List<SQLResultSetTableModel>> {
    private static final Logger LOGGER = Logger.getLogger(MetadataResultCallable.class.getName());
    private final String schemaName;
    private final String objectName;
    private final SQLObjectTypeEnum objectType;
    private final DbConfig config;

    public MetadataResultCallable(SQLObject obj, DbConfig config) {
        this(obj.schemaName, obj.name, obj.type, config);
    }

    public MetadataResultCallable(String schemaName, String objectName, SQLObjectTypeEnum objectType, DbConfig config) {
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.objectType = objectType;
        this.config = config;
    }

    private SQLResultSetTableModel getTableColumns(DatabaseMetaData metaData) throws SQLException {
        try (ResultSet resultSet = metaData.getColumns(null, this.schemaName, this.objectName, null);){
            SQLResultSetTableModel sQLResultSetTableModel = new SQLResultSetTableModel(resultSet, "Columns", "N/A", 2);
            return sQLResultSetTableModel;
        }
    }

    private SQLResultSetTableModel getTableIndexes(DatabaseMetaData metaData) throws SQLException {
        try (ResultSet result = metaData.getIndexInfo(null, this.schemaName, this.objectName, false, false);){
            SQLResultSetTableModel sQLResultSetTableModel = new SQLResultSetTableModel(result, "Index(es)", "N/A", 2);
            return sQLResultSetTableModel;
        }
    }

    private SQLResultSetTableModel getTablePrivileges(DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getTablePrivileges(null, this.schemaName, this.objectName);){
            SQLResultSetTableModel sQLResultSetTableModel = new SQLResultSetTableModel(rs, "Grants", "N/A", 2);
            return sQLResultSetTableModel;
        }
    }

    private SQLResultSetTableModel geTableForeignKeys(DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getImportedKeys(null, this.schemaName, this.objectName);){
            SQLResultSetTableModel sQLResultSetTableModel = new SQLResultSetTableModel(rs, "Foreign keys", "N/A", 2);
            return sQLResultSetTableModel;
        }
    }

    private SQLResultSetTableModel getProcedureColumns(DatabaseMetaData metaData) throws SQLException {
        try (ResultSet rs = metaData.getProcedureColumns(null, this.schemaName, this.objectName, null);){
            SQLResultSetTableModel sQLResultSetTableModel = new SQLResultSetTableModel(rs, "Columns", "N/A", 2);
            return sQLResultSetTableModel;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<SQLResultSetTableModel> call() {
        ArrayList<SQLResultSetTableModel> result = new ArrayList<SQLResultSetTableModel>();
        try (Connection con = this.config.getConnection();){
            DatabaseMetaData metaData = con.getMetaData();
            switch (this.objectType) {
                case TABLE: 
                case MATERIALIZED_VIEW: {
                    SQLResultSetTableModel resultTableCols = this.getTableColumns(metaData);
                    result.add(resultTableCols);
                    SQLResultSetTableModel resultIndexes = this.getTableIndexes(metaData);
                    result.add(resultIndexes);
                    SQLResultSetTableModel resultPriv = this.getTablePrivileges(metaData);
                    result.add(resultPriv);
                    SQLResultSetTableModel resultFK = this.geTableForeignKeys(metaData);
                    result.add(resultFK);
                    return result;
                }
                case VIEW: {
                    SQLResultSetTableModel resultViewCols = this.getTableColumns(metaData);
                    result.add(resultViewCols);
                    SQLResultSetTableModel resultViewPriv = this.getTablePrivileges(metaData);
                    result.add(resultViewPriv);
                    return result;
                }
                case PROCEDURE: {
                    SQLResultSetTableModel resultProc = this.getProcedureColumns(metaData);
                    result.add(resultProc);
                    return result;
                }
            }
            return result;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException | SQLException sqle) {
            LOGGER.log(Level.SEVERE, "SAQ Exception occurred while loading driver.", sqle);
            throw new RuntimeException(sqle);
        }
    }
}

