/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ctrl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.hironico.minisql.DbConfig;

public class SchemaListCallable
implements Callable<List<String>>,
Supplier<List<String>> {
    private static final Logger LOGGER = Logger.getLogger(SchemaListCallable.class.getName());
    private final DbConfig configToUse;

    public SchemaListCallable(DbConfig configToUse) {
        this.configToUse = configToUse;
    }

    @Override
    public List<String> call() {
        ArrayList<String> result = new ArrayList<String>();
        try (Connection con = this.configToUse.getConnection();
             ResultSet rs = con.getMetaData().getSchemas();){
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        catch (Throwable t2) {
            String msg = "Error while getting the table list. See log." + t2.getMessage();
            result.add(msg);
            LOGGER.log(Level.SEVERE, msg, t2);
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public List<String> get() {
        return this.call();
    }
}

