/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.editor.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import net.hironico.common.swing.ribbon.AbstractRibbonAction;
import net.hironico.minisql.ui.MainWindow;
import net.hironico.minisql.ui.editor.QueryPanel;

public class SaveQueryAction
extends AbstractRibbonAction {
    private static final long serialVersionUID = 1L;

    public SaveQueryAction() {
        super("Save...", "icons8_save_as_64px.png");
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Component comp = MainWindow.getInstance().getCurrentTabComponent();
        QueryPanel queryPanel = null;
        if (comp == null || !(comp instanceof QueryPanel)) {
            return;
        }
        queryPanel = (QueryPanel)comp;
        JFileChooser chooser = new JFileChooser(queryPanel.getLastUserDirectory());
        int resp = chooser.showSaveDialog(queryPanel);
        if (resp == 0) {
            int confirm;
            String lastDir = chooser.getSelectedFile().getAbsolutePath();
            queryPanel.setLastUsedDirectory(lastDir);
            File saveFile = chooser.getSelectedFile();
            if (saveFile.exists() && (confirm = JOptionPane.showConfirmDialog(queryPanel, "File exists. Overwrite ?", "Confirm...", 0)) != 0) {
                return;
            }
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(saveFile));){
                bw.write(queryPanel.getTxtQuery().getText());
                bw.flush();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(queryPanel, "Error while writing to the file:\n" + ex.getMessage(), "Error", 0);
            }
        }
    }
}

