/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.editor.ribbon;

import net.hironico.common.swing.ribbon.RibbonGroup;
import net.hironico.common.swing.ribbon.RibbonTab;
import net.hironico.minisql.ui.ExecuteBatchQueryAction;
import net.hironico.minisql.ui.ExecuteQueryAction;
import net.hironico.minisql.ui.editor.action.CheckSQLAction;
import net.hironico.minisql.ui.editor.action.CopyAction;
import net.hironico.minisql.ui.editor.action.CutAction;
import net.hironico.minisql.ui.editor.action.PasteAction;
import net.hironico.minisql.ui.editor.action.RedoAction;
import net.hironico.minisql.ui.editor.action.UndoAction;
import net.hironico.minisql.ui.editor.ribbon.FileRibbonGroup;

public class EditorRibbonTab
extends RibbonTab {
    private RibbonGroup fileRibbonGroup = null;
    private RibbonGroup clipBoardRibbonGroup = null;
    private RibbonGroup undoRedoRibbonGroup = null;
    private RibbonGroup executeRibbonGroup = null;

    public EditorRibbonTab() {
        super("Editor");
        this.addGroup(this.getFileRibbonGroup());
        this.addGroup(this.getUndoRedoRibbonGroup());
        this.addGroup(this.getClipboardRibbonGroup());
        this.addGroup(this.getExecuteRibbonGroup());
    }

    private RibbonGroup getFileRibbonGroup() {
        if (this.fileRibbonGroup == null) {
            this.fileRibbonGroup = new FileRibbonGroup();
        }
        return this.fileRibbonGroup;
    }

    private RibbonGroup getClipboardRibbonGroup() {
        if (this.clipBoardRibbonGroup == null) {
            this.clipBoardRibbonGroup = new RibbonGroup("Clipboard");
            this.clipBoardRibbonGroup.addButton(new PasteAction(), 3);
            this.clipBoardRibbonGroup.addButton(new CopyAction(), 0);
            this.clipBoardRibbonGroup.addButton(new CutAction(), 0);
        }
        return this.clipBoardRibbonGroup;
    }

    private RibbonGroup getUndoRedoRibbonGroup() {
        if (this.undoRedoRibbonGroup == null) {
            this.undoRedoRibbonGroup = new RibbonGroup("Undo/Redo");
            this.undoRedoRibbonGroup.addButton(new UndoAction(), 0);
            this.undoRedoRibbonGroup.addButton(new RedoAction(), 0);
        }
        return this.undoRedoRibbonGroup;
    }

    private RibbonGroup getExecuteRibbonGroup() {
        if (this.executeRibbonGroup == null) {
            this.executeRibbonGroup = new RibbonGroup("Execute");
            this.executeRibbonGroup.addButton(new ExecuteQueryAction(), 3);
            this.executeRibbonGroup.addButton(new ExecuteBatchQueryAction(), 3);
            this.executeRibbonGroup.addButton(new CheckSQLAction(), 3);
        }
        return this.executeRibbonGroup;
    }
}

