/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.history;

import java.util.Date;
import javax.swing.table.DefaultTableModel;
import net.hironico.minisql.ui.history.QueryHistory;
import net.hironico.minisql.ui.history.QueryHistoryEntry;
import net.hironico.minisql.ui.history.QueryHistoryListener;

public class QueryHistoryTableModel
extends DefaultTableModel
implements QueryHistoryListener {
    public QueryHistoryTableModel() {
        Object[] colNames = new String[]{"Timestamp", "SQL"};
        this.setColumnIdentifiers(colNames);
        QueryHistory history = QueryHistory.getInstance();
        history.addQueryHistoryListener(this);
        this.setQueryHistory(history);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Date.class;
            }
            case 1: {
                return String.class;
            }
        }
        return Object.class;
    }

    public void setQueryHistory(QueryHistory history) {
        while (this.getRowCount() > 1) {
            this.removeRow(0);
        }
        history.getSQLHistory().stream().map(h2 -> {
            Object[] row = new Object[]{h2.timestamp, h2.query};
            return row;
        }).forEach(this::addRow);
    }

    @Override
    public void queryAdded(QueryHistoryEntry query) {
        Object[] row = new Object[]{query.timestamp, query.query};
        this.insertRow(0, QueryHistoryTableModel.convertToVector(row));
    }

    @Override
    public void queryRemoved(QueryHistoryEntry query) {
    }
}

