/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.renderer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class RowHighlightRenderer
implements TableCellRenderer {
    private TableCellRenderer delegate;
    private final Color bgColorOdd = new Color(237, 243, 254);

    public RowHighlightRenderer(TableCellRenderer delegate) {
        assert (delegate != null);
        this.delegate = delegate;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component delegateComp = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            Color bgColor = row % 2 == 0 ? this.bgColorOdd : Color.WHITE;
            int sum = bgColor.getRed() + bgColor.getGreen() + bgColor.getBlue();
            Color fgColor = delegateComp.getForeground();
            if ((sum /= 128) < 3) {
                fgColor = Color.WHITE;
            }
            if (value == null) {
                int rgb = bgColor.getRGB() & 0xFFFFC8;
                bgColor = new Color(rgb);
            }
            delegateComp.setBackground(bgColor);
            delegateComp.setForeground(fgColor);
        }
        return delegateComp;
    }
}

