/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.visualdb;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.api.visual.border.Border;

class DbGraphNodeBorder
implements Border {
    private final Color colorBorder;
    private final Insets insets;
    private final Stroke stroke;
    private final Color color1;
    private final Color color2;

    public DbGraphNodeBorder(Color colorBorder, int thickness, Color color1, Color color2) {
        this.colorBorder = colorBorder;
        this.insets = new Insets(thickness, thickness, thickness, thickness);
        this.stroke = new BasicStroke(thickness);
        this.color1 = color1;
        this.color2 = color2;
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void paint(Graphics2D gr, Rectangle bounds) {
        Shape previousClip = gr.getClip();
        gr.clip(new RoundRectangle2D.Float(bounds.x, bounds.y, bounds.width, bounds.height, 4.0f, 4.0f));
        this.drawGradient(gr, bounds, this.color1, this.color2, 0.0f, 1.0f);
        gr.setColor(this.colorBorder);
        Stroke previousStroke = gr.getStroke();
        gr.setStroke(this.stroke);
        gr.draw(new RoundRectangle2D.Float((float)bounds.x + 0.5f, (float)bounds.y + 0.5f, bounds.width - 1, bounds.height - 1, 4.0f, 4.0f));
        gr.setStroke(previousStroke);
        gr.setClip(previousClip);
    }

    private void drawGradient(Graphics2D gr, Rectangle bounds, Color color1, Color color2, float y1, float y2) {
        y1 = (float)bounds.y + y1 * (float)bounds.height;
        y2 = (float)bounds.y + y2 * (float)bounds.height;
        gr.setPaint(new GradientPaint(bounds.x, y1, color1, bounds.x, y2, color2));
        gr.fill(new Rectangle2D.Float(bounds.x, y1, bounds.x + bounds.width, y2));
    }

    @Override
    public boolean isOpaque() {
        return true;
    }
}

