/*
 * Decompiled with CFR 0.152.
 */
package net.hironico.minisql.ui.visualdb;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import net.hironico.minisql.ui.visualdb.DBGraphScene;
import org.jdesktop.jxlayer.JXLayer;
import org.jdesktop.jxlayer.plaf.AbstractLayerUI;
import org.netbeans.api.visual.vmd.VMDGraphScene;
import org.netbeans.api.visual.widget.Scene;

public class SatelliteUI
extends AbstractLayerUI<JComponent>
implements Scene.SceneListener,
ComponentListener {
    protected VMDGraphScene graphScene = null;
    protected boolean satelliteVisible = false;
    protected Dimension size = new Dimension(150, 150);
    protected Point location = new Point(0, 0);

    public SatelliteUI(DBGraphScene graphScene) {
        this.graphScene = graphScene;
        this.addNotify();
    }

    public void addNotify() {
        this.graphScene.addSceneListener(this);
        JComponent viewComponent = this.graphScene.getView();
        if (viewComponent == null) {
            viewComponent = this.graphScene.createView();
        }
        viewComponent.addComponentListener(this);
    }

    public void removeNotify() {
        this.graphScene.getView().removeComponentListener(this);
        this.graphScene.removeSceneListener(this);
    }

    public boolean isSatelliteVisible() {
        return this.satelliteVisible;
    }

    public void setSatellitevisible(boolean satelliteVisible) {
        this.satelliteVisible = satelliteVisible;
        this.graphScene.repaint();
    }

    @Override
    protected void paintLayer(Graphics2D g2, JXLayer<? extends JComponent> layer) {
        super.paintLayer(g2, layer);
        if (this.satelliteVisible) {
            Rectangle viewRectangle;
            Rectangle bounds = this.graphScene.getBounds();
            if (bounds == null) {
                return;
            }
            double sx = bounds.width > 0 ? (double)this.size.width / (double)bounds.width : 0.0;
            double sy = bounds.width > 0 ? (double)this.size.height / (double)bounds.height : 0.0;
            double scale = Math.min(sx, sy);
            int vw = (int)(scale * (double)bounds.width);
            int vh = (int)(scale * (double)bounds.height);
            this.location.x = layer.getView().getWidth() - this.size.width - 1;
            this.location.y = 0;
            g2.setColor(Color.lightGray);
            g2.fillRect(this.location.x, this.location.y, this.location.x + this.size.width - 1, this.location.y + this.size.height - 1);
            AffineTransform previousTransform = g2.getTransform();
            g2.translate(this.location.x, this.location.y);
            g2.scale(scale, scale);
            this.graphScene.paint(g2);
            g2.setTransform(previousTransform);
            JComponent component = this.graphScene.getView();
            double zoomFactor = this.graphScene.getZoomFactor();
            Rectangle rectangle = viewRectangle = component != null ? component.getVisibleRect() : null;
            if (viewRectangle != null) {
                Rectangle window = new Rectangle((int)((double)viewRectangle.x * scale / zoomFactor), (int)((double)viewRectangle.y * scale / zoomFactor), (int)((double)viewRectangle.width * scale / zoomFactor), (int)((double)viewRectangle.height * scale / zoomFactor));
                window.translate(this.location.x, this.location.y);
                g2.setColor(new Color(200, 200, 200, 128));
                g2.fill(window);
                g2.setColor(Color.BLACK);
                g2.drawRect(window.x, window.y, window.width - 1, window.height - 1);
            }
            BorderFactory.createEtchedBorder().paintBorder(layer, g2, this.location.x, this.location.y, this.location.x + this.size.width - 1, this.location.y + this.size.height - 1);
        }
    }

    @Override
    public void processMouseEvent(MouseEvent e, JXLayer<? extends JComponent> layer) {
        if (e.getSource() != this.graphScene.getView()) {
            return;
        }
        if (!this.satelliteVisible) {
            return;
        }
        if (e.getButton() == 0) {
            return;
        }
        Rectangle visibleRect = this.graphScene.getView().getVisibleRect();
        int x = e.getX() - visibleRect.x;
        int y = e.getY() - visibleRect.y;
        if (x >= this.location.x && x <= this.location.x + this.size.width && y >= this.location.y && y <= this.location.y + this.size.height) {
            this.moveVisibleRect(new Point(x, y));
            e.consume();
        } else {
            this.setSatellitevisible(false);
        }
    }

    @Override
    public void processMouseMotionEvent(MouseEvent e, JXLayer<? extends JComponent> layer) {
        if (e.getSource() != this.graphScene.getView()) {
            return;
        }
        if (!this.satelliteVisible) {
            return;
        }
        Rectangle visibleRect = this.graphScene.getView().getVisibleRect();
        int x = e.getX() - visibleRect.x;
        int y = e.getY() - visibleRect.y;
        if (x >= this.location.x && x <= this.location.x + this.size.width && y >= this.location.y && y <= this.location.y + this.size.height) {
            if ((e.getModifiersEx() & 0x1F5) > 0) {
                this.moveVisibleRect(new Point(x, y));
            }
            e.consume();
        }
    }

    private void moveVisibleRect(Point center) {
        JComponent component = this.graphScene.getView();
        if (component == null) {
            return;
        }
        double zoomFactor = this.graphScene.getZoomFactor();
        Rectangle bounds = this.graphScene.getBounds();
        if (bounds == null) {
            return;
        }
        double sx = bounds.width > 0 ? (double)this.size.width / (double)bounds.width : 0.0;
        double sy = bounds.width > 0 ? (double)this.size.height / (double)bounds.height : 0.0;
        double scale = Math.min(sx, sy);
        int vw = (int)(scale * (double)bounds.width);
        int vh = (int)(scale * (double)bounds.height);
        int vx = this.location.x;
        int vy = this.location.y;
        int cx = (int)((double)(center.x - vx) / scale * zoomFactor);
        int cy = (int)((double)(center.y - vy) / scale * zoomFactor);
        Rectangle visibleRect = component.getVisibleRect();
        visibleRect.x = cx - visibleRect.width / 2;
        visibleRect.y = cy - visibleRect.height / 2;
        component.scrollRectToVisible(visibleRect);
    }

    @Override
    public void sceneRepaint() {
        this.setDirty(true);
    }

    @Override
    public void sceneValidating() {
    }

    @Override
    public void sceneValidated() {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setDirty(true);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.setDirty(true);
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

