/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.babelfish;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.jdbc.OracleStatement;
import oracle.jdbc.babelfish.BabelfishGenericProxy;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.GetProxy;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.ProxyFor;

@ProxyFor(value={OracleStatement.class, Statement.class})
public abstract class BabelfishStatement
extends BabelfishGenericProxy {
    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @GetProxy
    protected abstract Object proxify(Object var1, Object var2);

    @Override
    @OnError(value=SQLException.class)
    protected Object translateError(Method m4, SQLException ex) throws SQLException {
        throw this.translator.translateError(ex);
    }

    @Override
    @Post
    protected Object post_Methods(Method m4, Object result) {
        if (result instanceof BabelfishGenericProxy) {
            ((BabelfishGenericProxy)result).setTranslator(this.translator);
        }
        return result;
    }

    public void addBatch(String sql) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            ((Statement)this.getDelegate()).addBatch(translatedSql);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public boolean execute(String sql) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Statement)this.getDelegate()).execute(translatedSql);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Statement)this.getDelegate()).execute(translatedSql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Statement)this.getDelegate()).execute(translatedSql, columnIndexes);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Statement)this.getDelegate()).execute(translatedSql, columnNames);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            ResultSet rs = (ResultSet)this.proxify(((Statement)this.getDelegate()).executeQuery(translatedSql), this);
            ((BabelfishGenericProxy)((Object)rs)).setTranslator(this.translator);
            return rs;
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Statement)this.getDelegate()).executeUpdate(translatedSql);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Statement)this.getDelegate()).executeUpdate(translatedSql, autoGeneratedKeys);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Statement)this.getDelegate()).executeUpdate(translatedSql, columnIndexes);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            String translatedSql = this.translator.translateQuery(sql);
            return ((Statement)this.getDelegate()).executeUpdate(translatedSql, columnNames);
        }
        catch (SQLException ex) {
            throw this.translator.translateError(ex);
        }
    }
}

