/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import oracle.jdbc.diagnostics.ImmutableTraceAttributes;
import oracle.jdbc.diagnostics.OracleDiagnosticPermission;
import oracle.jdbc.diagnostics.OracleLogRecord;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.diagnostics.TraceAttributes;
import oracle.jdbc.diagnostics.TraceMemoryHandler;
import oracle.jdbc.driver.BuildInfo;
import oracle.jdbc.driver.GeneratedPhysicalConnection;

public class Diagnostic {
    private static final OracleDiagnosticPermission ENABLE_SENSITIVE_PERMISSION = new OracleDiagnosticPermission("enable_sensitive");
    private static final AtomicLong MILLIS = new AtomicLong(System.currentTimeMillis());
    private static final Timer CLOCK = new Timer("oracle.jdbc.diagnostics.Diagnostic.CLOCK", true);
    private static final String CLASS_NAME;
    private final Properties additionalConfig = new Properties();
    private static final Set<Integer> DEFAULT_ERROR_CODES;
    private static final Set<String> DEFAULT_ERROR_CODES_AS_STRINGS;
    private static final Set<Integer> errorCodesWatchedForDiagnoseFirstFailureDump;
    private static final Set<String> keywordsToSearchInException;
    private static final String ORA_ERROR_CODE_PREFIX = "ORA-";
    static final Properties SYSTEM_CONFIG;
    private static final Function<String, Boolean> IS_EXCEPTION_CONTAINS_KEYWORDS;
    private final AtomicBoolean isSensitiveEnabled = new AtomicBoolean(false);
    private boolean isAutomaticDiagnoseFirstFailureDumpEnabled = true;
    private final Logger debugLogger;
    private final String loggerName;
    private Handler diagnoseFirstFailureTargetHandler;
    private AtomicReference<TraceMemoryHandler> diagnoseFirstFailureHandler;
    private static final Level DEFAULT_PUSH_LEVEL;
    private ResourceBundle resourceBundle = null;

    public static Diagnostic get(String loggerName, int size) {
        return new Diagnostic(loggerName, size);
    }

    protected Diagnostic(String loggerName, int recordsCount) {
        Handler h2;
        Logger l;
        assert (loggerName != null && recordsCount > 0);
        this.loggerName = loggerName;
        for (l = this.debugLogger = Logger.getLogger(loggerName); l != null && l.getHandlers().length == 0; l = l.getParent()) {
        }
        Handler handler = h2 = l == null ? null : l.getHandlers()[0];
        if (h2 == null) {
            return;
        }
        this.diagnoseFirstFailureTargetHandler = h2;
        this.diagnoseFirstFailureHandler = new AtomicReference<TraceMemoryHandler>(new TraceMemoryHandler(this.diagnoseFirstFailureTargetHandler, recordsCount, DEFAULT_PUSH_LEVEL));
    }

    public void addConfig(Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.additionalConfig.setProperty((String)k, (String)v)));
    }

    public final void enableSensitive(boolean enabled) {
        SecurityManager securityManager;
        if (enabled && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(ENABLE_SENSITIVE_PERMISSION);
        }
        this.isSensitiveEnabled.set(enabled);
    }

    public boolean isSensitiveEnabled() {
        return this.isSensitiveEnabled.get();
    }

    public void enableDiagnoseFirstFailureDump(boolean enableDump) {
        this.isAutomaticDiagnoseFirstFailureDumpEnabled = enableDump;
    }

    public <T extends Throwable> T trace(Level level, SecurityLabel label, String sourceClass, String sourceMethod, TraceAttributes attributes, T thrown, String publicMessage, String sensitiveMessage, Object ... params) {
        if (this.diagnoseFirstFailureHandler == null) {
            return null;
        }
        if (level.intValue() >= DEFAULT_PUSH_LEVEL.intValue()) {
            Properties properties = (Properties)SYSTEM_CONFIG.clone();
            properties.put("DriverVersion", BuildInfo.getDriverVersion());
            this.additionalConfig.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.setProperty((String)k, (String)v)));
            OracleLogRecord configRecord = this.buildAndGetLogRecord(Level.CONFIG, label, CLASS_NAME, "trace", null, null, "properties={0}. ", null, GeneratedPhysicalConnection.CONNECTION_PROPERTIES_BLINDER.blind(properties));
            this.diagnoseFirstFailureHandler.get().publish(configRecord);
        }
        OracleLogRecord logRecord = this.buildAndGetLogRecord(level, label, sourceClass, sourceMethod, attributes, thrown, publicMessage, sensitiveMessage, params);
        this.diagnoseFirstFailureHandler.get().publish(logRecord);
        if (level.intValue() < DEFAULT_PUSH_LEVEL.intValue() && thrown instanceof SQLException && (errorCodesWatchedForDiagnoseFirstFailureDump.contains(((SQLException)thrown).getErrorCode()) || IS_EXCEPTION_CONTAINS_KEYWORDS.apply(thrown.getMessage()).booleanValue()) && this.isAutomaticDiagnoseFirstFailureDumpEnabled) {
            this.dumpDiagnoseFirstFailure(true);
        }
        return thrown;
    }

    public <T extends Throwable> T debug(Level level, SecurityLabel label, String sourceClass, String sourceMethod, TraceAttributes attributes, T thrown, String publicMessage, String sensitiveMessage, Object ... params) {
        OracleLogRecord logRecord = this.buildAndGetLogRecord(level, label, sourceClass, sourceMethod, attributes, thrown, publicMessage, sensitiveMessage, params);
        this.debugLogger.log(logRecord);
        return thrown;
    }

    private OracleLogRecord buildAndGetLogRecord(Level level, SecurityLabel label, String sourceClass, String sourceMethod, TraceAttributes attributes, Throwable thrown, String publicMessage, String sensitiveMessage, Object ... params) {
        ImmutableTraceAttributes immutableTraceAttributes = attributes != null ? attributes.toReadOnly() : null;
        String message = this.isSensitiveEnabled.get() && sensitiveMessage != null ? sensitiveMessage : publicMessage;
        OracleLogRecord record = new OracleLogRecord(level, label, immutableTraceAttributes, message);
        record.setMillis(MILLIS.getAndIncrement());
        record.setLoggerName(this.loggerName);
        if (message != null) {
            record.setParameters(params);
        }
        record.setResourceBundle(this.resourceBundle);
        record.setSourceClassName(sourceClass);
        record.setSourceMethodName(sourceMethod);
        record.setThreadID((int)Thread.currentThread().getId());
        record.setThrown(thrown);
        return record;
    }

    public void setLoggingLevel(String newLevel) {
        this.debugLogger.setLevel(Level.parse(newLevel));
    }

    boolean isLoggable(Level level) {
        return this.debugLogger.isLoggable(level);
    }

    protected static void addErrorCodeToWatchList(String errorCode) {
        String errCode = errorCode.trim().toUpperCase();
        if (errCode.startsWith(ORA_ERROR_CODE_PREFIX)) {
            String errNum = errCode.substring(ORA_ERROR_CODE_PREFIX.length());
            errorCodesWatchedForDiagnoseFirstFailureDump.add(Integer.parseInt(errNum));
        }
    }

    protected static void removeErrorCodeFromWatchList(String errorCode) {
        String errCode = errorCode.trim().toUpperCase();
        if (errCode.startsWith(ORA_ERROR_CODE_PREFIX)) {
            String errNum = errCode.substring(ORA_ERROR_CODE_PREFIX.length());
            errorCodesWatchedForDiagnoseFirstFailureDump.remove(Integer.parseInt(errNum));
        }
    }

    protected static String getErrorCodesWatchList() {
        return errorCodesWatchedForDiagnoseFirstFailureDump.stream().map(value -> ORA_ERROR_CODE_PREFIX + value).collect(Collectors.joining(","));
    }

    protected static void resetErrorCodeWatchList() {
        errorCodesWatchedForDiagnoseFirstFailureDump.clear();
        errorCodesWatchedForDiagnoseFirstFailureDump.addAll(DEFAULT_ERROR_CODES);
    }

    public void setDiagnoseFirstFailureBufferSize(int bufferSize) {
        if (this.diagnoseFirstFailureHandler == null) {
            return;
        }
        this.diagnoseFirstFailureHandler.get().push();
        TraceMemoryHandler previous = this.diagnoseFirstFailureHandler.get();
        this.diagnoseFirstFailureHandler.set(new TraceMemoryHandler(this.diagnoseFirstFailureTargetHandler, bufferSize, Level.WARNING));
        previous.flush();
    }

    protected static void dumpDiagnoseFirstFailureWhenNextExceptionContains(String commaSeparatedKeywords) {
        keywordsToSearchInException.addAll(Stream.of(commaSeparatedKeywords.split(",")).map(String::trim).map(String::toLowerCase).collect(Collectors.toSet()));
    }

    protected static String getExceptionKeywords() {
        return String.join((CharSequence)",", keywordsToSearchInException);
    }

    protected static void clearExceptionKeywords() {
        keywordsToSearchInException.clear();
    }

    public void dumpDiagnoseFirstFailure(boolean isDumpSystemConfig) {
        if (this.diagnoseFirstFailureHandler != null) {
            Properties properties = new Properties();
            if (!this.additionalConfig.isEmpty()) {
                this.additionalConfig.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.setProperty((String)k, (String)v)));
            }
            if (isDumpSystemConfig) {
                Properties systemProperties = (Properties)SYSTEM_CONFIG.clone();
                systemProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> properties.setProperty((String)k, (String)v)));
                properties.put("DriverVersion", BuildInfo.getDriverVersion());
            }
            if (!properties.isEmpty()) {
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "dumpDiagnoseFirstFailure", null, null, "properties={0}. ", null, GeneratedPhysicalConnection.CONNECTION_PROPERTIES_BLINDER.blind(properties));
            }
            this.diagnoseFirstFailureHandler.get().push();
        }
    }

    public static Set<Integer> getErrorCodeWatchList() {
        return errorCodesWatchedForDiagnoseFirstFailureDump;
    }

    public static void stopClockTimer() {
        CLOCK.cancel();
    }

    static {
        CLOCK.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MILLIS.set(System.currentTimeMillis());
            }
        }, 1000L, 1000L);
        CLASS_NAME = Diagnostic.class.getName();
        DEFAULT_ERROR_CODES = new HashSet<Integer>();
        DEFAULT_ERROR_CODES_AS_STRINGS = new HashSet<String>();
        errorCodesWatchedForDiagnoseFirstFailureDump = Collections.synchronizedSet(new HashSet());
        keywordsToSearchInException = Collections.synchronizedSet(new HashSet());
        SYSTEM_CONFIG = new Properties();
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    SYSTEM_CONFIG.setProperty("java.version: ", System.getProperty("java.version"));
                    SYSTEM_CONFIG.setProperty("java.class.path: ", System.getProperty("java.class.path"));
                    SYSTEM_CONFIG.setProperty("java.library.path: ", System.getProperty("java.library.path"));
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        SYSTEM_CONFIG.setProperty("LOCALE", Locale.getDefault().toString());
        DEFAULT_ERROR_CODES.addAll(Arrays.asList(17401, 17406, 17407, 17408, 17409, 17411, 17452));
        ArrayList<Integer> errorCodesExcludeList = new ArrayList<Integer>(){
            {
                this.add(1033);
            }
        };
        errorCodesExcludeList.forEach(DEFAULT_ERROR_CODES::remove);
        DEFAULT_ERROR_CODES.stream().forEach(value -> DEFAULT_ERROR_CODES_AS_STRINGS.add(ORA_ERROR_CODE_PREFIX + value));
        errorCodesWatchedForDiagnoseFirstFailureDump.addAll(DEFAULT_ERROR_CODES);
        IS_EXCEPTION_CONTAINS_KEYWORDS = exceptionMessage -> {
            for (String keyword : keywordsToSearchInException) {
                if (!exceptionMessage.toLowerCase().contains(keyword)) continue;
                return true;
            }
            return false;
        };
        DEFAULT_PUSH_LEVEL = Level.WARNING;
    }
}

