/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleStatement;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class GeneratedUpdatableResultSet
extends OracleResultSet {
    protected static final int MAX_CHA_BUFFER_SIZE = 1024;
    protected static final int MAX_BYTE_BUFFER_SIZE = 1024;
    OracleResultSet resultSet;
    boolean isRowDeleted = false;

    GeneratedUpdatableResultSet(OracleStatement stmt, OracleResultSet rset) throws SQLException {
        super(stmt.connection);
        this.resultSet = rset;
        if (stmt.sqlKind == OracleStatement.SqlKind.SELECT_FOR_UPDATE && stmt.connection.autocommit && stmt.connection.protocolId == 0) {
            this.needCommitAtClose = true;
        }
    }

    abstract void ensureOpen() throws SQLException;

    abstract void setIsNull(NullStatus var1);

    abstract void setIsNull(boolean var1);

    abstract boolean isOnInsertRow();

    abstract boolean isUpdatingRow() throws SQLException;

    abstract boolean isRowBufferUpdatedAt(int var1) throws SQLException;

    abstract Updater<?> getUpdater(int var1) throws SQLException;

    abstract void setUpdater(int var1, Updater<?> var2) throws SQLException;

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Array value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getArray").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getArray").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Array.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getArray(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Array array = value;
            return array;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            BigDecimal value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBigDecimal").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBigDecimal").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), BigDecimal.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBigDecimal(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            BigDecimal bigDecimal = value;
            return bigDecimal;
        }
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            BigDecimal value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBigDecimal").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBigDecimal").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), BigDecimal.class, this.connection, u.getExtra(), y);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBigDecimal(columnIndex, y);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            BigDecimal bigDecimal = value;
            return bigDecimal;
        }
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Blob value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBlob").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBlob").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Blob.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBlob(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Blob blob = value;
            return blob;
        }
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Boolean value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBoolean").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBoolean").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Boolean.class, this.connection, u.getExtra(), null);
                if (value == null) {
                    value = false;
                }
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBoolean(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            boolean bl = value;
            return bl;
        }
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Byte value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getByte").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getByte").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Byte.class, this.connection, u.getExtra(), null);
                if (value == null) {
                    value = 0;
                }
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getByte(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            byte by = value;
            return by;
        }
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            byte[] value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBytes").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBytes").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), byte[].class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBytes(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            byte[] byArray = value;
            return byArray;
        }
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Clob value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getClob").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getClob").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Clob.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getClob(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Clob clob = value;
            return clob;
        }
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Date value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getDate").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getDate").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Date.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getDate(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Date date = value;
            return date;
        }
    }

    @Override
    public Date getDate(int columnIndex, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Date value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getDate").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getDate").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Date.class, this.connection, u.getExtra(), y);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getDate(columnIndex, y);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Date date = value;
            return date;
        }
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Double value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getDouble").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getDouble").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Double.class, this.connection, u.getExtra(), null);
                if (value == null) {
                    value = 0.0;
                }
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getDouble(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            double d = value;
            return d;
        }
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Float value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getFloat").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getFloat").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Float.class, this.connection, u.getExtra(), null);
                if (value == null) {
                    value = Float.valueOf(0.0f);
                }
                this.setIsNull(u.getValue() == null);
            } else {
                value = Float.valueOf(this.resultSet.getFloat(columnIndex));
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            float f = value.floatValue();
            return f;
        }
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Integer value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getInt").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getInt").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Integer.class, this.connection, u.getExtra(), null);
                if (value == null) {
                    value = 0;
                }
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getInt(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            int n = value;
            return n;
        }
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Long value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getLong").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getLong").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Long.class, this.connection, u.getExtra(), null);
                if (value == null) {
                    value = 0L;
                }
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getLong(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            long l = value;
            return l;
        }
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            NClob value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getNClob").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getNClob").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), NClob.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getNClob(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            NClob nClob = value;
            return nClob;
        }
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getNString").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getNString").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), String.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getNString(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            String string = value;
            return string;
        }
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Object value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getObject").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Object.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getObject(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Object object = value;
            return object;
        }
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Object value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getObject").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Object.class, this.connection, u.getExtra(), y);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getObject(columnIndex, y);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Object object = value;
            return object;
        }
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Ref value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getRef").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getRef").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Ref.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getRef(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Ref ref = value;
            return ref;
        }
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            RowId value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getRowId").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getRowId").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), RowId.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getRowId(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            RowId rowId = value;
            return rowId;
        }
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Short value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getShort").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getShort").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Short.class, this.connection, u.getExtra(), null);
                if (value == null) {
                    value = 0;
                }
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getShort(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            short s2 = value;
            return s2;
        }
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            SQLXML value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getSQLXML").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getSQLXML").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), SQLXML.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getSQLXML(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            SQLXML sQLXML = value;
            return sQLXML;
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            String value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getString").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getString").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), String.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getString(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            String string = value;
            return string;
        }
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Time value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTime").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTime").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Time.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getTime(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Time time = value;
            return time;
        }
    }

    @Override
    public Time getTime(int columnIndex, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Time value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTime").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTime").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Time.class, this.connection, u.getExtra(), y);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getTime(columnIndex, y);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Time time = value;
            return time;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Timestamp value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTimestamp").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTimestamp").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Timestamp.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getTimestamp(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Timestamp timestamp = value;
            return timestamp;
        }
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Timestamp value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTimestamp").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTimestamp").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Timestamp.class, this.connection, u.getExtra(), y);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getTimestamp(columnIndex, y);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Timestamp timestamp = value;
            return timestamp;
        }
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            URL value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getURL").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getURL").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), URL.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getURL(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            URL uRL = value;
            return uRL;
        }
    }

    @Override
    public ARRAY getARRAY(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            ARRAY value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getARRAY").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getARRAY").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), ARRAY.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getARRAY(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            ARRAY aRRAY = value;
            return aRRAY;
        }
    }

    @Override
    public BFILE getBFILE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            BFILE value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBFILE").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBFILE").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), BFILE.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBFILE(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            BFILE bFILE = value;
            return bFILE;
        }
    }

    @Override
    public BFILE getBfile(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            BFILE value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBfile").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBfile").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), BFILE.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBfile(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            BFILE bFILE = value;
            return bFILE;
        }
    }

    @Override
    public BLOB getBLOB(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            BLOB value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBLOB").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBLOB").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), BLOB.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBLOB(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            BLOB bLOB = value;
            return bLOB;
        }
    }

    @Override
    public CHAR getCHAR(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            CHAR value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCHAR").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCHAR").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), CHAR.class, this.connection, u.getExtra(), CharacterSet.make(this.connection.getJdbcCsId()));
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getCHAR(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            CHAR cHAR = value;
            return cHAR;
        }
    }

    @Override
    public CLOB getCLOB(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            CLOB value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCLOB").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCLOB").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), CLOB.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getCLOB(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            CLOB cLOB = value;
            return cLOB;
        }
    }

    @Override
    public ResultSet getCursor(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            ResultSet value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCursor").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCursor").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), ResultSet.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getCursor(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            ResultSet resultSet = value;
            return resultSet;
        }
    }

    @Override
    public DATE getDATE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            DATE value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getDATE").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getDATE").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), DATE.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getDATE(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            DATE dATE = value;
            return dATE;
        }
    }

    @Override
    public INTERVALDS getINTERVALDS(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            INTERVALDS value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getINTERVALDS").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getINTERVALDS").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), INTERVALDS.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getINTERVALDS(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            INTERVALDS iNTERVALDS = value;
            return iNTERVALDS;
        }
    }

    @Override
    public INTERVALYM getINTERVALYM(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            INTERVALYM value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getINTERVALYM").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getINTERVALYM").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), INTERVALYM.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getINTERVALYM(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            INTERVALYM iNTERVALYM = value;
            return iNTERVALYM;
        }
    }

    @Override
    public NUMBER getNUMBER(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            NUMBER value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getNUMBER").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getNUMBER").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), NUMBER.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getNUMBER(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            NUMBER nUMBER = value;
            return nUMBER;
        }
    }

    @Override
    public OPAQUE getOPAQUE(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            OPAQUE value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getOPAQUE").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getOPAQUE").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), OPAQUE.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getOPAQUE(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            OPAQUE oPAQUE = value;
            return oPAQUE;
        }
    }

    @Override
    public Datum getOracleObject(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Datum value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getOracleObject").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getOracleObject").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Datum.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getOracleObject(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Datum datum = value;
            return datum;
        }
    }

    @Override
    public ORAData getORAData(int columnIndex, ORADataFactory y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            ORAData value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getORAData").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getORAData").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), ORAData.class, this.connection, u.getExtra(), y);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getORAData(columnIndex, y);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            ORAData oRAData = value;
            return oRAData;
        }
    }

    @Override
    public Object getObject(int columnIndex, OracleDataFactory y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Object value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getObject").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getObject").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Object.class, this.connection, u.getExtra(), y);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getObject(columnIndex, y);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Object object = value;
            return object;
        }
    }

    @Override
    public RAW getRAW(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            RAW value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getRAW").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getRAW").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), RAW.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getRAW(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            RAW rAW = value;
            return rAW;
        }
    }

    @Override
    public REF getREF(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            REF value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getREF").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getREF").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), REF.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getREF(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            REF rEF = value;
            return rEF;
        }
    }

    @Override
    public ROWID getROWID(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            ROWID value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getROWID").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getROWID").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), ROWID.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getROWID(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            ROWID rOWID = value;
            return rOWID;
        }
    }

    @Override
    public STRUCT getSTRUCT(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            STRUCT value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getSTRUCT").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getSTRUCT").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), STRUCT.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getSTRUCT(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            STRUCT sTRUCT = value;
            return sTRUCT;
        }
    }

    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            TIMESTAMPLTZ value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTIMESTAMPLTZ").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTIMESTAMPLTZ").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), TIMESTAMPLTZ.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getTIMESTAMPLTZ(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = value;
            return tIMESTAMPLTZ;
        }
    }

    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            TIMESTAMPTZ value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTIMESTAMPTZ").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTIMESTAMPTZ").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), TIMESTAMPTZ.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getTIMESTAMPTZ(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            TIMESTAMPTZ tIMESTAMPTZ = value;
            return tIMESTAMPTZ;
        }
    }

    @Override
    public TIMESTAMP getTIMESTAMP(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            TIMESTAMP value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getTIMESTAMP").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getTIMESTAMP").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), TIMESTAMP.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getTIMESTAMP(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            TIMESTAMP tIMESTAMP = value;
            return tIMESTAMP;
        }
    }

    @Override
    public CustomDatum getCustomDatum(int columnIndex, CustomDatumFactory y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            CustomDatum value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCustomDatum").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCustomDatum").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), CustomDatum.class, this.connection, u.getExtra(), y);
                if (value == null) {
                    value = null;
                }
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getCustomDatum(columnIndex, y);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            CustomDatum customDatum = value;
            return customDatum;
        }
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            InputStream value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getAsciiStream").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getAsciiStream").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), InputStream.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getAsciiStream(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            InputStream inputStream = value;
            return inputStream;
        }
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            InputStream value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getBinaryStream").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getBinaryStream").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), InputStream.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getBinaryStream(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            InputStream inputStream = value;
            return inputStream;
        }
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Reader value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getCharacterStream").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getCharacterStream").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Reader.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getCharacterStream(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Reader reader = value;
            return reader;
        }
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Reader value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getNCharacterStream").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getNCharacterStream").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), Reader.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getNCharacterStream(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            Reader reader = value;
            return reader;
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            InputStream value;
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "getUnicodeStream").fillInStackTrace();
            }
            if (this.isOnInsertRow() || this.isUpdatingRow() && this.isRowBufferUpdatedAt(columnIndex)) {
                Updater<?> u = this.getUpdater(columnIndex);
                if (u == null) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "getUnicodeStream").fillInStackTrace();
                }
                value = JavaToJavaConverter.convert(u.getValue(), InputStream.class, this.connection, u.getExtra(), null);
                this.setIsNull(u.getValue() == null);
            } else {
                value = this.resultSet.getUnicodeStream(columnIndex);
                this.setIsNull(NullStatus.VALUE_IN_RSET);
            }
            InputStream inputStream = value;
            return inputStream;
        }
    }

    @Override
    public void updateArray(int columnIndex, Array value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateArray").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateArray").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Array>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setArray(index, (Array)this.value);
                }
            });
        }
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBigDecimal").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBigDecimal").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<BigDecimal>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBigDecimal(index, (BigDecimal)this.value);
                }
            });
        }
    }

    @Override
    public void updateBlob(int columnIndex, Blob value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBlob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBlob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Blob>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBlob(index, (Blob)this.value);
                }
            });
        }
    }

    @Override
    public void updateBoolean(int columnIndex, boolean value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBoolean").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBoolean").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Boolean>(Boolean.valueOf(value)){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBoolean(index, (Boolean)this.value);
                }
            });
        }
    }

    @Override
    public void updateByte(int columnIndex, byte value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateByte").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateByte").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Byte>(Byte.valueOf(value)){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setByte(index, (Byte)this.value);
                }
            });
        }
    }

    @Override
    public void updateBytes(int columnIndex, byte[] value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBytes").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBytes").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<byte[]>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBytes(index, (byte[])this.value);
                }
            });
        }
    }

    @Override
    public void updateClob(int columnIndex, Clob value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateClob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateClob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Clob>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setClob(index, (Clob)this.value);
                }
            });
        }
    }

    @Override
    public void updateDate(int columnIndex, Date value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateDate").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateDate").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Date>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setDate(index, (Date)this.value);
                }
            });
        }
    }

    @Override
    public void updateDate(int columnIndex, Date value, final Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateDate").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateDate").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Date>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setDate(index, (Date)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateDouble(int columnIndex, double value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateDouble").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateDouble").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Double>(Double.valueOf(value)){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setDouble(index, (Double)this.value);
                }
            });
        }
    }

    @Override
    public void updateFloat(int columnIndex, float value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateFloat").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateFloat").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Float>(Float.valueOf(value)){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setFloat(index, ((Float)this.value).floatValue());
                }
            });
        }
    }

    @Override
    public void updateInt(int columnIndex, int value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateInt").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateInt").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Integer>(Integer.valueOf(value)){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setInt(index, (Integer)this.value);
                }
            });
        }
    }

    @Override
    public void updateLong(int columnIndex, long value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateLong").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateLong").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Long>(Long.valueOf(value)){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setLong(index, (Long)this.value);
                }
            });
        }
    }

    @Override
    public void updateNClob(int columnIndex, NClob value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNClob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNClob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<NClob>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setNClob(index, (NClob)this.value);
                }
            });
        }
    }

    @Override
    public void updateNString(int columnIndex, String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNString").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNString").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<String>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setNString(index, (String)this.value);
                }
            });
        }
    }

    @Override
    public void updateObject(int columnIndex, Object value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Object>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setObject(index, this.value);
                }
            });
        }
    }

    @Override
    public void updateObject(int columnIndex, Object value, final int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateObject").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateObject").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Object>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setObject(index, this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateRef(int columnIndex, Ref value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateRef").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateRef").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Ref>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setRef(index, (Ref)this.value);
                }
            });
        }
    }

    @Override
    public void updateRowId(int columnIndex, RowId value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateRowId").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateRowId").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<RowId>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setRowId(index, (RowId)this.value);
                }
            });
        }
    }

    @Override
    public void updateShort(int columnIndex, short value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateShort").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateShort").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Short>(Short.valueOf(value)){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setShort(index, (Short)this.value);
                }
            });
        }
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateSQLXML").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateSQLXML").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<SQLXML>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setSQLXML(index, (SQLXML)this.value);
                }
            });
        }
    }

    @Override
    public void updateString(int columnIndex, String value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateString").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateString").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<String>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setString(index, (String)this.value);
                }
            });
        }
    }

    @Override
    public void updateTime(int columnIndex, Time value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTime").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTime").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Time>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setTime(index, (Time)this.value);
                }
            });
        }
    }

    @Override
    public void updateTime(int columnIndex, Time value, final Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTime").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTime").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Time>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setTime(index, (Time)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTimestamp").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTimestamp").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Timestamp>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setTimestamp(index, (Timestamp)this.value);
                }
            });
        }
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp value, final Calendar y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTimestamp").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTimestamp").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Timestamp>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setTimestamp(index, (Timestamp)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateURL(int columnIndex, URL value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateURL").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateURL").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<URL>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setURL(index, (URL)this.value);
                }
            });
        }
    }

    @Override
    public void updateARRAY(int columnIndex, ARRAY value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateARRAY").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateARRAY").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<ARRAY>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setARRAY(index, (ARRAY)this.value);
                }
            });
        }
    }

    @Override
    public void updateBFILE(int columnIndex, BFILE value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBFILE").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBFILE").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<BFILE>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBFILE(index, (BFILE)this.value);
                }
            });
        }
    }

    @Override
    public void updateBfile(int columnIndex, BFILE value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBfile").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBfile").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<BFILE>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBfile(index, (BFILE)this.value);
                }
            });
        }
    }

    @Override
    public void updateBLOB(int columnIndex, BLOB value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBLOB").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBLOB").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<BLOB>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBLOB(index, (BLOB)this.value);
                }
            });
        }
    }

    @Override
    public void updateCHAR(int columnIndex, CHAR value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCHAR").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCHAR").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<CHAR>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setCHAR(index, (CHAR)this.value);
                }
            });
        }
    }

    @Override
    public void updateCLOB(int columnIndex, CLOB value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCLOB").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCLOB").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<CLOB>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setCLOB(index, (CLOB)this.value);
                }
            });
        }
    }

    @Override
    public void updateDATE(int columnIndex, DATE value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateDATE").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateDATE").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<DATE>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setDATE(index, (DATE)this.value);
                }
            });
        }
    }

    @Override
    public void updateINTERVALDS(int columnIndex, INTERVALDS value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateINTERVALDS").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateINTERVALDS").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<INTERVALDS>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setINTERVALDS(index, (INTERVALDS)this.value);
                }
            });
        }
    }

    @Override
    public void updateINTERVALYM(int columnIndex, INTERVALYM value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateINTERVALYM").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateINTERVALYM").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<INTERVALYM>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setINTERVALYM(index, (INTERVALYM)this.value);
                }
            });
        }
    }

    @Override
    public void updateNUMBER(int columnIndex, NUMBER value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNUMBER").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNUMBER").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<NUMBER>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setNUMBER(index, (NUMBER)this.value);
                }
            });
        }
    }

    @Override
    public void updateOracleObject(int columnIndex, Datum value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateOracleObject").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateOracleObject").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Datum>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setOracleObject(index, (Datum)this.value);
                }
            });
        }
    }

    @Override
    public void updateORAData(int columnIndex, ORAData value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateORAData").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateORAData").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<ORAData>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setORAData(index, (ORAData)this.value);
                }
            });
        }
    }

    @Override
    public void updateRAW(int columnIndex, RAW value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateRAW").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateRAW").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<RAW>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setRAW(index, (RAW)this.value);
                }
            });
        }
    }

    @Override
    public void updateREF(int columnIndex, REF value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateREF").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateREF").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<REF>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setREF(index, (REF)this.value);
                }
            });
        }
    }

    @Override
    public void updateROWID(int columnIndex, ROWID value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateROWID").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateROWID").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<ROWID>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setROWID(index, (ROWID)this.value);
                }
            });
        }
    }

    @Override
    public void updateSTRUCT(int columnIndex, STRUCT value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateSTRUCT").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateSTRUCT").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<STRUCT>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setSTRUCT(index, (STRUCT)this.value);
                }
            });
        }
    }

    @Override
    public void updateTIMESTAMPLTZ(int columnIndex, TIMESTAMPLTZ value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTIMESTAMPLTZ").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTIMESTAMPLTZ").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<TIMESTAMPLTZ>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setTIMESTAMPLTZ(index, (TIMESTAMPLTZ)this.value);
                }
            });
        }
    }

    @Override
    public void updateTIMESTAMPTZ(int columnIndex, TIMESTAMPTZ value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTIMESTAMPTZ").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTIMESTAMPTZ").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<TIMESTAMPTZ>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setTIMESTAMPTZ(index, (TIMESTAMPTZ)this.value);
                }
            });
        }
    }

    @Override
    public void updateTIMESTAMP(int columnIndex, TIMESTAMP value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateTIMESTAMP").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateTIMESTAMP").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<TIMESTAMP>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setTIMESTAMP(index, (TIMESTAMP)this.value);
                }
            });
        }
    }

    @Override
    public void updateCustomDatum(int columnIndex, CustomDatum value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCustomDatum").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCustomDatum").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<CustomDatum>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setCustomDatum(index, (CustomDatum)this.value);
                }
            });
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBlob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBlob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBlob(index, (InputStream)this.value);
                }
            });
        }
    }

    @Override
    public void updateBlob(int columnIndex, InputStream value, final long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBlob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBlob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBlob(index, (InputStream)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateClob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateClob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setClob(index, (Reader)this.value);
                }
            });
        }
    }

    @Override
    public void updateClob(int columnIndex, Reader value, final long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateClob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateClob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setClob(index, (Reader)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNClob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNClob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setNClob(index, (Reader)this.value);
                }
            });
        }
    }

    @Override
    public void updateNClob(int columnIndex, Reader value, final long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNClob").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNClob").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setNClob(index, (Reader)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateAsciiStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateAsciiStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setAsciiStream(index, (InputStream)this.value);
                }
            });
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream value, final int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateAsciiStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateAsciiStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setAsciiStream(index, (InputStream)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream value, final long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateAsciiStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateAsciiStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setAsciiStream(index, (InputStream)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBinaryStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBinaryStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBinaryStream(index, (InputStream)this.value);
                }
            });
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream value, final int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBinaryStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBinaryStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBinaryStream(index, (InputStream)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream value, final long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateBinaryStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateBinaryStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setBinaryStream(index, (InputStream)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCharacterStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCharacterStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setCharacterStream(index, (Reader)this.value);
                }
            });
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, final int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCharacterStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCharacterStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setCharacterStream(index, (Reader)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader value, final long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateCharacterStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateCharacterStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setCharacterStream(index, (Reader)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader value) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNCharacterStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNCharacterStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setNCharacterStream(index, (Reader)this.value);
                }
            });
        }
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader value, final long y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateNCharacterStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateNCharacterStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<Reader>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setNCharacterStream(index, (Reader)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    @Override
    public void updateUnicodeStream(int columnIndex, InputStream value, final int y) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            this.ensureOpen();
            if (this.isRowDeleted) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 82, "updateUnicodeStream").fillInStackTrace();
            }
            if (columnIndex < 1 || columnIndex > this.getColumnCount()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, "updateUnicodeStream").fillInStackTrace();
            }
            this.setUpdater(columnIndex, new Updater<InputStream>(value){

                @Override
                public void set(OraclePreparedStatement ps, int index) throws SQLException {
                    ps.setUnicodeStream(index, (InputStream)this.value, y);
                }

                @Override
                public Object getExtra() {
                    return y;
                }
            });
        }
    }

    protected static abstract class Updater<T> {
        protected T value;

        Updater(T v) {
            this.value = v;
        }

        abstract void set(OraclePreparedStatement var1, int var2) throws SQLException;

        Object getExtra() {
            return null;
        }

        final T getValue() throws SQLException {
            return this.value;
        }

        final boolean isNull() {
            return this.value == null;
        }
    }

    static enum NullStatus {
        VALUE_UNKNOWN,
        VALUE_IN_RSET,
        VALUE_NULL,
        VALUE_NOT_NULL;

    }
}

