/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import oracle.jdbc.OracleData;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DefaultJsonProvider;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.spi.OsonConverter;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.json.OracleJsonArray;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonDate;
import oracle.sql.json.OracleJsonDatum;
import oracle.sql.json.OracleJsonDecimal;
import oracle.sql.json.OracleJsonDouble;
import oracle.sql.json.OracleJsonException;
import oracle.sql.json.OracleJsonFactory;
import oracle.sql.json.OracleJsonFloat;
import oracle.sql.json.OracleJsonGenerator;
import oracle.sql.json.OracleJsonIntervalDS;
import oracle.sql.json.OracleJsonIntervalYM;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonParser;
import oracle.sql.json.OracleJsonString;
import oracle.sql.json.OracleJsonStructure;
import oracle.sql.json.OracleJsonTimestamp;
import oracle.sql.json.OracleJsonValue;
import oracle.sql.json.OracleJsonVector;

class JsonAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;
    private final OracleJsonFactory factory;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    JsonAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.JSON, stmt, 4000, isStoredInBindData);
        this.init(stmt, 119, 119, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
        this.factory = stmt.connection.getOracleJsonFactory();
    }

    JsonAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.JSON, stmt, 4000, false);
        this.init(stmt, 119, 119, form, false);
        this.initForDescribe(119, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
        this.factory = stmt.connection.getOracleJsonFactory();
    }

    @Override
    final boolean isPrefetched() {
        return this.lobPrefetchSizeForThisColumn > -1;
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        try {
            OracleJsonParser parser = this.factory.createJsonBinaryParser(this.getBufferInternal(currentRow));
            this.out.reset();
            OracleJsonGenerator generator = this.factory.createJsonTextGenerator(this.out);
            generator.writeParser(parser);
            generator.close();
            return this.out.toByteArray();
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    @Override
    JsonValue getJsonValue(int currentRow) throws SQLException {
        byte[] bytes = this.getBytesInternal(currentRow);
        try {
            return this.factory.createJsonBinaryValue(ByteBuffer.wrap(bytes)).wrap(JsonValue.class);
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    @Override
    JsonParser getJsonParser(int currentRow) throws SQLException {
        byte[] bytes = this.getBytesInternal(currentRow);
        try {
            return this.factory.createJsonBinaryParser(ByteBuffer.wrap(bytes)).wrap(JsonParser.class);
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    @Override
    JsonStructure getJsonStructure(int currentRow) throws SQLException {
        JsonValue jsonVal = this.getJsonValue(currentRow);
        if (jsonVal.getValueType() == JsonValue.ValueType.ARRAY || jsonVal.getValueType() == JsonValue.ValueType.OBJECT) {
            return (JsonStructure)jsonVal;
        }
        throw this.invalidColumnType();
    }

    @Override
    JsonObject getJsonObject(int currentRow) throws SQLException {
        return (JsonObject)this.getJsonValue(currentRow, JsonValue.ValueType.OBJECT);
    }

    @Override
    JsonArray getJsonArray(int currentRow) throws SQLException {
        return (JsonArray)this.getJsonValue(currentRow, JsonValue.ValueType.ARRAY);
    }

    @Override
    JsonString getJsonString(int currentRow) throws SQLException {
        return (JsonString)this.getJsonValue(currentRow, JsonValue.ValueType.STRING);
    }

    @Override
    JsonNumber getJsonNumber(int currentRow) throws SQLException {
        return (JsonNumber)this.getJsonValue(currentRow, JsonValue.ValueType.NUMBER);
    }

    private JsonValue getJsonValue(int currentRow, JsonValue.ValueType type) throws SQLException {
        JsonValue jsonVal = this.getJsonValue(currentRow);
        if (jsonVal.getValueType() == type) {
            return jsonVal;
        }
        throw this.invalidColumnType();
    }

    @Override
    jakarta.json.JsonValue getJakartaJsonValue(int currentRow) throws SQLException {
        byte[] bytes = this.getBytesInternal(currentRow);
        try {
            return this.factory.createJsonBinaryValue(ByteBuffer.wrap(bytes)).wrap(jakarta.json.JsonValue.class);
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    @Override
    jakarta.json.stream.JsonParser getJakartaJsonParser(int currentRow) throws SQLException {
        byte[] bytes = this.getBytesInternal(currentRow);
        try {
            return this.factory.createJsonBinaryParser(ByteBuffer.wrap(bytes)).wrap(jakarta.json.stream.JsonParser.class);
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    @Override
    jakarta.json.JsonStructure getJakartaJsonStructure(int currentRow) throws SQLException {
        jakarta.json.JsonValue jsonVal = this.getJakartaJsonValue(currentRow);
        if (jsonVal.getValueType() == JsonValue.ValueType.ARRAY || jsonVal.getValueType() == JsonValue.ValueType.OBJECT) {
            return (jakarta.json.JsonStructure)jsonVal;
        }
        throw this.invalidColumnType();
    }

    @Override
    jakarta.json.JsonObject getJakartaJsonObject(int currentRow) throws SQLException {
        return (jakarta.json.JsonObject)this.getJakartaJsonValue(currentRow, JsonValue.ValueType.OBJECT);
    }

    @Override
    jakarta.json.JsonArray getJakartaJsonArray(int currentRow) throws SQLException {
        return (jakarta.json.JsonArray)this.getJakartaJsonValue(currentRow, JsonValue.ValueType.ARRAY);
    }

    @Override
    jakarta.json.JsonString getJakartaJsonString(int currentRow) throws SQLException {
        return (jakarta.json.JsonString)this.getJakartaJsonValue(currentRow, JsonValue.ValueType.STRING);
    }

    @Override
    jakarta.json.JsonNumber getJakartaJsonNumber(int currentRow) throws SQLException {
        return (jakarta.json.JsonNumber)this.getJakartaJsonValue(currentRow, JsonValue.ValueType.NUMBER);
    }

    private jakarta.json.JsonValue getJakartaJsonValue(int currentRow, JsonValue.ValueType type) throws SQLException {
        jakarta.json.JsonValue jsonVal = this.getJakartaJsonValue(currentRow);
        if (jsonVal.getValueType() == type) {
            return jsonVal;
        }
        throw this.invalidColumnType();
    }

    @Override
    OracleJsonParser getOracleJsonParser(int currentRow) throws SQLException {
        try {
            return this.factory.createJsonBinaryParser(this.getBufferInternal(currentRow));
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    @Override
    OracleJsonDatum getOracleJsonDatum(int currentRow) throws SQLException {
        try {
            return new OracleJsonDatum(this.getBytesInternal(currentRow));
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    @Override
    Datum getDatum(int currentRow) throws SQLException {
        return this.getOracleJsonDatum(currentRow);
    }

    @Override
    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getOracleJsonDatum(currentRow);
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (this.statement.connection.jsonDefaultGetObjectType != null) {
            switch (this.statement.connection.jsonDefaultGetObjectType) {
                case "oracle.sql.json.OracleJsonValue": {
                    return this.getOracleJsonValue(currentRow);
                }
                case "java.lang.String": {
                    return this.getString(currentRow);
                }
                case "java.io.Reader": {
                    return this.getCharacterStream(currentRow);
                }
                case "java.io.InputStream": {
                    return this.getBinaryStream(currentRow);
                }
                case "jakarta.json.JsonValue": {
                    return this.getJakartaJsonValue(currentRow);
                }
                case "oracle.sql.json.OracleJsonParser": {
                    return this.getOracleJsonParser(currentRow);
                }
                case "jakarta.json.stream.JsonParser": {
                    return this.getJakartaJsonParser(currentRow);
                }
                case "oracle.sql.json.OracleJsonDatum": {
                    return this.getOracleJsonDatum(currentRow);
                }
            }
            throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1721, null, null, this.statement.connection.jsonDefaultGetObjectType, "oracle.jdbc.jsonDefaultGetObjectType").fillInStackTrace();
        }
        throw (SQLException)DatabaseError.formatSqlException(this.getConnectionDuringExceptionHandling(), 1722, null, null, "oracle.jdbc.jsonDefaultGetObjectType").fillInStackTrace();
    }

    @Override
    Object getObject(int currentRow, Map<String, Class<?>> map) throws SQLException {
        return super.getOracleObject(currentRow);
    }

    @Override
    <T> T getObject(int currentRow, Class<T> type) throws SQLException {
        if (this.isTypeConversionSupportedByDriver(type)) {
            return super.getObject(currentRow, type);
        }
        OsonConverter osonConverter = this.statement.connection.getOsonConverter();
        if (!osonConverter.equals(DefaultJsonProvider.NO_OP_OSON_CONVERTER)) {
            return (T)osonConverter.deserialize(this.factory.createJsonBinaryParser(this.getBufferInternal(currentRow)), type);
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    ORAData getORAData(int currentRow, ORADataFactory factory) throws SQLException {
        if (factory == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 281).fillInStackTrace();
        }
        Datum d = this.getOracleObject(currentRow);
        return factory.create(d, 2016);
    }

    @Override
    OracleJsonValue getOracleJsonValue(int currentRow) throws SQLException {
        try {
            return this.factory.createJsonBinaryValue(this.getBufferInternal(currentRow));
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    @Override
    OracleJsonStructure getOracleJsonStructure(int currentRow) throws SQLException {
        return (OracleJsonStructure)this.getOracleJsonValueAbstract(currentRow, OracleJsonValue.OracleJsonType.OBJECT, OracleJsonValue.OracleJsonType.ARRAY);
    }

    @Override
    OracleJsonNumber getOracleJsonNumber(int currentRow) throws SQLException {
        return (OracleJsonNumber)this.getOracleJsonValueAbstract(currentRow, OracleJsonValue.OracleJsonType.DECIMAL, OracleJsonValue.OracleJsonType.DOUBLE, OracleJsonValue.OracleJsonType.FLOAT);
    }

    @Override
    OracleJsonObject getOracleJsonObject(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.OBJECT).asJsonObject();
    }

    @Override
    OracleJsonArray getOracleJsonArray(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.ARRAY).asJsonArray();
    }

    @Override
    OracleJsonDecimal getOracleJsonDecimal(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.DECIMAL).asJsonDecimal();
    }

    @Override
    OracleJsonDouble getOracleJsonDouble(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.DOUBLE).asJsonDouble();
    }

    @Override
    OracleJsonFloat getOracleJsonFloat(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.FLOAT).asJsonFloat();
    }

    @Override
    OracleJsonString getOracleJsonString(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.STRING).asJsonString();
    }

    @Override
    OracleJsonBinary getOracleJsonBinary(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.BINARY).asJsonBinary();
    }

    @Override
    OracleJsonTimestamp getOracleJsonTimestamp(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.TIMESTAMP).asJsonTimestamp();
    }

    @Override
    OracleJsonDate getOracleJsonDate(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.DATE).asJsonDate();
    }

    @Override
    OracleJsonIntervalDS getOracleJsonIntervalDS(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.INTERVALDS).asJsonIntervalDS();
    }

    @Override
    OracleJsonIntervalYM getOracleJsonIntervalYM(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.INTERVALYM).asJsonIntervalYM();
    }

    @Override
    OracleJsonVector getOracleJsonVector(int currentRow) throws SQLException {
        return this.getOracleJsonValue(currentRow, OracleJsonValue.OracleJsonType.VECTOR).asJsonVector();
    }

    private OracleJsonValue getOracleJsonValue(int currentRow, OracleJsonValue.OracleJsonType type) throws SQLException {
        OracleJsonValue jsonVal = this.getOracleJsonValue(currentRow);
        if (jsonVal.getOracleJsonType() == type) {
            return jsonVal;
        }
        throw this.invalidColumnType();
    }

    private OracleJsonValue getOracleJsonValueAbstract(int currentRow, OracleJsonValue.OracleJsonType ... types) throws SQLException {
        OracleJsonValue jsonVal = this.getOracleJsonValue(currentRow);
        for (OracleJsonValue.OracleJsonType t2 : types) {
            if (t2 != jsonVal.getOracleJsonType()) continue;
            return jsonVal;
        }
        throw this.invalidColumnType();
    }

    @Override
    Reader getCharacterStream(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        String jsonTextString = this.getString(currentRow);
        return jsonTextString == null ? null : new StringReader(jsonTextString);
    }

    @Override
    InputStream getBinaryStream(int currentRow) throws SQLException {
        byte[] jsonTextBytes = this.getBytes(currentRow);
        return jsonTextBytes == null ? null : new ByteArrayInputStream(jsonTextBytes);
    }

    @Override
    String getString(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        try {
            OracleJsonParser parser = this.factory.createJsonBinaryParser(this.getBufferInternal(currentRow));
            StringWriter out = new StringWriter();
            OracleJsonGenerator generator = this.factory.createJsonTextGenerator(out);
            generator.writeParser(parser);
            generator.close();
            return out.toString();
        }
        catch (OracleJsonException e) {
            throw this.toSQLException(e);
        }
    }

    private boolean isTypeConversionSupportedByDriver(Class<?> type) {
        return type.equals(String.class) || Reader.class.isAssignableFrom(type) || InputStream.class.isAssignableFrom(type) || OracleJsonParser.class.isAssignableFrom(type) || Datum.class.isAssignableFrom(type) || type.equals(byte[].class) || OracleJsonValue.class.isAssignableFrom(type) || SQLData.class.isAssignableFrom(type) || OracleData.class.isAssignableFrom(type) || ORAData.class.isAssignableFrom(type) || PhysicalConnection.isJakartaJarPresent() && (jakarta.json.JsonValue.class.isAssignableFrom(type) || jakarta.json.stream.JsonParser.class.isAssignableFrom(type)) || PhysicalConnection.isJsonJarPresent() && (JsonValue.class.isAssignableFrom(type) || JsonParser.class.isAssignableFrom(type));
    }

    private ByteBuffer getBufferInternal(int currentRow) throws SQLException {
        return ByteBuffer.wrap(this.getBytesInternal(currentRow));
    }

    private SQLException toSQLException(RuntimeException e) {
        return (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), e).fillInStackTrace();
    }

    private SQLException invalidColumnType() {
        return (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    long updateChecksum(long _checkSum, int currentRow) throws SQLException {
        this.unimpl("updateChecksum");
        return -1L;
    }
}

