/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Map;
import oracle.dms.console.EventFactoryIntf;
import oracle.dms.console.NounFactoryIntf;
import oracle.dms.console.PhaseEventFactoryIntf;
import oracle.dms.console.StateFactoryIntf;
import oracle.dms.context.ECForJDBC;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.EventIntf;
import oracle.dms.instrument.ExecutionContextForJDBC;
import oracle.dms.instrument.NounIntf;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.StateIntf;
import oracle.jdbc.driver.DMSFactory;

public class LiveDMSFactory
extends DMSFactory {
    protected final EventFactoryIntf eventFactory = oracle.dms.console.DMSConsole.getConsole().newEventFactory();
    protected final NounFactoryIntf nounFactory = oracle.dms.console.DMSConsole.getConsole().newNounFactory();
    protected final PhaseEventFactoryIntf phaseEventFactory = oracle.dms.console.DMSConsole.getConsole().newPhaseEventFactory();
    protected final StateFactoryIntf stateFactory = oracle.dms.console.DMSConsole.getConsole().newStateFactory();

    protected LiveDMSFactory() throws ClassNotFoundException {
        SensorIntf_all = 511;
        PhaseEventIntf_all = 511;
        SensorIntf_active = 64;
        SENSOR_WEIGHT = DMSConsole.getSensorWeight();
        DMSConsole_NORMAL = 5;
        DMSFactory.Context.ECForJDBC.ACTION = "Action";
        DMSFactory.Context.ECForJDBC.CLIENTID = "client_identifier";
        DMSFactory.Context.ECForJDBC.ECID = "ECID_UID";
        DMSFactory.Context.ECForJDBC.MODULE = "Module";
        ecForJdbc = new LiveECForJDBC();
        executionContextForJDBC = new LiveExecutionContextForJDBC();
        Class.forName("oracle.core.ojdl.MessageType");
        try {
            Class.forName("oracle.dms.context.ECForJDBC");
            this.version = DMSFactory.DMSVersion.v11;
        }
        catch (ClassNotFoundException cnfEx) {
            this.version = DMSFactory.DMSVersion.v10G;
        }
    }

    @Override
    public DMSFactory.DMSEvent createEvent(DMSFactory.DMSNoun noun, String name, String desc) {
        NounIntf n = noun == null ? null : ((LiveDMSNoun)noun).target;
        return new LiveDMSEvent(this.eventFactory.create(n, name, desc));
    }

    @Override
    public DMSFactory.DMSNoun createNoun(DMSFactory.DMSNoun noun, String name, String type) {
        NounIntf n = noun == null ? null : ((LiveDMSNoun)noun).target;
        return new LiveDMSNoun(this.nounFactory.create(n == null ? ((LiveDMSNoun)this.getRoot()).target : n, name, type == null ? "n/a" : type));
    }

    @Override
    public DMSFactory.DMSNoun createNoun(String path, String type) {
        return new LiveDMSNoun(this.nounFactory.create(path, type == null ? "n/a" : type));
    }

    @Override
    public DMSFactory.DMSPhase createPhaseEvent(DMSFactory.DMSNoun noun, String name, String desc) {
        NounIntf n = noun == null ? null : ((LiveDMSNoun)noun).target;
        return new LiveDMSPhase(this.phaseEventFactory.create(n, name, desc));
    }

    @Override
    public DMSFactory.DMSState createState(DMSFactory.DMSNoun noun, String name, String units, String desc, int value) {
        NounIntf n = noun == null ? null : ((LiveDMSNoun)noun).target;
        return new LiveDMSState(this.stateFactory.create(n, name, units, desc, value));
    }

    @Override
    public DMSFactory.DMSState createState(DMSFactory.DMSNoun noun, String name, String units, String desc, Object value) {
        NounIntf n = noun == null ? null : ((LiveDMSNoun)noun).target;
        return new LiveDMSState(this.stateFactory.create(n, name, units, desc, value));
    }

    @Override
    public DMSFactory.DMSNoun getRoot() {
        LiveDMSNoun tNoun = new LiveDMSNoun(this.nounFactory.getRoot());
        return tNoun;
    }

    @Override
    public long getToken() {
        return this.phaseEventFactory.getToken();
    }

    @Override
    public DMSFactory.DMSNoun get(String name) {
        NounIntf tNoun = this.nounFactory.get(name);
        if (tNoun != null) {
            return new LiveDMSNoun(tNoun);
        }
        return null;
    }

    @Override
    protected boolean isLive() {
        return true;
    }

    protected class LiveDMSState
    extends DMSFactory.DMSState {
        protected final StateIntf target;

        protected LiveDMSState(StateIntf t2) {
            this.target = t2;
        }

        @Override
        public void deriveMetric(int metric) {
            this.target.deriveMetric(metric);
        }

        @Override
        public void destroy() {
            this.target.destroy();
        }

        @Override
        public void update(Object newVal) {
            this.target.update(newVal);
        }
    }

    protected class LiveDMSPhase
    extends DMSFactory.DMSPhase {
        protected final PhaseEventIntf target;

        protected LiveDMSPhase(PhaseEventIntf t2) {
            this.target = t2;
        }

        @Override
        public void deriveMetric(int metric) {
            this.target.deriveMetric(metric);
        }

        @Override
        public long start() {
            return this.target.start();
        }

        @Override
        public void start(long token) {
            this.target.start(token);
        }

        @Override
        public void stop(long token) {
            this.target.stop(token);
        }

        @Override
        public void destroy() {
            this.target.destroy();
        }
    }

    protected class LiveDMSEvent
    extends DMSFactory.DMSEvent {
        protected final EventIntf target;

        protected LiveDMSEvent(EventIntf t2) {
            this.target = t2;
        }

        @Override
        public void occurred() {
            this.target.occurred();
        }
    }

    protected class LiveDMSNoun
    extends DMSFactory.DMSNoun {
        protected final NounIntf target;

        protected LiveDMSNoun(NounIntf t2) {
            this.target = t2;
        }

        @Override
        public DMSFactory.DMSState getSensor(String name) {
            Sensor sensor = this.target.getSensor(name);
            return new LiveDMSState((StateIntf)sensor);
        }

        @Override
        public void destroy() {
            this.target.destroy();
        }
    }

    private class LiveExecutionContextForJDBC
    extends DMSFactory.ExecutionContextForJDBC {
        private LiveExecutionContextForJDBC() {
        }

        @Override
        public String[] getExecutionContextState() {
            return ExecutionContextForJDBC.getExecutionContextState();
        }

        @Override
        public int getECIDSequenceNumber() {
            return ExecutionContextForJDBC.getECIDSequenceNumber();
        }
    }

    protected class LiveECForJDBC
    extends DMSFactory.Context.ECForJDBC {
        protected LiveECForJDBC() {
        }

        @Override
        public boolean updateSqlText() {
            return ECForJDBC.updateSqlText();
        }

        @Override
        public Map<String, Map<String, String>> getMap() {
            return ECForJDBC.getMap();
        }

        @Override
        public void finished() {
            ECForJDBC.finished();
        }
    }
}

