/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import oracle.jdbc.DatabaseFunction;
import oracle.jdbc.TraceEventListener;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.SimpleTraceContext;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTICookie;
import oracle.jdbc.driver.T4CTTIMsg;

class T4C8TTIpro
extends T4CTTIMsg {
    private static final String CLASS_NAME = T4C8TTIpro.class.getName();
    short svrCharSet;
    short svrCharSetElem;
    byte svrFlags;
    byte[] svrPortDescription;
    short proSvrVer;
    short oVersion = (short)-1;
    boolean svrInfoAvailable = false;
    byte[] proCliVerTTC8 = new byte[]{6, 5, 4, 3, 2, 1, 0};
    byte[] proCliStrTTC8 = new byte[]{74, 97, 118, 97, 95, 84, 84, 67, 45, 56, 46, 50, 46, 48, 0};
    short NCHAR_CHARSET = 0;
    byte[] runtimeCapabilities = null;
    byte[] compileTimeCapabilities = null;

    T4C8TTIpro(T4CConnection _conn) throws SQLException, IOException {
        super(_conn, (byte)1);
    }

    public byte[] getSvrPortDescription() {
        return this.svrPortDescription;
    }

    public void setProtocolAndOracleVersions(short protocolVersion) throws SQLException {
        switch (protocolVersion) {
            case 4: {
                this.oVersion = (short)7230;
                break;
            }
            case 5: {
                this.oVersion = (short)8030;
                break;
            }
            case 6: {
                this.oVersion = (short)8100;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 444).fillInStackTrace();
            }
        }
        this.proSvrVer = protocolVersion;
    }

    byte[] receivePacket() throws SQLException, IOException {
        if (this.meg.unmarshalUB1() != 1) {
            this.connection.net().getSessionAttributes().ano.checkForAnoNegotiationFailure();
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401).fillInStackTrace();
        }
        return this.receivePayload();
    }

    byte[] receivePayload() throws SQLException, IOException {
        int j;
        this.meg.proSvrVer = this.meg.unmarshalUB1();
        this.setProtocolAndOracleVersions(this.meg.proSvrVer);
        this.meg.unmarshalUB1();
        this.svrPortDescription = this.meg.unmarshalTEXT(50);
        this.svrCharSet = (short)this.meg.unmarshalNativeUB2(true);
        this.svrFlags = (byte)this.meg.unmarshalUB1();
        this.svrCharSetElem = (short)this.meg.unmarshalNativeUB2(true);
        if (this.svrCharSetElem > 0) {
            this.meg.unmarshalNBytes(this.svrCharSetElem * 5);
        }
        this.svrInfoAvailable = true;
        if (this.proSvrVer < 5) {
            return null;
        }
        int fdoLength = this.meg.unmarshalNativeUB2(false);
        byte[] fdo = this.meg.unmarshalNBytes(fdoLength);
        int i = 6 + (fdo[5] & 0xFF) + (fdo[6] & 0xFF);
        this.NCHAR_CHARSET = (short)((fdo[i + 3] & 0xFF) << 8);
        this.NCHAR_CHARSET = (short)(this.NCHAR_CHARSET | (short)(fdo[i + 4] & 0xFF));
        if (this.proSvrVer < 6) {
            return null;
        }
        int len = this.meg.unmarshalUB1();
        this.compileTimeCapabilities = new byte[len];
        for (j = 0; j < len; ++j) {
            this.compileTimeCapabilities[j] = (byte)this.meg.unmarshalUB1();
        }
        len = this.meg.unmarshalUB1();
        if (len > 0) {
            this.runtimeCapabilities = new byte[len];
            for (j = 0; j < len; ++j) {
                this.runtimeCapabilities[j] = (byte)this.meg.unmarshalUB1();
            }
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "receive", "negotiated ttc oVersion={0}, server charset={1}", (String)null, (Throwable)null, (Object)this.oVersion, (Object)this.svrCharSet);
        return this.compileTimeCapabilities;
    }

    public void initFrom(T4CTTICookie cookie) throws SQLException {
        assert (cookie != null) : "cookie cannot be null";
        this.setProtocolAndOracleVersions(cookie.getConnectionProtocolVersion());
        this.svrPortDescription = cookie.getDatabasePortage();
        this.svrCharSet = cookie.getDatabaseCharSet();
        this.svrFlags = cookie.getDatabaseCharSetFlag();
        this.setNCharCharacterSet(cookie.getDatabaseNCharSet());
        this.runtimeCapabilities = cookie.getDatabaseRuntimeCapabilities();
        this.compileTimeCapabilities = cookie.getDatabaseCompileTimeCapabilities();
    }

    void setNCharCharacterSet(short nCharSet) {
        this.NCHAR_CHARSET = nCharSet;
    }

    final CompletionStage<byte[]> receiveAsync(Executor executor) {
        CompletableFuture<byte[]> receiveFuture = new CompletableFuture<byte[]>();
        this.meg.net.onWriteReady(writeError -> executor.execute(() -> {
            if (writeError != null) {
                receiveFuture.completeExceptionally((Throwable)writeError);
                return;
            }
            try {
                this.meg.flush();
                this.meg.net.onReadReady(readError -> executor.execute(() -> {
                    if (readError != null) {
                        receiveFuture.completeExceptionally((Throwable)readError);
                        return;
                    }
                    try {
                        byte[] compileTimeCapabilities = this.receivePacket();
                        receiveFuture.complete(compileTimeCapabilities);
                    }
                    catch (Throwable throwable) {
                        receiveFuture.completeExceptionally(throwable);
                    }
                }));
            }
            catch (Throwable throwable) {
                receiveFuture.completeExceptionally(throwable);
            }
        }));
        return receiveFuture;
    }

    short getOracleVersion() {
        return this.oVersion;
    }

    byte[] getServerRuntimeCapabilities() {
        return this.runtimeCapabilities;
    }

    byte[] getServerCompileTimeCapabilities() {
        return this.compileTimeCapabilities;
    }

    short getCharacterSet() {
        return this.svrCharSet;
    }

    short getncharCHARSET() {
        return this.NCHAR_CHARSET;
    }

    byte getFlags() {
        return this.svrFlags;
    }

    void marshal() throws IOException {
        this.marshalTTCcode();
        this.meg.marshalB1Array(this.proCliVerTTC8);
        this.meg.marshalB1Array(this.proCliStrTTC8);
    }

    short getProtocolVersion() {
        return this.proSvrVer;
    }

    void doRPC() throws IOException, SQLException {
        SimpleTraceContext ctx = SimpleTraceContext.builder().connectionId(this.connection.getNetConnectionId()).function(DatabaseFunction.TTC_PRO_ROUNDTRIP).build();
        this.connection.getTraceEventListener().roundTrip(TraceEventListener.Sequence.BEFORE, ctx, null);
        this.marshal();
        this.receivePacket();
        this.connection.getTraceEventListener().roundTrip(TraceEventListener.Sequence.AFTER, ctx, null);
    }

    void printServerInfo() {
        if (this.svrInfoAvailable) {
            int i = 0;
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "printServerInfo", "Protocol version={0} oVersion ={1}", (String)null, (Throwable)null, (Object)this.proSvrVer, (Object)this.oVersion);
            StringWriter s2 = new StringWriter();
            s2.write("Protocol string  =");
            while (i < this.svrPortDescription.length) {
                s2.write((char)this.svrPortDescription[i++]);
            }
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "printServerInfo", "{0}\nCharacter Set ID  = {1}\nRemote flags      = {2}\nNumber of Elements in Server's Character Set Graph = {3}", (String)null, (Throwable)null, (Object)s2.toString(), (Object)this.svrCharSet, (Object)this.svrFlags, (Object)this.svrCharSetElem);
        } else {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "printServerInfo", "Server info Not Available", null, null);
        }
    }
}

