/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Clob;
import java.sql.SQLException;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.ReadOnlyByteArray;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.driver.SimpleByteArray;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.VectorData;
import oracle.jdbc.driver.VectorMetaDataImpl;
import oracle.jdbc.driver.utils.AutoCloseableAdapter;
import oracle.jdbc.driver.utils.ThrowingRunnable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleTypes;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.VECTOR;

public class VectorAccessor
extends LobCommonAccessor {
    static final int MAXLENGTH = 4000;
    private final Class<?> defaultConversion;

    VectorAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean isOutBind, boolean isStoredInBindData) throws SQLException {
        super(Representation.VECTOR, stmt, 4000, isStoredInBindData);
        int oracleTypeCode;
        this.init(stmt, 127, 127, form, isOutBind);
        this.initForDataAccess(external_type, max_len, null);
        if (OracleTypes.isVector(external_type)) {
            oracleTypeCode = external_type;
        } else if (external_type == 127) {
            oracleTypeCode = -105;
        } else {
            throw (SQLException)DatabaseError.createSqlException((OracleConnection)stmt.connection, 4, Integer.toString(external_type)).fillInStackTrace();
        }
        VectorMetaDataImpl metaData = VectorMetaDataImpl.create(-1, oracleTypeCode, false);
        this.setVectorMetaData(metaData);
        this.defaultConversion = VectorAccessor.getDefaultConversion(this.statement.connection.vectorDefaultGetObjectType);
    }

    VectorAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, long contflag, int total_elems, short form) throws SQLException {
        super(Representation.VECTOR, stmt, 4000, false);
        this.init(stmt, 127, 127, form, false);
        this.initForDescribe(127, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
        this.defaultConversion = VectorAccessor.getDefaultConversion(stmt.connection.vectorDefaultGetObjectType);
    }

    @Override
    final boolean isPrefetched() {
        return this.lobPrefetchSizeForThisColumn > -1;
    }

    static Class<?> getDefaultConversion(String configured) {
        if (configured == null) {
            return null;
        }
        switch (configured) {
            case "double[]": {
                return double[].class;
            }
            case "float[]": {
                return float[].class;
            }
            case "byte[]": {
                return byte[].class;
            }
            case "short[]": {
                return short[].class;
            }
            case "int[]": {
                return int[].class;
            }
            case "long[]": {
                return long[].class;
            }
            case "boolean[]": {
                return boolean[].class;
            }
            case "String": {
                return String.class;
            }
            case "java.sql.Clob": 
            case "Clob": {
                return Clob.class;
            }
            case "oracle.sql.VECTOR": 
            case "VECTOR": {
                return VECTOR.class;
            }
            case "preferred-array-class": {
                return Object.class;
            }
        }
        return null;
    }

    @Override
    Object getObject(int currentRow) throws SQLException {
        if (this.defaultConversion == null) {
            throw DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "JDBC 4.3 does not specify a default conversion for VECTOR. A default conversion may be configured using the  \"oracle.jdbc.vectorDefaultGetObjectType\" connection property");
        }
        if (Clob.class.isAssignableFrom(this.defaultConversion)) {
            return this.getCLOB(currentRow);
        }
        return this.decode(currentRow, this.defaultConversion);
    }

    @Override
    CLOB getCLOB(int currentRow) throws SQLException {
        String string = this.getString(currentRow);
        if (string == null) {
            return null;
        }
        char[] charArray = string.toCharArray();
        byte[] quasiLocator = T4CConnection.setupClobVectorQuasiLocator(charArray.length, this.statement.connection.conversion.serverCharSetId);
        CLOB clob = new CLOB(this.statement.connection, quasiLocator);
        clob.setPrefetchedData(charArray);
        clob.setLength(charArray.length);
        clob.setActivePrefetch(true);
        return clob;
    }

    @Override
    String getString(int currentRow) throws SQLException {
        return this.decode(currentRow, String.class);
    }

    @Override
    double[] getDoubleArray(int currentRow) throws SQLException {
        return this.decode(currentRow, double[].class);
    }

    @Override
    float[] getFloatArray(int currentRow) throws SQLException {
        return this.decode(currentRow, float[].class);
    }

    @Override
    byte[] getBytes(int currentRow) throws SQLException {
        return this.decode(currentRow, byte[].class);
    }

    @Override
    short[] getShortArray(int currentRow) throws SQLException {
        return this.decode(currentRow, short[].class);
    }

    @Override
    int[] getIntArray(int currentRow) throws SQLException {
        return this.decode(currentRow, int[].class);
    }

    @Override
    long[] getLongArray(int currentRow) throws SQLException {
        return this.decode(currentRow, long[].class);
    }

    @Override
    boolean[] getBooleanArray(int currentRow) throws SQLException {
        return this.decode(currentRow, boolean[].class);
    }

    @Override
    VECTOR getOracleObject(int currentRow) throws SQLException {
        byte[] data = this.copyVectorData(currentRow);
        if (data == null) {
            return null;
        }
        return oracle.sql.VECTOR.fromData(data);
    }

    @Override
    VECTOR getVECTOR(int currentRow) throws SQLException {
        return this.getOracleObject(currentRow);
    }

    @Override
    VECTOR.SparseDoubleArray getSparseDoubleArray(int currentRow) throws SQLException {
        return this.decode(currentRow, VECTOR.SparseDoubleArray.class);
    }

    @Override
    VECTOR.SparseFloatArray getSparseFloatArray(int currentRow) throws SQLException {
        return this.decode(currentRow, VECTOR.SparseFloatArray.class);
    }

    @Override
    VECTOR.SparseByteArray getSparseByteArray(int currentRow) throws SQLException {
        return this.decode(currentRow, VECTOR.SparseByteArray.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T decode(int currentRow, Class<T> decodedClass) throws SQLException {
        long rowDataPosition = this.rowData.getPosition();
        try {
            ByteArray data = this.getVectorData(currentRow);
            if (data == null) {
                T t2 = null;
                return t2;
            }
            boolean isIeeeReencoding = !(data instanceof ReadOnlyByteArray);
            T t3 = VectorData.decode(data, decodedClass, isIeeeReencoding);
            return t3;
        }
        finally {
            this.rowData.setPosition(rowDataPosition);
        }
    }

    private byte[] copyVectorData(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (!this.isPrefetched()) {
            return this.copyLobVectorData(currentRow);
        }
        long length = this.getPrefetchedLength(currentRow);
        if (length > Integer.MAX_VALUE) {
            throw this.vectorTooLarge(length);
        }
        if (length > (long)this.getPrefetchedDataLength(currentRow)) {
            return this.copyLobVectorData(currentRow);
        }
        return this.rowData.get(this.getPrefetchedDataOffset(currentRow), (int)length);
    }

    private ByteArray getVectorData(int currentRow) throws SQLException {
        if (this.isNull(currentRow)) {
            return null;
        }
        if (!this.isPrefetched()) {
            byte[] data = this.copyLobVectorData(currentRow);
            return new SimpleByteArray(this.getDiagnosable(), data);
        }
        long length = this.getPrefetchedLength(currentRow);
        if (length > Integer.MAX_VALUE) {
            throw this.vectorTooLarge(length);
        }
        if (length > (long)this.getPrefetchedDataLength(currentRow)) {
            byte[] data = this.copyLobVectorData(currentRow);
            return new SimpleByteArray(this.getDiagnosable(), data);
        }
        this.rowData.setPosition(this.getPrefetchedDataOffset(currentRow));
        return this.rowData;
    }

    private byte[] copyLobVectorData(int currentRow) throws SQLException {
        byte[] locator = super.getBytesInternal(currentRow);
        BLOB blob = new BLOB(this.statement.connection, locator);
        try (AutoCloseableAdapter<SQLException> blobFree = VectorAccessor.autoFree(blob);){
            int prefetchedLength;
            long length;
            long l = length = this.isPrefetched() ? this.getPrefetchedLength(currentRow) : blob.length();
            if (length > Integer.MAX_VALUE) {
                throw this.vectorTooLarge(length);
            }
            byte[] data = new byte[(int)length];
            int n = prefetchedLength = this.isPrefetched() ? this.getPrefetchedDataLength(currentRow) : 0;
            if (prefetchedLength > 0) {
                this.rowData.get(this.getPrefetchedDataOffset(currentRow), data, 0, prefetchedLength);
            }
            blob.getBytes(prefetchedLength + 1, (int)length - prefetchedLength, data);
            byte[] byArray = data;
            return byArray;
        }
    }

    private static AutoCloseableAdapter<SQLException> autoFree(BLOB blob) throws SQLException {
        byte[] locator = blob.shareBytes();
        ThrowingRunnable free = PhysicalConnection.isTemporary(locator) && PhysicalConnection.isMemoryLocator(locator) ? blob::free : () -> {};
        return AutoCloseableAdapter.adapt(free);
    }

    private SQLException vectorTooLarge(long length) {
        return VectorAccessor.unrecognizedData("Vector length exceeds 2GB: " + length);
    }

    private static SQLException unrecognizedData(String message) {
        return DatabaseError.createSqlException(null, 89, message);
    }
}

