/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import oracle.jdbc.driver.json.Jsonp;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.JakartaOsonContext;
import oracle.jdbc.driver.json.binary.JsonSerializerImpl;
import oracle.jdbc.driver.json.binary.JsonpOsonContext;
import oracle.jdbc.driver.json.binary.OsonAbstractObject;
import oracle.jdbc.driver.json.binary.OsonContext;
import oracle.sql.json.OracleJsonBinary;
import oracle.sql.json.OracleJsonNumber;
import oracle.sql.json.OracleJsonObject;
import oracle.sql.json.OracleJsonTimestampTZ;
import oracle.sql.json.OracleJsonValue;

public class OsonObjectImpl
extends OsonAbstractObject
implements OracleJsonObject {
    public OsonObjectImpl(OsonContext ctx, int pos) {
        super(ctx);
        this.init(pos);
    }

    @Override
    public <T> T wrap(Class<T> c) {
        OsonContext newCtx = Jsonp.isJakartaJson(c) ? new JakartaOsonContext(this.ctx) : new JsonpOsonContext(this.ctx);
        return c.cast(newCtx.valueFactory.createObject(newCtx, this.pos));
    }

    @Override
    public OracleJsonValue get(Object key) {
        return (OracleJsonValue)this.getInternal(key);
    }

    public OracleJsonValue get(int position) {
        return (OracleJsonValue)this.getInternal(position);
    }

    @Override
    public Collection<OracleJsonValue> values() {
        return new OsonAbstractObject.OsonObjectValues<OracleJsonValue>();
    }

    @Override
    public Set<Map.Entry<String, OracleJsonValue>> entrySet() {
        return new OsonAbstractObject.OsonEntrySet<OracleJsonValue>();
    }

    @Override
    public String toString() {
        StringWriter writer = new StringWriter();
        JsonSerializerImpl ser = new JsonSerializerImpl(writer);
        ser.write(this);
        ser.close();
        return writer.toString();
    }

    @Override
    public byte[] getBytes(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonBinary)this.getValueInternal(childOffset)).getBytes();
    }

    @Override
    public byte[] getBytes(String key, byte[] d) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return d;
        }
        OracleJsonValue v = (OracleJsonValue)this.getValueInternal(childOffset);
        return v.getOracleJsonType() == OracleJsonValue.OracleJsonType.BINARY ? v.asJsonBinary().getBytes() : d;
    }

    @Override
    public double getDouble(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(childOffset)).doubleValue();
    }

    @Override
    public double getDouble(String key, double d) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return d;
        }
        OracleJsonNumber n = this.getNumeric(childOffset);
        return n == null ? d : n.doubleValue();
    }

    private OracleJsonNumber getNumeric(int childOffset) {
        Object v = this.getValueInternal(childOffset);
        return v instanceof OracleJsonNumber ? (OracleJsonNumber)v : null;
    }

    @Override
    public long getLong(String key, long d) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return d;
        }
        OracleJsonNumber n = this.getNumeric(childOffset);
        return n == null ? d : n.longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String key, BigDecimal d) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return d;
        }
        OracleJsonNumber n = this.getNumeric(childOffset);
        return n == null ? d : n.bigDecimalValue();
    }

    @Override
    public long getLong(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(childOffset)).longValue();
    }

    @Override
    public BigDecimal getBigDecimal(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        return ((OracleJsonNumber)this.getValueInternal(childOffset)).bigDecimalValue();
    }

    @Override
    public LocalDateTime getLocalDateTime(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        OracleJsonValue v = (OracleJsonValue)this.getValueInternal(childOffset);
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return v.asJsonDate().getLocalDateTime();
        }
        return v.asJsonTimestamp().getLocalDateTime();
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String key) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            throw new NullPointerException();
        }
        OracleJsonTimestampTZ v = (OracleJsonTimestampTZ)this.getValueInternal(childOffset);
        return v.getOffsetDateTime();
    }

    @Override
    public LocalDateTime getLocalDateTime(String key, LocalDateTime defaultValue) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return defaultValue;
        }
        OracleJsonValue v = (OracleJsonValue)this.getValueInternal(childOffset);
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.DATE) {
            return v.asJsonDate().getLocalDateTime();
        }
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMP) {
            return v.asJsonTimestamp().getLocalDateTime();
        }
        return defaultValue;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String key, OffsetDateTime defaultValue) {
        int childOffset = this.getChildOffset(key);
        if (childOffset == -1) {
            return defaultValue;
        }
        OracleJsonValue v = (OracleJsonValue)this.getValueInternal(childOffset);
        if (v.getOracleJsonType() == OracleJsonValue.OracleJsonType.TIMESTAMPTZ) {
            return v.asJsonTimestampTZ().getOffsetDateTime();
        }
        return defaultValue;
    }

    @Override
    public OracleJsonValue put(String name, String value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String name, int value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String name, long value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String name, BigDecimal value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String name, double value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String name, boolean value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue putNull(String name) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String name, byte[] values) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String key, OracleJsonValue value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue remove(Object key) {
        throw this.createNotModifiable();
    }

    @Override
    public void putAll(Map<? extends String, ? extends OracleJsonValue> m4) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String key, LocalDateTime value) {
        throw this.createNotModifiable();
    }

    @Override
    public OracleJsonValue put(String key, OffsetDateTime value) {
        throw this.createNotModifiable();
    }

    @Override
    public void clear() {
        throw this.createNotModifiable();
    }

    private UnsupportedOperationException createNotModifiable() {
        throw OracleJsonExceptions.OBJ_NOT_MUTABLE.create(OracleJsonExceptions.ORACLE_FACTORY, new Object[0]);
    }
}

