/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.parser.util;

import java.util.Arrays;

public class Array {
    public static int indexOf(int[] array, int value) {
        return Array.indexOf(array, 0, array.length - 1, value);
    }

    private static int indexOf(int[] array, int xx, int yy, int value) {
        if (xx + 1 == yy || xx == yy) {
            return array[xx] < value ? yy : xx;
        }
        int mid = (xx + yy) / 2;
        if (value < array[mid]) {
            return Array.indexOf(array, xx, mid, value);
        }
        return Array.indexOf(array, mid, yy, value);
    }

    public static int indexOf(long[] array, int xx, int yy, long value) {
        if (xx + 1 == yy || xx == yy) {
            return array[xx] < value ? yy : xx;
        }
        int mid = (xx + yy) / 2;
        if (value < array[mid]) {
            return Array.indexOf(array, xx, mid, value);
        }
        return Array.indexOf(array, mid, yy, value);
    }

    public static int[] insert(int[] array, int value) {
        int i;
        if (array == null || array.length == 0) {
            array = new int[]{value};
            return array;
        }
        int index = Array.indexOf(array, 0, array.length, value);
        if (index < array.length && array[index] == value) {
            return array;
        }
        int[] ret = new int[array.length + 1];
        for (i = 0; i < index; ++i) {
            ret[i] = array[i];
        }
        ret[index] = value;
        for (i = index + 1; i < ret.length; ++i) {
            ret[i] = array[i - 1];
        }
        return ret;
    }

    public static long[] insert(long[] array, long value) {
        int i;
        if (array == null || array.length == 0) {
            array = new long[]{value};
            return array;
        }
        int index = Array.indexOf(array, 0, array.length, value);
        if (index < array.length && array[index] == value) {
            return array;
        }
        long[] ret = new long[array.length + 1];
        for (i = 0; i < index; ++i) {
            ret[i] = array[i];
        }
        ret[index] = value;
        for (i = index + 1; i < ret.length; ++i) {
            ret[i] = array[i - 1];
        }
        return ret;
    }

    public static int[] delete(int[] array, int value) {
        int i;
        int index = Array.indexOf(array, 0, array.length, value);
        if (index == array.length || array[index] != value) {
            return array;
        }
        int[] ret = new int[array.length - 1];
        for (i = 0; i < index; ++i) {
            ret[i] = array[i];
        }
        for (i = index; i < ret.length; ++i) {
            ret[i] = array[i + 1];
        }
        return ret;
    }

    public static int[] delete(int[] array, int minVal, int maxVal) {
        int i;
        int iMax;
        if (minVal + 1 == maxVal) {
            return Array.delete(array, minVal);
        }
        int iMin = Array.indexOf(array, 0, array.length, minVal);
        if (array.length <= iMin) {
            return array;
        }
        if (array[iMin] < minVal) {
            ++iMin;
        }
        if (array[iMax = Array.indexOf(array, 0, array.length, maxVal)] > maxVal) {
            --iMax;
        }
        if (iMin == iMax) {
            return array;
        }
        int[] ret = new int[array.length - (iMax - iMin)];
        for (i = 0; i < iMin; ++i) {
            ret[i] = array[i];
        }
        for (i = iMax; i < array.length; ++i) {
            ret[i - (iMax - iMin)] = array[i];
        }
        return ret;
    }

    public static int[] merge(int[] x, int[] y) {
        int p;
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        int m4 = x.length;
        int n = y.length;
        int[] tmp = new int[m4 + n];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < m4 && j < n) {
            if (x[i] == y[j]) {
                tmp[k++] = x[i++];
                ++j;
                continue;
            }
            if (x[i] < y[j]) {
                tmp[k++] = x[i++];
                continue;
            }
            tmp[k++] = y[j++];
        }
        if (i < m4) {
            for (p = i; p < m4; ++p) {
                tmp[k++] = x[p];
            }
        } else {
            for (p = j; p < n; ++p) {
                tmp[k++] = y[p];
            }
        }
        int[] ret = new int[k];
        for (int ii = 0; ii < k; ++ii) {
            ret[ii] = tmp[ii];
        }
        return ret;
    }

    public static long[] merge(long[] x, long[] y) {
        if (x == null) {
            return y;
        }
        if (y == null) {
            return x;
        }
        int m4 = x.length;
        int n = y.length;
        long[] tmp = new long[m4 + n];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < m4 && j < n) {
            if (x[i] == y[j]) {
                tmp[k++] = x[i++];
                ++j;
                continue;
            }
            if (x[i] < y[j]) {
                tmp[k++] = x[i++];
                continue;
            }
            tmp[k++] = y[j++];
        }
        if (i < m4) {
            for (int p = i; p < m4; ++p) {
                tmp[k++] = x[p];
            }
        } else {
            for (int p = j; p < n; ++p) {
                tmp[k++] = y[p];
            }
        }
        return Arrays.copyOf(tmp, k);
    }
}

