/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.ByteBuffer;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import java.util.logging.Level;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.clio.annotations.Format;
import oracle.jdbc.diagnostics.Parameter;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.ObjectData;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.oracore.OracleNamedType;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeBFILE;
import oracle.jdbc.oracore.OracleTypeBINARY_DOUBLE;
import oracle.jdbc.oracore.OracleTypeBINARY_FLOAT;
import oracle.jdbc.oracore.OracleTypeBLOB;
import oracle.jdbc.oracore.OracleTypeCHAR;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.OracleTypeCOLLECTION;
import oracle.jdbc.oracore.OracleTypeDATE;
import oracle.jdbc.oracore.OracleTypeFLOAT;
import oracle.jdbc.oracore.OracleTypeINTERVAL;
import oracle.jdbc.oracore.OracleTypeNUMBER;
import oracle.jdbc.oracore.OracleTypeOPAQUE;
import oracle.jdbc.oracore.OracleTypeRAW;
import oracle.jdbc.oracore.OracleTypeREF;
import oracle.jdbc.oracore.OracleTypeROWID;
import oracle.jdbc.oracore.OracleTypeSINT32;
import oracle.jdbc.oracore.OracleTypeTIMESTAMP;
import oracle.jdbc.oracore.OracleTypeTIMESTAMPLTZ;
import oracle.jdbc.oracore.OracleTypeTIMESTAMPTZ;
import oracle.jdbc.oracore.OracleTypeUPT;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSPatch;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.TypeTreeElement;
import oracle.jdbc.oracore.Util;
import oracle.sql.AttributeDescriptor;
import oracle.sql.BLOB;
import oracle.sql.Datum;
import oracle.sql.JAVA_STRUCT;
import oracle.sql.NUMBER;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public class OracleTypeADT
extends OracleNamedType
implements Serializable,
Monitor {
    static final long serialVersionUID = 3031304012507165702L;
    private static final String CLASS_NAME = OracleTypeADT.class.getName();
    static final int S_TOP = 1;
    static final int S_EMBEDDED = 2;
    static final int S_UPT_ADT = 4;
    static final int S_JAVA_OBJECT = 16;
    static final int S_FINAL_TYPE = 32;
    static final int S_SUB_TYPE = 64;
    static final int S_ATTR_TDS = 128;
    static final int S_HAS_METADATA = 256;
    static final int S_TDS_PARSED = 512;
    private int statusBits = 1;
    int tdsVersion = -9999;
    static final int KOPT_V80 = 1;
    static final int KOPT_V81 = 2;
    static final int KOPT_VNFT = 3;
    static final int KOPT_VERSION = 3;
    boolean endOfAdt = false;
    int typeVersion = 1;
    long fixedDataSize = -1L;
    int alignmentRequirement = -1;
    OracleType[] attrTypes = null;
    String[] attrNames;
    String[] attrTypeNames;
    public long tdoCState = 0L;
    byte[] toid = null;
    int charSetId;
    int charSetForm;
    int flattenedAttrNum;
    transient int opcode;
    transient int idx = 1;
    boolean isTransient = false;
    private Monitor.CloseableLock monitorLock = Monitor.newDefaultLock();
    static final int CURRENT_USER_OBJECT = 0;
    static final int CURRENT_USER_SYNONYM = 1;
    static final int CURRENT_USER_SYNONYM_10g = 2;
    static final int CURRENT_USER_PUBLIC_SYNONYM = 3;
    static final int CURRENT_USER_PUBLIC_SYNONYM_10g = 4;
    static final int POSSIBLY_OTHER_USER_OBJECT = 5;
    static final int POSSIBLY_OTHER_USER_OBJECT_10g = 6;
    static final int OTHER_USER_OBJECT = 7;
    static final int OTHER_USER_SYNONYM = 8;
    static final int PUBLIC_SYNONYM = 9;
    static final int PUBLIC_SYNONYM_10g = 10;
    static final int BREAK = 11;
    static final String[] sqlString = new String[]{"SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME = :1 ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME in (SELECT TABLE_NAME FROM USER_SYNONYMS START WITH SYNONYM_NAME = :1 CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME UNION SELECT :1 FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS WHERE TYPE_NAME IN (SELECT TABLE_NAME FROM ALL_SYNONYMS START WITH SYNONYM_NAME = :1 AND  OWNER = 'PUBLIC' CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER UNION SELECT :2  FROM DUAL) ORDER BY ATTR_NO", "DECLARE CURSOR usyn_cur IS SELECT table_name, table_owner from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; l_syntown  user_synonyms.table_owner%TYPE; BEGIN SELECT TABLE_NAME, TABLE_OWNER BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name;   l_syntown :=  table_names(lastrow).table_owner; END IF; OPEN ? FOR SELECT  ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER   FROM ALL_TYPE_ATTRS  A   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?)  AND  A.OWNER = l_syntown   ORDER BY ATTR_NO; END;", "DECLARE CURSOR usyn_cur IS SELECT table_name, table_owner from user_synonyms; TYPE table_name_type IS TABLE OF usyn_cur%ROWTYPE; table_names table_name_type; lastrow BINARY_INTEGER := null; l_syntname user_synonyms.table_name%TYPE; l_syntown  user_synonyms.table_owner%TYPE; BEGIN SELECT TABLE_NAME, TABLE_OWNER BULK COLLECT INTO table_names FROM USER_SYNONYMS START WITH SYNONYM_NAME = ? CONNECT BY NOCYCLEPRIOR TABLE_NAME = SYNONYM_NAME; IF table_names.LAST IS NOT NULL THEN   lastrow := table_names.LAST;   l_syntname := table_names(lastrow).table_name;   l_syntown :=  table_names(lastrow).table_owner; END IF; OPEN ? FOR SELECT  ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER   FROM ALL_TYPE_ATTRS  A   WHERE (TYPE_NAME = l_syntname OR TYPE_NAME = ?)  AND  A.OWNER = l_syntown   ORDER BY ATTR_NO; END;", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = :1 AND TYPE_NAME = :2 ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS WHERE OWNER = (SELECT TABLE_OWNER FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:1) AND TYPE_NAME = (SELECT TABLE_NAME FROM ALL_SYNONYMS WHERE SYNONYM_NAME=:2) ORDER BY ATTR_NO", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;", "DECLARE   the_owner VARCHAR2(100);   the_type  VARCHAR2(100); begin  SELECT TABLE_NAME, TABLE_OWNER INTO THE_TYPE, THE_OWNER  FROM ALL_SYNONYMS  WHERE TABLE_NAME IN (SELECT TYPE_NAME FROM ALL_TYPES)  START WITH SYNONYM_NAME = :1 AND OWNER = 'PUBLIC'  CONNECT BY NOCYCLE PRIOR TABLE_NAME = SYNONYM_NAME AND TABLE_OWNER = OWNER; OPEN :2 FOR SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME,  ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS  WHERE TYPE_NAME = THE_TYPE and OWNER = THE_OWNER; END;"};
    static final int SEARCH_USER_TYPES = 0;
    static final int SEARCH_ALL_TYPES = 1;
    static final String[] sqlStringTOID = new String[]{"SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM USER_TYPE_ATTRS a, USER_TYPES b WHERE b.TYPE_OID = :1 AND a.TYPE_NAME = b.TYPE_NAME ORDER BY ATTR_NO", "SELECT ATTR_NO, ATTR_NAME, ATTR_TYPE_NAME, ATTR_TYPE_OWNER FROM ALL_TYPE_ATTRS a, ALL_TYPES b WHERE b.TYPE_OID = :1 AND a.TYPE_NAME = b.TYPE_NAME AND a.OWNER = b.OWNER ORDER BY ATTR_NO"};
    Boolean isInstanciable;
    String superTypeName;
    int numberOfLocalAttributes = -1;
    String[] subTypeNames;
    static final int TDS_SIZE = 4;
    static final int TDS_NUMBER = 1;
    static final int KOPM_OTS_SQL_CHAR = 1;
    static final int KOPM_OTS_DATE = 2;
    static final int KOPM_OTS_DECIMAL = 3;
    static final int KOPM_OTS_DOUBLE = 4;
    static final int KOPM_OTS_FLOAT = 5;
    static final int KOPM_OTS_NUMBER = 6;
    static final int KOPM_OTS_SQL_VARCHAR2 = 7;
    static final int KOPM_OTS_SINT32 = 8;
    static final int KOPM_OTS_REF = 9;
    static final int KOPM_OTS_VARRAY = 10;
    static final int KOPM_OTS_UINT8 = 11;
    static final int KOPM_OTS_SINT8 = 12;
    static final int KOPM_OTS_UINT16 = 13;
    static final int KOPM_OTS_UINT32 = 14;
    static final int KOPM_OTS_LOB = 15;
    static final int KOPM_OTS_UROWID = 16;
    static final int KOPM_OTS_CANONICAL = 17;
    static final int KOPM_OTS_OCTET = 18;
    static final int KOPM_OTS_RAW = 19;
    static final int KOPM_OTS_ROWID = 20;
    static final int KOPM_OTS_STAMP = 21;
    static final int KOPM_OTS_TZSTAMP = 23;
    static final int KOPM_OTS_INTERVAL = 24;
    static final int KOPM_OTS_PTR = 25;
    static final int KOPM_OTS_SINT16 = 26;
    static final int KOPM_OTS_UPT = 27;
    static final int KOPM_OTS_COLLECTION = 28;
    static final int KOPM_OTS_CLOB = 29;
    static final int KOPM_OTS_BLOB = 30;
    static final int KOPM_OTS_BFILE = 31;
    static final int KOPM_OTS_BINARY_INTEGE = 32;
    static final int KOPM_OTS_IMPTZSTAMP = 33;
    static final int KOPM_OTS_BFLOAT = 37;
    static final int KOPM_OTS_BDOUBLE = 45;
    static final int KOTTCOPQ = 58;
    static final int KOPT_OP_STARTEMBADT = 39;
    static final int KOPT_OP_ENDEMBADT = 40;
    static final int KOPT_OP_STARTADT = 41;
    static final int KOPT_OP_ENDADT = 42;
    static final int KOPT_OP_SUBTYPE_MARKER = 43;
    static final int KOPT_OP_EMBADT_INFO = 44;
    static final int KOPT_OPCODE_START = 38;
    static final int KOPT_OP_VERSION = 38;
    static final int REGULAR_PATCH = 0;
    static final int SIMPLE_PATCH = 1;

    protected OracleTypeADT() {
    }

    public OracleTypeADT(byte[] toid, int vsn, int csi, short csfrm, String fullName) throws SQLException {
        this(fullName, (Connection)null);
        this.toid = toid;
        this.typeVersion = vsn;
        this.charSetId = csi;
        this.charSetForm = csfrm;
    }

    public OracleTypeADT(String sql_name, Connection conn) throws SQLException {
        super(sql_name, (OracleConnection)conn);
        this.typeNameByUser = sql_name;
    }

    public OracleTypeADT(OracleTypeADT parent, int idx, Connection conn) throws SQLException {
        super(parent, idx, (OracleConnection)conn);
    }

    public OracleTypeADT(SQLName sqlName, byte[] typoid, int version, byte[] tds, OracleConnection conn) throws SQLException {
        this.sqlName = sqlName;
        this.init(tds, conn);
        this.toid = typoid;
        this.typeVersion = version;
    }

    public OracleTypeADT(AttributeDescriptor[] attr, OracleConnection conn) throws SQLException {
        int i;
        this.setConnectionInternal(conn);
        this.isTransient = true;
        this.flattenedAttrNum = attr.length;
        this.attrTypes = new OracleType[this.flattenedAttrNum];
        this.attrNames = new String[this.flattenedAttrNum];
        for (i = 0; i < this.flattenedAttrNum; ++i) {
            this.attrNames[i] = attr[i].getAttributeName();
        }
        this.statusBits |= 0x100;
        block25: for (i = 0; i < this.flattenedAttrNum; ++i) {
            TypeDescriptor td = attr[i].getTypeDescriptor();
            switch (td.getInternalTypeCode()) {
                case 12: {
                    this.attrTypes[i] = new OracleTypeDATE();
                    continue block25;
                }
                case 9: {
                    this.attrTypes[i] = new OracleTypeCHAR(this.connection, 12);
                    ((OracleTypeCHAR)this.attrTypes[i]).length = (int)td.getPrecision();
                    ((OracleTypeCHAR)this.attrTypes[i]).form = 1;
                    continue block25;
                }
                case 96: {
                    this.attrTypes[i] = new OracleTypeCHAR(this.connection, 1);
                    ((OracleTypeCHAR)this.attrTypes[i]).length = (int)td.getPrecision();
                    ((OracleTypeCHAR)this.attrTypes[i]).form = 1;
                    continue block25;
                }
                case 108: {
                    this.attrTypes[i] = (OracleTypeADT)td.getPickler();
                    ((OracleTypeADT)this.attrTypes[i]).setEmbeddedADT();
                    continue block25;
                }
                case 2: {
                    this.attrTypes[i] = new OracleTypeNUMBER(2);
                    ((OracleTypeNUMBER)this.attrTypes[i]).precision = (int)td.getPrecision();
                    ((OracleTypeNUMBER)this.attrTypes[i]).scale = td.getScale();
                    continue block25;
                }
                case 7: {
                    this.attrTypes[i] = new OracleTypeNUMBER(3);
                    ((OracleTypeNUMBER)this.attrTypes[i]).precision = (int)td.getPrecision();
                    ((OracleTypeNUMBER)this.attrTypes[i]).scale = td.getScale();
                    continue block25;
                }
                case 22: {
                    this.attrTypes[i] = new OracleTypeNUMBER(8);
                    ((OracleTypeNUMBER)this.attrTypes[i]).precision = (int)td.getPrecision();
                    ((OracleTypeNUMBER)this.attrTypes[i]).scale = td.getScale();
                    continue block25;
                }
                case 4: {
                    this.attrTypes[i] = new OracleTypeFLOAT();
                    ((OracleTypeFLOAT)this.attrTypes[i]).precision = (int)td.getPrecision();
                    continue block25;
                }
                case 100: {
                    this.attrTypes[i] = new OracleTypeBINARY_FLOAT();
                    continue block25;
                }
                case 101: {
                    this.attrTypes[i] = new OracleTypeBINARY_DOUBLE();
                    continue block25;
                }
                case 29: {
                    this.attrTypes[i] = new OracleTypeSINT32(false);
                    continue block25;
                }
                case 110: {
                    this.attrTypes[i] = new OracleTypeREF(this, i, this.connection);
                    continue block25;
                }
                case 114: {
                    this.attrTypes[i] = new OracleTypeBFILE(this.connection);
                    continue block25;
                }
                case 95: {
                    this.attrTypes[i] = new OracleTypeRAW();
                    continue block25;
                }
                case 112: {
                    this.attrTypes[i] = new OracleTypeCLOB(this.connection);
                    continue block25;
                }
                case 113: {
                    this.attrTypes[i] = new OracleTypeBLOB(this.connection);
                    continue block25;
                }
                case 187: {
                    this.attrTypes[i] = new OracleTypeTIMESTAMP(this.connection);
                    ((OracleTypeTIMESTAMP)this.attrTypes[i]).precision = (int)td.getPrecision();
                    continue block25;
                }
                case 188: {
                    this.attrTypes[i] = new OracleTypeTIMESTAMPTZ(this.connection);
                    ((OracleTypeTIMESTAMPTZ)this.attrTypes[i]).precision = (int)td.getPrecision();
                    continue block25;
                }
                case 232: {
                    this.attrTypes[i] = new OracleTypeTIMESTAMPLTZ(this.connection);
                    ((OracleTypeTIMESTAMPLTZ)this.attrTypes[i]).precision = (int)td.getPrecision();
                    continue block25;
                }
                case 189: {
                    this.attrTypes[i] = new OracleTypeINTERVAL(this.connection);
                    ((OracleTypeINTERVAL)this.attrTypes[i]).typeId = (byte)7;
                    ((OracleTypeINTERVAL)this.attrTypes[i]).precision = (int)td.getPrecision();
                    ((OracleTypeINTERVAL)this.attrTypes[i]).scale = td.getScale();
                    continue block25;
                }
                case 190: {
                    this.attrTypes[i] = new OracleTypeINTERVAL(this.connection);
                    ((OracleTypeINTERVAL)this.attrTypes[i]).typeId = (byte)10;
                    ((OracleTypeINTERVAL)this.attrTypes[i]).precision = (int)td.getPrecision();
                    ((OracleTypeINTERVAL)this.attrTypes[i]).scale = td.getScale();
                    continue block25;
                }
                case 122: {
                    this.attrTypes[i] = new OracleTypeCOLLECTION(this, i, this.connection);
                    continue block25;
                }
                default: {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 48, "type: " + td.getInternalTypeCode()).fillInStackTrace();
                }
            }
        }
    }

    @Override
    public Datum toDatum(Object value, OracleConnection conn) throws SQLException {
        if (value != null) {
            if (value instanceof STRUCT) {
                return (STRUCT)value;
            }
            if (value instanceof SQLData || value instanceof ObjectData) {
                return STRUCT.toSTRUCT(value, conn);
            }
            if (value instanceof Object[]) {
                StructDescriptor desc = this.createStructDescriptor();
                STRUCT result = this.createObjSTRUCT(desc, (Object[])value);
                return result;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, value).fillInStackTrace();
        }
        return null;
    }

    @Override
    public Datum[] toDatumArray(Object obj, OracleConnection conn, long beginIdx, int count) throws SQLException {
        Datum[] datumArray = null;
        if (obj != null) {
            if (obj instanceof Object[]) {
                Object[] objArray = (Object[])obj;
                int length = (int)(count == -1 ? (long)objArray.length : Math.min((long)objArray.length - beginIdx + 1L, (long)count));
                datumArray = new Datum[length];
                for (int i = 0; i < length; ++i) {
                    datumArray[i] = this.toDatum(objArray[(int)beginIdx + i - 1], conn);
                }
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 59, obj).fillInStackTrace();
            }
        }
        return datumArray;
    }

    @Override
    public int getTypeCode() throws SQLException {
        if ((this.getStatus() & 0x10) != 0) {
            return 2008;
        }
        return 2002;
    }

    public OracleType[] getAttrTypes() throws SQLException {
        if (this.attrTypes == null) {
            this.init(this.connection);
        }
        return this.attrTypes;
    }

    @Override
    public boolean isInHierarchyOf(OracleType anOracleType) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (anOracleType == null) {
                boolean bl = false;
                return bl;
            }
            if (!anOracleType.isObjectType()) {
                boolean bl = false;
                return bl;
            }
            StructDescriptor theOtherDesc = (StructDescriptor)anOracleType.getTypeDescriptor();
            boolean bl = this.descriptor.isInHierarchyOf(theOtherDesc.getName());
            return bl;
        }
    }

    @Override
    public boolean isInHierarchyOf(StructDescriptor aStructDescriptor) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (aStructDescriptor == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.descriptor.isInHierarchyOf(aStructDescriptor.getName());
            return bl;
        }
    }

    @Override
    public boolean isObjectType() {
        return true;
    }

    @Override
    public TypeDescriptor getTypeDescriptor() {
        return this.descriptor;
    }

    public void init(OracleConnection conn) throws SQLException {
        try (Monitor.CloseableLock lock = conn.acquireCloseableLock();){
            byte[] tds = this.initMetadata(conn);
            this.init(tds, conn);
        }
    }

    public CompletionStage<Void> initAsync(OracleConnection conn) {
        return this.initMetadataAsync(conn).thenApply(CompletionStageUtil.normalCompletionHandler(tds -> {
            this.init((byte[])tds, conn);
            return null;
        }));
    }

    public void init(byte[] tds, OracleConnection conn) throws SQLException {
        try (Monitor.CloseableLock lock = conn.acquireCloseableLock();){
            this.doInit(tds, conn);
        }
    }

    private void doInit(byte[] tds, OracleConnection conn) throws SQLException {
        this.statusBits = 1;
        this.connection = conn;
        if (tds != null) {
            this.parseTDS(tds, 0L);
        }
        this.setStatusBits(256);
    }

    public byte[] initMetadata(OracleConnection conn) throws SQLException {
        short dbVersion = conn.getVersionNumber();
        byte[] returnValue = null;
        returnValue = dbVersion >= 12000 ? this.initMetadata12(conn) : this.initMetadata11_2(conn);
        return returnValue;
    }

    /*
     * Exception decompiling
     */
    private byte[] initMetadata12(OracleConnection conn) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Loose catch block
     */
    private CompletionStage<byte[]> initMetadataAsync(OracleConnection conn) {
        try (Monitor.CloseableLock lock = conn.acquireCloseableLock();){
            CompletionStage<Object> executeStage;
            CallableStatement getTypeShapeCall;
            if ((this.statusBits & 0x100) != 0) {
                CompletionStage<Object> completionStage = CompletableFuture.completedStage(null);
                return completionStage;
            }
            try {
                this.connection.beginNonRequestCalls();
            }
            catch (SQLException beginCallsException) {
                CompletionStage<byte[]> completionStage = CompletableFuture.failedStage(beginCallsException);
                if (lock != null) {
                    lock.close();
                }
                return completionStage;
            }
            try {
                getTypeShapeCall = this.prepareGetTypeShapeCall(this.connection);
            }
            catch (SQLException prepareCallException) {
                try {
                    this.connection.endNonRequestCalls();
                }
                catch (SQLException endCallsException) {
                    CompletionStage<byte[]> completionStage = CompletableFuture.failedStage(endCallsException);
                    if (lock != null) {
                        lock.close();
                    }
                    return completionStage;
                }
                CompletionStage<byte[]> endCallsException = CompletableFuture.failedStage(prepareCallException);
                if (lock != null) {
                    lock.close();
                }
                return endCallsException;
            }
            try {
                executeStage = CompletionStageUtil.subscribeForSingleItem(getTypeShapeCall.unwrap(OraclePreparedStatement.class).executeAsyncOracle());
            }
            catch (SQLException executeException) {
                executeStage = CompletableFuture.failedStage(executeException);
            }
            CompletionStage<byte[]> completionStage = executeStage.thenCompose(CompletionStageUtil.normalCompletionHandler(executeResult -> {
                int returnCode = getTypeShapeCall.getInt(1);
                if (returnCode == 0) {
                    return CompletableFuture.completedStage(false);
                }
                if (returnCode == 24331) {
                    getTypeShapeCall.registerOutParameter(5, 2004);
                    return CompletionStageUtil.subscribeForSingleItem(getTypeShapeCall.unwrap(OraclePreparedStatement.class).executeAsyncOracle()).thenApply(CompletionStageUtil.normalCompletionHandler(reExecuteResult -> {
                        int useBlobErrorCode = getTypeShapeCall.getInt(1);
                        if (useBlobErrorCode != 0) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 74, this.typeNameByUser).fillInStackTrace();
                        }
                        return true;
                    }));
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 74, this.typeNameByUser).fillInStackTrace();
            })).thenCompose(CompletionStageUtil.normalCompletionHandler(useBlob -> {
                this.toid = getTypeShapeCall.getBytes(3);
                this.typeVersion = NUMBER.toInt(getTypeShapeCall.getBytes(4));
                if (!useBlob.booleanValue()) {
                    return CompletableFuture.completedStage(getTypeShapeCall.getBytes(5));
                }
                BLOB tdsBlob = (BLOB)((OracleCallableStatement)getTypeShapeCall).getBlob(5);
                return this.readTdsBlobAsync(tdsBlob);
            })).thenCompose(CompletionStageUtil.normalCompletionHandler(myTDS -> {
                ResultSet attributesCursor;
                this.metaDataInitialized = true;
                this.isInstanciable = "YES".equalsIgnoreCase(getTypeShapeCall.getString(6));
                Object superTypeName = getTypeShapeCall.getString(8);
                if (superTypeName != null) {
                    superTypeName = getTypeShapeCall.getString(7) + (String)superTypeName;
                }
                if ((attributesCursor = (ResultSet)getTypeShapeCall.getObject(9)) != null) {
                    return this.initializeAttributeNamesAsync(attributesCursor).handle((nil, error) -> {
                        CompletionStageUtil.handleCompletion(nil, error, () -> attributesCursor.close());
                        return myTDS;
                    });
                }
                return CompletableFuture.completedStage(myTDS);
            })).thenCompose(CompletionStageUtil.normalCompletionHandler(myTDS -> {
                ResultSet subTypeCursor = (ResultSet)getTypeShapeCall.getObject(10);
                if (subTypeCursor != null) {
                    return this.initializeSubTypeNamesAsync(subTypeCursor).handle((nil, error) -> {
                        CompletionStageUtil.handleCompletion(nil, error, () -> subTypeCursor.close());
                        return myTDS;
                    });
                }
                return CompletableFuture.completedStage(myTDS);
            })).handle((myTDS, error) -> CompletionStageUtil.handleCompletion(myTDS, error, () -> {
                try (Monitor.CloseableLock errorLock = conn.acquireCloseableLock();){
                    try {
                        if (error == null) {
                            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initMetadataAsync", "OracleTypeADT.initMetadata:tds={0}", (String)null, null, (Object)Parameter.arg(Format.Style.BYTE_ARRAY, myTDS, new long[0]));
                            this.flattenedAttrNum = Util.getUnsignedByte(myTDS[8]) * 256 + Util.getUnsignedByte(myTDS[9]);
                            this.setStatusBits(256);
                        }
                    }
                    finally {
                        try {
                            getTypeShapeCall.close();
                        }
                        catch (SQLException closeException) {
                            if (error != null) {
                                closeException.addSuppressed((Throwable)error);
                            }
                            throw new CompletionException(closeException);
                        }
                        finally {
                            this.connection.endNonRequestCalls();
                        }
                    }
                }
            }));
            return completionStage;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    private CompletionStage<byte[]> readTdsBlobAsync(final BLOB tdsBlob) {
        return tdsBlob.lengthInternalAsync().thenCompose(CompletionStageUtil.normalCompletionHandler(tdsLength -> {
            final byte[] myTDS = new byte[tdsLength.intValue()];
            final CompletableFuture tdsFuture = new CompletableFuture();
            tdsBlob.publisherOracle(1L).subscribe(new Flow.Subscriber<byte[]>(){
                ByteBuffer tdsBuffer;
                {
                    this.tdsBuffer = ByteBuffer.wrap(myTDS);
                }

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(byte[] tdsBytes) {
                    this.tdsBuffer.put(tdsBytes);
                }

                @Override
                public void onComplete() {
                    try {
                        tdsBlob.freeTemporary();
                        tdsFuture.complete(myTDS);
                    }
                    catch (SQLException freeException) {
                        tdsFuture.completeExceptionally(freeException);
                    }
                }

                @Override
                public void onError(Throwable error) {
                    try {
                        tdsBlob.freeTemporary();
                        tdsFuture.completeExceptionally(error);
                    }
                    catch (SQLException freeException) {
                        freeException.addSuppressed(error);
                        tdsFuture.completeExceptionally(freeException);
                    }
                }
            });
            return tdsFuture;
        }));
    }

    private CallableStatement prepareGetTypeShapeCall(OracleConnection conn) throws SQLException {
        CallableStatement getTypeShapeCall = this.connection.prepareCall("begin :1 := sys.dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7,:8,:9,:10); end;");
        getTypeShapeCall.registerOutParameter(1, 2);
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "prepareGetTypeShapeCall", "getFullName()={0}, typeNameByUser={1}", (String)null, null, (Object)this.getFullName(), (Object)this.typeNameByUser);
        String name = this.typeNameByUser == null ? this.getFullName() : this.typeNameByUser;
        getTypeShapeCall.setString(2, name);
        getTypeShapeCall.registerOutParameter(2, 12, 256);
        getTypeShapeCall.registerOutParameter(3, -3, 16);
        getTypeShapeCall.registerOutParameter(4, 4);
        getTypeShapeCall.registerOutParameter(5, -4);
        getTypeShapeCall.registerOutParameter(6, 12, 5);
        getTypeShapeCall.registerOutParameter(7, 12, 256);
        getTypeShapeCall.registerOutParameter(8, 12, 256);
        getTypeShapeCall.registerOutParameter(9, -10);
        getTypeShapeCall.registerOutParameter(10, -10);
        return getTypeShapeCall;
    }

    private void initializeAttributeNames(ResultSet attributesCursor) throws SQLException {
        if (!attributesCursor.next()) {
            return;
        }
        if (attributesCursor.getInt(1) != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown image format").fillInStackTrace();
        }
        ArrayList<String> attributeNames = new ArrayList<String>(5);
        ArrayList<String> attributeTypeNames = new ArrayList<String>(5);
        do {
            attributeNames.add(attributesCursor.getString(2));
            String owner = attributesCursor.getString(5);
            String pack = attributesCursor.getString(6);
            String type = this.getTypeName(owner, pack, attributesCursor.getString(4));
            attributeTypeNames.add(type);
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeAttributeNames", "{0} : {1} instantiable={2} supertype_name={3} oid={4}", (String)null, null, (Object)attributesCursor.getString(2), (Object)attributesCursor.getString(4), (Object)attributesCursor.getString(8), (Object)attributesCursor.getString(10), (Object)Parameter.arg(Format.Style.BYTE_ARRAY, attributesCursor.getBytes(7), new long[0]));
        } while (attributesCursor.next());
        this.attrNames = attributeNames.toArray(new String[0]);
        this.attrTypeNames = attributeTypeNames.toArray(new String[0]);
    }

    private CompletionStage<Void> initializeAttributeNamesAsync(ResultSet attributesCursor) {
        final CompletableFuture<Void> initializationFuture = new CompletableFuture<Void>();
        try {
            final ArrayList attributeNames = new ArrayList(5);
            final ArrayList attributeTypeNames = new ArrayList(5);
            attributesCursor.unwrap(OracleResultSet.class).publisherOracle(row -> {
                try {
                    if (attributeNames.isEmpty() && row.getObject(1, Integer.class) != 1) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown image format").fillInStackTrace();
                    }
                    attributeNames.add(row.getObject(2, String.class));
                    String owner = row.getObject(5, String.class);
                    String pack = row.getObject(6, String.class);
                    String type = this.getTypeName(owner, pack, row.getObject(4, String.class));
                    attributeTypeNames.add(type);
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeAttributeNamesAsync", "{0} : {1} instantiable={2}, supertype_name={3}, oid={4}", (String)null, null, (Object)row.getObject(2, String.class), (Object)row.getObject(4, String.class), (Object)row.getObject(8, String.class), (Object)row.getObject(10, String.class), (Object)Parameter.arg(Format.Style.BYTE_ARRAY, row.getObject(7, byte[].class), new long[0]));
                    return Boolean.TRUE;
                }
                catch (SQLException rowMappingException) {
                    throw new CompletionException(rowMappingException);
                }
            }).subscribe(new Flow.Subscriber<Boolean>(){

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(Boolean notUsed) {
                }

                @Override
                public void onComplete() {
                    if (!attributeNames.isEmpty()) {
                        OracleTypeADT.this.attrNames = attributeNames.toArray(new String[0]);
                        OracleTypeADT.this.attrTypeNames = attributeTypeNames.toArray(new String[0]);
                    }
                    initializationFuture.complete(null);
                }

                @Override
                public void onError(Throwable error) {
                    initializationFuture.completeExceptionally(error);
                }
            });
        }
        catch (SQLException publisherException) {
            initializationFuture.completeExceptionally(publisherException);
        }
        return initializationFuture;
    }

    private void initializeSubTypeNames(ResultSet subTypeCursor) throws SQLException {
        if (!subTypeCursor.next()) {
            return;
        }
        if (subTypeCursor.getInt(1) != 1) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown image format").fillInStackTrace();
        }
        ArrayList<CallSite> namesList = new ArrayList<CallSite>(5);
        do {
            namesList.add((CallSite)((Object)(subTypeCursor.getString(2) + "." + subTypeCursor.getString(3))));
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeSubTypeNames", "Sub-type={0}", (String)null, null, (Object)subTypeCursor.getString(3));
        } while (subTypeCursor.next());
        this.subTypeNames = namesList.toArray(new String[0]);
    }

    private CompletionStage<Void> initializeSubTypeNamesAsync(ResultSet subTypeCursor) {
        final CompletableFuture<Void> initializationFuture = new CompletableFuture<Void>();
        try {
            final ArrayList namesList = new ArrayList(5);
            subTypeCursor.unwrap(OracleResultSet.class).publisherOracle(row -> {
                try {
                    if (namesList.isEmpty() && row.getObject(1, Integer.class) != 1) {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Unknown image format").fillInStackTrace();
                    }
                    namesList.add(row.getObject(2, String.class) + "." + row.getObject(3, String.class));
                    Supplier<Object[]> supplier = () -> {
                        try {
                            return new Object[]{row.getObject(3, String.class)};
                        }
                        catch (SQLException exception) {
                            return new Object[]{exception.getMessage()};
                        }
                    };
                    this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initializeSubTypeNamesAsync", "Sub-type={0}", null, null, supplier);
                    return Boolean.TRUE;
                }
                catch (SQLException rowMappingException) {
                    throw new CompletionException(rowMappingException);
                }
            }).subscribe(new Flow.Subscriber<Boolean>(){

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                @Override
                public void onNext(Boolean notUsed) {
                }

                @Override
                public void onComplete() {
                    if (!namesList.isEmpty()) {
                        OracleTypeADT.this.subTypeNames = namesList.toArray(new String[0]);
                    }
                    initializationFuture.complete(null);
                }

                @Override
                public void onError(Throwable error) {
                    initializationFuture.completeExceptionally(error);
                }
            });
        }
        catch (SQLException publisherException) {
            initializationFuture.completeExceptionally(publisherException);
        }
        return initializationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] initMetadata11_2(OracleConnection conn) throws SQLException {
        try (Monitor.CloseableLock lock = conn.acquireCloseableLock();){
            byte[] myTDS = null;
            if ((this.statusBits & 0x100) != 0) {
                byte[] byArray = null;
                return byArray;
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initMetadata11_2", "conn={0} sqlName={1}", (String)null, null, (Object)conn, (Object)this.sqlName);
            if ((this.statusBits & 0x100) == 0) {
                Statement cstmt = null;
                this.connection.beginNonRequestCalls();
                try {
                    if (this.tdoCState == 0L) {
                        this.tdoCState = this.connection.getTdoCState(this.sqlName.getSchema(), this.sqlName.getSimpleName());
                    }
                    String sql_query = "begin :1 := sys.dbms_pickler.get_type_shape(:2,:3,:4,:5,:6,:7); end;";
                    boolean useBlob = false;
                    cstmt = this.connection.prepareCall(sql_query);
                    cstmt.registerOutParameter(1, 2);
                    cstmt.registerOutParameter(4, -3, 16);
                    cstmt.registerOutParameter(5, 4);
                    cstmt.registerOutParameter(6, -4);
                    cstmt.registerOutParameter(7, -4);
                    String schema = this.sqlName.getSchema();
                    cstmt.setString(2, this.sqlName.getSchema());
                    cstmt.setString(3, this.sqlName.getSimpleName());
                    cstmt.execute();
                    int returnCode = cstmt.getInt(1);
                    if (returnCode != 0) {
                        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "initMetadata11_2", "describing type: returnCode={0}", (String)null, null, (Object)returnCode);
                        if (returnCode != 24331) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 74, this.sqlName.toString()).fillInStackTrace();
                        }
                        if (returnCode == 24331) {
                            useBlob = true;
                            cstmt.registerOutParameter(6, 2004);
                            cstmt.execute();
                            returnCode = cstmt.getInt(1);
                            if (returnCode != 0) {
                                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 74, this.sqlName.toString()).fillInStackTrace();
                            }
                        }
                    }
                    this.toid = cstmt.getBytes(4);
                    this.typeVersion = NUMBER.toInt(cstmt.getBytes(5));
                    if (!useBlob) {
                        myTDS = cstmt.getBytes(6);
                    } else {
                        try {
                            Blob l_blob = ((OracleCallableStatement)cstmt).getBlob(6);
                            InputStream l_OutputStream = l_blob.getBinaryStream();
                            myTDS = new byte[(int)l_blob.length()];
                            l_OutputStream.read(myTDS);
                            l_OutputStream.close();
                            ((BLOB)l_blob).freeTemporary();
                        }
                        catch (IOException ea) {
                            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), ea).fillInStackTrace();
                        }
                    }
                    this.metaDataInitialized = true;
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initMetadata11_2", "tds={0}", (String)null, null, (Object)Parameter.arg(Format.Style.BYTE_ARRAY, myTDS, new long[0]));
                    this.flattenedAttrNum = Util.getUnsignedByte(myTDS[8]) * 256 + Util.getUnsignedByte(myTDS[9]);
                    cstmt.getBytes(7);
                }
                finally {
                    if (cstmt != null) {
                        cstmt.close();
                    }
                    this.connection.endNonRequestCalls();
                }
            }
            this.setStatusBits(256);
            byte[] byArray = myTDS;
            return byArray;
        }
    }

    TDSReader parseTDS(byte[] tds_bytes, long index) throws SQLException {
        if (this.attrTypes != null) {
            return null;
        }
        TDSReader tdsReader = new TDSReader(tds_bytes, index);
        long _endOffset = tdsReader.readLong() + tdsReader.offset();
        tdsReader.checkNextByte((byte)38);
        this.tdsVersion = tdsReader.readByte();
        tdsReader.skipBytes(2);
        this.flattenedAttrNum = tdsReader.readUB2();
        if ((tdsReader.readByte() & 0xFF) == 255) {
            this.setStatusBits(128);
        }
        long _tdsStart = tdsReader.offset();
        tdsReader.checkNextByte((byte)41);
        if (tdsReader.readUB2() != 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS").fillInStackTrace();
        }
        long _offsetIndexTable = tdsReader.readLong();
        this.parseTDSrec(tdsReader);
        if (this.tdsVersion >= 3) {
            tdsReader.skip_to(_tdsStart + _offsetIndexTable + 2L);
            tdsReader.skipBytes(2 * this.flattenedAttrNum);
            byte _flag = tdsReader.readByte();
            if (tdsReader.isJavaObject(this.tdsVersion, _flag)) {
                this.setStatusBits(16);
            }
            if (tdsReader.isFinalType(this.tdsVersion, _flag)) {
                this.setStatusBits(32);
            }
            if (tdsReader.readByte() != 1) {
                this.setStatusBits(64);
            }
        } else {
            this.setStatusBits(32);
        }
        tdsReader.skip_to(_endOffset);
        return tdsReader;
    }

    @Override
    public void parseTDSrec(TDSReader tdsReader) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            Vector<OracleType> type_tree = new Vector<OracleType>(5);
            OracleType type_object = null;
            this.idx = 1;
            while ((type_object = this.getNextTypeObject(tdsReader)) != null) {
                type_tree.addElement(type_object);
            }
            if (this.opcode == 42) {
                this.endOfAdt = true;
                this.applyTDSpatches(tdsReader);
            }
            this.attrTypes = new OracleType[type_tree.size()];
            type_tree.copyInto(this.attrTypes);
        }
    }

    private void applyTDSpatches(TDSReader tdsReader) throws SQLException {
        TDSPatch _patch = tdsReader.getNextPatch();
        while (_patch != null) {
            this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "applyTDSpatches", "sqlName={0}", (String)null, null, (Object)this.sqlName);
            tdsReader.moveToPatchPos(_patch);
            int patchSystem = _patch.getType();
            if (patchSystem == 0) {
                tdsReader.readByte();
                byte UPTcode = _patch.getUptTypeCode();
                switch (UPTcode) {
                    case -6: {
                        tdsReader.readLong();
                    }
                    case -5: {
                        OracleNamedType patchElem = _patch.getOwner();
                        OracleTypeADT newAdt = null;
                        newAdt = patchElem.hasName() ? new OracleTypeADT(patchElem.getFullName(), (Connection)this.connection) : new OracleTypeADT(patchElem.getParent(), patchElem.getOrder(), (Connection)this.connection);
                        newAdt.setUptADT();
                        TDSReader newTdsReader = newAdt.parseTDS(tdsReader.tds(), tdsReader.absoluteOffset());
                        tdsReader.skipBytes((int)newTdsReader.offset());
                        _patch.apply(newAdt.cleanup());
                        break;
                    }
                    case 58: {
                        OracleNamedType patchElem = _patch.getOwner();
                        OracleTypeOPAQUE opaque = null;
                        opaque = patchElem.hasName() ? new OracleTypeOPAQUE(patchElem.getFullName(), this.connection) : new OracleTypeOPAQUE(patchElem.getParent(), patchElem.getOrder(), this.connection);
                        opaque.parseTDSrec(tdsReader);
                        _patch.apply(opaque);
                        break;
                    }
                    default: {
                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
                    }
                }
            } else if (patchSystem == 1) {
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "applyTDSpatches", "patchSystem={0}", (String)null, null, (Object)patchSystem);
                OracleType newType = this.getNextTypeObject(tdsReader);
                _patch.apply(newType, this.opcode);
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 47, "parseTDS").fillInStackTrace();
            }
            _patch = tdsReader.getNextPatch();
        }
    }

    public OracleNamedType cleanup() {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (this.attrTypes.length == 1 && this.attrTypes[0] instanceof OracleTypeCOLLECTION) {
                this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "cleanup", "sqlName={0}", (String)null, null, (Object)this.sqlName);
                OracleTypeCOLLECTION col = (OracleTypeCOLLECTION)this.attrTypes[0];
                col.copy_properties(this);
                OracleTypeCOLLECTION oracleTypeCOLLECTION = col;
                return oracleTypeCOLLECTION;
            }
            if (this.attrTypes.length == 1 && (this.statusBits & 0x80) != 0 && this.attrTypes[0] instanceof OracleTypeUPT && ((OracleTypeUPT)this.attrTypes[0]).realType instanceof OracleTypeOPAQUE) {
                OracleTypeOPAQUE opq = (OracleTypeOPAQUE)((OracleTypeUPT)this.attrTypes[0]).realType;
                opq.copy_properties(this);
                OracleTypeOPAQUE oracleTypeOPAQUE = opq;
                return oracleTypeOPAQUE;
            }
            OracleTypeADT oracleTypeADT = this;
            return oracleTypeADT;
        }
    }

    void copy_properties(OracleTypeADT source) {
        this.sqlName = source.sqlName;
        this.typeNameByUser = source.typeNameByUser;
        this.parent = source.parent;
        this.idx = source.idx;
        this.connection = source.connection;
        this.toid = source.toid;
        this.tdsVersion = source.tdsVersion;
        this.typeVersion = source.typeVersion;
        this.tdoCState = source.tdoCState;
        this.endOfAdt = source.endOfAdt;
        this.attrTypeNames = source.attrTypeNames;
        if (this.attrNames != null && source.attrTypeNames == null) {
            this.attrNames = source.attrNames;
        }
    }

    OracleType getNextTypeObject(TDSReader tdsReader) throws SQLException {
        while (true) {
            this.opcode = tdsReader.readByte();
            if (this.opcode == 43) continue;
            if (this.opcode != 44) break;
            byte _flag = tdsReader.readByte();
            if (!tdsReader.isJavaObject(3, _flag)) continue;
            this.setStatusBits(16);
        }
        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "getNextTypeObject", "opcode={0}", (String)null, null, (Object)this.opcode);
        switch (this.opcode) {
            case 40: 
            case 42: {
                return null;
            }
            case 2: {
                OracleTypeDATE odate = new OracleTypeDATE();
                odate.parseTDSrec(tdsReader);
                ++this.idx;
                return odate;
            }
            case 7: {
                OracleTypeCHAR ochar = new OracleTypeCHAR(this.connection, 12);
                ochar.parseTDSrec(tdsReader);
                ++this.idx;
                return ochar;
            }
            case 1: {
                OracleTypeCHAR ochar = new OracleTypeCHAR(this.connection, 1);
                ochar.parseTDSrec(tdsReader);
                ++this.idx;
                return ochar;
            }
            case 39: {
                OracleTypeADT oadt = new OracleTypeADT(this, this.idx, (Connection)this.connection);
                oadt.setEmbeddedADT();
                oadt.parseTDSrec(tdsReader);
                ++this.idx;
                return oadt;
            }
            case 6: {
                OracleTypeNUMBER onum = new OracleTypeNUMBER(2);
                onum.parseTDSrec(tdsReader);
                ++this.idx;
                return onum;
            }
            case 3: {
                OracleTypeNUMBER onum = new OracleTypeNUMBER(3);
                onum.parseTDSrec(tdsReader);
                ++this.idx;
                return onum;
            }
            case 4: {
                OracleTypeNUMBER onum = new OracleTypeNUMBER(8);
                onum.parseTDSrec(tdsReader);
                ++this.idx;
                return onum;
            }
            case 5: {
                OracleTypeFLOAT onum = new OracleTypeFLOAT();
                onum.parseTDSrec(tdsReader);
                ++this.idx;
                return onum;
            }
            case 37: {
                OracleTypeBINARY_FLOAT bfloat = new OracleTypeBINARY_FLOAT();
                bfloat.parseTDSrec(tdsReader);
                ++this.idx;
                return bfloat;
            }
            case 45: {
                OracleTypeBINARY_DOUBLE bdouble = new OracleTypeBINARY_DOUBLE();
                bdouble.parseTDSrec(tdsReader);
                ++this.idx;
                return bdouble;
            }
            case 8: {
                OracleTypeSINT32 onum = new OracleTypeSINT32(false);
                onum.parseTDSrec(tdsReader);
                ++this.idx;
                return onum;
            }
            case 9: {
                OracleTypeREF oref = new OracleTypeREF(this, this.idx, this.connection);
                oref.parseTDSrec(tdsReader);
                ++this.idx;
                return oref;
            }
            case 31: {
                OracleTypeBFILE obfile = new OracleTypeBFILE(this.connection);
                obfile.parseTDSrec(tdsReader);
                ++this.idx;
                return obfile;
            }
            case 19: {
                OracleTypeRAW oraw = new OracleTypeRAW();
                oraw.parseTDSrec(tdsReader);
                ++this.idx;
                return oraw;
            }
            case 29: {
                OracleTypeCLOB oclob = new OracleTypeCLOB(this.connection);
                oclob.parseTDSrec(tdsReader);
                if (this.attrTypeNames != null && this.attrTypeNames.length > this.idx - 1) {
                    oclob.form = "NCLOB".equals(this.attrTypeNames[this.idx - 1]) ? 2 : 1;
                } else if (this.sqlName != null && !this.endOfAdt) {
                    this.connection.getForm(this, oclob, this.idx);
                }
                ++this.idx;
                return oclob;
            }
            case 30: {
                OracleTypeBLOB oblob = new OracleTypeBLOB(this.connection);
                oblob.parseTDSrec(tdsReader);
                ++this.idx;
                return oblob;
            }
            case 21: {
                OracleTypeTIMESTAMP timestamp = new OracleTypeTIMESTAMP(this.connection);
                timestamp.parseTDSrec(tdsReader);
                ++this.idx;
                return timestamp;
            }
            case 23: {
                OracleTypeTIMESTAMPTZ timestamp = new OracleTypeTIMESTAMPTZ(this.connection);
                timestamp.parseTDSrec(tdsReader);
                ++this.idx;
                return timestamp;
            }
            case 33: {
                OracleTypeTIMESTAMPLTZ timestamp = new OracleTypeTIMESTAMPLTZ(this.connection);
                timestamp.parseTDSrec(tdsReader);
                ++this.idx;
                return timestamp;
            }
            case 24: {
                OracleTypeINTERVAL interval = new OracleTypeINTERVAL(this.connection);
                interval.parseTDSrec(tdsReader);
                ++this.idx;
                return interval;
            }
            case 28: {
                OracleTypeCOLLECTION ocollection = new OracleTypeCOLLECTION(this, this.idx, this.connection);
                ocollection.parseTDSrec(tdsReader);
                ++this.idx;
                return ocollection;
            }
            case 27: {
                OracleTypeUPT oupt = new OracleTypeUPT(this, this.idx, this.connection);
                oupt.parseTDSrec(tdsReader);
                ++this.idx;
                return oupt;
            }
            case 16: {
                OracleTypeROWID oracleRowId = new OracleTypeROWID();
                oracleRowId.parseTDSrec(tdsReader);
                ++this.idx;
                return oracleRowId;
            }
        }
        Object type_object = null;
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 48, "get_next_type: " + this.opcode).fillInStackTrace();
    }

    @Override
    public byte[] linearize(Datum data) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            byte[] byArray = this.pickle81(data);
            return byArray;
        }
    }

    @Override
    public Datum unlinearize(byte[] pickled_bytes, long offset, Datum container, int style, Map map) throws SQLException {
        return this._unlinearize(pickled_bytes, offset, container, style, map);
    }

    public Datum _unlinearize(byte[] pickled_bytes, long offset, Datum container, int style, Map map) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            if (pickled_bytes == null) {
                Datum datum = null;
                return datum;
            }
            PickleContext context = new PickleContext(pickled_bytes, offset);
            Datum datum = (Datum)((Object)this.unpickle81(context, (OracleStruct)((Object)container), 1, style, map));
            return datum;
        }
    }

    protected OracleStruct unpickle81(PickleContext context, OracleStruct container, int style, int attrStyle, Map attrMap) throws SQLException {
        OracleStruct the_adt = container;
        long _offset = context.offset();
        byte flags = context.readByte();
        if (!PickleContext.is81format(flags)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is not in 8.1 format").fillInStackTrace();
        }
        if (PickleContext.isCollectionImage_pctx(flags)) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image is a collection image, expecting ADT").fillInStackTrace();
        }
        if (!context.readAndCheckVersion()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Image version is not recognized").fillInStackTrace();
        }
        block0 : switch (style) {
            case 9: {
                context.skipBytes(context.readLength(true) - 2);
                break;
            }
            case 3: {
                long length = context.readLength();
                the_adt = this.unpickle81Prefix(context, the_adt, flags);
                if (the_adt == null) {
                    StructDescriptor desc = this.createStructDescriptor();
                    the_adt = this.createByteSTRUCT(desc, null);
                }
                the_adt.setImage(context.image(), _offset, 0L);
                the_adt.setImageLength(length);
                context.skipTo(_offset + length);
                break;
            }
            default: {
                context.skipLength();
                the_adt = this.unpickle81Prefix(context, the_adt, flags);
                if (the_adt == null) {
                    StructDescriptor desc = this.createStructDescriptor();
                    the_adt = this.createByteSTRUCT(desc, null);
                }
                OracleType[] _attrs = the_adt.getDescriptor().getOracleTypeADT().getAttrTypes();
                switch (attrStyle) {
                    case 1: {
                        Datum[] datums = new Datum[_attrs.length];
                        for (int i = 0; i < _attrs.length; ++i) {
                            datums[i] = (Datum)_attrs[i].unpickle81rec(context, attrStyle, attrMap);
                        }
                        the_adt.setDatumArray(datums);
                        break block0;
                    }
                    case 2: {
                        Object[] oarray = new Object[_attrs.length];
                        for (int i = 0; i < _attrs.length; ++i) {
                            oarray[i] = _attrs[i].unpickle81rec(context, attrStyle, attrMap);
                        }
                        the_adt.setObjArray(oarray);
                        break block0;
                    }
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        return the_adt;
    }

    protected OracleStruct unpickle81Prefix(PickleContext context, OracleStruct container, byte flags) throws SQLException {
        OracleStruct the_adt = container;
        if (PickleContext.hasPrefix(flags)) {
            boolean hasVersion;
            long _endOffset = context.readLength() + context.absoluteOffset();
            byte _prefixFlag = context.readByte();
            byte _TypeInfoEncodedBits = (byte)(_prefixFlag & 0xC);
            boolean hasTypeInfoNONE = _TypeInfoEncodedBits == 0;
            boolean hasTypeInfoTOID = _TypeInfoEncodedBits == 4;
            boolean hasTypeInfoTOBJN = _TypeInfoEncodedBits == 8;
            boolean hasTypeInfoTDS = _TypeInfoEncodedBits == 12;
            boolean bl = hasVersion = (_prefixFlag & 0x10) != 0;
            if (hasTypeInfoTOID) {
                byte[] _toid = context.readBytes(16);
                String _subTypename = OracleTypeADT.toid2typename(this.connection, _toid);
                StructDescriptor desc = (StructDescriptor)TypeDescriptor.getTypeDescriptor(_subTypename, this.connection);
                if (the_adt == null) {
                    the_adt = this.createByteSTRUCT(desc, null);
                } else {
                    the_adt.setDescriptor(desc);
                }
            }
            if (hasVersion) {
                context.readLength();
            }
            if (hasTypeInfoTOBJN | hasTypeInfoTDS) {
                throw (SQLException)DatabaseError.createUnsupportedFeatureSqlException().fillInStackTrace();
            }
            context.skipTo(_endOffset);
        }
        return the_adt;
    }

    @Override
    protected Object unpickle81rec(PickleContext context, int type, Map map) throws SQLException {
        byte firstbyte = context.readByte();
        byte immemb = 0;
        if (PickleContext.isAtomicNull(firstbyte)) {
            return null;
        }
        if (PickleContext.isImmediatelyEmbeddedNull(firstbyte)) {
            immemb = context.readByte();
        }
        STRUCT s2 = this.unpickle81datum(context, firstbyte, immemb);
        return this.toObject(s2, type, map);
    }

    @Override
    protected Object unpickle81rec(PickleContext context, byte len_flags, int type, Map map) throws SQLException {
        STRUCT s2 = this.unpickle81datum(context, len_flags, (byte)0);
        return this.toObject(s2, type, map);
    }

    private STRUCT unpickle81datum(PickleContext context, byte len_flags, byte immemb) throws SQLException {
        int size = this.getNumAttrs();
        StructDescriptor desc = this.createStructDescriptor();
        STRUCT the_adt = this.createByteSTRUCT(desc, null);
        OracleType this_attr = this.getAttrTypeAt(0);
        Object firstElem = null;
        firstElem = PickleContext.isImmediatelyEmbeddedNull(len_flags) && immemb == 1 ? null : (PickleContext.isImmediatelyEmbeddedNull(len_flags) ? ((OracleTypeADT)this_attr).unpickle81datum(context, len_flags, (byte)(immemb - 1)) : (PickleContext.isElementNull(len_flags) ? (this_attr.getTypeCode() == 2002 || this_attr.getTypeCode() == 2008 ? this_attr.unpickle81datumAsNull(context, len_flags, immemb) : null) : this_attr.unpickle81rec(context, len_flags, 1, null)));
        Datum[] oarray = new Datum[size];
        oarray[0] = (Datum)firstElem;
        for (int ctr = 1; ctr < size; ++ctr) {
            this_attr = this.getAttrTypeAt(ctr);
            oarray[ctr] = (Datum)this_attr.unpickle81rec(context, 1, null);
        }
        the_adt.setDatumArray(oarray);
        return the_adt;
    }

    @Override
    protected Datum unpickle81datumAsNull(PickleContext context, byte len_flags, byte immemb) throws SQLException {
        int size = this.getNumAttrs();
        StructDescriptor desc = this.createStructDescriptor();
        STRUCT the_adt = this.createByteSTRUCT(desc, null);
        Datum[] oarray = new Datum[size];
        int ctr = 0;
        OracleType this_attr = this.getAttrTypeAt(ctr);
        oarray[ctr++] = this_attr.getTypeCode() == 2002 || this_attr.getTypeCode() == 2008 ? this_attr.unpickle81datumAsNull(context, len_flags, immemb) : (Datum)null;
        while (ctr < size) {
            this_attr = this.getAttrTypeAt(ctr);
            oarray[ctr] = this_attr.getTypeCode() == 2002 || this_attr.getTypeCode() == 2008 ? (Datum)this_attr.unpickle81rec(context, 1, null) : (Datum)this_attr.unpickle81rec(context, 1, null);
            ++ctr;
        }
        the_adt.setDatumArray(oarray);
        return the_adt;
    }

    public byte[] pickle81(Datum data) throws SQLException {
        PickleContext ctx = new PickleContext();
        ctx.initStream();
        this.pickle81(ctx, data);
        byte[] pickledBytes = ctx.stream2Bytes();
        data.setShareBytes(pickledBytes);
        return pickledBytes;
    }

    @Override
    protected int pickle81(PickleContext ctx, Datum data) throws SQLException {
        int lenOffset = ctx.offset() + 2;
        int imglen = 0;
        imglen += ctx.writeImageHeader(this.shouldHavePrefix());
        imglen += this.pickle81Prefix(ctx);
        ctx.patchImageLen(lenOffset, imglen += this.pickle81rec(ctx, data, 0));
        return imglen;
    }

    private boolean hasVersion() {
        return this.typeVersion > 1;
    }

    private boolean needsToid() {
        if (this.isTransient) {
            return false;
        }
        return (this.statusBits & 0x40) != 0 || (this.statusBits & 0x20) == 0 || this.hasVersion();
    }

    private boolean shouldHavePrefix() {
        if (this.isTransient) {
            return false;
        }
        return this.hasVersion() || this.needsToid();
    }

    protected int pickle81Prefix(PickleContext context) throws SQLException {
        if (this.shouldHavePrefix()) {
            int len = 0;
            int _prefix_flag = 1;
            int precalculated_length = 1;
            if (this.needsToid()) {
                precalculated_length += this.getTOID().length;
                _prefix_flag |= 4;
            }
            if (this.hasVersion()) {
                _prefix_flag |= 0x10;
                precalculated_length = this.typeVersion > PickleContext.KOPI20_LN_MAXV ? (precalculated_length += 5) : (precalculated_length += 2);
            }
            len = context.writeLength(precalculated_length);
            len += context.writeData((byte)_prefix_flag);
            if (this.needsToid()) {
                len += context.writeData(this.toid);
            }
            if (this.hasVersion()) {
                len = this.typeVersion > PickleContext.KOPI20_LN_MAXV ? (len += context.writeLength(this.typeVersion)) : (len += context.writeSB2(this.typeVersion));
            }
            return len;
        }
        return 0;
    }

    private int pickle81rec(PickleContext ctx, Datum data, int depth) throws SQLException {
        int imglen = 0;
        if (!this.metaDataInitialized) {
            this.copy_properties((OracleTypeADT)((OracleStruct)((Object)data)).getDescriptor().getPickler());
        }
        Datum[] values = ((OracleStruct)((Object)data)).getOracleAttributes();
        int field_num = values.length;
        int ctr = 0;
        OracleType this_attr = this.getAttrTypeAt(0);
        if (this_attr instanceof OracleTypeADT && !(this_attr instanceof OracleTypeCOLLECTION) && !(this_attr instanceof OracleTypeUPT)) {
            this.debugp(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "pickle81rec", "sqlName={0} check first null case and this attr={1} depth={2}", null, null, () -> new Object[]{this.sqlName, values[0] == null ? null : Parameter.arg(Format.Style.BYTE_ARRAY_CLONE, values[0].shareBytes(), new long[0]), depth});
            ctr = 1;
            imglen = values[0] == null ? (depth > 0 ? (imglen += ctx.writeImmediatelyEmbeddedElementNull((byte)depth)) : (imglen += ctx.writeAtomicNull())) : (imglen += ((OracleTypeADT)this_attr).pickle81rec(ctx, values[0], depth + 1));
        }
        while (ctr < field_num) {
            this_attr = this.getAttrTypeAt(ctr);
            int idx = ctr;
            this.debugp(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "pickle81rec", "sqlName={0} check idx={1} attr={2} depth={3}", null, null, () -> new Object[]{this.sqlName, idx, values[idx] == null ? null : Parameter.arg(Format.Style.BYTE_ARRAY_CLONE, values[idx].shareBytes(), new long[0]), depth});
            imglen = values[ctr] == null ? (this_attr instanceof OracleTypeADT && !(this_attr instanceof OracleTypeCOLLECTION) && !(this_attr instanceof OracleTypeUPT) ? (imglen += ctx.writeAtomicNull()) : (imglen += ctx.writeElementNull())) : (this_attr instanceof OracleTypeADT && !(this_attr instanceof OracleTypeCOLLECTION) && !(this_attr instanceof OracleTypeUPT) ? (imglen += ((OracleTypeADT)this_attr).pickle81rec(ctx, values[ctr], 1)) : (imglen += this_attr.pickle81(ctx, values[ctr])));
            ++ctr;
        }
        return imglen;
    }

    private Object toObject(STRUCT s2, int type, Map map) throws SQLException {
        switch (type) {
            case 1: {
                return s2;
            }
            case 2: {
                if (s2 == null) break;
                return s2.toJdbc(map);
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1).fillInStackTrace();
            }
        }
        return null;
    }

    public String getAttributeType(int idx) throws SQLException {
        return this.getAttributeType(idx, true);
    }

    public String getAttributeType(int idx, boolean force) throws SQLException {
        if (force) {
            if (this.sqlName == null) {
                this.getFullName();
            }
            if (this.attrNames == null) {
                this.initADTAttrNames();
            }
        }
        if (idx < 1 || this.attrTypeNames != null && idx > this.attrTypeNames.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid index").fillInStackTrace();
        }
        if (this.attrTypeNames != null) {
            return this.attrTypeNames[idx - 1];
        }
        return null;
    }

    public String getAttributeName(int idx) throws SQLException {
        if (this.attrNames == null) {
            this.initADTAttrNames();
        }
        String ret = null;
        if (this.attrNames != null) {
            if (idx < 1 || idx > this.attrNames.length) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid index").fillInStackTrace();
            }
            ret = this.attrNames[idx - 1];
        }
        return ret;
    }

    public String getAttributeName(int idx, boolean force) throws SQLException {
        if (force && this.connection != null) {
            return this.getAttributeName(idx);
        }
        if (idx < 1 || this.attrNames != null && idx > this.attrNames.length) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid index").fillInStackTrace();
        }
        if (this.attrNames != null) {
            return this.attrNames[idx - 1];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADTAttrNames() throws SQLException {
        block41: {
            if (this.connection == null) {
                return;
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            if (this.toid != null) {
                this.initADTAttrNamesUsingTOID();
                return;
            }
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                Statement cstmt = null;
                Statement ps = null;
                ResultSet rs = null;
                String[] temp_attrNames = new String[this.attrTypes.length];
                String[] temp_attrTypeNames = new String[this.attrTypes.length];
                int state = 0;
                int l_index = 0;
                if (this.attrNames != null) break block41;
                this.connection.beginNonRequestCalls();
                try {
                    int n = state = this.sqlName.getSchema().equals(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 7;
                    while (state != 11) {
                        switch (state) {
                            case 0: {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNames", "try CURRENT_USER_OBJECT, bind={0}", (String)null, null, (Object)this.sqlName.getSimpleName());
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setFetchSize(this.idx);
                                rs = ps.executeQuery();
                                state = 5;
                                break;
                            }
                            case 1: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    state = 2;
                                }
                            }
                            case 2: {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNames", "try CURRENT_USER_SYNONYM, bind={0}", (String)null, null, (Object)this.sqlName.getSimpleName());
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(this.idx);
                                rs = ps.executeQuery();
                                state = 3;
                                break;
                            }
                            case 3: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    state = 4;
                                }
                            }
                            case 4: {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNames", "try CURRENT_USER_PUBLIC_SYNONYM, bind={0}", (String)null, null, (Object)this.sqlName.getSimpleName());
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(this.idx);
                                rs = ps.executeQuery();
                                state = 8;
                                break;
                            }
                            case 5: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    state = 6;
                                }
                            }
                            case 6: {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNames", "try POSSIBLY_OTHER_USER_OBJECT, bind={0}", (String)null, null, (Object)this.sqlName.getSimpleName());
                                cstmt = (OracleCallableStatement)this.connection.prepareCall(this.getSqlHint() + sqlString[state]);
                                cstmt.setString(1, this.sqlName.getSimpleName());
                                cstmt.setString(3, this.sqlName.getSimpleName());
                                cstmt.registerOutParameter(2, -10);
                                cstmt.execute();
                                rs = ((OracleCallableStatement)cstmt).getCursor(2);
                                rs.setFetchSize(1);
                                state = 1;
                                break;
                            }
                            case 7: {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNames", "try OTHER_USER_OBJECT, bind : schema={0} simple name={1}", (String)null, null, (Object)this.sqlName.getSchema(), (Object)this.sqlName.getSimpleName());
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSchema());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(this.idx);
                                rs = ps.executeQuery();
                                state = 8;
                                break;
                            }
                            case 8: {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNames", "try OTHER_USER_SYNONYM, bind : simple name={0}", (String)null, null, (Object)this.sqlName.getSimpleName());
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlString[state]);
                                ps.setString(1, this.sqlName.getSimpleName());
                                ps.setString(2, this.sqlName.getSimpleName());
                                ps.setFetchSize(this.idx);
                                rs = ps.executeQuery();
                                state = 9;
                                break;
                            }
                            case 9: {
                                if (this.connection.getVersionNumber() >= 10000) {
                                    state = 10;
                                }
                            }
                            case 10: {
                                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNames", "try PUBLIC_SYNONYM, bind : simple name={0}", (String)null, null, (Object)this.sqlName.getSimpleName());
                                cstmt = this.connection.prepareCall(this.getSqlHint() + sqlString[state]);
                                cstmt.setString(1, this.sqlName.getSimpleName());
                                cstmt.registerOutParameter(2, -10);
                                cstmt.execute();
                                rs = ((OracleCallableStatement)cstmt).getCursor(2);
                                state = 11;
                            }
                        }
                        try {
                            if (rs != null) {
                                for (l_index = 0; l_index < this.attrTypes.length && rs.next(); ++l_index) {
                                    if (rs.getInt(1) != l_index + 1) {
                                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "inconsistent ADT attribute").fillInStackTrace();
                                    }
                                    temp_attrNames[l_index] = rs.getString(2);
                                    String owner = rs.getString(4);
                                    String type = rs.getString(3);
                                    temp_attrTypeNames[l_index] = owner == null || owner.isEmpty() ? type : SQLName.getTypeName(owner, type);
                                }
                            }
                            if (l_index != 0) {
                                this.attrTypeNames = temp_attrTypeNames;
                                this.attrNames = temp_attrNames;
                                state = 11;
                                continue;
                            }
                            if (rs != null) {
                                rs.close();
                            }
                            if (ps != null) {
                                ps.close();
                            }
                            if (cstmt == null) continue;
                            cstmt.close();
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                            if (ps != null) {
                                ps.close();
                            }
                            if (cstmt == null) continue;
                            cstmt.close();
                        }
                    }
                }
                finally {
                    this.connection.endNonRequestCalls();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initADTAttrNamesUsingTOID() throws SQLException {
        block24: {
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
                Statement cstmt = null;
                Statement ps = null;
                ResultSet rs = null;
                String[] temp_attrNames = new String[this.attrTypes.length];
                String[] temp_attrTypeNames = new String[this.attrTypes.length];
                int state = 0;
                int l_index = 0;
                if (this.attrNames != null) break block24;
                this.connection.beginNonRequestCalls();
                try {
                    int n = state = this.sqlName.getSchema().equals(this.connection.getDefaultSchemaNameForNamedTypes()) ? 0 : 1;
                    while (state != 11) {
                        switch (state) {
                            case 0: {
                                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNamesUsingTOID", "try SEARCH_USER_TYPES, bind={0}", (String)null, null, (Object)Parameter.arg(Format.Style.BYTE_ARRAY, this.toid, new long[0]));
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlStringTOID[state]);
                                ps.setBytes(1, this.toid);
                                ps.setFetchSize(this.idx);
                                rs = ps.executeQuery();
                                state = 1;
                                break;
                            }
                            case 1: {
                                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "initADTAttrNamesUsingTOID", "SEARCH_ALL_TYPES, bind: ", (String)null, null, (Object)Parameter.arg(Format.Style.BYTE_ARRAY, this.toid, new long[0]));
                                ps = this.connection.prepareStatement(this.getSqlHint() + sqlStringTOID[state]);
                                ps.setBytes(1, this.toid);
                                ps.setFetchSize(this.idx);
                                rs = ps.executeQuery();
                                state = 11;
                            }
                        }
                        try {
                            if (rs != null) {
                                for (l_index = 0; l_index < this.attrTypes.length && rs.next(); ++l_index) {
                                    if (rs.getInt(1) != l_index + 1 && state == 1) {
                                        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "inconsistent ADT attribute").fillInStackTrace();
                                    }
                                    temp_attrNames[l_index] = rs.getString(2);
                                    String owner = rs.getString(4);
                                    String type = rs.getString(3);
                                    temp_attrTypeNames[l_index] = owner == null || owner.isEmpty() ? type : SQLName.getTypeName(owner, type);
                                }
                            }
                            if (l_index != 0) {
                                this.attrTypeNames = temp_attrTypeNames;
                                this.attrNames = temp_attrNames;
                                state = 11;
                                continue;
                            }
                            if (rs != null) {
                                rs.close();
                            }
                            if (ps == null) continue;
                            ps.close();
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                            if (ps != null) {
                                ps.close();
                            }
                            if (cstmt == null) continue;
                            cstmt.close();
                        }
                    }
                }
                finally {
                    this.connection.endNonRequestCalls();
                }
            }
        }
    }

    StructDescriptor createStructDescriptor() throws SQLException {
        StructDescriptor returnValue = (StructDescriptor)this.descriptor;
        if (this.typeNameByUser == null && this.parent != null && this.parent.getTypeCode() == 2003) {
            this.typeNameByUser = this.parent.getAttributeType(1);
        }
        if (returnValue == null) {
            returnValue = new StructDescriptor(this, (Connection)this.connection);
        }
        return returnValue;
    }

    STRUCT createObjSTRUCT(StructDescriptor desc, Object[] value) throws SQLException {
        if ((this.statusBits & 0x10) != 0) {
            return new JAVA_STRUCT(desc, (Connection)this.connection, value);
        }
        return new STRUCT(desc, (Connection)this.connection, value);
    }

    STRUCT createByteSTRUCT(StructDescriptor desc, byte[] value) throws SQLException {
        if ((this.statusBits & 0x10) != 0) {
            return new JAVA_STRUCT(desc, value, this.connection);
        }
        return new STRUCT(desc, value, this.connection);
    }

    public static String getSubtypeName(Connection conn, byte[] image, long offset) throws SQLException {
        try (Monitor.CloseableLock lock = ((OracleConnection)conn).acquireCloseableLock();){
            byte flags;
            PickleContext context;
            block14: {
                block13: {
                    context = new PickleContext(image, offset);
                    flags = context.readByte();
                    if (!PickleContext.is81format(flags)) break block13;
                    if (PickleContext.isCollectionImage_pctx(flags)) break block13;
                    if (PickleContext.hasPrefix(flags)) break block14;
                }
                String string = null;
                return string;
            }
            if (!context.readAndCheckVersion()) {
                throw (SQLException)DatabaseError.createSqlException(1, "Image version is not recognized").fillInStackTrace();
            }
            context.skipLength();
            context.skipLength();
            flags = context.readByte();
            if ((flags & 4) != 0) {
                byte[] _toid = context.readBytes(16);
                String string = OracleTypeADT.toid2typename(conn, _toid);
                return string;
            }
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toid2typename(Connection conn, byte[] toid) throws SQLException {
        try (Monitor.CloseableLock lock = ((OracleConnection)conn).acquireCloseableLock();){
            String typename;
            block13: {
                typename = (String)((OracleConnection)conn).getDescriptor(toid);
                if (typename == null) {
                    PreparedStatement pstmt = null;
                    ResultSet rset = null;
                    ((OracleConnection)conn).beginNonRequestCalls();
                    try {
                        pstmt = conn.prepareStatement("select owner, type_name from all_types where type_oid = :1");
                        pstmt.setBytes(1, toid);
                        rset = pstmt.executeQuery();
                        if (rset.next()) {
                            typename = SQLName.getTypeName(rset.getString(1), rset.getString(2));
                            ((OracleConnection)conn).putDescriptor(toid, (Object)typename);
                            break block13;
                        }
                        throw (SQLException)DatabaseError.createSqlException(1, "Invalid type oid").fillInStackTrace();
                    }
                    finally {
                        if (rset != null) {
                            rset.close();
                        }
                        if (pstmt != null) {
                            pstmt.close();
                        }
                        ((OracleConnection)conn).endNonRequestCalls();
                    }
                }
            }
            String string = typename;
            return string;
        }
    }

    public int getTdsVersion() {
        return this.tdsVersion;
    }

    public void printDebug() {
    }

    public byte[] getTOID() {
        try {
            if (this.toid == null) {
                this.initMetadata(this.connection);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.toid;
    }

    public int getImageFormatVersion() {
        return PickleContext.KOPI20_VERSION;
    }

    @Override
    public int getTypeVersion() {
        try {
            if (this.typeVersion == -1) {
                this.initMetadata(this.connection);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.typeVersion;
    }

    public int getCharSet() {
        return this.charSetId;
    }

    public int getCharSetForm() {
        return this.charSetForm;
    }

    public long getTdoCState() {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            try {
                if (this.tdoCState == 0L) {
                    if (this.connection.getVersionNumber() >= 12000 && this.typeNameByUser != null) {
                        this.tdoCState = this.connection.getTdoCState(this.typeNameByUser);
                    } else {
                        this.getFullName();
                        this.tdoCState = this.connection.getTdoCState(this.sqlName.getSchema(), this.sqlName.getSimpleName());
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            long l = this.tdoCState;
            return l;
        }
    }

    public long getFIXED_DATA_SIZE() {
        try {
            return this.getFixedDataSize();
        }
        catch (SQLException sQLException) {
            return 0L;
        }
    }

    public long getFixedDataSize() throws SQLException {
        return this.fixedDataSize;
    }

    public int getAlignmentReq() throws SQLException {
        return this.alignmentRequirement;
    }

    public int getNumAttrs() throws SQLException {
        if (this.attrTypes == null && this.connection != null) {
            this.init(this.connection);
        }
        return this.attrTypes.length;
    }

    public OracleType getAttrTypeAt(int idx) throws SQLException {
        if (this.attrTypes == null && this.connection != null) {
            this.init(this.connection);
        }
        return this.attrTypes[idx];
    }

    public boolean isEmbeddedADT() throws SQLException {
        return (this.statusBits & 2) != 0;
    }

    public boolean isUptADT() throws SQLException {
        return (this.statusBits & 4) != 0;
    }

    public boolean isTopADT() throws SQLException {
        return (this.statusBits & 1) != 0;
    }

    public void setStatus(int status) throws SQLException {
        this.statusBits = status;
    }

    void setEmbeddedADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 2);
    }

    void setUptADT() throws SQLException {
        this.maskAndSetStatusBits(-16, 4);
    }

    public boolean isSubType() throws SQLException {
        return (this.statusBits & 0x40) != 0;
    }

    public boolean isFinalType() throws SQLException {
        return (this.statusBits & 0x20) != 0 | (this.statusBits & 2) != 0;
    }

    public boolean isJavaObject() throws SQLException {
        return (this.statusBits & 0x10) != 0;
    }

    public int getStatus() throws SQLException {
        if ((this.statusBits & 1) != 0 && (this.statusBits & 0x100) == 0) {
            this.init(this.connection);
        }
        return this.statusBits;
    }

    public static OracleTypeADT shallowClone(OracleTypeADT adt) throws SQLException {
        OracleTypeADT newADT = new OracleTypeADT();
        OracleTypeADT.shallowCopy(adt, newADT);
        return newADT;
    }

    public static void shallowCopy(OracleTypeADT from, OracleTypeADT to) throws SQLException {
        to.connection = from.connection;
        to.sqlName = from.sqlName;
        to.parent = from.parent;
        to.idx = from.idx;
        to.descriptor = from.descriptor;
        to.statusBits = from.statusBits;
        to.typeCode = from.typeCode;
        to.dbTypeCode = from.dbTypeCode;
        to.tdsVersion = from.tdsVersion;
        to.typeVersion = from.typeVersion;
        to.fixedDataSize = from.fixedDataSize;
        to.alignmentRequirement = from.alignmentRequirement;
        to.attrTypes = from.attrTypes;
        to.sqlName = from.sqlName;
        to.tdoCState = from.tdoCState;
        to.toid = from.toid;
        to.charSetId = from.charSetId;
        to.charSetForm = from.charSetForm;
        to.flattenedAttrNum = from.flattenedAttrNum;
        to.statusBits = from.statusBits;
        to.attrNames = from.attrNames;
        to.attrTypeNames = from.attrTypeNames;
        to.opcode = from.opcode;
        to.idx = from.idx;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.statusBits);
        out.writeInt(this.tdsVersion);
        out.writeInt(this.typeVersion);
        out.writeObject(null);
        out.writeObject(null);
        out.writeLong(this.fixedDataSize);
        out.writeInt(this.alignmentRequirement);
        out.writeObject(this.attrTypes);
        out.writeObject(this.attrNames);
        out.writeObject(this.attrTypeNames);
        out.writeLong(this.tdoCState);
        out.writeObject(this.toid);
        out.writeObject(null);
        out.writeInt(this.charSetId);
        out.writeInt(this.charSetForm);
        out.writeBoolean(true);
        out.writeInt(this.flattenedAttrNum);
        out.writeObject(this.monitorLock);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.statusBits = in.readInt();
        this.tdsVersion = in.readInt();
        this.typeVersion = in.readInt();
        in.readObject();
        in.readObject();
        in.readLong();
        in.readInt();
        this.attrTypes = (OracleType[])in.readObject();
        this.attrNames = (String[])in.readObject();
        this.attrTypeNames = (String[])in.readObject();
        in.readLong();
        this.toid = (byte[])in.readObject();
        in.readObject();
        this.charSetId = in.readInt();
        this.charSetForm = in.readInt();
        in.readBoolean();
        this.flattenedAttrNum = in.readInt();
        this.monitorLock = (Monitor.CloseableLock)in.readObject();
    }

    @Override
    public void setConnection(OracleConnection conn) throws SQLException {
        try (Monitor.CloseableLock lock = conn.acquireCloseableLock();){
            this.connection = conn;
            for (int i = 0; i < this.attrTypes.length; ++i) {
                this.attrTypes[i].setConnection(this.connection);
            }
        }
    }

    private void setStatusBits(int bits) {
        this.connection.assertLockHeldByCurrentThread();
        this.statusBits |= bits;
    }

    private void maskAndSetStatusBits(int mask, int bits) {
        this.connection.assertLockHeldByCurrentThread();
        this.statusBits &= mask;
        this.statusBits |= bits;
    }

    private void printUnsignedByteArray(byte[] b, PrintWriter pw) {
        int i;
        int length = b.length;
        int[] intArray = Util.toJavaUnsignedBytes(b);
        for (i = 0; i < length; ++i) {
            pw.print("0x" + Integer.toHexString(intArray[i]) + " ");
        }
        pw.println();
        for (i = 0; i < length; ++i) {
            pw.print(intArray[i] + " ");
        }
        pw.println();
    }

    @Override
    public void initChildNamesRecursively(Map typesMap) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            TypeTreeElement element = (TypeTreeElement)typesMap.get(this.sqlName);
            if (this.attrTypes != null && this.attrTypes.length > 0) {
                for (int j = 0; j < this.attrTypes.length; ++j) {
                    OracleType child = this.attrTypes[j];
                    child.setNames(element.getChildSchemaName(j + 1), element.getChildTypeName(j + 1));
                    child.initChildNamesRecursively(typesMap);
                    child.cacheDescriptor();
                }
            }
        }
    }

    @Override
    public void cacheDescriptor() throws SQLException {
        this.descriptor = StructDescriptor.createDescriptor(this);
    }

    private void initMetaData1() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            short version = this.connection.getVersionNumber();
            if (version >= 9000) {
                this.initMetaData1_9_0();
            } else {
                this.initMetaData1_pre_9_0();
            }
        }
    }

    public Boolean isInstanciable() throws SQLException {
        if (this.isInstanciable == null) {
            this.initMetaData1();
        }
        return this.isInstanciable;
    }

    public String getSuperTypeName() throws SQLException {
        if (this.superTypeName == null) {
            this.initMetaData1();
        }
        return this.superTypeName;
    }

    public int getNumberOfLocalAttributes() throws SQLException {
        if (this.numberOfLocalAttributes == -1) {
            this.initMetaData1();
        }
        return this.numberOfLocalAttributes;
    }

    public String[] getSubtypeNames() throws SQLException {
        if (this.subTypeNames == null) {
            this.initMetaData2();
        }
        return this.subTypeNames;
    }

    private void initMetaData1_9_0() throws SQLException {
        if (this.getTOID() != null) {
            this.initMetaData1_9_0UseToid();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_9_0UseToid() throws SQLException {
        block8: {
            if (this.isInstanciable != null && this.numberOfLocalAttributes != -1) {
                return;
            }
            String sql1 = "SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types t WHERE TYPE_OID = :1";
            PreparedStatement pstmt1 = null;
            ResultSet rset1 = null;
            if (this.sqlName == null) {
                this.getFullName();
            }
            this.connection.beginNonRequestCalls();
            try {
                pstmt1 = this.connection.prepareStatement(sql1);
                pstmt1.setBytes(1, this.getTOID());
                pstmt1.setFetchSize(1);
                rset1 = pstmt1.executeQuery();
                if (rset1.next()) {
                    this.isInstanciable = new Boolean(rset1.getString(1).equals("YES"));
                    this.superTypeName = rset1.getString(2) + "." + rset1.getString(3);
                    this.numberOfLocalAttributes = rset1.getInt(4);
                    break block8;
                }
                SQLException sqlException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Inconsistent catalog view").fillInStackTrace();
                this.trace(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "initMetaData1_9_0UseToid", sqlException.getMessage(), null, sqlException, new Object[0]);
                throw sqlException;
            }
            finally {
                if (rset1 != null) {
                    rset1.close();
                }
                if (pstmt1 != null) {
                    pstmt1.close();
                }
                this.connection.endNonRequestCalls();
            }
        }
    }

    private void initMetaData1_pre_9_0() throws SQLException {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.isInstanciable = new Boolean(true);
            this.superTypeName = "";
            this.numberOfLocalAttributes = 0;
        }
    }

    private void initMetaData2() throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            short version = this.connection.getVersionNumber();
            if (version >= 9000) {
                this.initMetaData2_9_0();
            } else {
                this.initMetaData2_pre_9_0();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2_9_0() throws SQLException {
        block21: {
            if (this.getTOID() != null) {
                this.initMetaData1_9_0UseToid();
            }
            if (this.sqlName == null) {
                this.getFullName();
            }
            String sql2 = "SELECT owner, type_name FROM all_types WHERE supertype_name = :1 and supertype_owner = :2";
            try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();
                 Monitor.CloseableLock selfLock = this.acquireCloseableLock();){
                if (this.subTypeNames != null) break block21;
                PreparedStatement pstmt = null;
                ResultSet rset = null;
                String[] temp_names_array = null;
                this.connection.beginNonRequestCalls();
                try {
                    pstmt = this.connection.prepareStatement(sql2);
                    pstmt.setString(1, this.sqlName.getSimpleName());
                    pstmt.setString(2, this.sqlName.getSchema());
                    rset = pstmt.executeQuery();
                    Vector<CallSite> _vector = new Vector<CallSite>();
                    while (rset.next()) {
                        _vector.addElement((CallSite)((Object)(rset.getString(1) + "." + rset.getString(2))));
                    }
                    temp_names_array = new String[_vector.size()];
                    for (int i = 0; i < temp_names_array.length; ++i) {
                        temp_names_array[i] = (String)_vector.elementAt(i);
                    }
                    _vector.removeAllElements();
                    _vector = null;
                }
                finally {
                    if (rset != null) {
                        rset.close();
                    }
                    if (pstmt != null) {
                        pstmt.close();
                    }
                    this.connection.endNonRequestCalls();
                }
                this.subTypeNames = temp_names_array;
            }
        }
    }

    private void initMetaData2_pre_9_0() throws SQLException {
        this.subTypeNames = new String[0];
    }

    @Override
    public void printXML(PrintWriter pw, int indent) throws SQLException {
        this.printXML(pw, indent, false);
    }

    @Override
    public void printXML(PrintWriter pw, int indent, boolean fetchAllMetaDataAsNeeded) throws SQLException {
        try (Monitor.CloseableLock lock = this.connection.acquireCloseableLock();){
            int i;
            for (i = 0; i < indent; ++i) {
                pw.print("  ");
            }
            pw.print("<OracleTypeADT sqlName=\"" + String.valueOf(this.sqlName) + "\" ");
            pw.print(" typecode=\"" + this.typeCode + "\"");
            if (this.tdsVersion != -9999) {
                pw.print(" tds_version=\"" + this.tdsVersion + "\"");
            }
            pw.println();
            for (i = 0; i < indent + 4; ++i) {
                pw.print("  ");
            }
            pw.println(" is_embedded=\"" + this.isEmbeddedADT() + "\" is_top_level=\"" + this.isTopADT() + "\" is_upt=\"" + this.isUptADT() + "\" finalType=\"" + this.isFinalType() + "\" subtype=\"" + this.isSubType() + "\">");
            if (this.attrTypes != null && this.attrTypes.length > 0) {
                for (i = 0; i < indent + 1; ++i) {
                    pw.print("  ");
                }
                pw.println("<attributes>");
                for (int j = 0; j < this.attrTypes.length; ++j) {
                    int i2;
                    for (i2 = 0; i2 < indent + 2; ++i2) {
                        pw.print("  ");
                    }
                    pw.println("<attribute name=\"" + this.getAttributeName(j + 1, fetchAllMetaDataAsNeeded) + "\"  type=\"" + this.getAttributeType(j + 1, false) + "\" >");
                    this.attrTypes[j].printXML(pw, indent + 3, fetchAllMetaDataAsNeeded);
                    for (i2 = 0; i2 < indent + 2; ++i2) {
                        pw.print("  ");
                    }
                    pw.println("</attribute> ");
                }
                for (i = 0; i < indent + 1; ++i) {
                    pw.print("  ");
                }
                pw.println("</attributes>");
            }
            for (i = 0; i < indent; ++i) {
                pw.print("  ");
            }
            pw.println("</OracleTypeADT>");
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }
}

