/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.Diagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.AdditionalDatabaseMetaData;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.jdbc.internal.OracleParameterMetaData;
import oracle.jdbc.internal.OracleResultSetMetaData;
import oracle.jdbc.internal.OracleRowId;
import oracle.jdbc.internal.OracleSavepoint;
import oracle.jdbc.internal.OracleStatement;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableStatement;

@ProxyFor(value={AdditionalDatabaseMetaData.class, ClientDataSupport.class, OracleParameterMetaData.class, OracleRowId.class, OracleSavepoint.class, OracleTypeMetaData.class, OracleTypeMetaData.Array.class, OracleTypeMetaData.Opaque.class, OracleTypeMetaData.Struct.class, OracleResultSetMetaData.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableBase
implements JDBCReplayable,
Diagnosable {
    protected TxnFailoverManagerImpl failoverMngr;
    private final ReentrantLock failoverMngrLock = new ReentrantLock();
    protected TxnFailoverManagerImpl.CallHistoryEntry headSameProxy = null;
    protected TxnFailoverManagerImpl.CallHistoryEntry tailSameProxy = null;
    protected TxnFailoverManagerImpl.CallHistoryEntry sssHeadSameProxy = null;
    protected TxnFailoverManagerImpl.CallHistoryEntry sssTailSameProxy = null;
    protected TxnFailoverManagerImpl.CallHistoryEntry replayingCallEntry = null;
    protected SQLRecoverableException originalError = null;
    protected static final int SPECIAL_SVR_RECOVERABLE_ERROR = 603;
    protected static final int TXN_IN_READONLY_REPLAY_ERROR = 29791;
    protected static final int SET_CONTAINER_AFTER_PREPARE = 44787;
    protected static final int SVR_NO_REPLAY_ERROR_CODE = 45;
    protected boolean isClosedAndNoReplay = false;
    protected boolean isLogicallyClosed = false;
    protected boolean isFreed = false;
    protected boolean abortCalledBeforeLatestClose = false;
    protected boolean isCreatingCallReplayable = true;
    protected boolean isCurrentExecuteReplayable = true;
    protected boolean isProxyReplayable = true;
    protected TxnFailoverManagerImpl.CallHistoryEntry creatorCallEntry = null;
    protected TxnFailoverManagerImpl.SSSCallHistoryEntry sssCreatorCallEntry = null;
    protected long currentBindChecksum = 0L;
    protected boolean isSSSCursor = false;
    private static final String PROXY_CLASS_SUFFIX = "$$$Proxy";
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableBase";

    protected TxnReplayableBase() {
    }

    @Pre
    protected void preForAll(Method m4, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.failoverMngr.acStatistics.incrementTotalCalls();
                if (this.isSSSCursor) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "preForAll", "On {0}, SSS CURSOR, SKIP recording for {1}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), m4.getName()});
                    break;
                }
                this.failoverMngr.record(this, m4, args, "started");
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                this.failoverMngr.acStatistics.incrementTotalCalls();
            }
        }
    }

    @Post
    protected void postForAll(Method m4) {
        this.postForAll(m4, null);
    }

    @Post
    protected Object postForAll(Method m4, Object result) {
        if (result instanceof TxnReplayableBase) {
            TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
            if (this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled) {
                jdbcProxy.isSSSCursor = this.isSSSCursor;
            }
        }
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                if (this.isSSSCursor) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "postForAll", "On {0}, SSS CURSOR, SKIP updating for {1}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), m4.getName()});
                    break;
                }
                this.doPostWhenRecording(m4, result, null);
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: 
            case REPLAYING_CALLBACK: {
                break;
            }
            case REPLAYING: {
                this.doPostWhenReplaying(m4, result, null);
            }
        }
        return result;
    }

    protected void doPostWhenRecording(Method m4, Object result, SQLException sqlexc) {
        this.failoverMngr.update(this, null, result, "completed", this.currentBindChecksum, sqlexc);
        this.currentBindChecksum = 0L;
    }

    protected void doPostWhenReplaying(Method m4, Object result, SQLException sqlexc) {
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m4, SQLException error) throws SQLException {
        this.onErrorForAll(m4, error);
    }

    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m4, SQLException error) throws SQLException {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle;
        TxnReplayableBase connProxy = (TxnReplayableBase)this.failoverMngr.getConnectionProxy();
        OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
        connProxy.abortCalledBeforeLatestClose = false;
        if (connProxy.isClosedAndNoReplay) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, method {1} hit outage, NO replay because there was a mid-request close() call earlier", (String)null, (Throwable)null, new Object[]{connProxy.hashCode(), m4.getName()});
            throw error;
        }
        if (oconn.isClosed() && oconn.isSafelyClosed()) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, method {1} hit outage, NO replay because the connection has been safely closed for RAC planned-maintenance", (String)null, (Throwable)null, new Object[]{connProxy.hashCode(), m4.getName()});
            throw error;
        }
        if (error instanceof BatchUpdateException) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, method {1} hit BatchUpdateException", (String)null, (Throwable)null, new Object[]{connProxy.hashCode(), m4.getName()});
            SQLException nextExc = error.getNextException();
            if (nextExc != null && nextExc instanceof SQLRecoverableException) {
                error = nextExc;
            }
        }
        if (error instanceof SQLRecoverableException && !this.isLogicallyClosed) {
            if (!this.failoverMngr.isSessionStateConsistencyDynamic() && !this.isCreatingCallReplayable) {
                this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, method {1} hit outage, NO replay because this method is not replayable", (String)null, (Throwable)null, new Object[]{connProxy.hashCode(), m4.getName()});
                this.failoverMngr.disableReplayAndThrowOriginalError(m4, 372, "Replay disabled because of nonreplayable call", (SQLRecoverableException)error);
            }
            lifecycle = this.failoverMngr.getReplayLifecycle();
            switch (lifecycle) {
                case ENABLED_NOT_REPLAYING: {
                    if (!this.failoverMngr.sssFetchOutage || this.failoverMngr.sssSavedRsetProxy != this) {
                        this.failoverMngr.update(this, null, null, "incomplete", this.currentBindChecksum, error);
                    } else {
                        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, SSS-cursor method next() hit outage, skip handling replay-context before handleOutage", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                    }
                    this.currentBindChecksum = 0L;
                }
                case ALWAYS_DISABLED: 
                case INTERNALLY_DISABLED: 
                case EXTERNALLY_DISABLED: {
                    this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, method {1} hit outage", (String)null, (Throwable)null, new Object[]{connProxy.hashCode(), m4.getName()});
                    return this.failoverMngr.handleOutage(m4, (SQLRecoverableException)error);
                }
                case REPLAYING_LASTCALL: {
                    if (!this.failoverMngr.sssFetchOutage || this.failoverMngr.sssSavedRsetProxy != this) {
                        this.failoverMngr.update(this, null, null, "incomplete", this.currentBindChecksum, error);
                    } else {
                        this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, SSS-cursor method next() hit outage, skip handling replay-context when replaying 2nd-to-last call", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                    }
                    this.currentBindChecksum = 0L;
                }
            }
            throw error;
        }
        if (error instanceof SQLRecoverableException && !this.failoverMngr.isSessionStateConsistencyDynamic() && !this.isCreatingCallReplayable) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, method {1} hit outage, NO replay because this method is not replayable", (String)null, (Throwable)null, new Object[]{connProxy.hashCode(), m4.getName()});
            this.failoverMngr.disableReplayAndThrowOriginalError(m4, 372, "Replay disabled because of nonreplayable call", (SQLRecoverableException)error);
        }
        if (error.getErrorCode() == 45) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, method {1} receives ORA-45 and replay is disabled", (String)null, (Throwable)null, new Object[]{connProxy.hashCode(), m4.getName()});
            this.failoverMngr.disableReplayAndThrowSQLException(m4, 398, "Replay disabled because server killed session with -noreplay option", error);
        }
        lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case REPLAYING_LASTCALL: {
                if (!this.failoverMngr.sssFetchOutage || this.failoverMngr.sssSavedRsetProxy != this) {
                    this.doPostWhenRecording(m4, null, error);
                    break;
                }
                this.debug(Level.FINE, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForAll", "On {0}, SSS-cursor method next() hit outage, skip handling replay-context before and after replay", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                break;
            }
        }
        throw error;
    }

    @Pre
    @Methods(signatures={@Signature(name="toString", args={})})
    protected void preForToString(Method m4, Object receiver, Object ... args) {
    }

    @Post
    @Methods(signatures={@Signature(name="toString", args={})})
    protected String postForToString(Method m4, String str) {
        return str;
    }

    @GetDelegate
    protected abstract Object getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) throws SQLException {
        Object result = null;
        try {
            TxnFailoverManagerImpl.ReplayLifecycle _lifecycle;
            Object newResult;
            ((JDBCReplayable)entry.jdbcProxy).setReplayingCallContext(entry, origError);
            TxnReplayableBase connProxy = (TxnReplayableBase)this.failoverMngr.getConnectionProxy();
            OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
            if (this.failoverMngr.isAutoAC) {
                if (entry.jdbcProxy instanceof TxnReplayableStatement) {
                    OracleConnection oldConn;
                    TxnReplayableStatement stmtProxy = (TxnReplayableStatement)entry.jdbcProxy;
                    OracleStatement delegate = (OracleStatement)this.getDelegate();
                    if (!delegate.isClosed() && (oldConn = delegate.getInternalConnection()) != oconn) {
                        stmtProxy.replugWithoutCreator(oconn);
                    }
                } else if (entry.jdbcProxy instanceof OracleLargeObject) {
                    Object lobProxy;
                    Object object = entry.jdbcProxy instanceof TxnReplayableBase ? (TxnReplayableBase)entry.jdbcProxy : (lobProxy = entry.jdbcProxy instanceof OracleConcreteProxy ? ((OracleConcreteProxy)entry.jdbcProxy).getConcreteProxy() : null);
                    if (lobProxy != null && ((TxnReplayableBase)lobProxy).getConnectionInDelegate() != oconn) {
                        ((TxnReplayableBase)lobProxy).replugWithoutCreator(oconn);
                    }
                    ((TxnReplayableBase)lobProxy).isFreed = false;
                    ((TxnReplayableBase)lobProxy).isLogicallyClosed = false;
                }
            }
            if (entry.replayContext != null) {
                oconn.setReplayContext(entry.replayContext);
                for (ReplayContext thisReplayContext : entry.replayContext) {
                    if (thisReplayContext == null) {
                        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayOneCall", "On {0}, server replay context set: NULL", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                        continue;
                    }
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayOneCall", "On {0}, server replay context set: NOT NULL", (String)null, (Throwable)null, (Object)connProxy.hashCode());
                }
            }
            result = newResult = entry.method.invoke(entry.jdbcProxy, entry.args);
            if (newResult instanceof TxnReplayableBase) {
                _lifecycle = this.failoverMngr.getReplayLifecycle();
                if (_lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING && newResult != null && entry.result != null) {
                    Object newDelegate = ((TxnReplayableBase)newResult).getDelegate();
                    ((TxnReplayableBase)entry.result).setDelegate(newDelegate);
                    result = entry.result;
                    ((TxnReplayableBase)entry.result).isFreed = false;
                    ((TxnReplayableBase)entry.result).isLogicallyClosed = false;
                }
            } else if (newResult instanceof OracleConcreteProxy && (_lifecycle = this.failoverMngr.getReplayLifecycle()) == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING && newResult != null && entry.result != null && entry.result instanceof OracleConcreteProxy) {
                TxnReplayableBase newConcreteProxy = ((OracleConcreteProxy)newResult).getConcreteProxy();
                TxnReplayableBase oldConcreteProxy = ((OracleConcreteProxy)entry.result).getConcreteProxy();
                if (newConcreteProxy != null && oldConcreteProxy != null) {
                    Object newDelegate = newConcreteProxy.getDelegate();
                    oldConcreteProxy.setDelegate(newDelegate);
                    result = entry.result;
                } else if (newConcreteProxy == null && oldConcreteProxy != null) {
                    oldConcreteProxy.setDelegate(newResult);
                    result = entry.result;
                }
                oldConcreteProxy.isFreed = false;
                oldConcreteProxy.isLogicallyClosed = false;
            }
        }
        catch (InvocationTargetException targetException) {
            SQLException nextExc;
            Throwable throwable = targetException.getCause();
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayOneCall", "On {0}, replaying {1} got InvocationTargetException with cause: {2}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), entry.method.getName(), throwable});
            if (throwable instanceof BatchUpdateException && (nextExc = ((BatchUpdateException)throwable).getNextException()) != null && nextExc instanceof SQLRecoverableException) {
                throwable = nextExc;
            }
            if (throwable instanceof SQLRecoverableException && !this.isLogicallyClosed) {
                int errCode;
                SQLRecoverableException sqlrexc = (SQLRecoverableException)throwable;
                Throwable t2 = sqlrexc.getCause();
                if (t2 == null && (errCode = sqlrexc.getErrorCode()) == 603) {
                    if (sqlrexc.getMessage().indexOf("ORA-29791") != -1) {
                        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "replayOneCall", "On {0}, replaying {1} receives ORA-603/ORA-29791", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), entry.method.getName()});
                        origError.setNextException(sqlrexc);
                        this.failoverMngr.disableReplayAndThrowException(entry.method, 390, "Replay failed because of active transaction during replay", origError);
                    } else if (sqlrexc.getMessage().indexOf("ORA-44787") != -1) {
                        this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "replayOneCall", "On {0}, replaying {1} receives ORA-603/ORA-44787", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), entry.method.getName()});
                        origError.setNextException(sqlrexc);
                        this.failoverMngr.disableReplayAndThrowException(entry.method, 366, "Replay failed because of calling set container after PREPARE_REPLAY", origError);
                    }
                }
                throw sqlrexc;
            }
            if (throwable instanceof SQLRecoverableException && this.isLogicallyClosed || throwable instanceof SQLException) {
                SQLException sqlexc = (SQLException)throwable;
                TxnFailoverManagerImpl.ReplayLifecycle _lifecycle = this.failoverMngr.getReplayLifecycle();
                if (sqlexc.getErrorCode() == 17290) {
                    throw sqlexc;
                }
                if (_lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && this.failoverMngr.didReplayingLastCallDisableReplay) {
                    throw sqlexc;
                }
                if (throwable instanceof SQLException && (entry.callException == null || sqlexc.getErrorCode() != entry.callException.getErrorCode())) {
                    origError.setNextException(sqlexc);
                    this.failoverMngr.disableReplayAndThrowException(entry.method, 389, "Replay failed because of error code or message mismatch", origError);
                } else if (_lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING_LASTCALL) {
                    throw sqlexc;
                }
            } else {
                this.failoverMngr.disableReplayAndThrowException(entry.method, 370, "Replay disabled", origError);
            }
        }
        catch (Throwable otherThrowable) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "replayOneCall", "On {0}, replaying {1} caught throwable: {2}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), entry.method.getName(), otherThrowable});
            otherThrowable.printStackTrace();
            this.failoverMngr.disableReplayAndThrowException(entry.method, 370, "Replay disabled", origError);
        }
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        switch (lifecycle) {
            case INTERNALLY_FAILED: 
            case INTERNALLY_DISABLED: {
                this.failoverMngr.throwReplayExceptionInternal(0, null, null);
            }
        }
        return result;
    }

    @Override
    public void addToSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry entry) {
        entry.prevEntrySameProxy = this.tailSameProxy;
        entry.nextEntrySameProxy = null;
        if (this.tailSameProxy != null) {
            this.tailSameProxy.nextEntrySameProxy = entry;
        }
        this.tailSameProxy = entry;
        if (this.headSameProxy == null) {
            this.headSameProxy = entry;
        }
    }

    @Override
    public void removeFromSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry entry) {
        if (entry.nextEntrySameProxy != null) {
            entry.nextEntrySameProxy.prevEntrySameProxy = entry.prevEntrySameProxy;
        }
        if (entry.prevEntrySameProxy != null) {
            entry.prevEntrySameProxy.nextEntrySameProxy = entry.nextEntrySameProxy;
        }
        if (this.headSameProxy == entry) {
            this.headSameProxy = entry.nextEntrySameProxy;
        }
        if (this.tailSameProxy == entry) {
            this.tailSameProxy = entry.prevEntrySameProxy;
        }
    }

    public void addToSSSSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry entry) {
        entry.prevEntrySameProxy = this.sssTailSameProxy;
        entry.nextEntrySameProxy = null;
        if (this.sssTailSameProxy != null) {
            this.sssTailSameProxy.nextEntrySameProxy = entry;
        }
        this.sssTailSameProxy = entry;
        if (this.sssHeadSameProxy == null) {
            this.sssHeadSameProxy = entry;
        }
    }

    public void removeFromSSSSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry entry) {
        if (entry.nextEntrySameProxy != null) {
            entry.nextEntrySameProxy.prevEntrySameProxy = entry.prevEntrySameProxy;
        }
        if (entry.prevEntrySameProxy != null) {
            entry.prevEntrySameProxy.nextEntrySameProxy = entry.nextEntrySameProxy;
        }
        if (this.sssHeadSameProxy == entry) {
            this.sssHeadSameProxy = entry.nextEntrySameProxy;
        }
        if (this.sssTailSameProxy == entry) {
            this.sssTailSameProxy = entry.prevEntrySameProxy;
        }
    }

    String dumpHistory() {
        Object ret = "Dump Same-proxy History: \n";
        if (this.headSameProxy != null) {
            TxnFailoverManagerImpl.CallHistoryEntry entry = this.headSameProxy;
            while (true) {
                ret = (String)ret + entry.toString();
                if (entry == this.tailSameProxy) break;
                entry = entry.nextEntry;
            }
        }
        return ret;
    }

    String dumpSSSHistory() {
        Object ret = "Dump SSS Same-proxy History: \n";
        if (this.sssHeadSameProxy != null) {
            TxnFailoverManagerImpl.CallHistoryEntry entry = this.sssHeadSameProxy;
            while (true) {
                ret = (String)ret + entry.toString();
                if (entry == this.sssTailSameProxy) break;
                entry = entry.nextEntry;
            }
        }
        return ret;
    }

    public void copyFromMainToSSSQueue() {
        this.sssCreatorCallEntry = this.failoverMngr.copyFromMainToSSSQueue(this.creatorCallEntry);
        TxnFailoverManagerImpl.CallHistoryEntry entry = this.headSameProxy;
        while (entry != this.tailSameProxy) {
            this.failoverMngr.copyFromMainToSSSQueue(entry);
            entry = entry.nextEntrySameProxy;
        }
        this.failoverMngr.copyExecCallFromMainToSSSQueue(this.tailSameProxy);
    }

    @Override
    public void purgeSameProxyList() {
        if (this.failoverMngr != null) {
            HashSet<Object> visitedProxies = new HashSet<Object>();
            for (Object ancestor = this; ancestor != null && ancestor instanceof TxnReplayableBase && !(ancestor instanceof ReplayableConnection); ancestor = ((TxnReplayableBase)ancestor).getCreator()) {
                visitedProxies.add(ancestor);
            }
            this.failoverMngr.purgeForSameProxy(visitedProxies, this.headSameProxy);
        }
    }

    public void purgeSSSSameProxyList() {
        if (this.failoverMngr != null) {
            HashSet<Object> visitedProxies = new HashSet<Object>();
            for (Object ancestor = this; ancestor != null && ancestor instanceof TxnReplayableBase && !(ancestor instanceof ReplayableConnection); ancestor = ((TxnReplayableBase)ancestor).getCreator()) {
                visitedProxies.add(ancestor);
            }
            this.failoverMngr.purgeForSSSSameProxy(visitedProxies, this.sssHeadSameProxy);
        }
    }

    void purgeFromSSSQueue() {
        this.failoverMngr.sssRemove(this.sssCreatorCallEntry);
        TxnFailoverManagerImpl.CallHistoryEntry entry = this.sssHeadSameProxy;
        while (entry != this.sssTailSameProxy) {
            this.failoverMngr.sssRemove((TxnFailoverManagerImpl.SSSCallHistoryEntry)entry);
            entry = entry.nextEntrySameProxy;
        }
        this.failoverMngr.sssRemove((TxnFailoverManagerImpl.SSSCallHistoryEntry)this.sssTailSameProxy);
        this.sssHeadSameProxy = null;
        this.sssTailSameProxy = null;
        this.sssCreatorCallEntry = null;
    }

    @Override
    public void setReplayingCallContext(TxnFailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) {
        this.replayingCallEntry = entry;
        this.originalError = origError;
    }

    @Override
    public void setFailoverManager(TxnFailoverManagerImpl mngr) {
        this.failoverMngrLock.lock();
        try {
            this.failoverMngr = mngr;
        }
        finally {
            this.failoverMngrLock.unlock();
        }
    }

    @Override
    public TxnFailoverManagerImpl getFailoverManager() {
        this.failoverMngrLock.lock();
        try {
            TxnFailoverManagerImpl txnFailoverManagerImpl = this.failoverMngr;
            return txnFailoverManagerImpl;
        }
        finally {
            this.failoverMngrLock.unlock();
        }
    }

    public void disableReplay() throws SQLException {
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplay();
        }
    }

    protected OracleConnection getConnectionInDelegate() throws SQLException {
        return null;
    }

    protected void replugWithoutCreator(OracleConnection newConn) throws SQLException {
    }

    private boolean isReplayFailure(Throwable t2) {
        int errCode;
        boolean result = false;
        if (t2 instanceof SQLException && (errCode = ((SQLException)t2).getErrorCode()) >= 370 && errCode < 400) {
            result = true;
        }
        return result;
    }

    protected boolean assertThrowablesMatch(Throwable currentT, Throwable originalT) {
        boolean doThrowablesMatch;
        boolean areSameType = originalT == null ? false : currentT.getClass().getName().equals(originalT.getClass().getName());
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "assertThrowablesMatch", "Errors at original execution and replay are of same type: {0}", (String)null, (Throwable)null, (Object)areSameType);
        if (currentT instanceof SQLException && areSameType) {
            doThrowablesMatch = ((SQLException)currentT).getErrorCode() == ((SQLException)originalT).getErrorCode();
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "assertThrowablesMatch", "Errors at original execution and replay are SQLException, error codes match: {0}", (String)null, (Throwable)null, (Object)doThrowablesMatch);
        } else if (areSameType) {
            String currentMesg = currentT.getMessage();
            String originalMesg = originalT.getMessage();
            doThrowablesMatch = currentMesg == null && originalMesg == null || currentMesg != null && originalMesg != null && currentT.getMessage().equals(originalT.getMessage());
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "assertThrowablesMatch", "Errors at original execution and replay are same type but not SQLException, error messages match: {0}", (String)null, (Throwable)null, (Object)doThrowablesMatch);
        } else {
            doThrowablesMatch = false;
        }
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "assertThrowablesMatch", "Errors at original execution and replay match: {0}", (String)null, (Throwable)null, (Object)doThrowablesMatch);
        return doThrowablesMatch;
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public Object getDelegateObj() {
        return this.getDelegate();
    }

    @Override
    public Diagnosable getDiagnosable() {
        return CommonDiagnosable.getInstance();
    }
}

