/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleRef;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnReplayableBase;

@ProxyFor(value={OracleRef.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableRef
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETOBJECT_METHOD = TxnReplayableRef.getMethod("getObject", new Class[0]);
    private static final Method GETOBJECT_WITH_MAP_METHOD = TxnReplayableRef.getMethod("getObject", Map.class);
    private static final Method GETVALUE_METHOD = TxnReplayableRef.getMethod("getValue", new Class[0]);
    private static final Method GETVALUE_WITH_MAP_METHOD = TxnReplayableRef.getMethod("getValue", Map.class);

    private static final Method getMethod(String methodName, Class<?> ... parameterTypes) {
        try {
            return OracleRef.class.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method m4, Object receiver, Object ... args) {
        super.preForAll(m4, receiver, args);
    }

    @Override
    @Post
    protected void postForAll(Method m4) {
        this.postForAll(m4, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m4, Object result) {
        if (result instanceof TxnReplayableBase) {
            TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m4, result);
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m4, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m4, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m4, SQLException error) throws SQLException {
        return super.onErrorForAll(m4, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject() throws SQLException {
        if (GETOBJECT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject()");
        }
        Method m4 = GETOBJECT_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            ProxyFactory pxyFactory;
            OracleRef ref = (OracleRef)this.getDelegate();
            Object result = ref.getObject();
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(java.util.Map<String,Class<?>>)");
        }
        Method m4 = GETOBJECT_WITH_MAP_METHOD;
        this.preForAll(m4, this, map);
        try {
            ProxyFactory pxyFactory;
            OracleRef ref = (OracleRef)this.getDelegate();
            Object result = ref.getObject(map);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getValue() throws SQLException {
        if (GETVALUE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getValue()");
        }
        Method m4 = GETVALUE_METHOD;
        this.preForAll(m4, this, new Object[0]);
        try {
            ProxyFactory pxyFactory;
            OracleRef ref = (OracleRef)this.getDelegate();
            Object result = ref.getValue();
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getValue(Map<String, Class<?>> map) throws SQLException {
        if (GETVALUE_WITH_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getValue(java.util.Map<String,Class<?>>)");
        }
        Method m4 = GETVALUE_WITH_MAP_METHOD;
        this.preForAll(m4, this, map);
        try {
            ProxyFactory pxyFactory;
            OracleRef ref = (OracleRef)this.getDelegate();
            Object result = ref.getValue(map);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        OracleRef delegate = (OracleRef)this.getDelegate();
        return delegate.getInternalConnection();
    }
}

