/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Map;
import java.util.logging.Level;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;
import oracle.jdbc.replay.driver.TxnReplayableStatement;
import oracle.sql.BFILE;

@ProxyFor(value={oracle.jdbc.internal.OracleResultSet.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableResultSet
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETCLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getClob", Integer.TYPE);
    private static final Method GETCLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getClob", String.class);
    private static final Method GETNCLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getNClob", Integer.TYPE);
    private static final Method GETNCLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getNClob", String.class);
    private static final Method GETBLOB_METHOD = TxnReplayableResultSet.getGetLobMethod("getBlob", Integer.TYPE);
    private static final Method GETBLOB_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getBlob", String.class);
    private static final Method GETBFILE_METHOD = TxnReplayableResultSet.getGetLobMethod("getBfile", Integer.TYPE);
    private static final Method GETBFILE_WITH_NAME_METHOD = TxnReplayableResultSet.getGetLobMethod("getBfile", String.class);
    private static final Method GETOBJECT_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE);
    private static final Method GETOBJECT_WITH_TYPE_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE, Class.class);
    private static final Method GETOBJECT_WITH_MAP_METHOD = TxnReplayableResultSet.getMethod("getObject", Integer.TYPE, Map.class);
    private static final Method GETOBJECT_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class);
    private static final Method GETOBJECT_WITH_NAME_AND_TYPE_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class, Class.class);
    private static final Method GETOBJECT_WITH_NAME_AND_MAP_METHOD = TxnReplayableResultSet.getMethod("getObject", String.class, Map.class);
    private static final Method GETREF_METHOD = TxnReplayableResultSet.getMethod("getRef", Integer.TYPE);
    private static final Method GETREF_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getRef", String.class);
    private static final Method GETARRAY_METHOD = TxnReplayableResultSet.getMethod("getArray", Integer.TYPE);
    private static final Method GETARRAY_WITH_NAME_METHOD = TxnReplayableResultSet.getMethod("getArray", String.class);
    int sssFetchCount = 0;
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableResultSet";

    protected TxnReplayableResultSet() {
    }

    @Override
    @Pre
    protected void preForAll(Method m4, Object receiver, Object ... args) {
        if (this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled) {
            Object creator = this.getCreator();
            if (creator instanceof TxnReplayableStatement) {
                TxnReplayableStatement stmt = (TxnReplayableStatement)creator;
                if (stmt.isSSSCursor) {
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "preForAll", "On {0}, SSS CURSOR, SKIP recording for {1}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), m4.getName()});
                } else {
                    super.preForAll(m4, receiver, args);
                }
            } else {
                super.preForAll(m4, receiver, args);
            }
        } else {
            super.preForAll(m4, receiver, args);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="next", args={})})
    protected void preForNext(Method m4, Object receiver, Object ... args) {
        Object creator;
        if (this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled && (creator = this.getCreator()) instanceof TxnReplayableStatement) {
            TxnReplayableStatement stmt = (TxnReplayableStatement)creator;
            if (stmt.isSSSCursor) {
                ++this.sssFetchCount;
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "preForNext", "On {0}, SSS CURSOR, SKIP recording for next", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                return;
            }
        }
        super.preForAll(m4, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="getAsciiStream", args={int.class}), @Signature(name="getBinaryStream", args={int.class}), @Signature(name="getCharacterStream", args={int.class}), @Signature(name="getNCharacterStream", args={int.class})})
    protected void preForGetStreams(Method m4, Object receiver, Object ... args) {
        try {
            ResultSetMetaData rsmd = ((ResultSet)this.getDelegate()).getMetaData();
            if (rsmd != null) {
                int colType = rsmd.getColumnType((Integer)args[0]);
                if (colType == 2004 || colType == 2005 || colType == -13 || colType == 2016) {
                    this.failoverMngr.setLobStreamInRequest(true);
                    this.failoverMngr.disableReplayInternal(m4, 372, "Replay disabled because of nonreplayable call", null);
                } else {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForGetStreams", "On {0}, marking lob-stream operation failed: NULL ResultSetMetaData", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode()});
                }
            }
        }
        catch (Throwable err) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForGetStreams", "On {0}, marking lob-stream operation failed: {1}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), err});
        }
        this.preForAll(m4, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="getAsciiStream", args={String.class}), @Signature(name="getBinaryStream", args={String.class}), @Signature(name="getCharacterStream", args={String.class}), @Signature(name="getNCharacterStream", args={String.class})})
    protected void preForGetStreamsByColumnName(Method m4, Object receiver, Object ... args) {
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            ResultSetMetaData rsmd = orset.getMetaData();
            if (rsmd != null) {
                int colType = rsmd.getColumnType(orset.findColumn((String)args[0]));
                if (colType == 2004 || colType == 2005 || colType == -13 || colType == 2016) {
                    this.failoverMngr.setLobStreamInRequest(true);
                    this.failoverMngr.disableReplayInternal(m4, 372, "Replay disabled because of nonreplayable call", null);
                } else {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForGetStreamsByColumnName", "On {0}, marking lob-stream operation failed: NULL ResultSetMetaData", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode()});
                }
            }
        }
        catch (Throwable err) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "preForGetStreamsByColumnName", "On {0}, marking lob-stream operation failed: {1}", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), err});
        }
        this.preForAll(m4, receiver, args);
    }

    @Pre
    @Methods(signatures={@Signature(name="getOPAQUE", args={int.class}), @Signature(name="getOPAQUE", args={String.class})})
    protected void preForMethodWithConcreteClass(Method m4, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "preForMethodWithConcreteClass", "On {0}, DISABLE REPLAY in preForMethodWithConcreteClass({1})", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), m4.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m4, 397, "Replay disabled because of concrete class usage", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForMethodWithConcreteClass", "On result set {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="updateAsciiStream", args={String.class, InputStream.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={String.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class}), @Signature(name="updateNCharacterStream", args={String.class, Reader.class, long.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateAsciiStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, int.class}), @Signature(name="updateBinaryStream", args={int.class, InputStream.class, long.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, int.class}), @Signature(name="updateCharacterStream", args={int.class, Reader.class, long.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class}), @Signature(name="updateNCharacterStream", args={int.class, Reader.class, long.class})})
    protected void preForUpdateStreams(Method m4, Object receiver, Object ... args) {
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "preForUpdateStreams", "On {0}, DISABLE REPLAY in preForUpdateStreams({1})", (String)null, (Throwable)null, new Object[]{this.failoverMngr.getConnectionProxy().hashCode(), m4.getName()});
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplayInternal(m4, 371, "Replay disabled because of active transaction", null);
        } else {
            this.debug(Level.SEVERE, SecurityLabel.UNKNOWN, CLASS_NAME, "preForUpdateStreams", "On result set {0}, failover manager not set", (String)null, (Throwable)null, (Object)this.hashCode());
        }
    }

    @Override
    @Post
    protected void postForAll(Method m4) {
        this.postForAll(m4, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m4, Object result) {
        Object creator;
        if (this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled && (creator = this.getCreator()) instanceof TxnReplayableStatement) {
            TxnReplayableStatement stmt = (TxnReplayableStatement)creator;
            if (stmt.isSSSCursor) {
                if (result instanceof TxnReplayableBase) {
                    TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
                    jdbcProxy.setFailoverManager(this.getFailoverManager());
                    jdbcProxy.isSSSCursor = this.isSSSCursor;
                }
                return result;
            }
        }
        return super.postForAll(m4, result);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(int columnIndex) throws SQLException {
        if (GETCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(int)");
        }
        Method m4 = GETCLOB_METHOD;
        this.preForAll(m4, this, columnIndex);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            Clob result = orset.getClob(columnIndex);
            return (Clob)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (Clob)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob getClob(String columnName) throws SQLException {
        if (GETCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getClob(String)");
        }
        Method m4 = GETCLOB_WITH_NAME_METHOD;
        this.preForAll(m4, this, columnName);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            Clob result = orset.getClob(columnName);
            return (Clob)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (Clob)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(int columnIndex) throws SQLException {
        if (GETNCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(int)");
        }
        Method m4 = GETNCLOB_METHOD;
        this.preForAll(m4, this, columnIndex);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            NClob result = orset.getNClob(columnIndex);
            return (NClob)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (NClob)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob getNClob(String columnName) throws SQLException {
        if (GETNCLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getNClob(String)");
        }
        Method m4 = GETNCLOB_WITH_NAME_METHOD;
        this.preForAll(m4, this, columnName);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            NClob result = orset.getNClob(columnName);
            return (NClob)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (NClob)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(int columnIndex) throws SQLException {
        if (GETBLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(int)");
        }
        Method m4 = GETBLOB_METHOD;
        this.preForAll(m4, this, columnIndex);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            Blob result = orset.getBlob(columnIndex);
            return (Blob)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (Blob)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob getBlob(String columnName) throws SQLException {
        if (GETBLOB_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBlob(String)");
        }
        Method m4 = GETBLOB_WITH_NAME_METHOD;
        this.preForAll(m4, this, columnName);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            Blob result = orset.getBlob(columnName);
            return (Blob)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (Blob)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE getBfile(int columnIndex) throws SQLException {
        if (GETBFILE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBfile(int)");
        }
        Method m4 = GETBFILE_METHOD;
        this.preForAll(m4, this, columnIndex);
        try {
            OracleResultSet orset = (OracleResultSet)this.getDelegate();
            BFILE result = orset.getBfile(columnIndex);
            return (BFILE)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (BFILE)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE getBfile(String columnName) throws SQLException {
        if (GETBFILE_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getBfile(String)");
        }
        Method m4 = GETBFILE_WITH_NAME_METHOD;
        this.preForAll(m4, this, columnName);
        try {
            OracleResultSet orset = (OracleResultSet)this.getDelegate();
            BFILE result = orset.getBfile(columnName);
            return (BFILE)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (BFILE)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex) throws SQLException {
        if (GETOBJECT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int)");
        }
        Method m4 = GETOBJECT_METHOD;
        this.preForAll(m4, this, columnIndex);
        try {
            ProxyFactory pxyFactory;
            ResultSet orset = (ResultSet)this.getDelegate();
            Object result = orset.getObject(columnIndex);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (GETOBJECT_WITH_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int,Class<T>)");
        }
        Method m4 = GETOBJECT_WITH_TYPE_METHOD;
        this.preForAll(m4, this, columnIndex, type);
        try {
            ProxyFactory pxyFactory;
            ResultSet orset = (ResultSet)this.getDelegate();
            T result = orset.getObject(columnIndex, type);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return (T)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (T)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(int, Map)");
        }
        Method m4 = GETOBJECT_WITH_MAP_METHOD;
        this.preForAll(m4, this, columnIndex, map);
        try {
            ProxyFactory pxyFactory;
            ResultSet orset = (ResultSet)this.getDelegate();
            Object result = orset.getObject(columnIndex, map);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName) throws SQLException {
        if (GETOBJECT_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String)");
        }
        Method m4 = GETOBJECT_WITH_NAME_METHOD;
        this.preForAll(m4, this, columnName);
        try {
            ProxyFactory pxyFactory;
            ResultSet orset = (ResultSet)this.getDelegate();
            Object result = orset.getObject(columnName);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T getObject(String columnName, Class<T> type) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_TYPE_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String,Class<T>)");
        }
        Method m4 = GETOBJECT_WITH_NAME_AND_TYPE_METHOD;
        this.preForAll(m4, this, columnName, type);
        try {
            ProxyFactory pxyFactory;
            ResultSet orset = (ResultSet)this.getDelegate();
            T result = orset.getObject(columnName, type);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return (T)this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return (T)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (T)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getObject(String columnName, Map<String, Class<?>> map) throws SQLException {
        if (GETOBJECT_WITH_NAME_AND_MAP_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getObject(String, Map)");
        }
        Method m4 = GETOBJECT_WITH_NAME_AND_MAP_METHOD;
        this.preForAll(m4, this, columnName, map);
        try {
            ProxyFactory pxyFactory;
            ResultSet orset = (ResultSet)this.getDelegate();
            Object result = orset.getObject(columnName, map);
            if (!(result instanceof OracleConcreteProxy) && (pxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(m4, pxyFactory.proxyFor(result));
            }
            return this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(int columnIndex) throws SQLException {
        if (GETREF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(int)");
        }
        Method m4 = GETREF_METHOD;
        this.preForAll(m4, this, columnIndex);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            Ref result = orset.getRef(columnIndex);
            return (Ref)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (Ref)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Ref getRef(String columnName) throws SQLException {
        if (GETREF_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getRef(String)");
        }
        Method m4 = GETREF_WITH_NAME_METHOD;
        this.preForAll(m4, this, columnName);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            Ref result = orset.getRef(columnName);
            return (Ref)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (Ref)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(int columnIndex) throws SQLException {
        if (GETARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(int)");
        }
        Method m4 = GETARRAY_METHOD;
        this.preForAll(m4, this, columnIndex);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            Array result = orset.getArray(columnIndex);
            return (Array)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (Array)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array getArray(String columnName) throws SQLException {
        if (GETARRAY_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot getArray(String)");
        }
        Method m4 = GETARRAY_WITH_NAME_METHOD;
        this.preForAll(m4, this, columnName);
        try {
            ResultSet orset = (ResultSet)this.getDelegate();
            Array result = orset.getArray(columnName);
            return (Array)this.postForAll(m4, result);
        }
        catch (SQLException sqlexc) {
            return (Array)this.postForAll(m4, this.onErrorForAll(m4, sqlexc));
        }
    }

    private static final Method getGetLobMethod(String methodName, Class<?> argType) {
        try {
            return oracle.jdbc.internal.OracleResultSet.class.getMethod(methodName, argType);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getMethod(String methodName, Class<?> ... parameterTypes) {
        try {
            return oracle.jdbc.internal.OracleResultSet.class.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Post
    @Methods(signatures={@Signature(name="next", args={})})
    protected boolean postForNext(Method m4, boolean result) {
        Object creator;
        if (this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled && (creator = this.getCreator()) instanceof TxnReplayableStatement) {
            TxnReplayableStatement stmt = (TxnReplayableStatement)creator;
            if (stmt.isSSSCursor) {
                this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "postForNext", "On {0}, postForNext -- SSS CURSOR, CLEARING replay-context for next", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
                OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
                try {
                    oconn.getReplayContext();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return result;
            }
        }
        return (Boolean)this.postForAll(m4, result);
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m4) {
        this.postForAll(m4);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.isLogicallyClosed = true;
            this.creatorCallEntry = null;
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m4, SQLException error) throws SQLException {
        this.onErrorForAll(m4, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m4, SQLException error) throws SQLException {
        return super.onErrorForAll(m4, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="next", args={})})
    protected boolean onErrorForNext(Method m4, SQLException error) throws SQLException {
        if (this.failoverMngr.isAutoAC && this.failoverMngr.isSSSCursorEnabled) {
            if (this.isClosedAndNoReplay) {
                throw error;
            }
            Object creator = this.getCreator();
            if (creator instanceof TxnReplayableStatement) {
                TxnReplayableStatement stmt = (TxnReplayableStatement)creator;
                if (stmt.isSSSCursor) {
                    this.failoverMngr.sssFetchOutage = true;
                    this.failoverMngr.sssSavedRsetProxy = (ResultSet)((Object)this);
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForNext", "On {0}, SSS CURSOR, next() hit outage", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                    super.onErrorForAll(m4, error);
                    --this.sssFetchCount;
                    this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForNext", "On {0}, SSS-cursor fetch outage, replaying last failed next()", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
                    return ((ResultSet)((Object)this)).next();
                }
                return (Boolean)super.onErrorForAll(m4, error);
            }
            return (Boolean)super.onErrorForAll(m4, error);
        }
        return (Boolean)super.onErrorForAll(m4, error);
    }

    @OnError(value=SQLException.class)
    @Methods(signatures={@Signature(name="last", args={})})
    protected boolean onErrorForLast(Method m4, SQLException error) throws SQLException {
        if (this.isClosedAndNoReplay) {
            throw error;
        }
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        if (error instanceof SQLRecoverableException && lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.debug(Level.FINER, SecurityLabel.UNKNOWN, CLASS_NAME, "onErrorForLast", "On {0}, DISABLE REPLAY in last()", (String)null, (Throwable)null, (Object)this.failoverMngr.getConnectionProxy().hashCode());
            this.failoverMngr.disableReplayInternal(m4, 372, "Replay disabled because of nonreplayable call", null);
        }
        return (Boolean)super.onErrorForAll(m4, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry entry, SQLRecoverableException origError) throws SQLException {
        Object result = super.replayOneCall(entry, origError);
        return result;
    }
}

