/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.Util;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

public class MutableArray {
    int length;
    Object[] elements;
    Datum[] datums;
    ARRAY pickled;
    boolean pickledCorrect;
    int sqlType;
    ORADataFactory factory;
    CustomDatumFactory old_factory;
    boolean isNChar;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public MutableArray(int sqlType, ARRAY s2, ORADataFactory factory) {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = s2;
        this.pickledCorrect = true;
        this.isNChar = false;
        this.sqlType = sqlType;
        this.factory = factory;
    }

    public MutableArray(int sqlType, Datum[] d, ORADataFactory factory) {
        this.sqlType = sqlType;
        this.factory = factory;
        this.isNChar = false;
        this.setDatumArray(d);
    }

    public MutableArray(int sqlType, Object[] a, ORADataFactory factory) {
        this.sqlType = sqlType;
        this.factory = factory;
        this.isNChar = false;
        this.setObjectArray(a);
    }

    public MutableArray(int sqlType, double[] a, ORADataFactory factory) {
        this.sqlType = sqlType;
        this.factory = factory;
        this.isNChar = false;
        this.setArray(a);
    }

    public MutableArray(int sqlType, int[] a, ORADataFactory factory) {
        this.sqlType = sqlType;
        this.factory = factory;
        this.isNChar = false;
        this.setArray(a);
    }

    public MutableArray(int sqlType, float[] a, ORADataFactory factory) {
        this.sqlType = sqlType;
        this.factory = factory;
        this.isNChar = false;
        this.setArray(a);
    }

    public MutableArray(int sqlType, short[] a, ORADataFactory factory) {
        this.sqlType = sqlType;
        this.factory = factory;
        this.isNChar = false;
        this.setArray(a);
    }

    public MutableArray(ARRAY s2, int sqlType, CustomDatumFactory factory) {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = s2;
        this.pickledCorrect = true;
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.isNChar = false;
    }

    public MutableArray(Datum[] d, int sqlType, CustomDatumFactory factory) {
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.isNChar = false;
        this.setDatumArray(d);
    }

    public MutableArray(Object[] a, int sqlType, CustomDatumFactory factory) {
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.isNChar = false;
        this.setObjectArray(a);
    }

    public MutableArray(double[] a, int sqlType, CustomDatumFactory factory) {
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.isNChar = false;
        this.setArray(a);
    }

    public MutableArray(int[] a, int sqlType, CustomDatumFactory factory) {
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.isNChar = false;
        this.setArray(a);
    }

    public MutableArray(float[] a, int sqlType, CustomDatumFactory factory) {
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.isNChar = false;
        this.setArray(a);
    }

    public MutableArray(short[] a, int sqlType, CustomDatumFactory factory) {
        this.sqlType = sqlType;
        this.old_factory = factory;
        this.isNChar = false;
        this.setArray(a);
    }

    public Datum toDatum(Connection c, String sqlTypeName) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new ARRAY(ArrayDescriptor.createDescriptor(sqlTypeName, c), c, this.getDatumArray(c));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection c, String sqlTypeName) throws SQLException {
        return this.toDatum((Connection)c, sqlTypeName);
    }

    public Datum toDatum(OracleConnection c, String sqlTypeName) throws SQLException {
        return this.toDatum((Connection)c, sqlTypeName);
    }

    public Object[] getOracleArray() throws SQLException {
        return this.getOracleArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getOracleArray(long index, int count) throws SQLException {
        int sliceLen = this.sliceLength(index, count);
        if (sliceLen < 0) {
            return null;
        }
        Object[] a = null;
        switch (this.sqlType) {
            case -13: {
                a = new BFILE[sliceLen];
                break;
            }
            case 2004: {
                a = new BLOB[sliceLen];
                break;
            }
            case 1: 
            case 12: {
                a = new CHAR[sliceLen];
                break;
            }
            case 2005: {
                a = new CLOB[sliceLen];
                break;
            }
            case 91: {
                a = new DATE[sliceLen];
                break;
            }
            case 93: {
                a = new TIMESTAMP[sliceLen];
                break;
            }
            case -101: {
                a = new TIMESTAMPTZ[sliceLen];
                break;
            }
            case -102: {
                a = new TIMESTAMPLTZ[sliceLen];
                break;
            }
            case -104: {
                a = new INTERVALDS[sliceLen];
                break;
            }
            case -103: {
                a = new INTERVALYM[sliceLen];
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                a = new NUMBER[sliceLen];
                break;
            }
            case -2: {
                a = new RAW[sliceLen];
                break;
            }
            case 100: {
                a = new BINARY_FLOAT[sliceLen];
                break;
            }
            case 101: {
                a = new BINARY_DOUBLE[sliceLen];
                break;
            }
            case 0: 
            case 2002: 
            case 2003: 
            case 2006: 
            case 2007: {
                if (this.old_factory == null) {
                    a = new ORAData[sliceLen];
                    break;
                }
                a = new CustomDatum[sliceLen];
                break;
            }
            case -15: 
            case -9: {
                this.setNChar();
                a = new CHAR[sliceLen];
                break;
            }
            case 2011: {
                a = new NCLOB[sliceLen];
                break;
            }
            default: {
                SQLException __ex__ = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 48);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
        }
        return this.getOracleArray(index, a);
    }

    public Object[] getOracleArray(long index, Object[] a) throws SQLException {
        if (a == null) {
            return null;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        if (sliceLen != a.length) {
            return null;
        }
        if (this.sqlType == 2002 || this.sqlType == 2007 || this.sqlType == 2003 || this.sqlType == 2006 || this.sqlType == 0) {
            if (this.old_factory == null) {
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = this.factory.create(this.getDatumElement(idx++, null), this.sqlType);
                }
            } else {
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = this.old_factory.create(this.getDatumElement(idx++, null), this.sqlType);
                }
            }
        } else {
            for (int i = 0; i < sliceLen; ++i) {
                a[i] = this.getDatumElement(idx++, null);
            }
        }
        return a;
    }

    public Object[] getOracleArray(Object[] a) throws SQLException {
        return this.getOracleArray(0L, a);
    }

    public Object[] getObjectArray() throws SQLException {
        return this.getObjectArray(0L, Integer.MAX_VALUE);
    }

    public Object[] getObjectArray(long index, int count) throws SQLException {
        Object[] a;
        int sliceLen = this.sliceLength(index, count);
        if (sliceLen < 0) {
            return null;
        }
        switch (this.sqlType) {
            case -15: 
            case -9: 
            case 1: 
            case 12: {
                a = new String[sliceLen];
                break;
            }
            case 91: {
                a = new Date[sliceLen];
                break;
            }
            case 93: {
                a = new Timestamp[sliceLen];
                break;
            }
            case 2: 
            case 3: {
                a = new BigDecimal[sliceLen];
                break;
            }
            case 6: 
            case 8: {
                a = new Double[sliceLen];
                break;
            }
            case 4: 
            case 5: {
                a = new Integer[sliceLen];
                break;
            }
            case 7: {
                a = new Float[sliceLen];
                break;
            }
            case -2: {
                a = (Object[])new byte[sliceLen][];
                break;
            }
            default: {
                return this.getOracleArray(index, count);
            }
        }
        return this.getObjectArray(index, a);
    }

    public Object[] getObjectArray(long index, Object[] a) throws SQLException {
        if (a == null) {
            return null;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        if (sliceLen != a.length) {
            return null;
        }
        switch (this.sqlType) {
            case -15: 
            case -9: 
            case -2: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 91: 
            case 93: {
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = this.getObjectElement(idx++);
                }
                return a;
            }
        }
        return this.getOracleArray(index, a);
    }

    public Object[] getObjectArray(Object[] a) throws SQLException {
        return this.getObjectArray(0L, a);
    }

    public Object getArray() throws SQLException {
        return this.getArray(0L, Integer.MAX_VALUE);
    }

    public Object getArray(long index, int count) throws SQLException {
        int sliceLen = this.sliceLength(index, count);
        int idx = (int)index;
        if (sliceLen < 0) {
            return null;
        }
        switch (this.sqlType) {
            case 6: 
            case 8: 
            case 101: {
                double[] a = new double[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = (Double)this.getObjectElement(idx++);
                }
                return a;
            }
            case 100: {
                float[] a = new float[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = ((Float)this.getObjectElement(idx++)).floatValue();
                }
                return a;
            }
            case 4: {
                int[] a = new int[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = (Integer)this.getObjectElement(idx++);
                }
                return a;
            }
            case 5: {
                short[] a = new short[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = (short)((Integer)this.getObjectElement(idx++)).intValue();
                }
                return a;
            }
            case 7: {
                float[] a = new float[sliceLen];
                for (int i = 0; i < sliceLen; ++i) {
                    a[i] = ((Float)this.getObjectElement(idx++)).floatValue();
                }
                return a;
            }
        }
        return this.getObjectArray(index, count);
    }

    public void setOracleArray(Object[] a) {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])a);
        } else {
            this.setObjectArray(a);
        }
    }

    public void setOracleArray(Object[] a, long index) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumArray((Datum[])a, index);
        } else {
            this.setObjectArray(a, index);
        }
    }

    public void setObjectArray(Object[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = a[i];
            }
        }
    }

    public void setObjectArray(Object[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(a[i], idx++);
        }
    }

    public void setArray(double[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = a[i];
            }
        }
    }

    public void setArray(double[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(a[i], idx++);
        }
    }

    public void setArray(int[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = a[i];
            }
        }
    }

    public void setArray(int[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(a[i], idx++);
        }
    }

    public void setArray(float[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = Float.valueOf(a[i]);
            }
        }
    }

    public void setArray(float[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(Float.valueOf(a[i]), idx++);
        }
    }

    public void setArray(short[] a) {
        if (a == null) {
            this.setNullArray();
        } else {
            this.setArrayGeneric(a.length);
            this.elements = new Object[this.length];
            for (int i = 0; i < this.length; ++i) {
                this.elements[i] = (int)a[i];
            }
        }
    }

    public void setArray(short[] a, long index) throws SQLException {
        if (a == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, a.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setObjectElement(a[i], idx++);
        }
    }

    public Object getObjectElement(long n) throws SQLException {
        Object element = this.getLazyArray()[(int)n];
        if (element == null) {
            if (this.old_factory == null) {
                Datum d = this.getLazyOracleArray()[(int)n];
                this.elements[(int)n] = element = Util.convertToObject(d, this.sqlType, this.factory);
                if (Util.isMutable(d, this.factory)) {
                    this.resetOracleElement(n);
                }
            } else {
                Datum d = this.getLazyOracleArray()[(int)n];
                this.elements[(int)n] = element = Util.convertToObject(d, this.sqlType, this.old_factory);
                if (Util.isMutable(d, this.old_factory)) {
                    this.resetOracleElement(n);
                }
            }
        }
        return element;
    }

    public Object getOracleElement(long n) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            Datum d = this.getDatumElement(n, null);
            if (Util.isMutable(d, this.factory)) {
                this.pickledCorrect = false;
            }
            return d;
        }
        return this.getObjectElement(n);
    }

    public void setObjectElement(Object element, long n) throws SQLException {
        if (element == null) {
            this.getLazyOracleArray();
        }
        this.resetOracleElement(n);
        this.getLazyArray()[(int)n] = element;
    }

    public void setOracleElement(Object o, long n) throws SQLException {
        if (this.factory == null && this.old_factory == null) {
            this.setDatumElement((Datum)o, n);
        } else {
            this.setObjectElement(o, n);
        }
    }

    public String getBaseTypeName() throws SQLException {
        return this.pickled.getBaseTypeName();
    }

    public int getBaseType() throws SQLException {
        return this.pickled.getBaseType();
    }

    public ArrayDescriptor getDescriptor() throws SQLException {
        return this.pickled.getDescriptor();
    }

    Datum[] getDatumArray(Connection c) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (this.datums == null) {
            return null;
        }
        Datum[] result = new Datum[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = this.getDatumElement(i, c);
        }
        return result;
    }

    void setDatumArray(Datum[] d) {
        if (d == null) {
            this.setNullArray();
        } else {
            this.length = d.length;
            this.elements = null;
            this.datums = (Datum[])d.clone();
            this.pickled = null;
            this.pickledCorrect = false;
        }
    }

    void setDatumArray(Datum[] d, long index) throws SQLException {
        if (d == null) {
            return;
        }
        int sliceLen = this.sliceLength(index, d.length);
        int idx = (int)index;
        for (int i = 0; i < sliceLen; ++i) {
            this.setDatumElement(d[i], idx++);
        }
    }

    Datum getDatumElement(long n, Connection c) throws SQLException {
        Datum datum = this.getLazyOracleArray()[(int)n];
        if (datum == null) {
            Object a = this.getLazyArray()[(int)n];
            this.datums[(int)n] = datum = Util.convertToOracle(a, c, this.isNChar);
        }
        return datum;
    }

    void setDatumElement(Datum datum, long n) throws SQLException {
        this.resetElement(n);
        this.getLazyOracleArray()[(int)n] = datum;
        this.pickledCorrect = false;
    }

    void resetElement(long n) throws SQLException {
        if (this.elements != null) {
            this.elements[(int)n] = null;
        }
    }

    void setNullArray() {
        this.length = -1;
        this.elements = null;
        this.datums = null;
        this.pickled = null;
        this.pickledCorrect = false;
    }

    void setArrayGeneric(int length) {
        this.length = length;
        this.datums = new Datum[length];
        this.pickled = null;
        this.pickledCorrect = false;
    }

    public int length() throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        return this.length;
    }

    public int sliceLength(long index, int reqLength) throws SQLException {
        if (this.length < 0) {
            this.getLazyOracleArray();
        }
        if (index < 0L) {
            return (int)index;
        }
        return Math.min(this.length - (int)index, reqLength);
    }

    void resetOracleElement(long n) throws SQLException {
        if (this.datums != null) {
            this.datums[(int)n] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyArray() throws SQLException {
        if (this.length == -1) {
            this.getLazyOracleArray();
        }
        if (this.elements == null) {
            this.elements = new Object[this.length];
        }
        return this.elements;
    }

    Datum[] getLazyOracleArray() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleArray();
                this.length = this.datums.length;
                this.pickledCorrect = true;
                if (this.elements != null) {
                    for (int x = 0; x < this.length; ++x) {
                        if (this.elements[x] == null) continue;
                        this.datums[x] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else if (this.length >= 0) {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }

    public void setNChar() {
        this.isNChar = true;
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

