/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jpub.runtime.Util;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORADataFactory;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class MutableStruct {
    int length;
    STRUCT pickled;
    Datum[] datums;
    Object[] attributes;
    CustomDatumFactory[] old_factories;
    ORADataFactory[] factories;
    int[] sqlTypes;
    boolean pickledCorrect;
    boolean[] isNChar;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public MutableStruct(STRUCT s2, int[] sqlTypes, ORADataFactory[] factories) {
        this.length = factories.length;
        this.pickled = s2;
        this.factories = factories;
        this.sqlTypes = sqlTypes;
        this.initNChar(sqlTypes.length);
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] attributes, int[] sqlTypes, ORADataFactory[] factories) {
        this.length = factories.length;
        this.attributes = attributes;
        this.factories = factories;
        this.sqlTypes = sqlTypes;
        this.initNChar(sqlTypes.length);
        this.pickledCorrect = false;
    }

    public MutableStruct(STRUCT s2, int[] sqlTypes, CustomDatumFactory[] factories) {
        this.length = factories.length;
        this.pickled = s2;
        this.old_factories = factories;
        this.sqlTypes = sqlTypes;
        this.initNChar(sqlTypes.length);
        this.pickledCorrect = true;
    }

    public MutableStruct(Object[] attributes, int[] sqlTypes, CustomDatumFactory[] factories) {
        this.length = factories.length;
        this.attributes = attributes;
        this.old_factories = factories;
        this.sqlTypes = sqlTypes;
        this.initNChar(sqlTypes.length);
        this.pickledCorrect = false;
    }

    public Datum toDatum(Connection c, String sqlTypeName) throws SQLException {
        if (!this.pickledCorrect) {
            this.pickled = new STRUCT(StructDescriptor.createDescriptor(sqlTypeName, c), c, this.getDatumAttributes(c));
            this.pickledCorrect = true;
        }
        return this.pickled;
    }

    public Datum toDatum(oracle.jdbc.OracleConnection c, String sqlTypeName) throws SQLException {
        return this.toDatum((Connection)c, sqlTypeName);
    }

    public Datum toDatum(OracleConnection c, String sqlTypeName) throws SQLException {
        return this.toDatum((Connection)c, sqlTypeName);
    }

    public Object getAttribute(int n) throws SQLException {
        Object attribute = this.getLazyAttributes()[n];
        if (attribute == null) {
            Datum d = this.getLazyDatums()[n];
            if (this.old_factories == null) {
                this.attributes[n] = attribute = Util.convertToObject(d, this.sqlTypes[n], this.factories[n]);
                if (Util.isMutable(d, this.factories[n])) {
                    this.resetDatum(n);
                }
            } else {
                this.attributes[n] = attribute = Util.convertToObject(d, this.sqlTypes[n], this.old_factories[n]);
                if (Util.isMutable(d, this.old_factories[n])) {
                    this.resetDatum(n);
                }
            }
        }
        return attribute;
    }

    public Object getOracleAttribute(int n) throws SQLException {
        Object o;
        if (this.old_factories == null) {
            if (this.factories[n] == null) {
                o = this.getDatumAttribute(n, null);
                Datum d = this.getLazyDatums()[n];
                if (Util.isMutable(d, this.factories[n])) {
                    this.pickledCorrect = false;
                }
            } else {
                o = this.getAttribute(n);
            }
        } else if (this.old_factories[n] == null) {
            o = this.getDatumAttribute(n, null);
            Datum d = this.getLazyDatums()[n];
            if (Util.isMutable(d, this.old_factories[n])) {
                this.pickledCorrect = false;
            }
        } else {
            o = this.getAttribute(n);
        }
        return o;
    }

    public Object[] getAttributes() throws SQLException {
        for (int i = 0; i < this.length; ++i) {
            this.getAttribute(i);
        }
        return this.attributes;
    }

    public Object[] getOracleAttributes() throws SQLException {
        Object[] result = new Object[this.length];
        for (int i = 0; i < this.length; ++i) {
            result[i] = this.getOracleAttribute(i);
        }
        return result;
    }

    public void setAttribute(int n, Object attribute) throws SQLException {
        if (attribute == null) {
            this.getLazyDatums();
        }
        this.resetDatum(n);
        this.getLazyAttributes()[n] = attribute;
    }

    public void setDoubleAttribute(int n, double attribute) throws SQLException {
        this.setAttribute(n, attribute);
    }

    public void setFloatAttribute(int n, float attribute) throws SQLException {
        this.setAttribute(n, Float.valueOf(attribute));
    }

    public void setIntAttribute(int n, int attribute) throws SQLException {
        this.setAttribute(n, attribute);
    }

    public void setOracleAttribute(int n, Object attribute) throws SQLException {
        if (this.old_factories == null) {
            if (this.factories[n] == null) {
                this.setDatumAttribute(n, (Datum)attribute);
            } else {
                this.setAttribute(n, attribute);
            }
        } else if (this.old_factories[n] == null) {
            this.setDatumAttribute(n, (Datum)attribute);
        } else {
            this.setAttribute(n, attribute);
        }
    }

    Datum getDatumAttribute(int n, Connection c) throws SQLException {
        Datum datum = this.getLazyDatums()[n];
        if (datum == null) {
            Object a = this.getLazyAttributes()[n];
            this.datums[n] = datum = Util.convertToOracle(a, c, this.isNChar(n));
        }
        return datum;
    }

    void setDatumAttribute(int n, Datum datum) throws SQLException {
        this.resetAttribute(n);
        this.getLazyDatums()[n] = datum;
        this.pickledCorrect = false;
    }

    Datum[] getDatumAttributes(Connection c) throws SQLException {
        for (int i = 0; i < this.length; ++i) {
            this.getDatumAttribute(i, c);
        }
        return (Datum[])this.datums.clone();
    }

    void resetAttribute(int n) throws SQLException {
        if (this.attributes != null) {
            this.attributes[n] = null;
        }
    }

    void resetDatum(int n) throws SQLException {
        if (this.datums != null) {
            this.datums[n] = null;
        }
        this.pickledCorrect = false;
    }

    Object[] getLazyAttributes() {
        if (this.attributes == null) {
            this.attributes = new Object[this.length];
        }
        return this.attributes;
    }

    Datum[] getLazyDatums() throws SQLException {
        if (this.datums == null) {
            if (this.pickled != null) {
                this.datums = this.pickled.getOracleAttributes();
                this.pickledCorrect = true;
                if (this.attributes != null) {
                    for (int x = 0; x < this.length; ++x) {
                        if (this.attributes[x] == null) continue;
                        this.datums[x] = null;
                        this.pickledCorrect = false;
                    }
                }
            } else {
                this.datums = new Datum[this.length];
            }
        }
        return this.datums;
    }

    private void initNChar(int n) {
        this.isNChar = new boolean[n];
        for (int i = 0; i < n; ++i) {
            this.isNChar[i] = false;
        }
    }

    public void setNChar(int n) throws SQLException {
        this.isNChar[n] = true;
    }

    public boolean isNChar(int n) throws SQLException {
        boolean is = this.isNChar[n];
        return is;
    }
}

