/*
 * Decompiled with CFR 0.152.
 */
package oracle.jpub.runtime;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBfile;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.OracleData;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleOpaque;
import oracle.jdbc.OracleRef;
import oracle.jdbc.OracleStruct;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleConnection;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.DATE;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;

public class OracleDataUtil {
    static short lastCsId = (short)870;
    static CharacterSet lastCS = CharacterSet.make(870);
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    public static Object convertToObject(Object d, int sqlType, OracleDataFactory f) throws SQLException {
        Object result = OracleDataUtil._convertToObject(d, sqlType, f);
        return result;
    }

    public static Object _convertToObject(Object d, int sqlType, OracleDataFactory f) throws SQLException {
        if (d == null) {
            return null;
        }
        if (d instanceof OracleStruct) {
            return f.create(d, 2002);
        }
        if (d instanceof OracleRef) {
            return f.create(d, 2006);
        }
        if (d instanceof OracleArray) {
            return f.create(d, 2003);
        }
        if (d instanceof OracleOpaque) {
            return f.create(d, 2007);
        }
        if (f != null) {
            return f.create(d, sqlType);
        }
        if (d instanceof NUMBER) {
            if (sqlType == 2 || sqlType == 3) {
                return ((NUMBER)d).bigDecimalValue();
            }
            if (sqlType == 8 || sqlType == 6) {
                return ((NUMBER)d).doubleValue();
            }
            if (sqlType == 4 || sqlType == 5) {
                return ((NUMBER)d).intValue();
            }
            if (sqlType == 7) {
                return Float.valueOf(((NUMBER)d).floatValue());
            }
            if (sqlType == 16) {
                return ((NUMBER)d).booleanValue();
            }
            SQLException __ex__ = DatabaseError.createSqlException(null, 48, " type: " + sqlType);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return d;
    }

    public static Object convertToOracle(Object d, Connection c) throws SQLException {
        return OracleDataUtil.convertToOracle(d, c, false);
    }

    public static Object convertToOracle(Object d, Connection c, boolean isNChar) throws SQLException {
        Object result = OracleDataUtil._convertToOracle(d, c, isNChar);
        return result;
    }

    private static Object _convertToOracle(Object d, Connection c, boolean isNChar) throws SQLException {
        if (d == null) {
            return null;
        }
        if (d instanceof OracleData) {
            return ((OracleData)d).toJDBCObject((OracleConnection)c);
        }
        if (d instanceof String) {
            short csId;
            short s2 = c == null || !(c instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (csId = isNChar ? ((oracle.jdbc.internal.OracleConnection)c).getNCharSet() : ((oracle.jdbc.internal.OracleConnection)c).getDbCsId());
            if (csId != lastCsId) {
                lastCsId = csId;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR((String)d, lastCS);
        }
        if (d instanceof Character) {
            short csId;
            short s3 = csId = c == null || !(c instanceof oracle.jdbc.internal.OracleConnection) ? (short)870 : (short)((oracle.jdbc.internal.OracleConnection)c).getDbCsId();
            if (csId != lastCsId) {
                lastCsId = csId;
                lastCS = CharacterSet.make(lastCsId);
            }
            return new CHAR(((Character)d).toString(), lastCS);
        }
        if (d instanceof BigDecimal) {
            return new NUMBER((BigDecimal)d);
        }
        if (d instanceof BigInteger) {
            return new NUMBER((BigInteger)d);
        }
        if (d instanceof Double) {
            return new NUMBER((Double)d);
        }
        if (d instanceof Float) {
            return new NUMBER(((Float)d).floatValue());
        }
        if (d instanceof Integer) {
            return new NUMBER((Integer)d);
        }
        if (d instanceof Boolean) {
            return new NUMBER((Boolean)d);
        }
        if (d instanceof Short) {
            return new NUMBER((Short)d);
        }
        if (d instanceof Byte) {
            return new NUMBER((Byte)d);
        }
        if (d instanceof Long) {
            return new NUMBER((Long)d);
        }
        if (d instanceof Timestamp) {
            return new TIMESTAMP((Timestamp)d);
        }
        if (d instanceof Date) {
            return new DATE((Date)d);
        }
        if (d instanceof java.util.Date) {
            return new DATE(new Date(((java.util.Date)d).getTime()));
        }
        if (d instanceof byte[]) {
            return new RAW((byte[])d);
        }
        if (d instanceof OracleData) {
            return d;
        }
        SQLException __ex__ = DatabaseError.createSqlException(null, 48);
        __ex__.fillInStackTrace();
        throw __ex__;
    }

    static boolean isMutable(Object d, OracleDataFactory f) {
        if (d == null) {
            return false;
        }
        return d instanceof OracleBfile || d instanceof OracleBlob || d instanceof OracleClob || f != null && (d instanceof OracleStruct || d instanceof OracleOpaque || d instanceof OracleArray);
    }

    protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

