/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import oracle.net.url.common.Validators;

public class NodeType {
    public static final NodeType DESCRIPTION_LIST = new NodeType("DESCRIPTION_LIST", NodeType.descriptionListParams(), NodeType.setOf("DESCRIPTION"), NodeType.descriptionListValidators());
    public static final NodeType DESCRIPTION = new NodeType("DESCRIPTION", NodeType.descriptionParams(), NodeType.setOf("ADDRESS", "ADDRESS_LIST", "CONNECT_DATA", "SECURITY", "COMPRESSION_LEVELS"), NodeType.descriptionValidators());
    public static final NodeType ADDRESS_LIST = new NodeType("ADDRESS_LIST", NodeType.addressListParams(), NodeType.setOf("ADDRESS"), NodeType.addressListValidators());
    public static final NodeType ADDRESS = new NodeType("ADDRESS", NodeType.addressParams(), Collections.EMPTY_SET, NodeType.addressValidators());
    public static final NodeType CONNECT_DATA = new NodeType("CONNECT_DATA", NodeType.connectDataParams(), NodeType.setOf("FAILOVER_MODE"), NodeType.connectDataValidators());
    public static final NodeType SECURITY = new NodeType("SECURITY", NodeType.securityParams(), Collections.EMPTY_SET, NodeType.securityValidators());
    public static final NodeType COMPRESSION_LEVELS = new NodeType("COMPRESSION_LEVELS", NodeType.setOf("LEVEL"), Collections.EMPTY_SET, Collections.singletonMap("LEVEL", s2 -> s2.toLowerCase().matches("high|low")));
    public static final NodeType FAILOVER_MODE = new NodeType("FAILOVER_MODE", NodeType.failOverModeParams(), Collections.EMPTY_SET, NodeType.failOverModeValidators());
    public static final NodeType UNKNOWN_TYPE = new NodeType("UNKNOWN", Collections.EMPTY_SET, Collections.EMPTY_SET, Collections.EMPTY_MAP);
    private final String nodeName;
    private final Set<String> validParams;
    private final Set<String> validChildTypes;
    private final Map<String, Predicate<String>> paramValidator;

    private NodeType(String nodeName, Set<String> validParams, Set<String> validChildTypes, Map<String, Predicate<String>> paramValidator) {
        this.nodeName = nodeName;
        this.validParams = validParams;
        this.validChildTypes = validChildTypes;
        this.paramValidator = paramValidator;
    }

    public static NodeType valueOf(String type) {
        if (type.equalsIgnoreCase("DESCRIPTION_LIST")) {
            return DESCRIPTION_LIST;
        }
        if (type.equalsIgnoreCase("DESCRIPTION")) {
            return DESCRIPTION;
        }
        if (type.equalsIgnoreCase("CONNECT_DATA")) {
            return CONNECT_DATA;
        }
        if (type.equalsIgnoreCase("SECURITY")) {
            return SECURITY;
        }
        if (type.equalsIgnoreCase("ADDRESS_LIST")) {
            return ADDRESS_LIST;
        }
        if (type.equalsIgnoreCase("ADDRESS")) {
            return ADDRESS;
        }
        if (type.equalsIgnoreCase("COMPRESSION_LEVELS")) {
            return COMPRESSION_LEVELS;
        }
        if (type.equalsIgnoreCase("FAILOVER_MODE")) {
            return FAILOVER_MODE;
        }
        return UNKNOWN_TYPE;
    }

    public String nodeName() {
        return this.nodeName;
    }

    public Set<String> validParams() {
        return this.validParams;
    }

    public Set<String> validChildTypes() {
        return this.validChildTypes;
    }

    public boolean isValidParam(String name) {
        name = name.toUpperCase();
        return this.validParams.contains(name);
    }

    public boolean isValidParamValue(String name, String value) {
        Predicate<String> validator = this.paramValidator.get(name = name.toUpperCase());
        if (validator != null) {
            return validator.test(value);
        }
        return true;
    }

    public boolean isValidChildType(NodeType type) {
        return this.validChildTypes.contains(type.nodeName);
    }

    public static boolean multipleAllowed(NodeType parentType, NodeType childType) {
        return childType == DESCRIPTION || childType == ADDRESS || childType == ADDRESS_LIST || childType == UNKNOWN_TYPE;
    }

    public String toString() {
        return this.nodeName;
    }

    static Set<String> descriptionListParams() {
        return NodeType.addressListParams();
    }

    static Map<String, Predicate<String>> descriptionListValidators() {
        return NodeType.addressListValidators();
    }

    static Set<String> descriptionParams() {
        return NodeType.setOf("CONNECT_TIMEOUT", "RETRY_COUNT", "RETRY_DELAY", "TRANSPORT_CONNECT_TIMEOUT", "RECV_TIMEOUT", "COMPRESSION", "COMPRESSION_LEVELS", "SDU", "TDU", "ENABLE", "EXPIRE_TIME", "RECV_BUF_SIZE", "SEND_BUF_SIZE", "TYPE_OF_SERVICE", "FAILOVER", "LOAD_BALANCE", "SOURCE_ROUTE", "PROTOCOL_STACK", "ENVS", "ARGS", "USE_SNI");
    }

    static Map<String, Predicate<String>> descriptionValidators() {
        HashMap<String, Predicate<String>> validators = new HashMap<String, Predicate<String>>();
        validators.put("CONNECT_TIMEOUT", Validators.TIME_DELAY_VALIDATOR);
        validators.put("TRANSPORT_CONNECT_TIMEOUT", Validators.TIME_DELAY_VALIDATOR);
        validators.put("RETRY_COUNT", Validators.NUMBER_VALIDATOR);
        validators.put("RETRY_DELAY", Validators.TIME_DELAY_VALIDATOR);
        validators.put("RECV_TIMEOUT", Validators.TIME_DELAY_VALIDATOR);
        validators.put("COMPRESSION", Validators.BOOLEAN_VALIDATOR);
        validators.put("SDU", Validators.NUMBER_VALIDATOR);
        validators.put("TDU", Validators.NUMBER_VALIDATOR);
        validators.put("EXPIRE_TIME", Validators.NUMBER_VALIDATOR);
        validators.put("RECV_BUF_SIZE", Validators.NUMBER_VALIDATOR);
        validators.put("SEND_BUF_SIZE", Validators.NUMBER_VALIDATOR);
        validators.put("FAILOVER", Validators.BOOLEAN_VALIDATOR);
        validators.put("LOAD_BALANCE", Validators.BOOLEAN_VALIDATOR);
        validators.put("SOURCE_ROUTE", Validators.BOOLEAN_VALIDATOR);
        validators.put("USE_SNI", Validators.BOOLEAN_VALIDATOR);
        validators.put("ENABLE", s2 -> s2.equalsIgnoreCase("broken"));
        return validators;
    }

    static Set<String> addressListParams() {
        return new HashSet<String>(Arrays.asList("FAILOVER", "LOAD_BALANCE", "SOURCE_ROUTE"));
    }

    static Map<String, Predicate<String>> addressListValidators() {
        HashMap<String, Predicate<String>> validators = new HashMap<String, Predicate<String>>();
        validators.put("FAILOVER", Validators.BOOLEAN_VALIDATOR);
        validators.put("LOAD_BALANCE", Validators.BOOLEAN_VALIDATOR);
        validators.put("SOURCE_ROUTE", Validators.BOOLEAN_VALIDATOR);
        return validators;
    }

    static Set<String> addressParams() {
        return NodeType.setOf("PROTOCOL", "HOST", "PORT", "HTTPS_PROXY", "HTTPS_PROXY_PORT", "WEBSOCK_URI");
    }

    static Map<String, Predicate<String>> addressValidators() {
        HashMap<String, Predicate<String>> validators = new HashMap<String, Predicate<String>>();
        validators.put("PROTOCOL", Validators.PROTOCOL_VALIDATOR);
        validators.put("HOST", Validators.HOST_VALIDATOR);
        validators.put("PORT", Validators.PORT_VALIDATOR);
        validators.put("HTTPS_PROXY_PORT", Validators.PORT_VALIDATOR);
        validators.put("HTTPS_PROXY", Validators.HOST_VALIDATOR);
        return validators;
    }

    static Set<String> connectDataParams() {
        return NodeType.setOf("COLOCATION_TAG", "CONNECTION_ID_PREFIX", "GLOBAL_NAME", "HS", "INSTANCE_NAME", "POOL_BOUNDARY", "POOL_NAME", "POOL_PURITY", "POOL_CONNECTION_CLASS", "RDB_DATABASE", "SHARDING_KEY", "SID", "SHARDING_KEY_ID", "SUPER_SHARDING_KEY", "SERVICE_NAME", "SERVER", "TUNNEL_SERVICE_NAME", "HANDLER_NAME", "ORACLE_HOME", "INSTANCE_ROLE", "USE_TCP_FAST_OPEN", "TFO", "SHARDING_KEY_B64", "SUPER_SHARDING_KEY_B64");
    }

    static Map<String, Predicate<String>> connectDataValidators() {
        HashMap<String, Predicate<String>> validators = new HashMap<String, Predicate<String>>();
        validators.put("COLOCATION_TAG", Validators.ALPHANUMERIC_VALIDATOR);
        validators.put("CONNECTION_ID_PREFIX", Validators.WORDCHAR_VALIDATOR.and(s2 -> s2.length() <= 8));
        validators.put("HS", s2 -> s2.toLowerCase().matches("ok"));
        validators.put("INSTANCE_NAME", Validators.ORA_NAMES_VALIDATOR);
        validators.put("POOL_BOUNDARY", s2 -> s2.toLowerCase().matches("statement|transaction"));
        validators.put("POOL_PURITY", s2 -> s2.toLowerCase().matches("new|self"));
        validators.put("POOL_CONNECTION_CLASS", Validators.ORA_NAMES_VALIDATOR);
        validators.put("RDB_DATABASE", Validators.ORA_NAMES_VALIDATOR);
        validators.put("SHARDING_KEY", Validators.WORDCHAR_VALIDATOR);
        validators.put("SID", Validators.ORA_NAMES_VALIDATOR);
        validators.put("SHARDING_KEY_ID", s2 -> s2.matches("^[a-fA-F0-9]{64}$") || s2.matches("^\"[a-fA-F0-9]{64}\"$") || s2.matches("^'[a-fA-F0-9]{64}'$"));
        validators.put("SUPER_SHARDING_KEY", Validators.WORDCHAR_VALIDATOR);
        validators.put("SERVICE_NAME", Validators.ORA_NAMES_VALIDATOR);
        validators.put("SERVER", Validators.SERVER_MODE_VALIDATOR);
        validators.put("TUNNEL_SERVICE_NAME", Validators.ORA_NAMES_VALIDATOR);
        validators.put("HANDLER_NAME", Validators.ORA_NAMES_VALIDATOR);
        validators.put("INSTANCE_ROLE", Validators.ORA_NAMES_VALIDATOR);
        validators.put("USE_TCP_FAST_OPEN", Validators.BOOLEAN_VALIDATOR);
        validators.put("TFO", Validators.BOOLEAN_VALIDATOR);
        return validators;
    }

    static Set<String> securityParams() {
        return NodeType.setOf("AUTHENTICATION_SERVICE", "AZURE_DB_APP_ID_URI", "AZURE_CREDENTIALS", "CLIENT_CERTIFICATE", "CLIENT_ID", "IGNORE_ANO_ENCRYPTION_FOR_TCPS", "KERBEROS5_CC_NAME", "KERBEROS5_PRINCIPAL", "OCI_COMPARTMENT", "OCI_CONFIG_FILE", "OCI_DATABASE", "OCI_IAM_URL", "OCI_PROFILE", "OCI_TENANCY", "PASSWORD_AUTH", "SSL_CERTIFICATE_ALIAS", "TENANT_ID", "SSL_CERTIFICATE_THUMBPRINT", "SSL_CLIENT_AUTHENTICATION", "SSL_SERVER_CERT_DN", "SSL_SERVER_DN_MATCH", "SSL_VERSION", "SSL_ALLOW_WEAK_DN_MATCH", "SSL_DISABLE_VERSION", "TOKEN_AUTH", "TOKEN_LOCATION", "WALLET_LOCATION", "REDIRECT_URI", "SEPS_WALLET_LOCATION", "ENCRYPTION_CLIENT", "ENCRYPTION_TYPES_CLIENT", "CRYPTO_CHECKSUM_CLIENT", "CRYPTO_CHECKSUM_TYPES_CLIENT", "TLS_SERVER_CERT_DN", "TLS_SERVER_DN_MATCH", "TLS_ALLOW_WEAK_DN_MATCH", "TLS_VERSION", "TLS_CIPHER_SUITES", "TLS_CERTIFICATE_ALIAS", "TLS_CERTIFICATE_THUMBPRINT", "TLS_DISABLE_VERSION", "MY_WALLET_DIRECTORY", "ALLOW_WEAK_CRYPTO");
    }

    static Map<String, Predicate<String>> securityValidators() {
        HashMap<String, Predicate<String>> validators = new HashMap<String, Predicate<String>>();
        validators.put("AUTHENTICATION_SERVICE", Validators.WORDCHAR_VALIDATOR);
        validators.put("IGNORE_ANO_ENCRYPTION_FOR_TCPS", Validators.BOOLEAN_VALIDATOR);
        validators.put("PASSWORD_AUTH", Validators.WORDCHAR_VALIDATOR);
        validators.put("SSL_CLIENT_AUTHENTICATION", Validators.BOOLEAN_VALIDATOR);
        validators.put("SSL_SERVER_DN_MATCH", Validators.BOOLEAN_VALIDATOR);
        validators.put("ENCRYPTION_CLIENT", s2 -> s2.toLowerCase().matches("accepted|rejected|required|requested"));
        validators.put("ENCRYPTION_TYPES_CLIENT", Validators.WORDCHAR_VALIDATOR_MULTI);
        validators.put("CRYPTO_CHECKSUM_CLIENT", s2 -> s2.toLowerCase().matches("accepted|rejected|required|requested"));
        validators.put("CRYPTO_CHECKSUM_TYPES_CLIENT", Validators.WORDCHAR_VALIDATOR_MULTI);
        validators.put("ALLOW_WEAK_CRYPTO", Validators.BOOLEAN_VALIDATOR);
        return validators;
    }

    private static Set<String> failOverModeParams() {
        return NodeType.setOf("BACKUP", "TYPE", "METHOD", "TRANSACTION", "RETRIES", "DELAY");
    }

    private static Map<String, Predicate<String>> failOverModeValidators() {
        HashMap<String, Predicate<String>> validators = new HashMap<String, Predicate<String>>();
        validators.put("BACKUP", Validators.ORA_NAMES_VALIDATOR);
        validators.put("TYPE", Validators.WORDCHAR_VALIDATOR);
        validators.put("METHOD", Validators.WORDCHAR_VALIDATOR);
        validators.put("TRANSACTION", Validators.WORDCHAR_VALIDATOR);
        validators.put("RETRIES", Validators.NUMBER_VALIDATOR);
        validators.put("DELAY", Validators.TIME_DELAY_VALIDATOR);
        return validators;
    }

    private static Set<String> setOf(String ... arg) {
        return new HashSet<String>(Arrays.asList(arg));
    }
}

