/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Predicate;

public class Validators {
    public static final Predicate<String> NUMBER_VALIDATOR = s2 -> s2.trim().matches("\\d+");
    public static final Predicate<String> BOOLEAN_VALIDATOR = s2 -> s2.trim().toLowerCase().matches("yes|no|true|false|on|off");
    public static final Predicate<String> SERVER_MODE_VALIDATOR = s2 -> s2.trim().toLowerCase().matches("shared|pooled|dedicated");
    public static final Predicate<String> TIME_DELAY_VALIDATOR = s2 -> s2.trim().toLowerCase().matches("\\d+\\s*(ms|sec|min|msec|hr)?");
    public static final Predicate<String> PROTOCOL_VALIDATOR = s2 -> s2.trim().toLowerCase().matches("tcp|tcps|beq|wss|msgq|sdp|exadirect|msgqlt");
    public static final Predicate<String> PORT_VALIDATOR = NUMBER_VALIDATOR.and(s2 -> s2.length() < 6 && Integer.parseInt(s2) >= 1 && Integer.parseInt(s2) <= 65535);
    public static final Predicate<String> ALPHANUMERIC_VALIDATOR = s2 -> s2.trim().toLowerCase().matches("^[a-zA-Z0-9]+$");
    public static final Predicate<String> WORDCHAR_VALIDATOR = s2 -> s2.trim().toLowerCase().matches("^[a-zA-Z0-9_]+$");
    public static final Predicate<String> WORDCHAR_VALIDATOR_MULTI = s2 -> s2.trim().toLowerCase().matches("^[a-zA-Z0-9_\\-(),]+$");
    public static final Predicate<String> ASCII_VALIDATOR = s2 -> s2.matches("^\\p{ASCII}+$");
    public static final Predicate<String> IPv6_VALIDATOR = Validators::isValidIPv6Address;
    public static final Predicate<String> IPv4_VALIDATOR = Validators::isValidIPv4Address;
    public static final Predicate<String> HOSTNAME_VALIDATOR = Validators::isValidHostName;
    public static final Predicate<String> HOST_VALIDATOR = HOSTNAME_VALIDATOR.or(IPv4_VALIDATOR).or(IPv6_VALIDATOR);
    public static final Predicate<String> ORA_NAMES_VALIDATOR = s2 -> s2.matches("^[a-zA-Z0-9][a-zA-Z0-9\\.\\-_@#$!%~+?,]*$");

    private static boolean isValidIPv6Address(String s2) {
        if (s2 == null || s2.isEmpty() || s2.charAt(0) != '[') {
            return false;
        }
        int pcIndex = s2.indexOf(37);
        String string = s2 = pcIndex == -1 ? s2.substring(1, s2.length() - 1).trim() : s2.substring(1, pcIndex).trim();
        if (s2.length() > 39) {
            return false;
        }
        if (s2.equals("::")) {
            return true;
        }
        ArrayList<String> values = new ArrayList<String>();
        int zeroSupIndex = s2.indexOf("::");
        if (zeroSupIndex != -1) {
            Object ipv6Address = zeroSupIndex == s2.length() - 2 ? s2.substring(0, zeroSupIndex) : (zeroSupIndex == 0 ? s2.substring(2) : s2.substring(0, zeroSupIndex) + s2.substring(zeroSupIndex + 1));
            if (((String)ipv6Address).contains("::") || ((String)ipv6Address).startsWith(":") || ((String)ipv6Address).endsWith(":")) {
                return false;
            }
            values.addAll(Arrays.asList(((String)ipv6Address).split(":")));
            if (values.size() > 7) {
                return false;
            }
        } else {
            if (s2.startsWith(":") || s2.endsWith(":")) {
                return false;
            }
            values.addAll(Arrays.asList(s2.split(":")));
            if (values.size() != 8) {
                return false;
            }
        }
        for (String part : values) {
            if (part.isEmpty() || part.length() > 4) {
                return false;
            }
            for (char c : part.toCharArray()) {
                if (Character.digit(c, 16) != -1) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isValidIPv4Address(String s2) {
        if (s2 == null || s2.isEmpty()) {
            return false;
        }
        if (s2.length() > 15 || !Character.isDigit(s2.charAt(0))) {
            return false;
        }
        String[] parts = s2.split("\\.");
        if (parts.length != 4) {
            return false;
        }
        for (String part : parts) {
            try {
                int value = Integer.parseInt(part);
                if (value >= 0 && value <= 255) continue;
                return false;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    private static boolean isValidHostName(String s2) {
        if (s2 == null || s2.isEmpty() || s2.length() > 255) {
            return false;
        }
        String[] labels = s2.split("\\.");
        boolean seenAlphabet = false;
        for (String label : labels) {
            char[] chars = label.toCharArray();
            if (chars.length == 0 || chars.length > 63) {
                return false;
            }
            for (char c : chars) {
                if (!Character.isLetterOrDigit(c) && c != '-' && c != '_') {
                    return false;
                }
                if (!Character.isAlphabetic(c)) continue;
                seenAlphabet = true;
            }
        }
        return seenAlphabet;
    }
}

